C
C
      SUBROUTINE PLSDAT (NCOLA, NCOLB, NIN, NOUT, NROWA, NROWB,
     +                   FNAMEA, FNAMEB, TITLEA, TITLEB)
C
C ACTION : Analyse two matrices
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          30/03/2007 derived from M_MATTWO 
C          12/06/2007 replaced CLOSE by CALL CLOSER
C          23/06/2010 corrected dimension check to read j.gt.0 for matrix B
C          21/10/2010 increased NISX from 1000  to 10000
C          08/02/2011 increased NISX from 10000 to 100000
C          17/04/2011 restored NISX to 1000
C
C         NCOLA: (input/output) column dimension of matrix A = X-predictors 
C         NCOLB: (input/output) column dimension of matrix B = Y-responses
C           NIN: (input/unchanged) unconnected unit for data input
C          NOUT: (input/unchanged) preconnected unit for results
C         NROWA: (input/output) row dimension of matrix A
C         NROWB: (input/output) row dimension of matrix A
C        FNAMEA: (input/output) file name for A data
C        FNAMEB: (input/output) file name for B data
C        TITLEA: (input/output) A-title
C        TITLEB: (input/output) B-title  
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NOUT   
      INTEGER,             INTENT (INOUT) :: NCOLA, NCOLB, NROWA, NROWB
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMEA, FNAMEB,
     +                                       TITLEA, TITLEB
C
C Local allocatable workspaces
C                        
      INTEGER,          ALLOCATABLE :: ISX(:)
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: A1(:,:), B1(:,:)
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 15,
     +           NUMOPT = 7)
      INTEGER    N0, N1, N2, N3, N4, N5, NISX, NTYPE
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, 
     +           NTYPE = 3, NISX = 1000) 
      INTEGER    NCADD, NRADD
      PARAMETER (NCADD = 1, NRADD = 0)
      INTEGER    NCMAX, NCMAXA, NCMAXB, NCOL, NRMAX, NRMAXA, NRMAXB,
     +           NROW
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
      INTEGER    I, IERR, IOS, J, JSEND, NLINES
      INTEGER    ICOUNT, ISXSAV(NISX)
      CHARACTER (LEN = 12) I12(4), FORM12
      CHARACTER  FNAME*1024, LINE*100, TITLE*80
      CHARACTER  CHOP80*80, TEXT(30)*100, TRIM80*80
      CHARACTER  ATITLE*80, BTITLE*80
      CHARACTER  AFNAME*80, BFNAME*80
      CHARACTER  SIM256*1024, STATE*30
      CHARACTER  NODATA*60, NOFILE*30, NREADY*30, READY*30
      PARAMETER (NODATA = '(...No data...)',
     +           NOFILE = 'No file',
     +           NREADY = '(..Not ready..)',
     +            READY = '(*** Ready ***)' )
      CHARACTER  OPTION(2)*4
      CHARACTER  BLANK4*4, STAR4*4
      PARAMETER (BLANK4 = '    ', STAR4 = '****')
      CHARACTER  HEADER*80
      PARAMETER (HEADER = 'Partial Least Squares (PLS) data sets')
      LOGICAL    ABORT, NEWDAT(2), REPEET
      LOGICAL    ALLPOS, LABEL
      PARAMETER (ALLPOS = .TRUE., LABEL = .TRUE.)
      LOGICAL    FIXCOL, FIXROW
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   FORM12
      EXTERNAL   PUTADV, PUTFAT, LBOX01, CHOP80, PATCH1, MAT2IN, MAT3IN,
     +           ISITMF, VIEWIT, TRIM80, PLSMOD, SIM256, EOFINT, WRITER,
     +           CLOSER
      INTRINSIC  MIN, TRIM   
      SAVE       ICOUNT
      SAVE       ISXSAV
      DATA       ICOUNT / 0 /
      DATA       ISXSAV /NISX*1 /
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Deallocate workspaces
C
      IERR = 0   
      IF (ALLOCATED(ISX)) DEALLOCATE(ISX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B)) DEALLOCATE(B, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Check input data using ISITMF and initialise
C                                            
      IF (NCOLA.LE.N0 .OR. NROWA.LE.N0) THEN
         NCOLA = 15
         NROWA = 15
         FNAMEA = SIM256('g02laf.tf1')
      ENDIF
      IF (NCOLB.LE.N0 .OR. NROWB.LE.N0) THEN
          NCOLB = 1
          NROWB = 15
          FNAMEB = SIM256('g02laf.tf2')
      ENDIF
      IF (NCOLA.GT.N1 .AND. NROWA.GT.N1) THEN
         CALL ISITMF(I, J,
     +               FNAMEA)
         IF (I.EQ.NCOLA .AND. J.EQ.NROWA) THEN 
            NCMAXA = NCOLA + NCADD
            NRMAXA = NROWA + NRADD
            ALLOCATE(A(NRMAXA,NCMAXA), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CALL CLOSER (NIN)
               CALL MAT2IN (NIN, NCMAXA, NCOLA, NRMAXA, NROWA,
     +                      A,
     +                      FNAMEA, TITLEA,
     +                      ABORT)
               CALL CLOSER (NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(A, STAT = IERR)
               NCOLA = N0
               NROWA = N0
               FNAMEA = NOFILE
               TITLEA = NODATA
            ENDIF
         ELSE
            NCOLA = N0
            NROWA = N0
            FNAMEA = NOFILE
            TITLEA = NODATA
         ENDIF
      ELSE
         NCOLA = N0
         NROWA = N0
         TITLEA = NODATA
      ENDIF
      ATITLE = CHOP80(TITLEA)
      AFNAME = TRIM80(FNAMEA)
      IF (NCOLB.GE.N1 .AND. NROWB.GT.N1) THEN
         CALL ISITMF(I, J,
     +               FNAMEB)
         IF (I.EQ.NCOLB .AND. J.EQ.NROWB) THEN
            NCMAXB = NCOLB + NCADD
            NRMAXB = NROWB + NRADD
            ALLOCATE(B(NRMAXB,NCMAXB), STAT = IERR)
            ABORT = .FALSE.
            IF (IERR.EQ.N0) THEN
               CALL CLOSER (NIN)
               CALL MAT2IN (NIN, NCMAXB, NCOLB, NRMAXB, NROWB,
     +                      B,
     +                      FNAMEB, TITLEB,
     +                      ABORT)
               CALL CLOSER (NIN)
            ENDIF
            IF (ABORT) THEN
               DEALLOCATE(B, STAT = IERR)
               NCOLB = N0
               NROWB = N0
               FNAMEB = NOFILE
               TITLEB = NODATA  
            ENDIF
         ELSE
            NCOLB = N0
            NROWB = N0
            FNAMEB = NOFILE
            TITLEB = NODATA
         ENDIF
      ELSE
         NCOLB = N0
         NROWB = N0
         TITLEB = NODATA
      ENDIF
      BFNAME = TRIM80(FNAMEB)
      BTITLE = CHOP80(TITLEB)
C
C Main loop......................................................
C
      NEWDAT(1) = .FALSE.
      NEWDAT(2) = .FALSE.
      REPEET = .TRUE.
      DO WHILE (REPEET)     
         IF (NEWDAT(1)) THEN
            NUMDEC = N1
         ELSEIF (NEWDAT(2)) THEN
            NUMDEC = N2
         ELSE      
            DO I = N1, N2
               OPTION(I) = BLANK4
            ENDDO
            IF (NCOLA.LT.N2 .OR. NROWA.LT.N2) THEN
               NUMDEC = N1
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ELSEIF (NCOLB.LT.N1 .OR. NROWB.LT.N2) THEN
               NUMDEC = N2
               OPTION(NUMDEC) = STAR4
               STATE = NREADY
            ELSE
               NUMDEC = N3
               STATE = READY
            ENDIF
            I12(1) = FORM12(NROWA)
            I12(2) = FORM12(NCOLA)
            I12(3) = FORM12(NROWB)
            I12(4) = FORM12(NCOLB)
            WRITE (TEXT,100) HEADER,
     +                       AFNAME, ATITLE, TRIM(I12(1)), TRIM(I12(2)),
     +                       BFNAME, BTITLE, TRIM(I12(3)), TRIM(I12(4)),
     +                      (OPTION(I), I = N1, N2), STATE
            NTEXT = NSTART + NUMOPT - N1
            NUMBLD(1) = N4
            NUMBLD(4) = N1
            NUMBLD(6) = N1
            NUMBLD(10) = N1
            NUMBLD(12) = N1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            NUMBLD(1) = N0
            NUMBLD(4) = N0
            NUMBLD(6) = N0
            NUMBLD(10) = N0
            NUMBLD(12) = N0
         ENDIF   
         IF (NUMDEC.EQ.N3) THEN
           IF (NCOLA.LT.N2 .OR. NCOLB.LT.N1 .OR.
     +         NROWA.LT.N2 .OR. NROWA.NE.NROWB) THEN
               WRITE (LINE,200)
               CALL PUTFAT (LINE)
               NUMDEC = N0
            ENDIF 
         ENDIF  
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Read in data matrix A
C ===========
C             
            NEWDAT(1) = .FALSE.
            WRITE (LINE,300) 'X'
            CALL PUTADV (LINE)
c
c -------------------------------
c start of code to input a matrix
c
            jsend = 3
            call closer (nin)
            call mat3in (jsend, j, nin, i,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            call closer (nin)
            if (.not.abort .and. i.gt.1 .and. j.gt.0) then  
               ncol = j
               nrow = i
               ncmax = ncol + ncadd
               nrmax = nrow + nradd
              
               call closer (nin)       
              
               if (allocated(a)) deallocate(a, stat = ierr)
               if (ierr.eq.0) allocate(a(nrmax,ncmax), stat = ierr)
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, nrmax, i,
     +                         a,
     +                         fname, title,
     +                         abort)
                  call closer (nin)
                  ncola = ncol
                  nrowa = nrow
                  fnamea = fname
                  titlea = title
                  afname = trim80(fname)
                  atitle = chop80(title)  
                 
               endif
            endif
c
c end of code to read in a matrix
c -------------------------------
c
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Read in data matrix B
C ===========
C
            NEWDAT(2) = .FALSE.
            WRITE (LINE,300) 'Y'
            CALL PUTADV (LINE)
c
c -------------------------------
c start of code to input a matrix
c
            jsend = 3
            call closer (nin)
            call mat3in (jsend, j, nin, i,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            call closer (nin)
            if (.not.abort .and. i.gt.1 .and. j.gt.0) then 
               ncol = j
               nrow = i
               ncmax = ncol + ncadd
               nrmax = nrow + nradd
               call closer (nin)
               if (allocated(b)) deallocate(b, stat = ierr)
               if (ierr.eq.0) allocate(b(nrmax,ncmax), stat = ierr)
               if (ierr.eq.0) then
                  call mat2in (nin, ncmax, j, nrmax, i,
     +                         b,
     +                         fname, title,
     +                         abort)
                  call closer (nin)
                  ncolb = ncol
                  nrowb = nrow
                  fnameb = fname
                  titleb = title
                  bfname = trim80(fname)
                  btitle = chop80(title)
               endif
            endif
c
c end of code to read in a matrix
c -------------------------------
c
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Analyse
C ===========
            IERR = 0
            IF (ALLOCATED(A1)) DEALLOCATE(A1, STAT = IERR)
            IF (IERR.NE.0) RETURN
            IF (ALLOCATED(B1)) DEALLOCATE(B1, STAT = IERR)
            IF (IERR.NE.0) RETURN
C
C Dimension the workspaces as required by the NAG routines
C
            NCMAXA = NCOLA + NCADD
            NCMAXB = NCOLB + NCADD
            NRMAXA = NROWA + NRADD
            NRMAXB = NROWB + NRADD
C
C Allocate workspaces
C
            ALLOCATE(A1(NRMAXA,NCMAXA), STAT = IERR)
            IF (IERR.NE.0) RETURN
            ALLOCATE(B1(NRMAXB,NCMAXB), STAT = IERR)
            IF (IERR.NE.0) RETURN
C
C Make copies of A and B just in case they are changed by the calls
C
            DO J = N1, NCOLA
               DO I = N1, NROWA
                  A1(I,J) = A(I,J)
               ENDDO
            ENDDO
            DO J = N1, NCOLB
               DO I = N1, NROWB
                  B1(I,J) = B(I,J)
               ENDDO
            ENDDO
C
C Allocate/define ISX
C                     
            if (allocated(isx)) deallocate (isx, stat = ierr)
            allocate (isx(ncola), stat = ierr)     
            call eofint (isx, ncola,
     +                   fnamea,
     +                   abort, allpos)
            if (abort) then
               do i = 1, min(nisx,ncola)
                  isx(i) = isxsav(i)
               enddo 
               if (ncola.gt.nisx) then
                  do i = nisx + 1, ncola
                     isx(i) = 1
                  enddo
               endif        
            endif        
C
C Fit the pLS model
C                            
            ICOUNT = ICOUNT + N1
            WRITE (TEXT,400) ICOUNT, AFNAME, ATITLE, BFNAME, BTITLE
            NLINES = 12
            CALL WRITER (IOS, NLINES, NOUT,
     +                   TEXT)            

            CALL PLSMOD (ISX, NCMAXA, NCMAXB, NCOLA, NCOLB, NIN, NOUT, 
     +                   NRMAXA, NRMAXB, NROWA, NROWB, 
     +                   A1, B1, 
     +                   FNAMEA, FNAMEB,
     +                   NEWDAT)
C
C Store the indicators
C         
            DO I = N1, MIN(NCOLA,NISX)
               ISXSAV(I) = ISX(I)
            ENDDO  
            
            IF (.NOT.NEWDAT(1) .AND. .NOT.NEWDAT(2)) REPEET = .FALSE.
                
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: View A
C ===========
C       
            IF (ALLOCATED(A) .AND. NCOLA.GE.N1 .AND. NROWA.GT.N1) THEN
               CALL VIEWIT (NCOLA, NROWA, NROWA, NTYPE,
     +                      A,
     +                      TITLEA)                
            ELSE
               WRITE (LINE,500) 'X'
               CALL PUTFAT (LINE)
               NUMDEC = N1
            ENDIF  
        ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: View B
C ===========
C       
            IF (ALLOCATED(B) .AND. NCOLB.GE.N1 .AND. NROWB.GT.N1) THEN
               CALL VIEWIT (NCOLB, NROWB, NROWB, NTYPE,
     +                      B,
     +                      TITLEB)                
            ELSE
               WRITE (LINE,500) 'Y'
               CALL PUTFAT (LINE)
               NUMDEC = N1
            ENDIF          
     
           
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C ====================
C         
            WRITE (TEXT,600)
            NTEXT = 20
            NUMBLD(1) = 1
            CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTEXT,
     +                   TEXT,
     +                   BORDER)
            NUMBLD(1) = 0
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit
C ================
C
            REPEET = .FALSE.
            CLOSE (UNIT = NIN)
            ABORT = .TRUE.
         ENDIF
      ENDDO
C
C End of main loop......................................................
C

C
C Deallocate workspace
C                               
      DEALLOCATE(ISX, STAT = IERR)
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(B, STAT = IERR)
      DEALLOCATE(A1, STAT = IERR)
      DEALLOCATE(B1, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     +A
     +/
     +/'Filename for current PLS X-predictor data:' 
     +/A
     +/'Title for current PLS X-predictor matrix:'
     +/A
     +/'(number of rows = ',A,', number of columns = ',A,')'
     +/
     +/'Filename for current PLS Y-response data:'
     +/A
     +/'Title For current PLS Y-response matrix:'
     +/A
     +/'(number of rows = ',A,', number of columns = ',A,')'
     +/
     +/'Input a new PLS X-data matrix (predictors)',1X,A
     +/'Input a new PLS Y-data matrix (responses)',1X,A
     +/'Analyse the current X,Y data',1X,A
     +/'View current matrix X'
     +/'View current matrix Y'
     +/'Help'
     +/'Quit ... Exit these PLS options') 
  200 FORMAT ('Matrices X and Y have inconsistent dimensions')   
  300 FORMAT ('Now input the PLS',1X,A,'-data matrix')
  400 FORMAT (
     +/' Partial Least Squares analysis (PLS):',i3
     +/' ----------------------------------------'
     +/
     +/' X-File (predictors):'
     +/1x,A 
     +/' X-Title:'
     +/1x,A 
     +/' Y-File (responses):'
     +/1x,A 
     +/' Y-Title:'
     +/1x,A
     +/)
  500 FORMAT ('Matrix',1X,A,1X,'has not been initialised') 
  600 FORMAT (
     + 'Supplying two data samples for analysis'
     +/
     +/'The analytical procedure you have selected requires two samples'
     +/'as data matrices, with no missing values, that is'
     +/
     +/'N by MX Matrix X (predictors) with N > 1, MX > 1, and'
     +/'N by MY Matrix Y (responses) with N > 1, MY >= 1.'
     +/
     +/'From this control you can input two data samples for each'
     +/'analysis or, if it is more convenient, maintain one sample'
     +/'as a reference sample and just renew the other data set.'
     +/
     +/'Note that the PLS procedure imposes restrictions on the'
     +/'dimensions of the matrices or on their properties, e.g. X and'
     +/'Y must have the same number of N rows (i.e. cases).'
     +/'You can input data from matrix type files, type values at'
     +/'the terminal, or paste in as tables from the clipboard, but'
     +/'you should always supply meaningful titles, to identify the'
     +/'results retrospectively from these titles as they are written'
     +/'to the results log file.')
      END
C
C
