c
c
      subroutine plsdef
c
c action: PLS definitions
c author: w.g.bardsley, university of manchester, u.k., 29/08/2011
c
      integer    i, icolor
      integer    numtxt
      parameter (numtxt = 50)
      character  text(numtxt)*100
      external   table1
      write (text,100)
      icolor = 15
      call table1 (icolor, 'OPEN')
      do i = 1, numtxt
         if (i.le.2) then
            icolor = 1
         elseif (i.eq.12) then
            icolor = 4
         else
            icolor = 0
         endif          
         call table1 (icolor, text(i))
      enddo
      call table1 (icolor, 'CLOSE')    
  100 format (
     + 'PLS uses the X and Y data supplied as a training set to predict'
     +/'new Y from a Z matrix in one of two mutually exclusive ways.'
     +/
     +/'Method 1: X, Y and Z are raw data with no centering or scaling,'
     +/'          so that Y-predicted will have the same units as Y.'
     +/'          Centering and scaling if required is done internally.'
     +/'Method 2: X and Y are centered and possibly scaled and Z is'
     +/'          centered and possibly scaled using identical offsets'
     +/'          and scaling factors used for X. Y-predicted will be'
     +/'          centered and scaled by the same values used for Y.'
     +/
     +/'Item            Definition'
     +/'X(N,MX)         Predictor data'
     +/'Y(N,MY)         Response data'  
     +/'N               No. of observations         N>1'         
     +/'MX              No. of predictor variables  MX>1'         
     +/'IP              No. of X variables included 1<IP=< MX'
     +/'MY              No. of response variables   MY>=1'
     +/'Z(K,MX)         New data to predict new Y   K>=1'
     +/'MAXFACT         Maximum no. of factors      MAXFACT=<MX'
     +/'NUMFACT         No. of factors in the model 1=<NUMFACT=<MAXFACT' 
     +/'XBAR(IP)        Means of X'
     +/'XSTD(IP)        Standard deviations of X'
     +/'YBAR(MY)        Means of Y'
     +/'YBAR(MY)        Standard deviations of Y'
     +/'XRES(N,IP)      X residuals (for MAXFACT factors)'
     +/'YRES(N,MY)      Y residuals (for MAXFACT factors)'
     +/'W(IP,MAXFACT)   X weights'
     +/'P(IP,MAXFACT)   X loadings'
     +/'T(N,MAXFACT)    X scores'
     +/'C(MY,MAXFACT)   Y loadings'
     +/'U(N,MAXFACT)    Y scores'
     +/'XCV(MAXFACT)    Cumulative X variance'
     +/'YCV(MAXFACT,MY) Cumulative Y variance'
     +/'OB(IP+1,MY)     Parameters for Method 1 (with offsets in row 1)'
     +/'B(IP,MY)        Parameters for Method 2'
     +/'VIP(IP,VIPOPT)  VIP depending on VIPOPT as follows'
     +/'                VIPOPT = 1,  overall VIP values'
     +/'                VIPOPT = MY, individual VIP values'
     +/'ISCALE          -1: X is not to be scaled internally'
     +/'                 1: X scaled internally by XSTD and Y by YSTD' 
     +/'                 2: X and Y scaled internally by user values'
     +/'ORIG             1: Parameter OB calculated and used for Z'
     +/'                    if X,Y and Z are uncentered/unscaled'
     +/'                    as for Method 1'
     +/'                -1: Parameters B calculated and used for Z'
     +/'                    if X,Y and Z are centered/scaled'
     +/'                    as for Method 2'
     
     +/'RCOND            rank for pseudo-inverse is estimated using'
     +/'                 smallest nonzero-sigma >= RCOND*largest-sigma')       
      end
c
c      