c
c-------------------------------------
c     
      subroutine plsfit (nin, nout,
     +                   asamod) 
c
c action: driver for PLS analysis
c author: w.g.bardsley, university of manchester, uk, 02/04/2007  
c         04/06/2007 added call to dllnag and asamod to arguments
c                                    
c    nin: (input/unchanged) unconnected unit for reading in data
c   nout: (input/unchanged) preconnected unit for results log
c asamod: (input/unchanged) if .true. then call as a module, o/w as part of Simfit
c
      implicit   none 
c
c arguments
c          
      integer, intent (in) :: nin, nout
      logical, intent (in) :: asamod
c
c locals
c         
      integer    ncolx, ncoly, nrowx, nrowy, mark  
      character  fnamex*1024, fnamey*1024, titlex*80, titley*80  
      integer    isend
      integer    icolor, mode, numhdr, numopt, numtxt
      parameter (icolor = 7, mode = 1, numhdr = 7, numopt = 4,
     +           numtxt = 21)
      integer    numbld(30), numpos(numopt), nval(12)
      character  header(numhdr)*100, option(numopt)*50
      character  cval(12)*1024, sim256*1024, text(30)*100
      character  xdata*10, ydata*10
      parameter (xdata = 'g02laf.tf1',
     +           ydata = 'g02laf.tf2') 
      logical    abort, repeet
      logical    first, ok, there
      external   plsdat, sim256, titles, patch2, config, putfat, dllnag
      save       first  
      save       ncolx, ncoly, nrowx, nrowy
      save       fnamex, fnamey, titlex, titley
      data       first / .true. /  
      data       ncolx, ncoly, nrowx, nrowy / 15, 1, 15, 15 / 
      data       numbld / 1*1, 29*0 /
      data       numpos / numopt*1 /
      data       option /
     +'Provide details',
     +'Run the program', 
     +'Configure Simfit',
     +'Quit  ...  Exit' /
c
c check for mark >= 21 
c                    
      call dllnag (mark,
     +             ok)
      if (ok .and. mark.lt.22) then
         call putfat ('requires NAG Library Mark >= 22')
         return
      endif   
       
      if (first) then 
c
c first time define the default data sets
c      
         first = .false.
         fnamex = sim256(xdata)
         inquire (file = fnamex, exist = there)
         if (.not.there) fnamex = xdata 
         titlex =
     +'PLS X-data (i.e. predictor matrix) for g02laf,g02lbf,and g02lcf'
         fnamey = sim256(ydata) 
         inquire (file = fnamey, exist = there)
         if (.not.there) fnamey = ydata  
         titley =  
     +'PLS Y-data (i.e. response matrix) for g02laf,g02lbf, and g02lcf'
      endif  
            
     
      IF (ASAMOD) THEN
c
c put out a header if called as a module
c      
         ABORT = .FALSE.
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (HEADER,100) 
            ISEND = 1
            CALL TITLES (ICOLOR, NUMBLD, ISEND, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
            IF (ISEND.EQ.1) THEN
               WRITE (TEXT,200)
               CALL PATCH2 (NUMBLD, NUMTXT,
     +                      TEXT)            
            ELSEIF (ISEND.EQ.2) THEN
               ABORT = .FALSE.
               REPEET = .FALSE. 
            ELSEIF (ISEND.EQ.3) THEN
               CALL CONFIG (MODE, NVAL,
     +                      CVAL)               
            ELSEIF (ISEND.EQ.4) THEN
               ABORT = .TRUE.
               REPEET = .FALSE.
           ENDIF
         ENDDO
      ELSE
         ABORT = .FALSE.
      ENDIF       
c       
c call the main PLS analysis routine
c      
      if (.not.abort) call plsdat (ncolx, ncoly, nin, nout, nrowx,
     +                             nrowy,                    
     +                             fnamex, fnamey, titlex, titley)
c
c format statements
c     
  100 format (
     + 'Package `SIMFIT'
     +/'Program `PLSFIT'
     +/'Action  `Multivariate calibration and QSAR'
     +/'        `Reads in X-predictor and Y-response matrices as a'
     +/'        `training set to fit a PLS (partial least squares)'
     +/'        `model then calculate new-Y from new-X.'
     +/'Author  `W. G. Bardsley, University of Manchester, U.K.')
  200 format (
     + 'The partial least squares matrices X, Y, new-X, and new-Y'
     +/
     +/'The X-predictor matrix must have N rows and MX columns, and the'
     +/'Y-response matrix must have N rows and MY columns, where N > 1,'
     +/'MX > 1, and MY >= 1. You first choose a large enough number of'
     +/'factors (MAXFACT) to investigate the cumulative variance and'
     +/'correlation between successive scores, using the graphical'
     +/'techniques provided for this purpose. Then you choose a minimum'
     +/'number of factors (NUMFACT) to represent the data sufficiently'
     +/'well to act as a training set, checking this by the VIP plots.'   
     +/      
     +/'The new-X predictor matrix must have MX columns and this will'
     +/'allow the calculation of a new-Y matrix with MY columns.'
     +/
     +/'It is best to supply raw X and Y data and let the program scale'
     +/'internally, so that you can use raw new-X data. Otherwise, if X'
     +/'is centered and scaled before analysis, then new-X must not be'
     +/'centered and scaled but must be shifted and scaled using the'
     +/'same column means and variances used to center and scale X. In'
     +/'this case new-Y will be shifted and scaled by the same column'
     +/'means and variances used to center and scale Y.')
      end 
c     
c
