c
c 
      subroutine plshat (ip, ldy, ldyhat, mx, my, nfact, nout,
     +                   nrow,
     +                   y, yhat)
c
c action: plot/fit/correlate y-data against y-hat from fitting a PLS model
c author: w.g.bardsley, university of manchester, u.k. 16/08/2011
c
      implicit none
c
c arguments
c      
      integer,          intent (in) :: ip, ldy, ldyhat, mx, my, nfact,
     +                                 nout, nrow
      double precision, intent (in) :: y(ldy,my), yhat(ldyhat,my)
c
c allocatables
c      
      double precision, allocatable :: xplot(:), yplot(:)
c
c locals
c      
      integer    i, ierr, m, num, numdec, npts
      integer    numbot, numtop
      integer    l, numopt, numsta, numtxt
      parameter (l = 0, numopt = 6, numsta = 10)
      integer    numbld(30)
      character  ptitle*60, xtitle*30, ytitle*30
      character  text(30)*100
      character (len = 12) form12, word12(7)
      logical    fileit, repeet
      logical    print1
      parameter (print1 = .true.)
      save       num
      save       fileit
      data       num / 1 /
      data       fileit / .false. /
      data       numbld / 30*0 /
      external   getjm1, putfat, gks001, form12, lstbox, linfit, patch2,
     +           putadv
c
c check
c      
      if (ldy.lt.1 .or. ldyhat.lt.1 .or. my.lt.1 .or.
     +    nrow.gt.ldy .or. nrow.gt.ldyhat) then
         call putfat ('Data dimension error in call to PLSHAT')
         return
      endif 
      if (ip.lt.2 .or. ip.gt.mx .or. my.lt.1 .or. nfact.lt.1 .or.
     +    nfact.gt.mx) then
         call putfat ('PLS dimension error in call to PLSHAT')  
         return
      endif     
c
c allocate
c      
      npts = nrow
      ierr = 0
      if (allocated(xplot)) deallocate (xplot, stat = ierr)
      if (ierr.ne.0) return  
      allocate (xplot(npts), stat = ierr)     
      if (ierr.ne.0) return 
      if (allocated(yplot)) deallocate (yplot, stat = ierr)
      if (ierr.ne.0) return  
      allocate (yplot(npts), stat = ierr)     
      if (ierr.ne.0) return        

      word12(1) = form12(mx)  
      word12(2) = form12(ip)  
      word12(3) = form12(nfact)  
      word12(4) = form12(my)  
c
c main loop
c
      repeet = .true.
      numdec = 1
      if (num.gt.my) num = 1
      do while (repeet)  
c
c asign word12 and set up the menu
c
         word12(5) = form12(num)
         if (fileit) then
            word12(6) = '[Yes]'
         else
            word12(6) = '[No]'
         endif  
         word12(7) = word12(6)    
         write (text,100) (word12(i), i = 1, 7) 
         numtxt = numopt + numsta - 1
         numbld(1) = 4 
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text) 
         numbld(1) = 0         
         if (numdec.eq.1) then   
c
c numdec = 1: choose num = y index
c              
            if (num.gt.my) num = 1
            if (my.eq.1) then
               num = 1
               call putadv ('There is only 1 response variable')
            else
               numbot = 1
               numtop = my
               call getjm1 (numbot, num, numtop,
     +                     'Number of the response variable required') 
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: simple plot
c         
            if (npts.le.60) then
               m = 5
            else
               m = 1
            endif
            do i = 1, npts
               xplot(i) = yhat(i,num)
               yplot(i) = y(i,num)
            enddo   
            write (ptitle,200) num
            write (xtitle,300) 
            write (ytitle,400) 
            call gks001 (l, m, npts,
     +                   xplot, yplot,
     +                   ptitle, xtitle, ytitle)
            if (my.eq.1) then
               numdec = 3
            else
               numdec = 1
            endif      
         elseif (numdec.eq.3) then
c
c numdec = 3: full correlation plot
c         
            do i = 1, npts
               xplot(i) = yhat(i,num)
               yplot(i) = y(i,num)
            enddo  
            call linfit (nout, npts,
     +                   xplot, yplot,
     +                   fileit, print1) 
            if (my.eq.1) then
               numdec = numopt
            else
               numdec = 1
            endif             
         elseif (numdec.eq.4) then
c
c numdec = 4: change archiving to results file
c         
            fileit = .not. fileit
            numdec = 3
         elseif (numdec.eq.5) then
c
c numdec = 5: help
c            
            write (text,500)
            numbld(1) = 1
            numtxt = 21
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0 
            numdec = 1           
         else
c
c numdec = numopt: cancel
c           
            repeet = .false.
         endif   
      enddo
c
c deallocate
c
      deallocate (xplot, stat = ierr)
      deallocate (yplot, stat = ierr)
c
c format statements
c      
  100 format (
     + 'Comparing response variable against PLS approximation'
     +/
     +/'Number of predictor variables ... Total MX:',1x,a
     +/'Number of predictor variables ... Included IP:',1x,a
     +/'Number of PLS factors NUMFACT:',1x,a 
     +/'Number of response variables MY:',1x,a
     +/'Response variable selected for plotting/correlation:',1x,a
     +/'Write correlation parameters to the results file:',1x,a
     +/ 
     +/'Change response variable for plotting and correlation'
     +/'Data(as y) against PLS model(as x): Simple plot'
     +/'Data(as y) against PLS model(as x): Correlation options'
     +/'Archive correlation results to log file:',1x,a
     +/'Help'
     +/'Quit ... Exit these PLS options')
  200 format ('Data Against PLS approximation for Column',i3)
  300 format ('Approximation')     
  400 format ('Y-Data')
  500 format (
     + 'Examining the best fit PLS approximation model'
     +/ 
     +/'The current PLS approximation model is for the situation where' 
     +/'there are MX predictor variables, of which IP are currently' 
     +/'selected, MY response variables, and MAXFACT factors have been'
     +/'fitted. NUMFACT of these are currently being investigated to' 
     +/'choose a satisfactory best fit PLS model approximation with'
     +/'    MX >= IP >= 2, MY >= 1, and MX >= MAXFACT >= NUMFACT.'  
     +/ 
     +/'One of the ways to assess the goodness of fit of the PLS' 
     +/'model is to simply examine a plot with y = a column of the'
     +/'original response data and x = the corresponding column of'
     +/'the predicted PLS model approximation with NUMFACT factors, to' 
     +/'see if there is a linear relationship with slope approximately' 
     +/'one and intercept close to zero.' 
     +/ 
     +/'A more advanced way is to perform a full linear regression and'
     +/'correlation analysis for a more quantitative analysis. If this' 
     +/'is done, it is best to plot the data with both y = A + Bx, and' 
     +/'x = C + Dy or, better still, a major or reduced major axis'
     +/'regression line as, in this context, y is not a function of x.') 
      end
c
c      