c
c
      subroutine plslab (m, n,
     +                   ellx, elly, x, y,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)
c
c action: plot a PLS label type file
c author: w.g.bardsley, university of manchester, U.K
c         11/04/2007 derived from PCA002
c         12/06/2007 now uses sim256 to define labfil
c         30/01/2022 added e_numbers and e_formats, etc.
c
c      m: (input/unchanged) ellipse dimension
c      n: (input/unchanged) data dimension
c   ellx: (input/unchanged) ellipse coordinates
c   elly: (input/unchanged) ellipse coordinates
c      x: (input/unchanged) data coordinates
c      y: (input/unchanged) data coordinates
c ptitle: (input/unchanged) plot title
c  wordx: (input/unchanged) plot labels
c xtitle: (input/unchanged) x-legend
c ytitle: (input/unchanged) y-legend
c ellips: (input/unchanged) if .true. then plot an ellipse
c
c         nmax = maximum number of data files to plot
c
      implicit   none
c
c arguments
c      
      integer,             intent (in) :: m, n
      double precision,    intent (in) :: ellx(m), elly(m), x(n), y(n)
      character (len = *), intent (in) :: ptitle, wordx(n), xtitle,
     +                                    ytitle
      logical,             intent (in) :: ellips
c
c locals
c      
      integer    i
      integer    ifail, ntotal
      integer    nmax, nout, n0, n1, n2
      parameter (nmax = 2, nout = 10, n0 = 0, n1 = 1, n2 = 2)
      integer    jfiles(nmax), lfiles(nmax), mfiles(nmax), nfiles
      character (len = 13) d13(2), showrj
      character (len = 12) i12(2), form12
      character  filex*1024, filey*1024, labfil*1024, title*80,
     +           sim256*1024
      character  files(nmax)*1024, titles(4)*80
      logical    e_numbers, e_formats
      logical    askif, there
      parameter (askif = .false.)
      external   e_formats, form12, showrj
      external   gettmp, deleet, putfat, sim256
      external   smplot
      data       jfiles, lfiles, mfiles
     +         / nmax*0, nmax*0, nmax*1 /    
      e_numbers = e_formats()  
c
c Define ntotal and labfil
c
      ntotal = n 
      labfil = sim256('f$labels.tmp')
c
c Open a temporary file and connect to a temporary unit
c
      call gettmp (ifail, 
     +             filex)
      open (unit = nout, file = filex)
c
c The file title identifies the file type to simplot
c THE NEXT LINE MUST NOT BE TRANSLATED
c *************************************
c
      write (title,100) '%simfitplotlabelsfile%'
      write (nout,100) title
      if (e_numbers) then
         write (nout,200) ntotal, n2
      else
         i12(1) = form12(ntotal)
         i12(2) = form12(n2)
         write (nout,250) i12(1), i12(2)
      endif  
      do i = 1, ntotal
         if (e_numbers) then
            write (nout,300) x(i), y(i)
         else
            d13(1) = showrj(x(i))
            d13(2) = showrj(y(i))
            write (nout,350) d13(1), d13(2)
         endif       
      enddo
      write (nout,400) n1
      write (nout,100) 'Default Line'
      close (unit = nout)
c
c Create the actual labels file
c
      call deleet (labfil,
     +             askif, there)
      if (there) then
         call putfat ('You must attrib -r f$labels.tmp then delete')
      else
         open (unit = nout, file = labfil)
         do i = 1, ntotal
            write (nout,100) wordx(i)
         enddo
         close (unit = nout)
      endif
      nfiles = n1
      files(nfiles) = filex
      if (ellips) then
c
c Open a temporary file and connect to a temporary unit
c
         call gettmp (ifail,
     +                filey)
         open (unit = nout, file = filey)
         write (title,100) 'ellipse data'
         write (nout,100) title
         if (e_numbers) then
            write (nout,200) ntotal, n2
         else
            i12(1) = form12(ntotal)
            i12(2) = form12(n2)
            write (nout,250) i12(1), i12(2)
         endif  
         do i = 1, m
            if (e_numbers) then
               write (nout,300) ellx(i), elly(i)
            else
               d13(1) = showrj(ellx(i))
               d13(2) = showrj(elly(i))
               write (nout,350) d13(1), d13(2)
            endif   
         enddo
         write (nout,400) n1
         write (nout,100) 'Default Line'
         close (unit = nout)
         nfiles = nfiles + n1
         files(nfiles) = filey
         lfiles(nfiles) = n1
         mfiles(nfiles) = n0
      endif
      titles(1) = ptitle
      titles(2) = xtitle
      titles(3) = ytitle
      titles(4) = ' '
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      call deleet (filex,
     +             askif, there)
      if (ellips) call deleet (filey,
     +                         askif, there)
c
c format statements
c     
  100 format (a)
  200 format (2i6)
  250 format (2a12) 
  300 format (1p,2e12.4)
  350 format (2a13)
  400 format (i3)
      end
c
c
