c
c     
      subroutine plsmod (isx, ncmaxx, ncmaxy, ncolx, ncoly, nin, nout,
     +                   nrmaxx, nrmaxy, nrowx, nrowy, 
     +                   x, y,
     +                   fnamea, fnameb, 
     +                   newdat)
c
c action: fit a PLS model      
c author: w.g.bardsley, university of manchester, u.k., 30/03/2007
c         18/05/2007 added option to change orig and re-calculate parameters 
c         23/05/2007 added messages when parameters re-calculated 
c         28/05/2007 added putifa and model fitting and parameter estimation now separated
c         29/07/2007 added verbose and changed initialisation of numdec
c         06/04/2010 increased labels to maximum = 2000 and code for nlabel and getlab
c         20/04/2010 added extra column to ycvar for averages
c         23/06/2010 added parameters_ready to plsplt argument list
c         18/08/2011 added call to plshat
c         15/06/2015 added numdec_sav to ensure parameters re-calculated for options 6 an 7
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: ncmaxx, ncmaxy, ncolx,
     +                                       ncoly, nin, nout,
     +                                       nrmaxx, nrmaxy, nrowx,
     +                                       nrowy
      integer,             intent (inout) :: isx(ncolx)  
      double precision,    intent (in)    :: x(nrmaxx,ncmaxx),
     +                                       y(nrmaxy,ncmaxy)  
      character (len = *), intent (in)    :: fnamea, fnameb
      logical,             intent (out)   :: newdat(2) 
c
c local allocatable arrays
c        
      double precision,     allocatable :: b(:,:), c(:,:), origb(:,:), 
     +                                     p(:,:), t(:,:), u(:,:), 
     +                                     vip(:,:), w(:,:), 
     +                                     xbar(:), xcvar(:), xres(:,:),
     +                                     xstd(:), ybar(:),
     +                                     ycvar(:,:), yhat(:,:), 
     +                                     yres(:,:), ystd(:)        
      character (len = 40), allocatable :: labels(:)
c
c locals
c      
      integer    i, ip, j, ldb, ldorigb, 
     +           ldvip, ldw, ldx, ldxres, ldycvar, ldyhat, ldyres,
     +           maxfact, maxfact_sav, nfact, nfact_sav, orig, vipopt  
      integer    ifail1, ifail2, ios, nlabel, nlines
      integer    n, mx, my, ldy, ldp, ldt, ldc, ldu 
      integer    scale1
      integer    nbot, ntop
      integer    icolor, ix, iy, lshade
      parameter (icolor = 7, ix = 4, iy = 4, lshade = 0)
      integer    numdec, numdec_sav, nstart, ntext, numopt 
      integer    numbld(30), numpos(20)
      integer    nxmin
      parameter (nxmin = 2)
      double precision dmy, sumy
      double precision rcond, zero
      parameter (rcond = 0.005d+00, zero = 0.0d+00)
      character  header*100, line*100, text(30)*100, word20(6)*20   
      character  cipher(2)*20, mssage(5)*20, yesno*3 
      character  keys(6)*20, fit(5)*60, params(2)*20, values(6)*8
      logical    model_ready, parameters_ready 
      logical    getlab, repeet, showit, verbose 
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   putfat, lbox01, isxtyp, isxedi, revpro, triml1, getjm1,
     +           putadv, patch2, writer, putifa  
      external   plsres, plsprd, plsplt, plshat, plsdef
      external   g02laf$, g02lcf$, g02ldf$   
      intrinsic  max, min, dble
      data       numbld / 30*0 /
      data       numpos / 20*1 / 
      data       mssage / '***** Fit now *****',
     +                    'Fitted OK          ',
     +                    'Current variables: ',
     +                    'Calculate now      ', 
     +                    'Calculated OK      ' /
      data       keys /   '[No scaling]       ',
     +                    '[Unit variance]    ',
     +                    '[VIPOPT = 0, none] ',
     +                    '[VIPOPT = 1, mean] ',
     +                    '[VIPOPT = MY, all] ',
     +                    '[VIPOPT = 1 = MY]  ' /
      data       fit /                         
     +'Fitting a PLS model was successful                          ',
     +'Fitting successful (*** Note: X-variables re-numbered ***)  ',
     +'Fitting a PLS model failed                                  ',
     +'Best Fit Parameters have been calculated                    ',
     +'Best Fit Parameters could not be calculated                 ' / 
      data       params / '[Internal only]    ',
     +                    '[Both types]       ' / 
      data       values / ' maxfact',
     +                    '   nfact',
     +                    '   scale',
     +                    '      ip',
     +                    '   origb',
     +                    '  vipopt' /  
c
c initialise and save the nag parameters and nfact_sav
c     
      save       verbose
      save       nfact, orig, scale1, vipopt
      data       verbose / .true. /
      data       nfact, orig, scale1, vipopt / 2, 1, 1, 1 / 
      save       model_ready, parameters_ready      
c     
c initialise newdat and set nfact_sav to force parameter calculation with new data
c 
      newdat(1) = .false.
      newdat(2) = .false. 
      model_ready = .false.
      parameters_ready = .false.
c
c check input parameters
c                             
      if (ncolx.lt.2 .or. ncolx.gt.ncmaxx .or.
     +    ncoly.lt.1 .or. ncoly.gt.ncmaxy .or.
     +    nrowx.lt.2 .or. nrowx.gt.nrmaxx .or.
     +    nrowy.lt.2 .or. nrowy.gt.nrmaxy) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (nrowx.ne.nrowy) then
          write (line,200)
          call putfat (line)
          return
      endif   
c
c check vipopt 
c               
      if (vipopt.lt.0) then
         vipopt = 0
      elseif (vipopt.gt.1) then   
         vipopt = my
      endif    
c
c assign nag parameters
c 
                     
      n = nrowx
      mx = ncolx
      my = ncoly     
      ldx = nrmaxx  
      ldy = nrmaxy
        
      maxfact = min(12,ncolx - 1)                
      if (nfact.gt.maxfact) nfact = maxfact

      ldxres = n
      ldyres = n
      ldw = mx
      ldp = mx
      ldt = n 
      ldc = my
      ldu = n
      ldb = mx
      ldorigb = mx + 1
      ldycvar = mx
      ldyhat = n
      ldvip = mx
      
c
c allocate nag arrays and plotting labels
c     
 
      allocate(b(ldb,my), c(ldc,mx), origb(ldorigb,my), 
     +         p(ldp,mx), t(ldt,mx), u(ldu,mx),
     +         vip(ldvip,my), w(ldw,mx), xbar(mx),
     +         xcvar(mx), xres(ldxres,mx), xstd(mx), ybar(my),
     +         ycvar(ldycvar,my + 1), yhat(ldyhat,my), yres(ldyres,my),
     +         ystd(my))
      nlabel = n + max(mx,my)
      if (nlabel.gt.2000) then
         nlabel = 1
         getlab = .false.
      else
         getlab = .true.
      endif      
      allocate(labels(nlabel)) 
      
c
c prepare for main loop ............................................................
c                   
      write (word20(2),'(i20)') maxfact
      call triml1 (word20(2)) 
      write (word20(3),'(i20)') nfact
      call triml1 (word20(3))
     
      getlab = .true.  
      
c
c main loop..........................................................................
c 
      numdec_sav = 0
      repeet = .true.
      do while (repeet)
c
c check the number of free variables
c      
         call isxtyp (isx, ncolx, ip, nxmin, 
     +                header,
     +                showit) 
         write (word20(1),'(i20)') ip
         call triml1 (word20(1)) 
c
c set up the main menu
c                 
         if (model_ready) then
            cipher(1) = mssage(2)
         else
            cipher(1) = mssage(1)
         endif
         if (parameters_ready) then
            cipher(2) = mssage(5)
         else
            cipher(2) = mssage(4)
         endif
         if (scale1.eq.-1) then
            word20(4) = keys(1)  
         else
            scale1 = 1
            word20(4) = keys(2)
         endif                 
         if (vipopt.eq.0) then
            word20(5) = keys(3) 
         elseif (my.gt.1) then
            if (vipopt.eq.1) then 
               word20(5) = keys(4)
            else
               vipopt = my
               word20(5) = keys(5)  
            endif    
         else
            vipopt = 1
            word20(5) = keys(6)    
         endif
         if (orig.eq.-1) then
            word20(6) = params(1)
         else
            orig = 1
            word20(6) = params(2)
         endif  
         if (verbose) then
            yesno = 'Yes'
         else
            yesno = 'No'
         endif      
c
c write out the main menu
c                                 
         write (text,300) header, word20(1),
     +                   (cipher(i), i = 1, 2), 
     +                   (word20(i), i = 2, 6),
     +                    yesno
         nstart = 7
         numopt = 18
         ntext = nstart + numopt - 1
         if (model_ready) then
            if (numdec_sav.eq.6 .or. numdec_sav.eq.7) then
c
c ensure option 6 or 7 is re-selected after parameters have been re-calculated
c              
               numdec = numdec_sav
            else   
               numdec  = 5
            endif   
         else   
            numdec = 2
         endif 
         numdec_sav = 0  
         numbld(1) = 4
         numbld(4) = 1   
c
c call the menu control
c         
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
c
c check for options that require previous fitting
c                       
         if (.not.model_ready) then
            if (numdec.ge.3 .and.numdec.le.7) then
               write (line,400)
               call putadv (line)
               numdec = 0
            endif   
         endif       
c
c check for options before calling the nag routines to avoid ifail failures
c                   
         if (numdec.eq.2) then 
            if (maxfact.lt.1 .or. maxfact.gt.ip) then
               write (line,500)
               call putfat (line)
               numdec = 0    
            elseif (nfact.lt.1 .or. nfact.gt.maxfact) then
               write (line,600)
               call putfat (line)
               numdec = 0            
            elseif (ip.lt.2) then
               write (line,700)
               call putfat (line)
               numdec = 0   
            elseif (n.lt.2 .or. mx.lt.2 .or. my.lt.1) then
               write (line,800)
               call putfat (line)
               numdec = 0    
            endif      
         endif           
c
c check that parameters have been calculated before predicting
c        
         if (model_ready .and. .not.parameters_ready) then                                                     
            if (numdec.eq.6 .or. numdec.eq.7) then
               numdec_sav = numdec
               numdec = 3 
            else
               numdec_sav = 0   
            endif   
         endif
         
c
c----------------------------------------------------------------------
c start of the options
c---------------------------------------------------------------------- 
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ==========
c         
            newdat(1) = .true.
            repeet = .false.   
         elseif (numdec.eq.2) then
c
c numdec = 2: call the nag pls routine                      
c ==========
c
            model_ready = .false.
            parameters_ready = .false.  
            ifail1 = 1 
            call g02laf$ (n, mx, x, ldx, isx, ip, my, y, ldy, xbar,
     +                    ybar,  scale1, xstd, ystd, maxfact, xres,
     +                    ldxres, yres, ldyres, w, ldw, p, ldp, t,
     +                    ldt, c, ldc, u, ldu, xcvar, ycvar, ldycvar,
     +                    ifail1) 
            if (ifail1.eq.0) then
               model_ready = .true.
               numdec = 5 
               if (verbose) then
                  if (ip.eq.mx) then
                     call putadv (fit(1))
                  else
                     call putadv (fit(2))
                  endif 
               endif        
               if (showit) then 
                  text(1) = mssage(3)
                  text(2) = header  
                  nlines = 2
                  call writer (ios, nlines, nout,
     +                         text)                    
               endif 
c
c calculate average y variances
c               
               dmy = dble(my)
               do i = 1, maxfact
                  sumy = zero
                  do j = 1, my
                     sumy = sumy + ycvar(i,j)
                  enddo
                  ycvar(i,my + 1) = sumy/dmy   
               enddo     
            else 
               model_ready = .false. 
               call putfat (fit(3)) 
               call putifa (ifail1, nout,
     +                     'G02LAF/PLSMOD')  
            endif 
         elseif (numdec.eq.3) then
c
c numdec = 3: calculate parameters
c ==========
c                                 
            parameters_ready = .false.  
            ifail2 = 1 
            call g02lcf$ (ip, my, maxfact, nfact, p, ldp, c, ldc, w, 
     +                    ldw, rcond, b, ldb, orig, xbar, ybar, scale1,
     +                    xstd, ystd, origb, ldorigb, vipopt, ycvar,
     +                    ldycvar, vip, ldvip, ifail2)          
            if (ifail2.eq.0) then
               parameters_ready = .true. 
               if (verbose) call putadv (fit(4))   
               write (text(1),'(6a8)') (values(i), i = 1, 6)
               write (text(2),'(6i8)') maxfact, nfact, scale1, ip,
     +                                 orig, vipopt 
               nlines = 2
               call writer (ios, nlines, nout,
     +                      text) 
                if (orig.eq.1) then
                  ifail2 = 1
                  call g02ldf$ (ip, my, orig, xbar, ybar, scale1, xstd,
     +                          ystd, origb, ldorigb, n, mx, isx, x,
     +                          ldx, yhat, ldyhat, ifail2)
                  call putifa (ifail2, nout, 'G02LDF/PLSMOD')   
               else   
                  ifail2 = 1
                  call g02ldf$ (ip, my, orig, xbar, ybar, scale1, xstd,
     +                          ystd, b, ldb, n, mx, isx, x, ldx,
     +                          yhat, ldyhat, ifail2) 
                  call putifa (ifail2, nout, 'G02LDF/PLSMOD')
               endif 
            else 
               parameters_ready = .false. 
               call putfat (fit(5))   
               call putifa (ifail2, nout,
     +                     'G02LCF/PLSMOD')
            endif 
         elseif (numdec.eq.4) then
c
c numdec = 4: view output (if model_ready = .true.)
c ==========
c                                       
            if (model_ready) then 
               call plsres (ip, ldb, ldc, ldorigb, ldp, ldt, ldu, 
     +                      ldvip, ldw, ldx, ldxres, ldy, ldycvar,
     +                      ldyres, maxfact, mx, my, n, nfact, nout,
     +                      orig, vipopt,
     +                      b, c, origb, p, t, u, vip, w, x, xbar,
     +                      xcvar, xres, xstd, y, ybar, ycvar, yres,
     +                      ystd,
     +                      parameters_ready)
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: plot output (if model_ready = .true.)
c ==========
c                                                                    
            if (model_ready) then
               call plsplt (ip, isx, ldc, ldp, ldt, ldu, ldvip, ldw,
     +                      ldycvar, maxfact, mx, my, n, nlabel, nout,
     +                      vipopt,
     +                      c, p, t, u, vip, w, xcvar, ycvar,
     +                      fnamea, fnameb, labels,
     +                      getlab, parameters_ready) 
            endif  
         elseif (numdec.eq.6) then    
c
c numdec = 6: plot y against yhat
c ==========
c                    
            if (model_ready) then
               call plshat (ip, ldy, ldyhat, mx, my, nfact, nout, n,
     +                      y, yhat)               
            endif   
         elseif (numdec.eq.7) then
c
c numdec = 7: predict Y from X (if model_ready = parameters_ready = .true.)
c ==========
c                                                   
            if (model_ready .and. parameters_ready) then
               call plsprd (ip, isx, ldb, ldorigb, mx, my, nfact, nin,
     +                      nout, orig, scale1,       
     +                      b, origb, xbar, xstd, ybar, ystd)                
            endif
         elseif (numdec.eq.8) then
c
c numdec = 8: suppress/restore variables
c ==========
c         
             call isxedi (isx, ncolx, ip, nxmin) 
             write (word20(1),'(i20)') ip
             call triml1 (word20(1))
             model_ready = .false.
             parameters_ready = .false.   
         elseif (numdec.eq.9) then
c
c numdec = 9: change maximum number of factors, i.e. maxfact
c ==========
c                 
             maxfact_sav = maxfact          
             nbot = 1
             ntop = max(nfact,ip)
             if (maxfact.lt.nbot) then
                maxfact = nbot
             elseif (maxfact.gt.ntop) then
                maxfact = ntop
             endif       
             if (ntop.gt.nbot) then
                write (line,900)
                call getjm1 (nbot, maxfact, ntop,
     +                       line) 
             else
                write (line,1000)
                call putadv (line)
             endif  
             write (word20(2),'(i20)') maxfact
             call triml1 (word20(2)) 
             if (maxfact.gt.maxfact_sav)then
                maxfact_sav = maxfact
                model_ready = .false.     
             endif
          elseif (numdec.eq.10) then
c
c numdec = 10: change number of parameter factors, i.e. nfact
c ===========
c                            
             nbot = 1
             ntop = maxfact 
             nfact_sav = nfact
             if (nfact.lt.nbot) then
                nfact = nbot
             elseif (nfact.gt.ntop) then
                nfact = ntop
             endif       
             if (ntop.gt.nbot) then
                write (line,1100)
                call getjm1 (nbot, nfact, ntop,
     +                       line) 
             else
                write (line,1000)
                call putadv (line)
             endif  
             write (word20(3),'(i20)') nfact
             call triml1 (word20(3))
             if (nfact.ne.nfact_sav) parameters_ready = .false. 
          elseif (numdec.eq.11) then
c
c numdec = 11: change internal scaling
c ===========
c                                   
             if (scale1.eq.-1) then
                scale1 = 1
             else
                scale1 = -1
             endif 
             model_ready = .false. 
             parameters_ready = .false.
         elseif (numdec.eq.12) then
c
c numdec = 12: change VIP method
c ===========
c                          
             if (vipopt.eq.0) then
                vipopt = 1
             elseif (vipopt.eq.1) then
                if (my.gt.1) then
                   vipopt = my 
                else
                   vipopt = 0
                endif      
             else
                vipopt = 0
             endif        
             parameters_ready = .false.                 
         elseif (numdec.eq.13) then
c
c numdec = 13: change orig
c ===========
c                                  
            orig = - orig
            if (orig.eq.1) parameters_ready = .false. 
         elseif (numdec.eq.14) then
c
c numdec = 14: change verbose
c ============
c
            verbose = .not.verbose              
         elseif (numdec.eq.numopt - 3) then
c
c numdec = numopt - 3: results 
c ===================
c         
             call revpro (nout)        
         elseif (numdec.eq.numopt - 2) then    
c
c numdec = numopt - 2: help 
c ===================
c                              
            write (text,1200)
            numbld(1) = 1
            numbld(13) = 1
            numbld(18) = 1
            ntext = 21
            call patch2 (numbld, ntext,
     +                   text) 
            numbld(1) = 0
            numbld(13) = 0
            numbld(18) = 0
         elseif (numdec.eq.numopt - 1) then    
c
c numdec = numopt - 1: help 
c ===================
c                      
            call plsdef  
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel 
c ===============
c         
            repeet = .false.
         endif
c
c----------------------------------------------------------------------
c end of the options
c---------------------------------------------------------------------- 
c                                                                      
      enddo 
        
c
c deallocate the nag arrays and labels
c     
      deallocate(b, c, origb, p, t, u, vip, w, xbar, xcvar, xres, xstd,
     +           ybar, ycvar, yhat, yres, ystd)
      deallocate(labels)
c
c format statements
c        
  100 format ('Inconsistent data supplied to PLSFIT')    
  200 format ('Must have no. rows of X equal to no. of rows of Y')
  300 format (
     + 'Partial Least Squares Analysis (PLS)'
     +/
     +/'Variables'
     +/A 
     +/'Number of free variables =',1x,a
     +/
     +/'New data'
     +/'PLS model:',1x,a 
     +/'PLS parameters and VIP:',1x,a
     +/'View/File statistics'
     +/'Plot statistics'
     +/'Plot Y-measured against PLS approximation'
     +/'Predict new-Y from new-X' 
     +/'Suppress/Restore variables'  
     +/'Change number of factors: MAXFACT =',1x,a
     +/'Change number of factors: NUMFACT =',1x,a
     +/'Change internal scaling: current =',1x,a 
     +/'Change VIP method: current =',1x,a 
     +/'Change parameter estimation: current =',1x,a
     +/'Confirm successful calculations:',1x,a
     +/'Results'
     +/'Help: PLS summary'
     +/'Help: PLS definitions'
     +/'Quit ... Exit PLS analysis')     
  400 format ('First fit a PLS model')  
  500 format (
     +'Must have maxfact >= 1 and maxfact =< no. of free variables')
  600 format (
     +'Must have numfact >= 1 and numfact =< maxfact')
  700 format (
     +'Must have number of free variables >= 2')
  800 format (
     +'Must have no. of rows > 1, no. X columns > 1, no. Y columns > 0')
  900 format ('MAXFACT: the maximum number of factors required') 
 1000 format ('No variation is possible') 
 1100 format ('NUMFACT: the actual number of factors required') 
 1200 format (
     + 'Partial Least Squares Analysis (PLS)'
     +/
     +/'This uses a N by MX X-matrix of predictor variables and a N by'
     +/'MY Y-matrix of response variables and finds best-fit parameters'
     +/'to maximise correlation between X and Y in subspaces of lower'
     +/'dimension. The parameters can then be used to predict a M by MY'
     +/'Y-matrix of responses from a new M by MX X-matrix of predictor'
     +/'variables, as in quantitative structure activity relationships'
     +/'(QSAR) or multivariate calibration. The X-matrix is always'
     +/'centered internally and can also be scaled to unit variance if'
     +/'required, so you do not need to input centered and scaled data.'
     +/
     +/'MAXFACT'
     +/'This is the maximum number of dimensions fitted, usually much'
     +/'less than MX so that the cumulative statistics can be observed'
     +/'to find a mimimum but sensible number of factors to use.'
     +/
     +/'NUMFACT'
     +/'This is the actual number of factors to use in prediction, and'
     +/'is usually much less than MAXFACT but sufficient to account for'
     +/'a large enough proportion of variance and covariance.')
      end
c
c         