c
c
      subroutine plsplt (ip, isx, ldc, ldp, ldt, ldu, ldvip, ldw,
     +                   ldycvar, maxfact, mx, my, n, nlabel, nout,
     +                   vipopt, 
     +                   c, p, t, u, vip, w, xcvar, ycvar,
     +                   fnamea, fnameb, wordx,
     +                   getlab, parameters_ready) 
c
c action: plot PLS matrices
c author: w.g.bardsley, university of manchester, u.k., 09/04/2007
c         06/04/2010 added nlabel to argument list
c         20/04/2010 used averages in last column of ycvar
c         23/06/2010 added parameters_ready to argument list and check for VIP
c
      implicit none
c
c arguments
c       
      integer,             intent (in)    :: ip, ldc, ldp, ldt, ldu,
     +                                       ldvip, ldw, ldycvar,
     +                                       maxfact, mx, my, n, nlabel, 
     +                                       nout, vipopt 
      integer,             intent (in)    :: isx(mx)
      double precision,    intent (in)    :: c(ldc,maxfact), 
     +                                       p(ldp,maxfact),
     +                                       t(ldt,maxfact),
     +                                       u(ldu,maxfact),
     +                                       vip(ldvip,my),
     +                                       w(ldw,maxfact),
     +                                       xcvar(maxfact),
     +                                       ycvar(ldycvar,my + 1)
      character (len = *), intent (in)    :: fnamea, fnameb 
      character (len = *), intent (inout) :: wordx(nlabel)   
      logical,             intent (inout) :: getlab
      logical,             intent (in)    :: parameters_ready
c
c local allocatable arrays
c                         
      double precision,     allocatable :: x1(:), x2(:), y1(:), y2(:)
      double precision,     allocatable :: xgraf(:), ygraf(:) 
      double precision,     allocatable :: xmat(:,:)
      character (len = 10), allocatable :: xlab(:)
c
c locals
c                          
      integer    i, ierr, isend, iy, j, k, nget, nmax, ntemp, numdec   
      integer    iybot, iymid, iytop
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      integer    ngbot, ngraf, ngtop
      parameter (ngbot = 10, ngtop = 1000)
      integer    numopt, numtxt
      parameter (numopt = 24, numtxt = 21)
      integer    numbld(numtxt) 
      double precision x3(2), x4(2), y3(2), y4(2)
      double precision siglev
      double precision zero, sigbot, sigmid, sigtop
      parameter (zero = 0.0d+00, sigbot = 0.001d+00, sigmid = 0.05d+00, 
     +           sigtop = 0.99d+00)
      character  cipher*10, line*100, text(30)*100, word6*6   
      character  titles(4)*40
      character  ptitle*60, xtitle*40, ytitle*40 
      character  blank*1
      parameter (blank = ' ')
      logical    abort, ellips, repeet
      logical    axes, gsave, none
      parameter (axes = .true., gsave = .true., none = .false.) 
      external   listbx, getjm1, triml1, eofcha, getdm1, patch2
      external   gks004, mtplot, plssym, plscor, plsrot, bcplot,
     +           putfat 
      intrinsic  max   
      save       ngraf, ellips, siglev 
      data       ngraf / 100 / 
      data       ellips / .true. /
      data       siglev / 0.05d+00 / 
      data       numbld /numtxt*0 /
c
c allocate
c         
      ierr = 0
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(x2)) deallocate(x2, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y2)) deallocate(y2, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(xmat)) deallocate(xmat, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(xlab)) deallocate(xlab, stat = ierr)
      if (ierr.ne.0) return 
      nmax = max(ip, ldc, ldp, ldt, ldu, ldvip, ldw, ldycvar,
     +           maxfact, my, n) + 1
      allocate (x1(nmax), stat = ierr)
      if (ierr.ne.0) return    
      allocate (x2(nmax), stat = ierr)
      if (ierr.ne.0) return
      allocate (y1(nmax), stat = ierr)
      if (ierr.ne.0) return  
      allocate (y2(nmax), stat = ierr)
      if (ierr.ne.0) return    
      allocate (xgraf(ngraf), stat = ierr)
      if (ierr.ne.0) return  
      allocate (ygraf(ngraf), stat = ierr)
      if (ierr.ne.0) return  
      allocate (xmat(maxfact,2), stat = ierr)
      if (ierr.ne.0) return
      allocate (xlab(maxfact), stat = ierr)
      if (ierr.ne.0) return    
c
c initialise
c           
      do i = 1, 2
         x3(i) = zero
         x4(i) = zero
         y3(i) = zero
         y4(i) = zero
      enddo 
      iy = 1
      do i = 1, maxfact
         xmat(i,1) = xcvar(i)
         write (xlab(i),'(i10)') i
         call triml1 (xlab(i))
      enddo
c
c main loop
c      
      if (nlabel.lt.n + max(ldp,my)) getlab = .false.
      repeet = .true.
      do while (repeet)     
         if (ellips) then
            cipher = '[Yes]'
         else
            cipher = '[No]'
         endif      
         write (text,100) cipher, siglev, ngraf  
         numdec = numopt - 1
         call listbx (numdec, numopt,
     +                text)
         if (numdec.ge.14 .and. numdec.le.17) then
            if (getlab) then 
c
c initialise labels
c         
               if (numdec.eq.15) then
                  nget = n + mx 
                  call eofcha (nget,
     +                         fnamea, wordx,
     +                         abort)
               elseif (numdec.eq.17) then
                  nget = n + my 
                  call eofcha (nget,
     +                         fnameb, wordx,
     +                         abort)
               else
                  nget = n
                  call eofcha (nget,
     +                         fnameb, wordx,
     +                         abort)
                  if (abort) then 
                     call eofcha (nget,
     +                            fnamea, wordx,
     +                            abort)
                  endif 
               endif
               if (abort) then
                  do i = 1, n  
                     wordx(i) = blank
                     write (wordx(i)(1:6),'(i6)') i
                  enddo 
                  do i = n + 1, nlabel
                      wordx(i) = blank
                     write (wordx(i)(1:6),'(i6)') i - n
                  enddo                             
               endif 
               if (numdec.eq.15 .and. ip.lt.mx) then
                   k = mx
                   do i = mx - 1, 1, -1
                      if (isx(i).eq.0) then
                         k = k - 1
                         do j = n + i, n + k
                            wordx(j) = wordx(j + 1)
                         enddo  
                      endif  
                   enddo  
               endif  
            else     
               numdec = numopt - 1   
               call putfat ('Too many labels requested')
            endif       
         endif
         if (numdec.eq.1) then   
c
c numdec = 1: cumulative variances: standard plot
c         
            iybot = 1 
            iytop = my + 1     
            if (iy.lt.iybot .or. iy.gt.iytop) then
               iymid = iytop
            else
               iymid = iy
            endif 
            write (word6,'(i6)') iytop  
            call triml1 (word6)        
            write (line,200) word6
            call getjm1 (iybot, iymid, iytop,
     +                   line)
            iy = iymid
            if (iy.eq.my + 1) then
               ptitle = 'X and Average Y, (O=X,*=Y)'
            else   
               write (word6,'(i6)') iy  
               call triml1 (word6)
               write (ptitle,300) word6, '(O=X,*=Y)'
            endif   
            write (xtitle,400)
            write (ytitle,500) 
            do i = 1, maxfact + 1
                x1(i) = dble(i - 1)
                x2(i) = x1(i) 
                if (i.eq.1) then
                   y1(i) = zero
                   y2(i) = zero
                else   
                   y1(i) = xcvar(i - 1)
                   y2(i) = ycvar(i - 1,iy)
                endif   
            enddo
            l1 = 0
            l2 = 0
            l3 = 0
            l4 = 0
            m1 = 5
            m2 = 4
            m3 = 0
            m4 = 0
            n1 = maxfact + 1
            n2 = maxfact + 1
            n3 = 0
            n4 = 0
            call gks004 (l1, l2, l3, l4, 
     +                   m1, m2, m3, m4,
     +                   n1, n2, n3, n4,        
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
         elseif (numdec.eq.2) then
c
c numdec = 2: cumulative variances: bar chart
c                                             
            iybot = 1 
            iytop = my + 1     
            if (iy.lt.iybot .or. iy.gt.iytop) then
               iymid = iytop
            else
               iymid = iy
            endif 
            write (word6,'(i6)') iytop  
            call triml1 (word6)        
            write (line,200) word6
            call getjm1 (iybot, iymid, iytop,
     +                   line)
            iy = iymid
            if (iy.eq.my + 1) then
               titles(1) = 'X and Average Y, (lhs=X,rhs=Y)'
            else  
               write (word6,'(i6)') iy  
               call triml1 (word6) 
               write (titles(1),300) word6, '(lhs=X,rhs=Y)'
            endif   
            write (titles(2),400)
            write (titles(3),500) 
            titles(4) = '...' 
            do i = 1, maxfact
               xmat(i,2) = ycvar(i,iy)
            enddo    
            isend = 2
            n2 = 2
            call bcplot (isend, n2, maxfact, maxfact,
     +                   xmat,
     +                   xlab, titles)            
         elseif (numdec.eq.3) then
c
c numdec = 3: Correlation
c         
             call plscor (ldt, ldu, maxfact, n, nout,
     +                    t, u)             
         elseif (numdec.eq.4) then
c
c numdec = 4: VIP
c               
             if (vipopt.eq.1) then
                isend = 1  
                ierr = 1
             elseif (vipopt.eq.my) then                    
                isend = 2
                ierr = my
             endif   
             if (vipopt.ne.0 .and. parameters_ready) then
                call mtplot (isend, ierr, ierr, ldvip, ip,
     +                       vip)
             else
                call putfat ('VIP has not yet been calculated')
             endif            
         elseif (numdec.eq.5) then
c
c numdec = 5: X-scores
c                                
             isend = 2
             call mtplot (isend, maxfact, maxfact, ldt, n,
     +                    t)            
         elseif (numdec.eq.6) then
c
c numdec = 6: X-loadings
c                
            isend = 2
            call mtplot (isend, maxfact, maxfact, ldp, ip,
     +                   p)    
          elseif (numdec.eq.7) then
c
c numdec = 7: W-weightings
c                
            isend = 2
            call mtplot (isend, maxfact, maxfact, ldw, ip,
     +                   w)             
          elseif (numdec.eq.8) then
c
c numdec = 8: Y-scores
c               
             isend = 2
             call mtplot (isend, maxfact, maxfact, ldu, n,
     +                    u)            
         elseif (numdec.eq.9) then
c
c numdec = 9: Y-loadings
c                
            isend = 2
            call mtplot (isend, maxfact, maxfact, ldc, my,
     +                   c)              
         elseif (numdec.eq.10) then 
c
c numdec = 10: X-scores as symbols
c            
            isend = 1
            ptitle = text(numdec)(1:60)
            xtitle = 't'
            ytitle = 't'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldt, n, 
     +                   t, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)            
         elseif (numdec.eq.11) then 
c
c numdec = 11: X-loadings as symbols
c            
            isend = 2
            ptitle = text(numdec)(1:60)
            xtitle = 'p'
            ytitle = 'p'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldp, ip, 
     +                   p, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   none)                
         elseif (numdec.eq.12) then
c
c numdec = 12: Y-scores as symbols
c            
            isend = 3
            ptitle = text(numdec)(1:60)
            xtitle = 'u'
            ytitle = 'u'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldu, n, 
     +                   u, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)             
         elseif (numdec.eq.13) then 
c
c numdec = 13: Y-loadings as symbols
c            
            isend = 4
            ptitle = text(numdec)(1:60)
            xtitle = 'c'
            ytitle = 'c'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldc, my, 
     +                   c, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   none)      
         elseif (numdec.eq.14) then 
c
c numdec = 14: X-scores as labels
c            
            isend = 5
            ptitle = text(numdec)(1:60)
            xtitle = 't'
            ytitle = 't'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldt, n, 
     +                   t, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)            
         elseif (numdec.eq.15) then 
c
c numdec = 15: X-loadings as labels
c            
            isend = 6
            ptitle = text(numdec)(1:60)
            xtitle = 'p'
            ytitle = 'p'
            ntemp = nlabel - n
            call plssym (isend, maxfact, ngraf, ntemp, nout, ldp, ip, 
     +                   p, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx(n + 1), xtitle, ytitle,
     +                   none)                
         elseif (numdec.eq.16) then
c
c numdec = 16: Y-scores as labels
c            
            isend = 7
            ptitle = text(numdec)(1:60)
            xtitle = 'u'
            ytitle = 'u'
            call plssym (isend, maxfact, ngraf, nlabel, nout, ldu, n, 
     +                   u, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)             
         elseif (numdec.eq.17) then 
c
c numdec = 17: Y-loadings as labels
c            
            isend = 8
            ptitle = text(numdec)(1:60)
            xtitle = 'c'
            ytitle = 'c'
            ntemp = nlabel - n
            call plssym (isend, maxfact, ngraf, ntemp, nout, ldc, my, 
     +                   c, siglev, x1, xgraf, y1, ygraf,
     +                   ptitle, wordx(n + 1), xtitle, ytitle,
     +                   none)                   
         elseif (numdec.eq.18) then 
c
c numdec = 18: overlay ellipses
c                    
            ellips = .not.ellips
         elseif (numdec.eq.19) then  
c
c numdec = 19: significance levels
c                                   
            write (line,600) 
            if (siglev.lt.sigbot .or. siglev.gt.sigtop) siglev = sigmid
            call getdm1 (sigbot, siglev, sigtop,
     +                   line)
         elseif (numdec.eq.20) then
c
c numdec = 20: ellipse points
c               
            write (line,700)
            call getjm1 (ngbot, ngraf, ngtop,
     +                   line)
            deallocate (xgraf, stat = ierr)
            deallocate (ygraf, stat = ierr)
            allocate (xgraf(ngraf), stat = ierr)
            allocate (ygraf(ngraf), stat = ierr)                    
         elseif (numdec.eq.21) then
c
c numdec = 21: Rotation of X-loadings
c         
                 
             call plsrot (maxfact, nout, ldp, ip,
     +                    p)               
         elseif (numdec.eq.22) then
c
c numdec = 22: Rotation of Y-loadings
c         
                 
             call plsrot (maxfact, nout, ldc, my,
     +                    c)           
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c                                       
            write (text,800)
            numbld(1) = 1  
            numbld(6) = 1 
            numbld(10) = 1
            numbld(15) = 1
            numbld(20) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0  
            numbld(6) = 0 
            numbld(10) = 0
            numbld(15) = 0
            numbld(20) = 0            
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c         
            repeet = .false. 
         endif           
      enddo             
c
c deallocate
c      
      deallocate (x1, stat = ierr)  
      deallocate (x2, stat = ierr)
      deallocate (y1, stat = ierr)
      deallocate (y2, stat = ierr) 
      deallocate (xgraf, stat = ierr)
      deallocate (ygraf, stat = ierr) 
      deallocate (xmat, stat = ierr)
      deallocate (xlab, stat = ierr)
c
c format statements
c      
  100 format (          
c     + 'Goodness of Fit: cumulative variance plot'   
c     +/'Goodness of Fit: cumulative variance bar chart' 
c     +/'Goodness of Fit: correlation' 
c     +/'Goodness of Fit: VIP'
c     +/'Matrix plot: X-predictor scores T(N,MAXFACT)'
c     +/'Matrix plot: X-predictor loadings P(IP,MAXFACT)'
c     +/'Matrix plot: X-weights W(IP,MAXFACT)'
c     +/'Matrix plot: Response-Y scores U(N,MAXFACT)'
c     +/'Matrix plot: Response-Y loadings C(MY,MAXFACT)'
c     +/'Plot as symbols: X-predictor scores'
c     +/'Plot as symbols: X-predictor loadings'
c     +/'Plot as symbols: Response-Y scores'
c     +/'Plot as symbols: Response-Y loadings'   
c     +/'Display labels: X-predictor scores'
c     +/'Display labels: X-predictor loadings'
c     +/'Display labels: Response-Y scores'
c     +/'Display labels: Response-Y loadings' 
c     +/'Overlay confidence ellipse on scores',1x,a
c     +/'Change signifcance level: current =',f8.4 
c     +/'Change number of ellipse points: current =',i4
c     +/'Orthomax Rotation: X-loadings'
c     +/'Orthomax Rotation: Y-loadings'
c     +/'Help'
c     +/'Quit ... Exit') 
     + 'Cumulative variance plot            `Goodness of fit'   
     +/'Cumulative variance bar chart       `Goodness of fit' 
     +/'Correlation                         `Goodness of fit' 
     +/'Variable influence on projection    `VIP'
     +/'Matrix plot: X-predictor scores     `T(N,MAXFACT)'
     +/'Matrix plot: X-predictor loadings   `P(IP,MAXFACT)'
     +/'Matrix plot: X-weights              `W(IP,MAXFACT)'
     +/'Matrix plot: Response-Y scores      `U(N,MAXFACT)'
     +/'Matrix plot: Response-Y loadings    `C(MY,MAXFACT)'
     +/'Symbol plot: X-predictor scores     `T(N,MAXFACT)'
     +/'Synbol plot: X-predictor loadings   `P(IP,MAXFACT)'
     +/'Symbol plot: Response-Y scores      `U(N,MAXFACT)'
     +/'Symbol plot: Response-Y loadings    `C(MY,MAXFACT)'   
     +/'Label plot: X-predictor scores      `T(N,MAXFACT)'
     +/'Label plot: X-predictor loadings    `P(IP,MAXFACT)'
     +/'Label plot: Response-Y scores       `U(N,MAXFACT)'
     +/'Label plot: Response-Y loadings     `C(MY,MAXFACT)' 
     +/'Overlay confidence ellipse on scores`',1x,a
     +/'Change signifcance level            `Current:',f6.2 
     +/'Change number of ellipse points     `Current:',i4
     +/'Orthomax Rotation: X-loadings       `Rotate P'
     +/'Orthomax Rotation: Y-loadings       `Rotate C'
     +/'Help                                `Advice'
     +/'Quit                                `Exit plotting options')   
  200 format ('Y-variable required: or for averages input',1x,a)   
  300 format ('X, and Y(i),i=',a,a)
  400 format ('Number of factors')
  500 format ('X,Y cumulative variance')
  600 format ('Significance level required') 
  700 format ('Number of ellipse points required')         
  800 format (
     + 'Goodness of fit options'
     +/'These can be used to confirm that sufficient factors have been'
     +/'used to capture a significant proportion of the variation, and'
     +/'to examine the correlation between successive scores.'
     +/
     +/'Matrix plot options'
     +/'These permit you to plot any rows or columns of the matrices in'
     +/'one, two, or three dimensions.'
     +/
     +/'Plot as symbols options'
     +/'These are simple scatter plots but, in the case of scores, then'
     +/'confidence ellipses can be overlayed if required using a chosen'
     +/'significance level that can be adjusted.'
     +/
     +/'Display labels options'
     +/'These will display labels instead of symbols. If labels are at'
     +/'the end of the data file using the begin{labels} ...end{labels}'
     +/'method, these will be used. Otherwise integers will be plotted.'  
     +/
     +/'Orthomax rotation options'
     +/'These allow you to rotate then re-plot the loading matrices')
      end
c
c
