c                                             
c            
      subroutine plsprd (ip, isx, ldb, ldorigb, mx, my, nfact, nin,
     +                   nout, orig, scale1,       
     +                   b, origb, xbar, xstd, ybar, ystd) 
c
c action: install a x matrix then predict y by PLS
c author: w.g.bardsley, university of manchester, u.k.
c         derived from m_matone 05/04/2007 
c         18/05/2007 added orig to arguments and in_line, my_code to suppress my code 
c         04/06/2007 added code to save data filename and title 
c         06/06/2007 now sets ifail = 1 on entry  
c         28/07/2007 added call to sim256 first time round   
c                                                   
c      ip: (input/unchanged) number of active x-variables
c     isx: (input/unchanged) include/suppress indicators  
c     ldb: (input/unchanged) leading dimension for parameters from g02laf/g02lcf
c ldorigb: (input/unchanged) leading dimension for parameters from g02laf/g02lcf
c      mx: (input/unchanged) no. of x columns  
c      my: (input/unchanged) no. of y columns
c   nfact: (input/unchanged) no. of PLS factors    
c     nin: (input/unchanged) unconnected unit for data input
c    nout: (input/unchanged) preconnected unit for results 
c    orig: (input/unchanged) flag for parameter type 
c  scale1: (input/unchanged) flag for scaling type
c       b: (input/unchanged) best fit parameters for centered/scaled data
c   origb: (input/unchanged) best fit parameters for original data  
c    xbar: (input/unchanged) x-means
c    xstd: (input/unchanged) x-std.devs.
c    ybar: (input/unchanged) y-means
c    ystd: (input/unchanged) y-std.devs. 
c
      implicit   none
c
c arguments
c
      integer,             intent (in) :: ip, ldb, ldorigb, mx, my, 
     +                                    nfact, nin, nout, orig, scale1
      integer,             intent (in) :: isx(mx) 
      double precision,    intent (in) :: b(ldb,my), origb(ldorigb,my), 
     +                                    xbar(ip), xstd(ip),
     +                                    ybar(my), ystd(my) 
c
c Local allocatable array
c
      double precision, allocatable :: x(:,:), y(:,:), yhat(:,:)
c
c locals
c                                                                
      integer    i, ifail, ios, j, k, l, n
      integer    ierr, jsend, ncmax, ncol, ncol1, nrmax, nrow, nrow1
      integer    numdec 
      integer    nlines, ntype, numopt, numtxt
      parameter (nlines = 3, ntype = 3, numopt = 6, numtxt = 22)
      integer    numbld(numtxt) 
      double precision xvalue, ymean 
      double precision zero, epsi
      parameter (zero = 0.0d+00, epsi = 1.0d-50) 
      character  line*100, title*80, title1*80, word10(3)*10,
     +           sim256*1024
      character  no_data*30, no_file*30
      parameter (no_data = 'No data',
     +           no_file = 'No file')
      character  details(nlines)*80, fname*1024, text(30)*100, trim80*80 
      logical    abort, again, done, fileit, first
      logical    fixcol, fixrow, label, newdat, repeet  
      parameter (fixcol = .true., fixrow = .false., label = .true.) 
      logical    in_line, my_code
      parameter (my_code = .false.)
      external   isitmf, mat2in, mat3in, mat4in, putadv, dsplay,
     +           listbx, patch2, revpro, triml1, putifa, trim80,
     +           writer, closer, sim256   
      external   g02ldf$
      intrinsic  max        
      save       first 
      save       fname
      data       first / .true. /
      data       fname / 'g02laf.tf3' / 
      data       numbld / numtxt*0 /
c
c first time round define default X
c      
      if (first) then
         first = .false.
         fname = sim256('g02laf.tf3')
      endif   
c
c check 
c 
      if (ip.lt.1 .or. ldb.lt.1 .or. ldorigb.lt.1 .or. mx.lt.1 .or.
     +    my.lt.1) return
c
c------------------------------------------------------------
c Start of code to access a predictor matrix Z, i.e. x
c------------------------------------------------------------
c                   
      write (word10(1),'(i10)') mx  
      write (word10(2),'(i10)') my
      write (word10(3),'(i10)') nfact
      do i = 1, 3
         call triml1 (word10(i)) 
      enddo
      repeet = .true.
      do while (repeet)
c
c Step 1: if ncol > 0 and nrow > 0 check if fname supplied is a current matrix file
c ======= isitmf returns ncol1 > 0 and nrow1 > 0 if fnamea is a vector file
c
         ncol1 = 0
         nrow1 = 0
         call isitmf (ncol1, nrow1,
     +                fname)
c
c Step 2: if fname is not a matrix file of correct size try to open a file
c ======= mat3in selects a matrix file of size nrow1 > 0 by ncol1 > 0 if successful
c
         if (ncol1.ne.mx .or. nrow1.le.0) then
            ncol = 0
            nrow = 0
            fname = no_file
            title = no_data
            jsend = 3
            call closer (nin)
            write (line,100) word10(1)
            call putadv (line)
            ncol1 = mx
            call mat3in (jsend, ncol1, nin, nrow1,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            call closer (nin)
            if (ncol1.ne.mx) then
               abort = .true.
               call putadv ('Incorrect format or number of columns')
            endif   
            
            if (abort) then
               ncol = 0
               nrow = 0
               fname = no_file
               title = no_data
               return
            endif
         endif
c
c Check if file is suitable
c            
         if (ncol1.ne.mx .or. nrow1.le.0) then
            ncol = 0
            nrow = 0
            fname = no_file
            title = no_data
            return
         endif   
c
c Step 3: we now have a matrix file of size nrow > 0 by ncol > 0 so allocate workspaces
c ======  if there is any error then ierr is nonzero and exit happens
c
         ncol = ncol1
         nrow = nrow1
         ierr = 0
         if (allocated(x)) deallocate(x, stat = ierr)
         if (ierr.ne.0) return
         ncmax = mx
         nrmax = nrow
         allocate(x(nrmax,ncmax), stat = ierr)
         if (ierr.ne.0) return  
         if (allocated(y)) deallocate(y, stat = ierr)
         if (ierr.ne.0) return
         allocate(y(nrmax,my), stat = ierr)
         if (ierr.ne.0) return 
         if (allocated(yhat)) deallocate(yhat, stat = ierr)
         if (ierr.ne.0) return
         allocate(yhat(nrmax,my), stat = ierr)
         if (ierr.ne.0) return  

c
c Step 4: read in the data consisting of nrow by ncol points from file fnamea
c ======= if an error occurs then workspaces are deallocated and exit occurs
c         otherwise fnamea and titlea are not changed from now on
c
         call closer (nin)
         call mat2in (nin, ncmax, ncol, nrmax, nrow,
     +                x,
     +                fname, title,
     +                abort)
         call closer (nin)
         if (abort) then
            deallocate (x, stat = ierr)
            deallocate (y, stat = ierr)
            deallocate (yhat, stat = ierr)
            ncol = 0
            nrow = 0
            fname = no_file
            title = no_data
            return
         endif
c
c Step 5: see what the user wants to do ... title may change in mat4in
c ======= mat4in is the equivalent of vecone offering as follows:
c         abort = .true. on return: deallocate workspaces then exit
c         newdat = .true. on return: try for a new data set
c         newdat = .false. on return: proceed with original or edited data
c         title1 is altered if the data are edited but title is unchanged
c                       
         write (line,200) 
         title1 = title
         call mat4in (ncmax, ncol, nrmax, nrow,
     +                x,
     +                fname, line, title1,
     +                abort, newdat)
         if (abort) then
c
c Option 1 on return from mat4in: Deallaocate then exit
c --------
c
            deallocate (x, stat = ierr)
            deallocate (y, stat = ierr) 
            deallocate (yhat, stat = ierr)
            return
         elseif (newdat) then
c
c Option 2 on return from from mat4in: New data
c --------
c
            fname = no_file
            title = no_data
            ncol = 0
            nrow = 0
         else
c
c Option 3 on return from from mat4in: calculate YY = XX*B
c --------
c  
            ncol1 = ncol
            nrow1 = nrow 
            n = nrow    

c                              
c**********************************************
c Start of my in-line code equivalent to g02ldf$
c**********************************************
c            
                        
            in_line = my_code
            if (in_line .and. orig.eq.1) then                                                                          
c
c Case 1 (work out y1 using origb): step 1...set YY columns equal to the intercepts
c                                   Note: y1 is Y-hat using my code and origb         
c              
               do j = 1, my    
                  ymean = origb(1,j)
                  do i = 1, n 
                     y(i,j) = ymean
                  enddo
               enddo  
c
c Case 1 (work out y using origb): step 2...add XX*B to the Y intercepts
c            
               do i = 1, n
                  do j = 1, my 
                     l = 1
                     do k = 1, mx  
                        if (isx(k).eq.1) then 
                            l = l + 1
                            y(i,j) = y(i,j) + x(i,k)*origb(l,j)
                        endif 
                     enddo   
                  enddo
               enddo 
            elseif (in_line .and. orig.eq.-1) then
c
c Case 2 (work out y using b): step 1...set YY columns equal to 0
c                               Note: y is yhat using my code and b
c                                     first Z =x is transformed to Z1
c                                     then Y-hat1 is calculated
c                                     finally Y-hat1 is transformed into Y-hat 
c                    
               do j = 1, my
                  do i = 1, n 
                     y(i,j) = zero
                  enddo
               enddo  
c
c Case 2 (work out y using b): step 2...action depends on scale1           

c            
               if (scale1.eq.1) then        
                  do i = 1, n  
                     do j = 1, my 
                        l = 0
                        do k = 1, mx 
                           if (isx(k).eq.1) then
                               l = l + 1
                               xvalue = x(i,k) - xbar(l)
                               xvalue = xvalue/max(xstd(l),epsi)
                               y(i,j) = y(i,j) + b(l,j)*xvalue 
                           endif
                        enddo 
                        y(i,j) = y(i,j)*ystd(j) + ybar(j)
                     enddo
                  enddo
               else 
                  do i = 1, n  
                     do j = 1, my 
                        l = 0
                        do k = 1, mx 
                           if (isx(k).eq.1) then
                               l = l + 1
                               xvalue = x(i,k) - xbar(l)
                              y(i,j) = y(i,j) + b(l,j)*xvalue 
                           endif
                        enddo
                        y(i,j) = y(i,j) + ybar(j)
                     enddo
                  enddo
               endif   
            endif
            
c                                             
c**********************************************
c End of my in-line code equivalent to g02ldf$ 
c**********************************************
c
            
            if (.not.in_line) then
               if (orig.eq.1) then
                  ifail = 1
                  call g02ldf$ (ip, my, orig, xbar, ybar, scale1, xstd,
     +                          ystd, origb, ldorigb, n, mx, isx, x,
     +                          nrmax, yhat, nrmax, ifail)
                  call putifa (ifail, nout, 'G02LDF/PLSPRD')   
               else   
                  ifail = 1
                  call g02ldf$ (ip, my, orig, xbar, ybar, scale1, xstd,
     +                          ystd, b, ldb, n, mx, isx, x, nrmax,
     +                          yhat, nrmax, ifail) 
                  call putifa (ifail, nout, 'G02LDF/PLSPRD')    
               endif 
            endif    
c
c loop to inspect YY = XX*B
c                              
            
            write (line,300) word10(3)
            done = .false.
            again = .true.
            do while (again) 
               write (text,400) 
               numdec = numopt - 1
               call listbx (numdec, numopt,
     +                      text)
               if (numdec.eq.1) then 
                  fileit = .false.
               elseif (numdec.eq.2) then                   
                  fileit = .true. 
               elseif (numdec.eq.3) then
                  newdat = .true.
               elseif (numdec.eq.numopt) then
                  newdat = .false.      
               endif      
               if (done) fileit = .false.   
               if (fileit) then
                  write (details,500) trim80(fname), title
                  call writer (ios, nlines, nout,
     +                         details)                  
               endif 
               if (numdec.le.2) then 
                  if (orig.eq.1) then 
                     if (in_line) then 
                        call dsplay (my, my, nout, nrow1, nrow1, ntype,
     +                               y,
     +                              'Y_predicted (in-line using origb)',
     +                               fileit) 
                     else                   
                        call dsplay (my, my, nout, nrow1, nrow1, ntype,
     +                               yhat,
     +                              'Y-predicted (g02ldf using origb)',
     +                               fileit) 
                     endif 
                  else  
                      if (in_line) then
                        call dsplay (my, my, nout, nrow1, nrow1, ntype,
     +                                y,
     +                               'Y-predicted (in-line using b)',
     +                               fileit)                   
                     else
                        call dsplay (my, my, nout, nrow1, nrow1, ntype,
     +                               yhat,
     +                              'Y-predicted (g02ldf using b)',
     +                               fileit)  
                     endif 
                  endif
                  if (fileit) done = .true.
               elseif (numdec.eq.numopt - 2) then
                  call revpro (nout)
               elseif (numdec.eq.numopt - 1) then
                  write (text,600) (word10(i), i = 1, 3)
                  numbld(1) = 1
                  call patch2 (numbld, numtxt,
     +                         text)
                  numbld(1) = 0                       
               else
                  again = .false.
               endif      
            enddo             
            if (.not.newdat) then
               deallocate(x, stat = ierr)  
               deallocate(y, stat = ierr)
               deallocate(yhat, stat = ierr)
               return
            endif  
         endif
 
      enddo
c------------------------------------------------------------
c End of code to access a matrix
c------------------------------------------------------------
c       

c
c format statements
c
  100 format (
     +'X-Predictor must have number of variables (i.e. columns) =',1x,a) 
  200 format ('New X-predictor data to estimate new Y-response by PLS')
  300 format ('New Y-response: number of factors used =',1x,a)
  400 format (
     + 'View new Y-response'
     +/'View new Y-response and write to log file'  
     +/'Input new X-predictor data'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit these predictor options') 
  500 format (
     + 'X-predictor filename and title:'
     +/a
     +/a)    
  600 format (
     + 'Using best-fit PLS parameters to predict new Y given new X'
     +/                                               
     +/'The current column dimension for predictors X is MX =',1x,a 
     +/'The current column dimension for responses Y is MY =',1x,a
     +/'The current number of factors is NUMFACT =',1x,a
     +/
     +/'You input a K by MX matrix of new X-predictor values with K > 0'
     +/'and this is used to predict a K by MY matrix of new Y-response'
     +/'variables, based upon NUMFACT, the number of factors selected.'
     +/
     +/'The following facts should be noted.'
     +/'1)`The input matrix must have the same number of columns as the'
     +/'  `original X-matrix used as a training set, i.e. MX.'
     +/'2)`If variables have been suppressed when fitting the training' 
     +/'  `set, these automatically will be suppressed when predicting'
     +/'  `the new Y-response matrix.' 
     +/'3)`It does not matter if the original training matrices were'
     +/'  `centered and/or scaled before being used as a training set.'
     +/'  `All that matters is the you must do exactly with the new'
     +/'  `X-predictor matrix what you did with the original training'
     +/'  `matrix, and the predicted Y-response matrix will then be of'
     +/'  `the same form as the original Y-training matrix.')        
      end
c
c        
      
                            