c
c action: output PLS statistics
c author: w.g.bardsley, university of manchester, u.k., 04/04/2007
c         20/04/2010 added averages to ycvar
c                                                                     
      subroutine plsres (ip, ldb, ldc, ldorigb, ldp, ldt, ldu, 
     +                   ldvip, ldw, ldx, ldxres, ldy, ldycvar, ldyres,
     +                   maxfact, mx, my, n, nfact, nout, orig, 
     +                   vipopt,
     +                   b, c, origb, p, t, u, vip, w, x, xbar, xcvar,
     +                   xres, xstd, y, ybar, ycvar, yres, ystd,
     +                   parameters_ready)
      implicit none
c
c arguments
c          
      integer,          intent (in) :: ip, ldb, ldc, ldorigb,
     +                                 ldp, ldt, ldu, ldvip, 
     +                                 ldw, ldx, ldxres, ldy, ldycvar,
     +                                 ldyres, maxfact, mx, my, n,
     +                                 nfact, nout, orig, vipopt
      double precision, intent (in) :: b(ldb,my), c(ldc,maxfact), 
     +                                 origb(ldorigb,my), 
     +                                 p(ldp,maxfact),
     +                                 t(ldt,maxfact), u(ldu,maxfact),
     +                                 vip(ldvip,my), 
     +                                 w(ldw,maxfact), x(ldx,mx),
     +                                 xbar(ip), xcvar(maxfact),
     +                                 xres(ldxres,ip), xstd(ip),
     +                                 y(ldy,my), ybar(my), 
     +                                 ycvar(ldycvar,my + 1),
     +                                 yres(ldyres,my), ystd(my)  
      logical,          intent (in) :: parameters_ready 
c
c locals
c           
      integer    i, myp1, nd, numdec                          
      integer    ntype, numopt, numtxt, n1
      parameter (ntype = 3, numopt = 22, numtxt = 22, n1 = 1)
      character  line*100, text(30)*100, title*80
      integer    numbld(numtxt) 
      character  word8(9)*8
      logical    nofile
      parameter (nofile = .false.)
      logical    done(18), file(18), fileit, repeet 
      external   dsplay, putadv, listbx, triml1, revpro, patch2
      save       fileit
      data       fileit / .false. /
      data       numbld / numtxt*0 / 
c
c initialise
c      
      do i = 1, 18
         done(i) = .false.
         file(i) = fileit
      enddo   
      write (word8(1),'(i8)') nfact
      call triml1 (word8(1))
      do i = 2, 7
         word8(i) = word8(1)
      enddo  
      write (word8(9),'(i8)') maxfact
      call triml1 (word8(9)) 
c
c main loop
c      
      repeet = .true.
      do while (repeet)  
         if (fileit) then
            word8(8) = '[Yes]'
         else
            word8(8) = '[No]'
         endif       
         write (text,100) (word8(i), i = 5, 8) 
         numdec = numopt - 1
         call listbx (numdec, numopt,
     +                text)         
        
         if (numdec.le.18) then
            title = text(numdec)(1:80)
            if (done(numdec)) then
               file(numdec) = nofile
            else
               file(numdec) = fileit
            endif
         endif  
         
         if (numdec.eq.1) then          
c
c 1: x
c
            call dsplay (mx, mx, nout, ldx, n, ntype,
     +                   x,
     +                   title,
     +                   nofile) 
         elseif (numdec.eq.2) then                    
c
c 2: xbar
c            
            call dsplay (n1, n1, nout, ip, ip, ntype,
     +                   xbar,
     +                   title,
     +                   nofile)    
         elseif (numdec.eq.3) then
c
c 3: xstd
c                                     
            call dsplay (n1, n1, nout, ip, ip, ntype,
     +                   xstd,
     +                   title,
     +                  nofile) 
         elseif (numdec.eq.4) then
c
c 4: xcvar ... done(4)
c                   
            call dsplay (n1, n1, nout, maxfact, maxfact, ntype,
     +                   xcvar,
     +                   title,
     +                   file(numdec)) 
         elseif (numdec.eq.5) then 
c
c 5: xres ... done(5)
c                  
            call dsplay (ip, ip, nout, ldxres, n, ntype,
     +                   xres,
     +                   title,
     +                   file(numdec))    
         elseif (numdec.eq.6) then 
c
c 6: w ... done(6)
c                  
            call dsplay (maxfact, maxfact, nout, ldw, ip, ntype,
     +                   w,
     +                   title,
     +                   file(numdec))  
         elseif (numdec.eq.7) then 
c
c 7: p ... done(7)
c                  
            call dsplay (maxfact, maxfact, nout, ldp, ip, ntype,
     +                   p,
     +                   title,
     +                   file(numdec))  
         elseif (numdec.eq.8) then 
c
c 8: t ... done(8)
c                  
            call dsplay (maxfact, maxfact, nout, ldt, n, ntype,
     +                   t,
     +                   title,
     +                   file(numdec))
c
c 9: y
c          
         elseif (numdec.eq.9) then           
            call dsplay (my, my, nout, ldy, n, ntype,
     +                   y,
     +                   title,
     +                   nofile) 
         elseif (numdec.eq.10) then       
c
c 10: ybar
c            
            call dsplay (n1, n1, nout, my, my, ntype,
     +                   ybar,
     +                   title,
     +                   nofile)    
         elseif (numdec.eq.11) then
c
c 11: ystd
c                   
            call dsplay (n1, n1, nout, my, my, ntype,
     +                   ystd,
     +                   title,
     +                   nofile)  
         elseif (numdec.eq.12) then
c
c 12: ycvar ... done(12)
c                             
            myp1 = my + 1  
            title = 'Cumulative Y-variances, Last column = averages'        
            call dsplay (myp1, myp1, nout, ldycvar, maxfact, ntype,
     +                   ycvar,
     +                   title,
     +                   file(numdec)) 
         elseif (numdec.eq.13) then 
c
c 13: yres ... done(13)
c                                       
            call dsplay (my, my, nout, ldyres, n, ntype,
     +                   yres,
     +                   title,
     +                   file(numdec))  
         elseif (numdec.eq.14) then 
c
c 14: c ... done(14)
c                  
            call dsplay (maxfact, maxfact, nout, ldc, my, ntype,
     +                   c,
     +                   title,
     +                   file(numdec))               
         elseif (numdec.eq.15) then 
c
c 15: u ... done(15)
c                  
            call dsplay (maxfact, maxfact, nout, ldu, n, ntype,
     +                   u,
     +                   title,
     +                   file(numdec)) 
         elseif (numdec.eq.16) then 
c
c 16: b ... done(16)
c                        
            if (parameters_ready) then                                                  
               call dsplay (my, my, nout, ldb, ip, ntype,
     +                      b,
     +                      title,
     +                      file(numdec))  
             else 
                write (line,200)
                call putadv (line)
             endif
          elseif (numdec.eq.17) then 
c
c 17: origb ... done(17)
c                         
            if (parameters_ready) then
               if (orig.eq.-1) then  
                  write (line,200)
                  call putadv (line)
               else
                  nd = ip + 1
                  call dsplay (my, my, nout, ldorigb, nd, ntype,
     +                         origb,
     +                         title,
     +                         file(numdec))
               endif
            else
               write (line,200)
               call putadv (line)    
            endif
         elseif (numdec.eq.18) then                           
c
c 18: vip ... done(18)
c            
            if (vipopt.eq.0 .or. .not.parameters_ready) then 
               write (line,200)
               call putadv (line)
            else
               if (vipopt.eq.1) then
                  nd = 1
               else
                  nd = my
               endif                                
               call dsplay (my, nd, nout, ldvip, ip, ntype,
     +                      vip,
     +                      title,
     +                      file(numdec))
            endif  
         elseif (numdec.eq.numopt - 3) then
c
c 19: yes-no
c         
            fileit = .not.fileit 
            do i = 1, 18
               file(i) = fileit
            enddo     
         elseif (numdec.eq.numopt - 2) then
c
c 20: review progress
c         
            call revpro (nout)
         elseif (numdec.eq.numopt - 1) then
c
c 21: help
c         
            write (text,300) word8(9), word8(1)
            numbld(1) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0                    
         else 
c
c 20: cancel
c         
             repeet = .false.    
         endif 
         if (numdec.le.18) then 
            if (file(numdec)) done(numdec) = .true.
         endif     
      enddo 
c
c format statements
c                               
  100 format (
     + 'X-predictors: original data'
     +/'X-predictors: means (free variables)'
     +/'X-predictors: standard deviations (free variables)'   
     +/'X-predictors: cumulative variance (percent)'
     +/'X-predictors: residuals'
     +/'X-predictors: weights W(IP,MAXFACT)'
     +/'X-predictors: loadings P(IP,MAXFACT)'
     +/'X-predictors: scores T(N,MAXFACT)'
     +/'Responses-Y: original data'
     +/'Responses-Y: means'
     +/'Responses-Y: standard deviations'
     +/'Responses-Y: cumulative variance (percent)'
     +/'Responses-Y: residuals'
     +/'Responses-Y: loadings C(MY,MAXFACT)'  
     +/'Responses-Y: scores (N,MAXFACT)'     
     +/'Parameters: internal, NUMFACT =',1x,a 
     +/'Parameters: intercept and external, NUMFACT =',1x,a 
     +/'Variable influence on projection (VIP), NUMFACT =',1x,a     
     +/'Archive calculated results to log file on viewing',1x,a  
     +/'Results'
     +/'Help'
     +/'Quit ... Exit these PLS options')                  
  200 format ('VIP has not yet been calculated')     
  300 format (
     + 'PLS results for MAXFACT =',1x,a,', NUMFACT =',1x,a
     +/
     +/'All results are calculated for matrices X1 and Y1 which are the'
     +/'original X and Y matrices after centering by subtracting column'
     +/'means internally, and scaling to unit variance by dividing by'
     +/'column std. devs. if this is required. If your X and Y data'
     +/'matrices had already been centered and possibly also scaled to'
     +/'unit variance, then the results apply directly of course.'
     +/
     +/'Cumulative variances are calculated for up to MAXFACT factors'
     +/'so you can check if the number of factors chosen (NUMFACT) is'
     +/'sufficiently large.' 
     +/
     +/'Variable Influence on Projection (VIP) can be calculated as'
     +/'averaged over all response variables Y or for all individual Y.'
     +/
     +/'Note that, if any X-variables have been suppressed, the indices'
     +/'will refer to the rearranged X-columns.'  
     +/
     +/'You can choose to save important results (not original data,'
     +/'means, or standard deviations) to the results log file which'
     +/'can be investigated retrospectively from the [Results] option.')
                   
      end    