c
c
      subroutine plsrot (ncol, nout, nrmax, nrow, 
     +                   p)
c
c action: orthomax rotation
c author: w.g.bardsley, university of manchester, u.k., 11/04/2007  
c
c  ncol: (input/unchanged) column dimension 
c  nout: (input/unchanged) preconnected unit for results log
c nrmax: (input/unchanged) leading dimension of matrix
c  nrow: (input/unchanged) row dimension
c     a: (input/unchanged) matrix
c
      implicit none
c
c arguments
c          
      integer,          intent (in) :: ncol, nout, nrmax, nrow
      double precision, intent (in) :: p(nrmax,ncol)  
c
c local allocatable arrays
c                         
      double precision, allocatable :: w(:), r(:,:), y(:,:), yhat(:,:) 
c
c locals
c                
      integer    i, ierr, ios, isend, j, lw, ncmax
      integer    nin
      parameter (nin = 10)     
      character  filex*1024, line*100
      logical    abort, there
      logical    askif
      parameter (askif = .false.)      
      external   putfat, gettmp, deleet, orotat 
c
c check
c      
      if (ncol.lt.2 .or. nrow.lt.2 .or. nrow.gt. nrmax) then
         write (line,100)
         call putfat (line)
         return
      endif   
c
c write matrix to temporary file
c                                   
      call gettmp (isend,
     +             filex) 
      close (unit = nin)
      open (unit = nin, file = filex, iostat = ios)
      if (ios.eq.0) write (nin,200)
      if (ios.eq.0) write (nin,'(2i8)',iostat=ios) nrow, ncol
      do i = 1, nrow
         if (ios.eq.0) write (nin,'(1p,50e13.5)',iostat=ios)
     +                       (p(i,j), j = 1, ncol)
      enddo
      close (unit = nin)
      if (ios.eq.0) then
         ierr = 0
         if (allocated(r)) deallocate(r, stat = ierr)
         if (ierr.ne.0) return  
         if (allocated(w)) deallocate(w, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(y)) deallocate(y, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(yhat)) deallocate(yhat, stat = ierr)
         if (ierr.ne.0) return
         ncmax = ncol + 1
         allocate(r(nrmax,ncmax), stat = ierr)
         if (ierr.ne.0) return         
         lw = 2*nrmax + ncmax*ncmax + 5*(ncmax - 1)
         allocate(w(lw), stat = ierr)
         if (ierr.ne.0) return
         allocate(y(nrmax,ncmax), stat = ierr)
         if (ierr.ne.0) return
         allocate(yhat(nrmax,ncmax), stat = ierr)
         if (ierr.ne.0) return
         isend = 2              
c
c rotate
c         
         call orotat (isend, ncol, nin, nout, nrmax,
     +                r, w, y, yhat,
     +                filex,
     +                abort)
          deallocate(r, stat = ierr)
          deallocate(w, stat = ierr)
          deallocate(y, stat = ierr)
          deallocate(yhat, stat = ierr)
       else    
          write (line,300)
          call putfat (line)
       endif
c
c delete temporary file
c       
       call deleet (filex,
     +              askif, there)
c
c format statements
c      
  100 format ('Must have ncol > 1, nrow > 1, and nrmax >= nrow') 
  200 format ('Loadings')  
  300 format ( 'Failure to rotate loadings')      
      end
c
c 