c
c
      subroutine plssym (isend, ncol, ngraf, nlabel, nout, nrmax, nrow, 
     +                   a, siglev, x, xgraf, y, ygraf,
     +                   ptitle, wordx, xtitle, ytitle,
     +                   ellips)  
c
c action: plot PLS scores and loadings as symbols
c author: w.g.bardsley, university of manchester, u.k., 10/04/2007
c         06/04/2010 added nlabel to argument list 
c         27/09/2010 added qtitle and checked for grave accents
c         12/11/2016 added call to pcaplt
c
      implicit none
c
c arguments
c  
      integer,             intent (in)    :: isend, ncol, ngraf, nlabel, 
     +                                       nout, nrmax, nrow
      double precision,    intent (in)    :: a(nrmax,ncol), siglev 
      double precision,    intent (inout) :: x(nrow), y(nrow),
     +                                       xgraf(ngraf), ygraf(ngraf)
      character (len = *), intent (in)    :: ptitle, xtitle, ytitle
      character (len = *), intent (inout) :: wordx(nlabel) 
      logical,             intent (inout) :: ellips  
c
c locals
c                                                
      integer    l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4
      integer    i, ifail, jx, jy, jtop
      integer    len200
      double precision x_factor, y_factor
      double precision x3(2), x4(2), y3(2), y4(2)
      double precision ax, by, delta, df1, df2, dn, fval, ratio, pi,
     +                 theta, xbar, xvar, ybar, yvar 
      double precision g01fdfg, x01aafg
      double precision zero, one, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00)
      character (len = 100) line
      character (len = 80 ) qtitle
      character (len = 40 ) titlex, titley 
      character (len = 8  ) word8 
      character (len = 1  ) blank, grave, minus
      parameter (blank = ' ', grave = '`', minus = '-')
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   putfat, len200, triml1, gks004, putifa    
      external   plslab, pcaplt
      external   g01fdfg, x01aafg
      intrinsic  sqrt, sin, cos, index
      save       jx, jy
      data       jx, jy / 1, 2 / 
      save       x_factor, y_factor
      data       x_factor, y_factor / one, one /
c
c check
c                   
      if (ncol.lt.2 .or.nrow.lt.2) then
         write (line,100)
         call putfat (line)
         return
      endif  
      if (nrow.gt.nrmax) then
         write (line,200)
         call putfat (line) 
         return           
      endif
c
c initialise
c         
      do i = 1,2
         x3(i) = zero
         x4(i) = zero
         y3(i) = zero
         y4(i) = zero
      enddo   
      l1 = index(ptitle,grave)
      if (l1.gt.0) then
         qtitle = ptitle(1:l1)
         qtitle(l1:l1) = blank
         l2 = len200(qtitle)
         l3 = len200(ptitle)
         if (l3.gt.l1) qtitle = qtitle(1:l2)//blank//ptitle(l1 + 1:l3)
      else
         qtitle = ptitle
      endif     
      titlex = blank
      titley = blank 
c
c set jx and jy
c     
      jtop = ncol                 
      if (jx.gt.jtop .or. jy.gt.jtop) then
         jx = 1
         jy = 2
      endif
      call pcaplt (jtop, jx, jy,
     +             x_factor, y_factor)   
c
c define titlex, titley
c                      
      write (word8,'(i8)') jx
      call triml1 (word8)
      l1 = 1
      l2 = len200(xtitle)
      if (x_factor.gt.zero) then
         titlex = xtitle(l1:l2)//word8
      else   
         titlex = minus//xtitle(l1:l2)//word8
      endif   
      write (word8,'(i8)') jy
      call triml1 (word8)
      l1 = 1
      l2 = len200(ytitle)
      if (y_factor.gt.zero) then
         titley = ytitle(l1:l2)//word8             
      else   
         titley = minus//ytitle(l1:l2)//word8             
      endif   
c
c define plotting symbols
c      
      l1 = 0
      l3 = 0
      l4 = 0
      m1 = 5
      m2 = 0
      m3 = 0
      m4 = 0
      n1 = nrow
      n2 = ngraf
      n3 = 2
      n4 = 2             
c
c define x and y
c               
      do i = 1, nrow
         x(i) = x_factor*a(i,jx)
         y(i) = y_factor*a(i,jy)
      enddo  
      if (nrow.lt.3) then
         write (line,300)
         call putfat (line)
         ellips = .false.
      endif   
      if (ellips) then  
c
c calculate a confidence ellipse
c        
         l2 = 1
         xbar = zero
         ybar = zero
         do i = 1, nrow
            xbar = xbar + x(i)
            ybar = ybar + y(i)
         enddo
         dn = dble(nrow)
         xbar = xbar/dn
         ybar = ybar/dn
         xvar = zero
         yvar = zero
         do i = 1, nrow
            xvar = xvar + (x(i) - xbar)**2
            yvar = yvar + (y(i) - ybar)**2
         enddo
         xvar = xvar/(dn - one)
         yvar = yvar/(dn - one)
         delta = one - siglev
         df1 = two
         df2 = dn - two
         ifail = 0
         fval = g01fdfg(delta, df1, df2, ifail)
         call putifa (ifail, nout, 'G01FDF/PLSPLT')
         theta = one
         pi = x01aafg(theta)
         ratio = fval*two*(dn**2 - one)/(dn*df2)
         ax = sqrt(xvar*ratio)
         by = sqrt(yvar*ratio)
         delta = two*pi/dble(ngraf - 2)
         theta = zero
         do i = 1, ngraf - 1
            xgraf(i) = ax*cos(theta)
            ygraf(i) = by*sin(theta)
            theta = theta + delta
         enddo
         xgraf(ngraf) = xgraf(1)
         ygraf(ngraf) = ygraf(1)
      else  
         l2 = 0
         do i = 1, ngraf
            xgraf(i) = zero
            ygraf(i) = zero
         enddo     
      endif
c
c call  standard graphics for symbols
c                                    
      if (isend.ge.1 .and. isend.le.4) then
         call gks004 (l1, l2, l3, l4,
     +                m1, m2, m3, m4,
     +                n1, n2, n3, n4, 
     +                x, xgraf, x3, x4,
     +                y, ygraf, y3, y4,
     +                qtitle, titlex, titley,
     +                axes, gsave)  
      elseif (isend.ge.5 .and. isend.le.8) then  
c
c call advanced graphics for labels
c      
         call plslab (ngraf, nrow,
     +                xgraf, ygraf, x, y,
     +                qtitle, wordx, titlex, titley,
     +                ellips)          
      endif                     
c
c format statements
c      
  100 format ('Must have at least two rows and two columns')          
  200 format ('NROW < NRMAX in call to PLSSYM')  
  300 format ('Must have at least three rows for a confidence ellipse')
      end
c
c