

C
C POL000 = SUB00: Main subroutine for POLNOM
C ==========================================
C
C as of 23/10/2020 ntype used as follows:-
C ntype = 1: line/calibrate (simple)                           
C ntype = 2: line/calibrate (advanced)                         
C ntype = 3: polynomial                                          
C ntype = 4: polynomial after transformimg to X(x,y), Y(x,y)     
C
C MODE is used to control the polynomial fitting routines as follows:
C ====
C MODE = 1: linear/polynomial (NTYPE chosen, data input, ADVISE supplied)
C MODE = 2: polynomial (NTYPE chosen, data input, ADVISE supplied)
C MODE = 3: polynomial with NTYPE = 3, data supplied, ADVISE not used
C MODE = 4: linear with NTYPE = 1 or 2, data supplied, ADVISE not used
C
C Summary: MODE = 1 is reserved for the comprehensive version of POLNOM
C =======  MODE = 2 is the normal mode for POLNOM
C          MODE = 3 is for polynomial fitting from SIMSTAT
C          MODE = 4 is for linear fitting from LINFIT or SIMSTAT
C
C
C POL000 = SUB00 ... control program operation
C POL001 = SUB01 ... read in the data
C POL002 = SUB02 ... transform the data
C POL003 = SUB03 ... fit the data
C POL004 = SUB04 ... statistics
C POL005 = SUB05 ... choose the degree
C POL006 = SUB06 ... covariance matrix
C POL007 = SUB07 ... evaluate y = f(x)
C POL008 = SUB08 ... calibrate x = g(y)
C POL009 = SUB09 ... solve f(x) - const = 0
C POL010 = SUB10 ... 95% confidence limits
C
C
      SUBROUTINE POL000 (MODE, M3, M7, NIN, NOUT, NP, NPTS, NTYPE,
     +                   E, W, WORK1, W1, W2, W3, W4, X, XBIGT, XT, Y,
     +                   DNAME, FNAME, TITLE,
     +                   ABORT, NEW)
C
C ACTION : new version of what was originally MAIN in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          18/08/1999 Set DNAME = BLANK if ABORT to control the subsequent
C                     call to GOGOGO in POLNOM
C          14/06/2000 added WEIGHT
C          01/08/2005 deleted ADVISE from argument list and deleted
C                     MODE and NTYPe from calls to POL006, POL007, and POL008
C          05/04/2015 added INTENTS
C          27/12/2019 added AGAIN
C          23/10/2020 made NTYPE intent (in) and assumes the scheme:
C                     ntype = 1: line/calibrate (simple)                           
C                     ntype = 2: line/calibrate (advanced)                         
C                     ntype = 3: polynomial                                          
C                     ntype = 4: polynomial after transformimg to X(x,y), Y(x,y)  
C          17/11/2020 reversed the order of calling POL007 and POL008   
c
C
C          This version is designed for maximum degree 6 so if a higher
C          degree is required all the array dimensions will have to be
C          increased accordingly
C
C          NPRED = dimension of prediction arrays
C          N7 = number of polynomial coefficients = degee + 1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODE, M3, M7, NIN, NOUT, NP
      INTEGER,             INTENT (IN)    :: NTYPE
      INTEGER,             INTENT (INOUT) :: NPTS
      DOUBLE PRECISION,    INTENT (INOUT) :: E(NP), W(NP), WORK1(M3,NP),
     +                                       W1(NP), W2(NP), W3(NP),
     +                                       W4(NP), X(NP),
     +                                       XBIGT(M7,NP),
     +                                       XT(NP), Y(NP)
      CHARACTER (LEN = *), INTENT (INOUT) :: DNAME, FNAME, TITLE
      LOGICAL,             INTENT (IN)    :: NEW
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    NGANG
      INTEGER    NPRED, N2, N3, N6, N7, N13
      PARAMETER (NPRED = 200, N2 = 2, N3 = 3, N6 = 6, N7 = 7, N13 = 13)
      INTEGER    I, IA1, NADD1, NBEST, NB2, NB2P1, NMAX, NTPNT
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      DOUBLE PRECISION RTOL
      DOUBLE PRECISION XDIFF, XMAX, XMIN, YBAR, YMAX, YMIN
      DOUBLE PRECISION A(N7,N7), S(N7)
      DOUBLE PRECISION F(N6), PGF(N6), PGW(N7), Q(N7)
      DOUBLE PRECISION B(N7)
      DOUBLE PRECISION P(N7), QF(N13), TSQD, TSTAT, V(N7,N7)
      DOUBLE PRECISION PCS(N6), PCW(N6)
      DOUBLE PRECISION U(N7,N7), WORK2(N2,N7)
      DOUBLE PRECISION EBOT, ETOP
      PARAMETER (EBOT = 0.99D+00, ETOP = 1.01D+00)
      CHARACTER (LEN = 18) HAZARD(NPRED)
      CHARACTER (LEN = 1 ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    AGAIN, ISTOP, XFROMY, YFROMX
      LOGICAL    YES
      LOGICAL    WEIGHT
      SAVE       NGANG
      DATA       NGANG / 0 /
      DATA       AGAIN / .FALSE. /
      EXTERNAL   POL001, POL002, POL003, POL004, POL005, POL006,
     +           POL007, POL008
      EXTERNAL   PUTFAT, YESNO2
C
C Check MODE, M3 and M7
C
      IF (MODE.LT.1 .OR. MODE.GT.4) THEN
         ABORT = .TRUE.
         CALL PUTFAT ('Incorrect value for MODE in POL000')
         RETURN
      ENDIF
      IF (M3.NE.N3 .OR. M7.NE.N7) THEN
         ABORT = .TRUE.
         CALL PUTFAT ('M3 and M7 .NE. N3 and N7 IN POL000')
         RETURN
      ELSE
         ABORT = .FALSE.
      ENDIF
C
C Initialise then call the data input/checking routine
C
      XFROMY = .FALSE.
      YFROMX = .FALSE.
      CALL POL001 (MODE, NIN, NOUT, NP, NPTS, NTYPE,
     +             E, RTOL, W, X, Y,
     +             DNAME, FNAME, TITLE,
     +             ISTOP, NEW)
      IF (ISTOP) THEN
         DNAME = BLANK
         RETURN
      ENDIF
C
C Check if weights are required
C
      WEIGHT = .FALSE.
      I = 0
      DO WHILE (I.LT.NPTS .AND. .NOT.WEIGHT)
         I = I + 1
         IF (E(I).LT.EBOT .OR. E(I).GT.ETOP) WEIGHT = .TRUE.
      ENDDO
      CALL POL002 (NOUT, NPTS,
     +             RTOL, X, XDIFF, XMAX, XMIN, XT, Y, YBAR, YMAX, YMIN,
     +             ISTOP)
      CALL POL003 (NMAX, NOUT, NP, NPTS, NTYPE, N2, N3, N7,
     +             A, S, W, WORK1, WORK2, XT, Y,
     +             ISTOP)
      IF (NTYPE.LT.3) THEN
C
C Just fit a line
C
         NBEST = 1
      ELSE
C
C User chooses best-fit polynomial degree
C
        CALL POL004 (NMAX, NOUT, NPTS, N6, N7,
     +               F, PGF, PGW, Q, RTOL, S,
     +               ISTOP)
      ENDIF
C
C Loop enables choosing another degree for the polynomial if NTYPE = 3
C ====================================================================
C
      YES = .TRUE.
      DO WHILE (YES)
         CALL POL005 (IA1, NADD1, NBEST, NB2, NB2P1, NMAX, NOUT, NTYPE,
     +                N6, N7,
     +                A, B, F, PCS, PCW, PGF, PGW, Q, RTOL, S,
     +                ISTOP)
         CALL POL006 (IA1, NADD1, NBEST, NB2, NB2P1, NGANG, NOUT, NPTS, 
     +                NTPNT, NTYPE, N7, N13,
     +                B, E, P, QF, RTOL, S, TSQD, TSTAT, U, V, W, W1,
     +                W2, W3, X, XBIGT, XMAX, XMIN, Y,
     +                AGAIN, ISTOP, XFROMY, YFROMX, WEIGHT)
         CALL POL008 (IA1, NADD1, NBEST, NB2, NB2P1, NGANG, NIN, NOUT,
     +                NPRED, NTPNT, N7, N13,
     +                B, P, QF, TSQD, W1, W2, W3, W4, XDIFF, XMAX, XMIN,
     +                YMAX, YMIN,
     +                HAZARD,
     +                ISTOP, XFROMY)
         IF (NTYPE.EQ.3) CALL POL007 (IA1, NADD1, NBEST, NB2, NB2P1,
     +                                NGANG, NIN, NOUT, NPRED, N7, N13,
     +                                B, P, QF, TSTAT, W1, W2, W3, XMAX,
     +                                XMIN,
     +                                HAZARD,
     +                                ISTOP, YFROMX)
         IF (ISTOP .AND. NADD1.EQ.NBEST) ISTOP = .FALSE.
         IF (NTYPE.EQ.3 .AND. .NOT.ISTOP .AND. AGAIN) THEN
            YES = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY,
     +       'Fit a polynomial of different degree to same data ?', YES)
         ELSE
            YES = .FALSE.
         ENDIF
      ENDDO
      END
C
C
