C
C
      SUBROUTINE POL001 (MODE, NIN, NOUT, NP, NPTS, NTYPE,
     +                   E, RTOL, W, X, Y,
     +                   DNAME, FNAME, TITLE,
     +                   ISTOP, NEW)
C
C ACTION : new version of what was originally SUB01 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          Read in data, calculate weights W = 1/(standard error in Y)
C          then correlation analysis and unweighted linear regression
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODE, NIN, NOUT, NP, NTYPE
      INTEGER,             INTENT (INOUT) :: NPTS    
      DOUBLE PRECISION,    INTENT (INOUT) :: E(NP), RTOL, W(NP), X(NP),
     +                                       Y(NP)
      CHARACTER (LEN = *), INTENT (INOUT) :: DNAME, FNAME, TITLE
      LOGICAL,             INTENT (INOUT) :: ISTOP, NEW
C
C Locals
C      
      INTEGER    I, ICOUNT, ISEND
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    M1
      PARAMETER (M1 = - 1)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 2, NUMOPT = 3,
     +           NSTART = 4, NTEXT = 6)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ONE, EMIN
      PARAMETER (ONE = 1.0D+00, EMIN = 1.0D-100)
      CHARACTER (LEN = 100) LINE, TEXT(NTEXT)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    NO, YES
      PARAMETER (NO = .FALSE., YES = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   X02AMF$
      EXTERNAL   DATTIN, DATCHK, PUTFAT, RESFIL, HBOX01, DATSXY,
     +           LINFIT
      SAVE ICOUNT, ISEND
      DATA ICOUNT / M1 /
      DATA NUMBLD / NTEXT*N0 /
      DATA NUMPOS / NUMOPT*N1 /
C
C Assign RTOL then decide data input mode if MODE = 1 or 2
C
      RTOL = 1.0D+09*X02AMF$()
      IF (ICOUNT.EQ.-N1) THEN
         IF (MODE.EQ.1 .OR. MODE.EQ.2) THEN
            IF (NTYPE.EQ.N1) THEN
               ISEND = N3
            ELSEIF (NTYPE.EQ.N2) THEN
               WRITE (TEXT,100)
               ISEND = N2
               CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND,
     +                      NUMOPT, NUMPOS, NSTART, NTEXT, TEXT,
     +                      BORDER, FLASH, HIGH)
            ELSEIF (NTYPE.EQ.3) THEN
               ISEND = N2
            ENDIF
         ENDIF
         ICOUNT = ICOUNT + N1
      ENDIF
C
C Read in data if MODE = 1 or 2
C
      IF (MODE.EQ.1 .OR. MODE.EQ.2) THEN
         IF (NEW) THEN
            I = ISEND
            CLOSE (UNIT = NIN)
            CALL DATTIN (I, NIN, NP, NPTS,
     +                   E, X, Y,
     +                   DNAME, TITLE, 
     +                   ISTOP, NO, YES)
            CLOSE (UNIT = NIN)
            IF (ISTOP) RETURN
         ELSE
            CLOSE (UNIT = NIN)
            CALL DATSXY (NIN, NP, NPTS,
     +                   E, X, Y,
     +                   DNAME, TITLE,
     +                   ISTOP)
            CLOSE (UNIT = NIN)
            IF (ISTOP) RETURN
         ENDIF
         CALL DATCHK (NPTS,
     +                E, X, Y,
     +                ISTOP)
         IF (ISTOP) RETURN
      ELSE
C
C Check the data supplied by the calling program
C
         ISTOP = .FALSE.
         IF (E(1).LT.EMIN) THEN
            WRITE (LINE,200) N1
            CALL PUTFAT (LINE)
            ISTOP = .TRUE.
            RETURN
         ENDIF
         DO I = N2, NPTS
            IF (E(I).LT.EMIN .OR. X(I).LT.X(I - N1)) THEN
               WRITE (LINE,200) I
               CALL PUTFAT (LINE)
               ISTOP = .TRUE.
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C Checks on input data etc. then calculate weights
C
      IF (NPTS.LT.N3) THEN
         CALL PUTFAT ('Must have at least 3 data points')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      IF (NPTS.GT.NP) THEN
         CALL PUTFAT ('Data set too large for this version')
         ISTOP = .TRUE.
         RETURN
      ENDIF
      DO I = N1, NPTS
         W(I) = ONE/E(I)
      ENDDO
C
C Open a log file if MODE = 1 or 2 and this is the first call
C
      IF (MODE.EQ.1 .OR. MODE.EQ.2) THEN
         IF (ICOUNT.EQ.N0) THEN
            CALL RESFIL (NOUT,
     +                   FNAME,
     +                   ISTOP)
            IF (ISTOP) THEN
               FNAME = BLANK
               RETURN
            ENDIF
            WRITE (NOUT,300)
         ENDIF
      ENDIF
      ICOUNT = ICOUNT + N1
      WRITE (NOUT,400) ICOUNT, TITLE
C
C Do correlation analysis if NTYPE = 2
C
      IF (NTYPE.EQ.2) CALL LINFIT (NOUT, NPTS, 
     +                             X, Y,
     +                             YES, YES)
C
C Format statements
C        
  100 FORMAT (
     + 'Now decide on the mode required to input experimental'
     +/'x,y,s data points for the duration of the current run'
     +/
     +/'Terminal'
     +/'File'
     +/'Either')
  200 FORMAT ('X-value out of order or S too small at data point',I6)
  300 FORMAT (/1X,'PACKAGE : SIMFIT'/1X,'PROGRAM : POLNOM'
     +/1X,'ACTION  : Weighted least squares polynomials.'
     +/1X,'AUTHOR  : W. G. Bardsley, University of Manchester, U.K.')
  400 FORMAT (
     +/
     +/'...'
     +/
     +/1X,'Line/Polynomial Analysis number',I4
     +/1X,'-----------------------------------'
     +/1X,'Data title'
     +/1X,A)
      END
C
C