C
C
      SUBROUTINE POL002 (NOUT, NPTS,
     +                   RTOL, X, XDIFF, XMAX, XMIN, XT, Y, YBAR, YMAX,
     +                   YMIN,
     +                   ISTOP)
C
C ACTION : new version of what was originally SUB02 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          Calculate XMAX, XMIN, YMAX, YMIN, transform X to (- 1, 1)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NOUT, NPTS
      DOUBLE PRECISION, INTENT (IN)    :: RTOL, X(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT)   :: XDIFF, XMAX, XMIN, XT(NPTS),
     +                                    YBAR, YMAX, YMIN
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C      
      INTEGER    N1, N2
      PARAMETER (N1 = 1, N2 = 2)
      INTEGER    I
      DOUBLE PRECISION BIG, SMALL
      PARAMETER (BIG = 1.0D+04, SMALL = - BIG)
      CHARACTER (LEN = 100) LINE
      EXTERNAL   PUTFAT, PUTADV
      INTRINSIC  DBLE
      IF (ISTOP) RETURN
C
C Find the extreme values and mean Y
C
      XMAX = X(1)
      XMIN = X(1)
      YBAR = Y(1)
      YMAX = Y(1)
      YMIN = Y(1)
      DO I = N2, NPTS
         IF (X(I).LT.XMIN) XMIN = X(I)
         IF (X(I).GT.XMAX) XMAX = X(I)
         IF (Y(I).LT.YMIN) YMIN = Y(I)
         IF (Y(I).GT.YMAX) YMAX = Y(I)
         YBAR = YBAR + Y(I)
      ENDDO
      YBAR = YBAR/DBLE(NPTS)
      XDIFF = XMAX - XMIN
C
C Check for reasonable range of data
C
      IF (XDIFF.LT.RTOL) THEN
         CALL PUTFAT ('Must have distinct x values')
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Transform the data to (-1,1)
C
      DO I = N1, NPTS
         XT(I) = ((X(I) - XMIN) - (XMAX - X(I)))/XDIFF
      ENDDO
      IF (XMIN.LT.SMALL .OR. XMAX.GT.BIG) THEN
         WRITE (LINE,100) SMALL, BIG
         CALL PUTADV (LINE)
         WRITE (NOUT,200) SMALL, BIG
      ENDIF
C
C Format statements
C      
  100 FORMAT (
     +'Use units so',1P,E11.3,'< x <',E11.3,' to avoid problems')
  200 FORMAT (
     +/1X,'CAUTION : It is a good idea to choose your  x-units so that'
     +/10X,1P,E11.3,' <= x <=',E11.3
     +/11X,'otherwise numerical difficulties may sometimes be'
     +/11X,'encountered with high degree best-fit polynomials'
     +/1X,'REMEDY  : Use EDITFL to edit the data file')
      END
C
C