C
C
      SUBROUTINE POL003 (NMAX, NOUT, NP, NPTS, NTYPE, N2, N3, N7,
     +                   A, S, W, WORK1, WORK2, XT, Y,
     +                   ISTOP)
C
C ACTION : new version of what was originally SUB03 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          Best-fit polynomials up to degree NMAX =< NDEG
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (OUT)   :: NMAX
      INTEGER,          INTENT (IN)    :: NOUT, NP, NPTS, NTYPE, N2, N3,
     +                                    N7
      DOUBLE PRECISION, INTENT (IN)    :: W(NPTS), XT(NPTS), Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT)   :: A(N7,N7), S(N7)
      DOUBLE PRECISION, INTENT (INOUT) :: WORK1(N3,NP), WORK2(N2,N7)
      LOGICAL,          INTENT (INOUT) :: ISTOP
C
C Locals
C      
      INTEGER    I, IFAIL, NBIG, NDIST
      INTEGER    K0, K1, K2, K3
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      DOUBLE PRECISION EPSI
      DOUBLE PRECISION X02AJF$
      EXTERNAL   X02AJF$, E02ADF$
      EXTERNAL   PUTIFA
      INTRINSIC  MIN
      IF (ISTOP) RETURN
      IF (NTYPE.LT.K3) THEN
C
C Set NMAX = 1
C
         NMAX = K1
      ELSE
C
C Calculate NMAX from maximum allowed and number of distinct data values
C
         EPSI = X02AJF$()
         NDIST = K1
         DO I = K2, NPTS
            IF ((XT(I) - XT(I - K1)).GT.EPSI) NDIST = NDIST + K1
         ENDDO
         NBIG = N7 - K1
         NMAX = MIN(NBIG, NDIST - K1)
      ENDIF
      IFAIL = K1
      CALL E02ADF$(NPTS, NMAX + K1, N7, XT, Y, W, WORK1, WORK2, A, S,
     +             IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'E02ADF/POL003')
      IF (IFAIL.NE.K0) ISTOP = .TRUE.
      END
C
C