C
C
      SUBROUTINE POL004 (NMAX, NOUT, NPTS, N6, N7,
     +                   F, PGF, PGW, Q, RTOL, S,
     +                   ISTOP)
C
C ACTION : new version of what was originally SUB04 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          Chi-square test on WSSQ and F test on successive WSSQ(I)
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NMAX, NOUT, NPTS, N6, N7
      DOUBLE PRECISION, INTENT (OUT) :: F(N6), PGF(N6), PGW(N7), Q(N7)
      DOUBLE PRECISION, INTENT (IN)  :: RTOL, S(N7)
      LOGICAL,          INTENT (IN)  :: ISTOP
C
C Locals
C      
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I, IFAIL, NDOF
      DOUBLE PRECISION DENOM, RI, RNDOF, RNPTS
      DOUBLE PRECISION G01EDF$, G01ECF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   G01ECF$, G01EDF$
      EXTERNAL   PUTIFA
      INTRINSIC  MAX, DBLE
      IF (ISTOP) RETURN
      DO I = N1, NMAX + N1
         NDOF = NPTS - I
         RNDOF = DBLE(NDOF)
         Q(I) = RNDOF*(S(I)**2)
         IF (Q(I).LE.ZERO) THEN
            Q(I) = ZERO
            PGW(I) = ONE
         ELSE
            IFAIL = N1
            PGW(I) = G01ECF$('Upper-tail', Q(I), DBLE(NDOF), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/POL004')
         ENDIF
      ENDDO
      RNPTS = DBLE(NPTS)
      DO I = N1, NMAX
         DENOM  = MAX(Q(I + N1), RTOL)
         RI = DBLE(I)
         F(I) = (Q(I) - Q(I + 1))*(RNPTS - RI - ONE)/DENOM
      ENDDO
      DO I = N1, NMAX
         IF (F(I).LE.ZERO) THEN
            F(I) = ZERO
            PGF(I) = ONE
         ELSE
            IFAIL = N1
            PGF(I) = G01EDF$('Upper-tail', F(I), DBLE(N1),
     +                       DBLE(NPTS - I - N1), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01EDF/POL004')
         ENDIF
      ENDDO
      END
C
C