C
C
      SUBROUTINE POL005 (IA1, NADD1, NBEST, NB2, NB2P1, NMAX, NOUT,
     +                   NTYPE, N6, N7,
     +                   A, B, F, PCS, PCW, PGF, PGW, Q, RTOL, S,
     +                   ISTOP)
C
C ACTION : new version of what was originally SUB05 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS 
C          15/09/2017 removed TABLE1 and TABLE4 and replaced by call to LIMINT
C          01/06/2021 corrected errors in the call to LIMINT noted when new number formatting was introduced
C
C          Display results, user then chooses best-fit degree
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: IA1, NADD1, NBEST, NB2, NB2P1
      INTEGER,          INTENT (IN)    :: NMAX, NOUT, NTYPE, N6, N7
      DOUBLE PRECISION, INTENT (INOUT) :: B(N7), PCS(N6), PCW(N6)
      DOUBLE PRECISION, INTENT (IN)    :: A(N7,N7), F(N6), PGF(N6),
     +                                    PGW(N7), Q(N7), RTOL, S(N7)
      LOGICAL,          INTENT (IN)    :: ISTOP
C
C Locals
C     
      INTEGER    I, IADD1, IBOT, IMID, ITOP, J, NMAXP1, NUMTXT
      INTEGER    NC95, NC99, NF95, NF99, NSV, NSUM, NWV
      INTEGER    ICOLOR
      PARAMETER (ICOLOR = 9)
      INTEGER    NUMBLD(30)
      DOUBLE PRECISION PNT01, PNT05, TEN, CENT, SIX
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, TEN = 10.0D+00,
     +           CENT = 100.0D+00, SIX = 6.0D+00)
      CHARACTER (LEN = 100) LINE, TEXT(30), TEXT3(3), TEXT6(6)
      CHARACTER (LEN = 100) QUEST
      CHARACTER (LEN = 10 ) D10(7), SHOW10
      CHARACTER (LEN = 3  ) F95(20), F99(20)
      CHARACTER (LEN = 3  ) C95(20), C99(20)
      LOGICAL    RECCSV, RECCWV, RECC95, RECC99, RECF95, RECF99
      LOGICAL    FIXED
      PARAMETER (FIXED = .TRUE.)
      EXTERNAL   SHOW10
      EXTERNAL   LIMINT
      INTRINSIC  ABS, MAX, DBLE, NINT, INDEX
      DATA       NUMBLD / 30*0 /
      IF (ISTOP)  RETURN
C
C No decision required if only a line (NTYPE < 3)
C
      IF (NTYPE.LT.3) THEN
         IA1 = 1
         NADD1 = NBEST + 1
         NB2 = 2*NBEST
         NB2P1 = NB2 + 1
         DO I = 1, NADD1
            B(I) = A(NADD1,I)
         ENDDO
         RETURN
      ENDIF
C
C Set up for call to LIMINT
C
      IADD1 = 0 
      WRITE (TEXT3,100)
      WRITE (NOUT,100)
      LINE = TEXT3(2)
      IADD1 = IADD1 + 1
      TEXT(IADD1) = LINE
      NMAXP1 = NMAX + 1
      DO I = 1, NMAXP1
         DO J = 1, I
            D10(J) = SHOW10(A(I,J))
         ENDDO    
         WRITE (LINE,200) I - 1, (D10(J), J = 1, I)
         IADD1 = IADD1 + 1
         TEXT(IADD1) = LINE 
         WRITE (NOUT,200) I - 1, (D10(J), J = 1, I)
      ENDDO
      DO I = 1, NMAX
        PCS(I) = CENT*ABS((S(I) - S(I + 1))/MAX(RTOL,S(I)))
        PCW(I) = CENT*ABS((Q(I) - Q(I + 1))/MAX(RTOL,Q(I)))
        C95(I) = ' no'
        C99(I) = ' no'
        IF (PGW(I).GE.PNT05) C95(I) = 'yes'
        IF (PGW(I).GE.PNT01) C99(I) = 'yes'
        F95(I) = ' no'
        F99(I) = ' no'
        IF (PGF(I).LE.PNT05) F95(I) = 'yes'
        IF (PGF(I).LE.PNT01) F99(I) = 'yes'
      ENDDO
      C95(NMAXP1) = ' no'
      C99(NMAXP1) = ' no'
      IF (PGW(NMAXP1).GE.PNT05) C95(NMAXP1) = 'yes'
      IF (PGW(NMAXP1).GE.PNT01) C99(NMAXP1) = 'yes'
      F95(NMAXP1) = ' no'
      F99(NMAXP1) = ' no'
      WRITE (TEXT3,300)
      WRITE (NOUT,300)
      LINE = TEXT3(2)
      IADD1 = IADD1 + 1
      TEXT(IADD1) = LINE
      D10(1) = SHOW10(S(1))
      D10(2) = SHOW10(Q(1))
C      WRITE (NOUT,400) 0, S(1), Q(1), PGW(1), C95(1)      
      WRITE (LINE,400) 0, D10(1), D10(2), PGW(1), C95(1)
      
      IADD1 = IADD1 + 1  !these two lines had been omitted when the
      TEXT(IADD1) = LINE !call to LIMINT was used to replace TABLE1
      
      WRITE (NOUT,400) 0, D10(1), D10(2), PGW(1), C95(1)
      DO I = 1, NMAX
C         WRITE (TEXT6,500) (I, S(I+1), PCS(I), Q(I+1), PCW(I), PGW(I+1),
C     +                      C95(I+1), F(I), PGF(I), F95(I), I = 1, NMAX)
C         WRITE (NOUT,500) (I, S(I+1), PCS(I), Q(I+1), PCW(I), PGW(I+1),
C     +                    C95(I+1), F(I), PGF(I), F95(I), I = 1, NMAX)

         D10(1) = SHOW10(S(I + 1))
         D10(2) = SHOW10(Q(I + 1))
         D10(3) = SHOW10(F(I)) 
         WRITE (TEXT6(I),500) I, D10(1), PCS(I), D10(2), PCW(I), 
     +                        PGW(I + 1), C95(I + 1), D10(3), PGF(I), 
     +                        F95(I) 
         WRITE (NOUT,500) I, D10(1), PCS(I), D10(2), PCW(I), 
     +                    PGW(I + 1), C95(I + 1), D10(3), PGF(I), 
     +                    F95(I) 
      ENDDO
      DO I = 1, NMAX
         IADD1 = IADD1 + 1
         TEXT(IADD1) = TEXT6(I)
      ENDDO
C
C Prepare data for call to LIMINT
C
      RECCSV = .FALSE.
      RECCWV = .FALSE.
      RECC95 = .FALSE.
      RECC99 = .FALSE.
      NSV = 0
      NWV = 0
      NC95 = 0
      NC99 = 0
      NF95 = 0
      NF99 = 0
      IF (F95(1).EQ.' no') THEN
         RECF95 = .TRUE.
         NF95 = 0
      ELSE
         RECF95 = .FALSE.
      ENDIF
      IF (F99(1).EQ.' no') THEN
         RECF99 = .TRUE.
         NF99 = 0
      ELSE
         RECF99 = .FALSE.
      ENDIF
      DO I = 1, NMAXP1
         IF (.NOT.RECCSV .AND. I.LT.NMAXP1) THEN
            NSV = I
            IF (PCS(I).LE.TEN) THEN
                NSV = I - 1
                RECCSV = .TRUE.
            ENDIF
         ENDIF
         IF (.NOT.RECCWV .AND. I.LT.NMAXP1) THEN
            NWV = I
            IF (PCW(I).LE.TEN) THEN
               NWV = I - 1
               RECCWV = .TRUE.
            ENDIF
         ENDIF
         IF (.NOT.RECC95) THEN
            IF (PGW(I).GE.PNT05) THEN
               NC95 = I - 1
               RECC95 = .TRUE.
            ENDIF
         ENDIF
         IF (.NOT.RECC99) THEN
            IF (PGW(I).GE.PNT01) THEN
               NC99 = I - 1
               RECC99 = .TRUE.
            ENDIF
         ENDIF
         IF (.NOT.RECF95 .AND. I.LT.NMAXP1) THEN
            IF (F95(I).EQ.'yes' .AND. F95(I + 1).EQ.' no') THEN
                NF95 = I
                RECF95 = .TRUE.
             ENDIF
         ENDIF
         IF (.NOT.RECF99 .AND. I.LT.NMAXP1) THEN
            IF (F99(I).EQ.'yes' .AND. F99(I + 1).EQ.' no') THEN
               NF99 = I
               RECF99 = .TRUE.
            ENDIF
         ENDIF
      ENDDO
C
C Open LIMINT
C 
      WRITE (TEXT3,600)
      WRITE (NOUT,600)
      IADD1 = IADD1 + 1
      TEXT(IADD1) = TEXT3(2)
      IADD1 = IADD1 + 1   
      IF (RECCSV) THEN
         WRITE (TEXT(IADD1),700) NSV
         WRITE (NOUT,700) NSV
      ELSE
         WRITE (TEXT(IADD1),800)
         WRITE (NOUT,800)
      ENDIF
      
      IADD1 = IADD1 + 1
      IF (RECCWV) THEN
         WRITE (TEXT(IADD1),900) NWV
         WRITE (NOUT,900) NWV
      ELSE
         WRITE (TEXT(IADD1),1000)
         WRITE (NOUT,1000)
      ENDIF
      
      IADD1 = IADD1 + 1
      IF (RECC95) THEN
         WRITE (TEXT(IADD1),1100) NC95
         WRITE (NOUT,1100) NC95
      ELSE
         WRITE (TEXT(IADD1),1200)
         WRITE (NOUT,1200)
      ENDIF
      
      IADD1 = IADD1 + 1
      IF (RECC99) THEN
         WRITE (TEXT(IADD1),1300) NC99
         WRITE (NOUT,1300) NC99
      ELSE
         WRITE (TEXT(IADD1),1400)
         WRITE (NOUT,1400)
      ENDIF
      
      WRITE (TEXT3,1500) NF95, NF99
      WRITE (NOUT,1500) NF95, NF99
      DO I = 1, 2
         IADD1 = IADD1 + 1
         TEXT(IADD1) = TEXT3(I)
      ENDDO   
     
      NSUM = NSV + NWV + NC95 + NC99 + NF95 + NF99
      IBOT = 0
      IMID = NINT(DBLE(NSUM)/SIX)
      ITOP = NMAX
      NUMTXT = IADD1
      DO I = 1, NUMTXT
         IF (INDEX(TEXT(I),'Chebyshev').GT.0 .OR.
     +       INDEX(TEXT(I),'%change').GT.0   .OR.
     +       INDEX(TEXT(I),'Information').GT.0)  NUMBLD(I) = 1
      ENDDO  
      NUMTXT = NUMTXT + 1
      NUMBLD(NUMTXT) = 1
      WRITE (TEXT(NUMTXT),'(A)')
     +' Now select the degree required for calibration or smoothing.'  
      WRITE (QUEST,1600) IMID
      CALL LIMINT (IBOT, ICOLOR, IMID, ITOP, NUMBLD, NUMTXT,
     +             QUEST, TEXT,
     +             FIXED)
      NBEST = IMID 
       
C
C Write best-fit degree to results file then define IA1, NADD1, NBEST, NB2, NB2P1 and B
C
C
      WRITE (NOUT,1700) NBEST
      IA1 = 1
      NADD1 = NBEST + 1
      NB2 = 2*NBEST
      NB2P1 = NB2 + 1
      DO I = 1, NADD1
         B(I) = A(NADD1,I)
      ENDDO
      LINE(1:3) = C99(1)!to silence ftn95
C
C Format statements
C      
  100 FORMAT (/1X,'n',2X,'Chebyshev coefficients A0, A1,..., An'/)
C  200 FORMAT (I2,1P,7E12.4)
  200 FORMAT (I2,7(4X,A10)) 
c  300 FORMAT (/1X,'n',3X,'SIGMA   %change',3X,'WSSQ    %change',1X,
c     +'P(C>=WSSQ) 5%   F-val   P(F>=F-val) 5% '/)
  300 FORMAT (/1X,'n',5X,'SIGMA    %change',4X,'WSSQ     %change',2X,
     +'P(C>=WSSQ)  5%    F-val    P(F>=F-val)  5% '/)     
C  400 FORMAT (I2,1P,E11.4,7X,E11.4,7X,0P,F8.4,3X,A3)
C  500 FORMAT (I2,1P,E11.4,0P,F7.2,1P,E11.4,0P,F7.2,F8.4,3X,A3,
C     +1P,E11.4,0P,F8.4,3X,A3)
     
  400 FORMAT (I2,2X,A10,9X,1X,A10,10X,F8.4,4X,A3)
  500 FORMAT (I2,2X,A10,1X,F7.2,2X,A10,1X,F7.2,2X,F8.4,4X,A3,
     + 2X,A10,1X,F8.4,4X,A3)  

  600 FORMAT (
     +/1X,'Information to help you select a best-fit polynomial'/)
  700 FORMAT (
     +1X,'Lowest degree where < 10% change in SIGMA =',I2)
  800 FORMAT (1X,'SIGMA has not stabilised')
  900 FORMAT (
     +1X,'Lowest degree where < 10% change in  WSSQ =',I2)
 1000 FORMAT (1X,'WSSQ  has not stabilised')
 1100 FORMAT (
     +1X,'Lowest degree by chi-sq. at 5% sig. level =',I2)
 1200 FORMAT (
     +1X,'All rejected  by chi-sq. at 5% sig. level')
 1300 FORMAT (
     +1X,'Lowest degree by chi-sq. at 1% sig. level =',I2)
 1400 FORMAT (
     +1X,'All rejected  by chi-sq. at 1% sig. level')
 1500 FORMAT (
     +1X,'Lowest degree  by F test at 5% sig. level =',I2
     +/1X,'Lowest degree  by F test at 1% sig. level =',I2)
 1600 FORMAT (1X,'Degree >',i2,
     +' will fit better but may not be statistically valid')
 1700 FORMAT (
     +/1X,'Degree selected by the user =',i2)  	    
      END
C
C
