C
C Subroutines
C POL006
C OPTPOL (used when NTYPE is not 1 or 2)      
C POLOPT_1 (used when NTYPE is 1)
C POLOPT_2 (used when NTYPE is 2)
C POLOPT is not used now (24/10/2020)
C 
      SUBROUTINE POL006 (IA1, NADD1, NBEST, NB2, NB2P1, NGANG, NOUT,
     +                   NPTS, NTPNT, NTYPE, N7, N13,
     +                   B, E, P, QF, RTOL, S, TSQD, TSTAT, U, V, W,
     +                   W1, W2, W3, X, XBIGT, XMAX, XMIN, Y,
     +                   AGAIN, ISTOP, XFROMY, YFROMX, WEIGHT)
C
C ACTION : new version of what was originally SUB06 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/06/2000 added call to NXYR2P
C          14/06/2000 added WEIGHT
C          08/10/2001 replaced call to POLINV by call to QNINV1 since
C                     call to F04ASF4 proved to be over accurate
C          01/08/2005 deleeted MODE and ADVISE from argument list
C          29/11/2007 introduced U8, V8, to increase dimensions for covariance calculations
C          14/01/2015 introduced JCOLOR and replaced call to TABLE3 by calls to TABLE1 
C          06/04/2015 added INTENTS and added NGANG to allow various options depednding on NTYPE
C          18/09/2017 removed call to TABLE6, added TEXT_X, and rearranged output 
C          24/12/2019 added USE_POLOPT = .TRUE. to call POLOPT for decision about run-time options
C          23/04/2020 added DERIVS and call to OPTPOL and POLOPT
C          20/10/2020 corrected call to OPTPOL or POLOPT depending on NTYPE
C          24/10/2020 added calls to POLOPT_1 for NTYPE = 1 and POLOPT_2 for NTYPE = 2 
C          21/09/2021 introduced FORMGR   
C 
C          Best-fit polynomial coefficients and covariance matrix
C          W1 = THEORY, W2 = RESID, W3 = WRESID
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (INOUT) :: NADD1, NGANG, NTPNT
      INTEGER,          INTENT (IN)    :: IA1, NBEST, NB2, NB2P1, NOUT,
     +                                    NPTS, NTYPE, N7, N13
      DOUBLE PRECISION, INTENT (IN)    :: B(N7), E(NPTS), RTOL,
     +                                    S(N7), W(NPTS), X(NPTS), XMAX,
     +                                    XMIN, Y(NPTS)
      DOUBLE PRECISION, INTENT (INOUT) :: P(N7), QF(N13), TSQD, TSTAT,
     +                                    U(N7,N7), V(N7,N7), 
     +                                    W1(NPTS), W2(NPTS), W3(NPTS),
     +                                    XBIGT(N7,NPTS) 
      LOGICAL,          INTENT (IN)    :: WEIGHT     
      LOGICAL,          INTENT (INOUT) :: AGAIN, ISTOP, XFROMY, YFROMX     
C
C locals
C     
      INTEGER    NGRAF
      PARAMETER (NGRAF = 160)
      INTEGER    L0, L1, L3, L5, L8, L12, L30
      PARAMETER (L0 = 0, L1 = 1, L3 = 3, L5 = 5, L8 = 8, L12 = 12,
     +           L30 = 30)
      INTEGER    I, ICOUNT, IFAIL, J, JCOLOR, K, L, NC, NDOF
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMDEC = 1,
     +           NSTART = 3)
      INTEGER    NUMBLD(L30), NUMPOS(L12)
      INTEGER    NUMBLD_1(L30), NUMPOS_1(L12)
      INTEGER    NUMBLD_2(L30), NUMPOS_2(L12)
      INTEGER    NUMBLD_3(L30), NUMPOS_3(L12)
      INTEGER    NTITLE
      PARAMETER (NTITLE = 2)
      INTEGER    NUMOPT_1, NUMOPT_2, NUMOPT_3
      PARAMETER (NUMOPT_1 = L12 - 4, NUMOPT_2 = L12 - 1, NUMOPT_3 = L12)
      INTEGER    COLOUR
      INTEGER    N_COLOR(L30), N_LINES
      DOUBLE PRECISION ZHIGH, ZLOW
      PARAMETER (ZHIGH = 10.0D+00, ZLOW = - ZHIGH)
      DOUBLE PRECISION PNT05, PNT975
      PARAMETER (PNT05 = 0.05D+00, PNT975 = 0.975D+00)
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION C(20), CL(20), SE(20), TL(20), TP(20), TU(20)
      DOUBLE PRECISION WK1(2,20), WK2(40), Z(20)
      DOUBLE PRECISION U8(L8,L8), V8(L8,L8)
      DOUBLE PRECISION ALPHA, DELTA, RATIO, RI, RNBEST, ZMAX, ZMIN
      DOUBLE PRECISION DUMMY, EPSI, SIGMA
      DOUBLE PRECISION POLF07, POLFCN
      DOUBLE PRECISION G01EBF$, G01FBF$, X02AJF$, X02AMF$
      DOUBLE PRECISION XTEMP1(NGRAF), XTEMP2(NGRAF), XTEMP3(NGRAF)
      DOUBLE PRECISION YTEMP1(NGRAF), YTEMP2(NGRAF), YTEMP3(NGRAF)
      DOUBLE PRECISION PROB, R, RSQD
      DOUBLE PRECISION CMIN
      CHARACTER (LEN = 100) LINE1, LINE2(2), TEXT(L30), 
     +                      TEXT_N(L30), TEXT_X(L30)
      CHARACTER (LEN = 80 ) TITLE(NTITLE)
      CHARACTER (LEN = 29 ) PTITLE
      CHARACTER (LEN = 13 ) D13(4), SHOWRJ
      CHARACTER (LEN = 11 ) INTER, SLOPE
      CHARACTER (LEN = 10 ) D10(2), FORMGR
      CHARACTER (LEN = 7  ) SYMBOL(7)
      CHARACTER (LEN = 1  ) BLANK, XTITLE, YTITLE
      PARAMETER (BLANK = ' ', INTER = '  Intercept',
     +           SLOPE = '  Slope    ')
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SAVEIT, SCALE1
      PARAMETER (SAVEIT = .TRUE., SCALE1 = .TRUE.)
      LOGICAL    ABORT, REPEET, VARCOV
      LOGICAL    CONLIM, DERIVS, FIRST, GRAPH, PLOT, PARS
      LOGICAL    FILE1, TAB1
      LOGICAL    FILE2, TAB2
      PARAMETER (FILE2 = .TRUE.)
      LOGICAL    USE_POLOPT, USE_POLOPT_1
      PARAMETER (USE_POLOPT_1 = .TRUE.)
      EXTERNAL   SHOWRJ, FORMGR
      EXTERNAL   POLFCN, QNINV1, POLF07, POLADV
      EXTERNAL   FZ1CAF$, FZ1CLF$
      EXTERNAL   F04ATF$, G01FBF$, G01EBF$, C02AGF$, X02AJF$, X02AMF$
      EXTERNAL   PUTIFA, PUTFAT, GKSR01, DIVIDE, TABLE1, 
     +           RBOX01, NXYR2P, GKS004
      EXTERNAL   OPTPOL, POLOPT_1, POLOPT_2, POLPLT
      INTRINSIC  ABS, SQRT, DBLE
      SAVE       DERIVS
      SAVE       CONLIM, FIRST, PLOT, PARS
      SAVE       FILE1, GRAPH, TAB1, TAB2
      SAVE       NUMBLD_1, NUMBLD_2, NUMBLD_3
      SAVE       NUMPOS_1, NUMPOS_2, NUMPOS_3
      DATA       DERIVS / .FALSE. / 
      DATA       FILE1, GRAPH, TAB1, TAB2 / .FALSE., .FALSE., .FALSE.,
     +                                      .TRUE. /
      DATA       CONLIM, FIRST, PLOT, PARS / .FALSE., .TRUE., .FALSE.,
     +                                       .TRUE. /
      DATA       NUMBLD_1, NUMBLD_2, NUMBLD_3 / L30*0, L30*0, L30*0 /
      DATA       NUMPOS_1, NUMPOS_2, NUMPOS_3 / L12*0, L12*0, L12*0 /
      
      USE_POLOPT = USE_POLOPT_1
      
      IF (FIRST) THEN
C
C First time initialise parameters for interface depending on NTYPE
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C        
         FIRST = .FALSE.
         NGANG = 0
         NUMBLD_1(1) = 1
         NUMBLD_2(1) = 1
         NUMBLD_3(1) = 1
         I = NUMOPT_1 - 2
         J = NUMOPT_2 - 2
         K = NUMOPT_3 - 2
         DO L = 1, 3
            I = I + 1
            J = J + 1
            K = K + 1
            NUMBLD_1(I) = 100
            NUMBLD_2(J) = 100
            NUMBLD_3(K) = 100
         ENDDO
         
         NUMPOS_1(5) = 1
         NUMPOS_1(7) = 0

         NUMPOS_2(1) = 1
         NUMPOS_2(2) = 1
         NUMPOS_2(5) = 1
         NUMPOS_2(7) = 0

         NUMPOS_3(1) = 1
         NUMPOS_3(2) = 1
         NUMPOS_3(5) = 1
         NUMPOS_3(7) = 0
      ENDIF   
      
      IF (ISTOP) RETURN
C
C Calculate P(I) from A(I,J) if possible by solving linear system
C Otherwise set NADD1 = NBEST and return to decide next action
C
      ZMIN = XMIN
      ZMAX = XMAX
      IF (ZMIN.LE.ZLOW  .AND.  ZMAX.GT.ZLOW) ZMIN = ZLOW
      IF (ZMAX.GE.ZHIGH .AND. ZMIN.LT.ZHIGH) ZMAX = ZHIGH
      RNBEST = DBLE(NBEST)
      IF (NBEST.GT.0) DELTA = (ZMAX - ZMIN)/RNBEST
      DO I = 1, NADD1
         IF (NBEST.EQ.0) THEN
            Z(I) = (ZMAX + ZMIN)/TWO
         ELSE
            IF (I.EQ.1) THEN
               Z(I) = ZMIN
            ELSEIF (I.EQ.NADD1) THEN
               Z(I) = ZMAX
            ELSE
               Z(I) = Z(I - 1) + DELTA
            ENDIF
         ENDIF
         C(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                 B, P, Z(I), XMAX, XMIN)
      ENDDO
      CALL FZ1CAF$(U8, L8, L8, I)
      CALL FZ1CAF$(V8, L8, L8, I)
      CALL FZ1CAF$(XBIGT, N7, NPTS, I)
      DO I = 1, NADD1
         U8(I,1) = ONE
         DO J = 2, NADD1
            U8(I,J) = U8(I,J - 1)*Z(I)
         ENDDO
      ENDDO
      IFAIL = 1
      CALL F04ATF$(U8, L8, C, NADD1, P, V8, L8, WK1, WK2, IFAIL)
      DO J = 1, NADD1
         DO I = 1, NADD1
            U(I,J) = U8(I,J)
            V(I,J) = V8(I,J)
         ENDDO
      ENDDO    
      CALL PUTIFA (IFAIL, NOUT, 'F04ATF/POL006')
      IF (IFAIL.NE.0) THEN
C
C Failure to calculate best-fit coefficients so return
C        
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         WRITE (TEXT,100)
         DO I = 1, 4
            IF (I.EQ.1) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            CALL TABLE1 (COLOUR, TEXT(I))
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
         NADD1 = NBEST
         ISTOP = .TRUE.
         RETURN
      ENDIF
C
C Calculate covariance matrix and parameter standard errors
C
      DO I = 1, NPTS
        XBIGT(1,I) = W(I)
      ENDDO
      DO I = 2, NADD1
         DO J = 1, NPTS
           XBIGT(I,J) = XBIGT(I - 1,J)*X(J)
         ENDDO
      ENDDO
      CALL FZ1CLF$(U, XBIGT, XBIGT, N7, N7, NPTS, IFAIL)
      DO J = 1, NADD1
         DO I = 1, NADD1
            U8(I,J) = U(I,J)
         ENDDO
      ENDDO      
      CALL QNINV1 (L8, NADD1, NOUT, U8, V8)
      DO J = 1, NADD1
         DO I = 1, NADD1
            U(I,J) = U8(I,J)
            V(I,J) = V8(I,J)
         ENDDO
      ENDDO      
      SIGMA = S(NADD1)**2
      DO I = 1, NADD1
         DO J = 1, I
            V(I,J) = SIGMA*V(I,J)
            V(J,I) = V(I,J)
         ENDDO
      ENDDO
      DO I = 1, NB2P1
         QF(I) = ZERO
      ENDDO
      DO I = 1, NADD1
         DO J = 1, NADD1
            K = I + J - 1
            QF(K) = QF(K) + V(J,I)
         ENDDO
      ENDDO
      NDOF = NPTS - NADD1
      IFAIL = 1
      TSTAT = G01FBF$('Lower-tail', PNT975, DBLE(NDOF), IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FBF/POL006')
      TSQD = TSTAT**2
      VARCOV = .TRUE.
      DO I = 1, NADD1
        SE(I) = SQRT(V(I,I))
        CL(I) = TSTAT*SE(I)
        TL(I) = P(I) - CL(I)
        TU(I) = P(I) + CL(I)
        IF (SE(I).GT.RTOL) THEN
           RATIO = ABS(P(I)/SE(I))
           IFAIL = 1
           ALPHA = ONE - G01EBF$('Lower-tail', RATIO, DBLE(NDOF), IFAIL)
           CALL PUTIFA (IFAIL, NOUT, 'G01EBF/POL006')
           TP(I) = TWO*ALPHA
         ELSE
           TP(I) = ZERO
           VARCOV = .FALSE.
         ENDIF
      ENDDO
      DO I = 1, NADD1
         IF (VARCOV) THEN
            IF (TP(I).GT.PNT05) THEN
               SYMBOL(I) = ' *'
            ELSE
               SYMBOL(I) = BLANK
            ENDIF
         ELSE
            SYMBOL(I) = ' *'
         ENDIF
      ENDDO
      IF (WEIGHT) THEN
         LINE1 = '   Results for weighted fitting (w = 1/s^2)'
      ELSE
         LINE1 = '   Results for Unweighted fitting (all s = 1)'
      ENDIF
      WRITE (LINE2,200) LINE1
      WRITE (NOUT,'(A)') BLANK
      WRITE (NOUT,200) LINE1
      TITLE(1) = LINE2(1)(1:80)
      TITLE(2) = LINE2(2)(1:80)
C
C fill-in TEXT_N with best-fit parameters 
C
      N_LINES = 0
      JCOLOR = 4
      N_LINES = N_LINES + 1
      N_COLOR(N_LINES) = JCOLOR
      TEXT_N(N_LINES) = TITLE(1)
      N_LINES = N_LINES + 1
      N_COLOR(N_LINES) = JCOLOR
      TEXT_N(N_LINES) = TITLE(2)
      JCOLOR = 0
      IF (NADD1.GT.2) THEN
C
C Degree > 1 (NADD1 = no. coefficients = degree + 1)
C
C         WRITE (TEXT,300) (I - 1, P(I), SE(I), TL(I), TU(I), TP(I),
C     +                     SYMBOL(I), I = 1, NADD1)
C         WRITE (NOUT,300) (I - 1, P(I), SE(I), TL(I), TU(I), TP(I),
C     +                     SYMBOL(I), I = 1, NADD1)

         DO I = 1, NADD1
           
            D13(1) = SHOWRJ(P(I))
            D13(2) = SHOWRJ(SE(I))
            D13(3) = SHOWRJ(TL(I))
            D13(4) = SHOWRJ(TU(I))
            WRITE (TEXT(I),300) I - 1, D13(1), D13(2), D13(3), D13(4), 
     +                          TP(I), SYMBOL(I) 
            WRITE (NOUT,300) I - 1, D13(1), D13(2), D13(3), D13(4), 
     +                       TP(I), SYMBOL(I)
     
         ENDDO  
         
         DO I = 1, NADD1
           
            N_LINES = N_LINES + 1
            N_COLOR(N_LINES) = JCOLOR
            TEXT_N(N_LINES) = TEXT(I)
           
         ENDDO   
      ELSE
C
C First the constant term
C
C         WRITE (TEXT(1),350) INTER,
C     +                    P(1), SE(1), TL(1), TU(1), TP(1), SYMBOL(1)
 
         D13(1) = SHOWRJ(P(1))
         D13(2) = SHOWRJ(SE(1))
         D13(3) = SHOWRJ(TL(1))
         D13(4) = SHOWRJ(TU(1))   
         WRITE (TEXT(1),350) INTER, D13(1), D13(2), D13(3), D13(4),
     +                       TP(1), SYMBOL(1)
     
         N_LINES = N_LINES + 1
         N_COLOR(N_LINES) = JCOLOR
         TEXT_N(N_LINES) = TEXT(1)

C         WRITE (NOUT,350) INTER,
C     +                    P(1), SE(1), TL(1), TU(1), TP(1), SYMBOL(1)
         WRITE (NOUT,350) INTER, D13(1), D13(2), D13(3), D13(4), 
     +                    TP(1), SYMBOL(1) 
     
         IF (NADD1.GT.1) THEN
C
C Now the linear term if degree > 0
C
C            WRITE (TEXT(2),350) SLOPE, P(2), SE(2),
C     +                          TL(2), TU(2), TP(2), SYMBOL(2)
     
            D13(1) = SHOWRJ(P(2))
            D13(2) = SHOWRJ(SE(2))
            D13(3) = SHOWRJ(TL(2))
            D13(4) = SHOWRJ(TU(2))
            WRITE (TEXT(2),350) SLOPE, D13(1), D13(2), D13(3), D13(4),
     +                          TP(2), SYMBOL(2)  
            
            N_LINES = N_LINES + 1
            N_COLOR(N_LINES) = JCOLOR
            TEXT_N(N_LINES) = TEXT(2)

C            WRITE (NOUT,350) SLOPE, P(2), SE(2),
C     +                       TL(2), TU(2), TP(2), SYMBOL(2)
            WRITE (NOUT,350) SLOPE, D13(1), D13(2), D13(3), D13(4),
     +                       TP(2), SYMBOL(2)  


         ENDIF
         CALL NXYR2P (NPTS,
     +                PROB, R, RSQD, X, Y,
     +                ABORT)
         IF (.NOT.ABORT) THEN
            IF (NADD1.GT.1) THEN
               WRITE (TEXT(3),375) RSQD, R, PROB

               N_LINES = N_LINES + 1
               N_COLOR(N_LINES) = JCOLOR
               TEXT_N(N_LINES) = TEXT(3)

            ELSE
               WRITE (TEXT(2),375) RSQD, R, PROB

               N_LINES = N_LINES + 1
               N_COLOR(N_LINES) = JCOLOR
               TEXT_N(N_LINES) = TEXT(2)
               
            ENDIF
            WRITE (NOUT,375) RSQD, R, PROB
         ENDIF
      ENDIF
      
      IF (NTYPE.GT.1 .AND. NBEST.GT.0) THEN
         IF (VARCOV) THEN
            N_LINES = N_LINES + 1
            N_COLOR(N_LINES) = JCOLOR
            TEXT_N(N_LINES) = BLANK
            WRITE (LINE2,400)
            TITLE(1) = LINE2(2)(1:80)
            WRITE (NOUT,400)
            JCOLOR = 4
            N_LINES = N_LINES + 1
            N_COLOR(N_LINES) = JCOLOR
            TEXT_N(N_LINES) = TITLE(1)
            JCOLOR = 0
            DO I = 1, NADD1
               WRITE (LINE1,500) (V(I,J)/(SE(I)*SE(J)), J = 1, I)
               N_LINES = N_LINES + 1
               N_COLOR(N_LINES) = JCOLOR
               TEXT_N(N_LINES) = LINE1
               WRITE (NOUT,500) (V(I,J)/(SE(I)*SE(J)), J = 1, I)
            ENDDO
         ELSE
           CALL PUTFAT ('Correlation matrix cannot be calculated')
         ENDIF
      ENDIF
C
C Locate zeros of derivative of best-fit polynomial if NBEST > 1
C
      NTPNT = 0
      IF (NBEST.GT.1) THEN
         DO I = 1, NBEST
            RI = DBLE(I)
            C(I) = (RNBEST - RI + ONE)*P(NBEST - I + 2)
         ENDDO
         EPSI = X02AJF$()
         CMIN = 1.0D+09*X02AMF$()
         IF (ABS(C(1)).GT.CMIN) THEN
            IFAIL = 1
            CALL C02AGF$(C, NBEST - 1, SCALE1, WK1, WK2, IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'C02AGF/POL006')
         ELSE
            IFAIL = -1
         ENDIF      
         IF (IFAIL.EQ.0) THEN
            DO I = 1, NBEST - 1
               IF (ABS(WK1(2,I)).LE.EPSI) THEN
                  IF (WK1(1,I).GE.XMIN .AND. WK1(1,I).LE.XMAX) THEN
                     NTPNT = NTPNT + 1
                     TL(NTPNT) = WK1(1,I)
                  ENDIF
               ENDIF
            ENDDO
            IF (NTPNT.GT.0) THEN
               DO I = 1, NTPNT
                  TU(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                           B, P, TL(I), XMAX, XMIN)
               ENDDO
               WRITE (TEXT,600)
               WRITE (NOUT,600)
               ICOUNT = 0 
               DO I = 1, 5
                  ICOUNT = ICOUNT + 1
                  TEXT_X(ICOUNT) = TEXT(I)
               ENDDO
               DO I = 1, NTPNT
                  ICOUNT = ICOUNT + 1
                  D13(1) = SHOWRJ(TL(I))
                  D13(2) = SHOWRJ(TU(I))
                  WRITE (LINE1,700) D13(1), D13(2)
                  TEXT_X(ICOUNT) = LINE1 
                  WRITE (NOUT,700) D13(1), D13(2)
               ENDDO
            ELSE
               WRITE (TEXT,800)
               ICOUNT = 0
               DO I = 1, 4
                  ICOUNT = ICOUNT + 1
                  TEXT_X(ICOUNT) = TEXT(I) 
               ENDDO
            ENDIF
         ENDIF
         ICOUNT = ICOUNT + 1
         TEXT_X(ICOUNT) = BLANK 
      ENDIF
C
C Analysis of residuals with W1 = THEORY, W2 = RESID, W3 = WRESID
C
      DO I = 1, NPTS
         W1(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                  B, P, X(I), XMAX, XMIN)
      ENDDO

      IF (USE_POLOPT) THEN
C
C Code to be used if USE_POLOPT = .TRUE.
C----------------------------------------
C        
         IF (NTYPE.EQ.1) THEN
            CALL POLOPT_1 (NGANG, NTYPE,
     +                     AGAIN, CONLIM, FILE1, GRAPH, PARS, PLOT,
     +                     TAB1, TAB2, XFROMY, YFROMX)
         ELSEIF (NTYPE.EQ.2) THEN 
            CALL POLOPT_2 (NGANG, NTYPE,
     +                     AGAIN, CONLIM, FILE1, GRAPH, PARS, PLOT, 
     +                     TAB1, TAB2, XFROMY, YFROMX)
         ELSE 
            CALL OPTPOL (NGANG, NTYPE,
     +                   AGAIN, CONLIM, DERIVS, FILE1, GRAPH, PARS,
     +                   PLOT, TAB1, TAB2, XFROMY, YFROMX)
         ENDIF
      ELSE
C
C Start of code to be used if USE_POLOPT = .FALSE.
C-------------------------------------------------
C        
C
C Decide type of output required depending on NTYPE as follows
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C
   
      PARS = .FALSE.
      TAB2 = .FALSE.
      FILE1 = .FALSE.
      GRAPH = .FALSE.
      PLOT = .FALSE.
      CONLIM = .FALSE.
      XFROMY = .FALSE.
      YFROMX = .FALSE.
      IF (NTYPE.EQ.1) THEN
         NUMOPT = NUMOPT_1
         NTEXT = NUMOPT + 2
         IF (NUMPOS_1(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_1(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_1(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_1(7).EQ.1) XFROMY = .TRUE. 
         DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_1(I)
         ENDDO     
      ELSEIF (NTYPE.EQ.2) THEN
         NUMOPT = NUMOPT_2
         NTEXT = NUMOPT + 2
         IF (NUMPOS_2(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_2(2).EQ.1) TAB2 = .TRUE.
         IF (NUMPOS_2(3).EQ.1) FILE1 = .TRUE.
         IF (NUMPOS_2(4).EQ.1) GRAPH = .TRUE.
         IF (NUMPOS_2(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_2(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_2(7).EQ.1) XFROMY = .TRUE.
          DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_2(I)
         ENDDO   
      ELSE    
         NUMOPT = NUMOPT_3
         NTEXT = NUMOPT + 2
         IF (NUMPOS_3(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_3(2).EQ.1) TAB2 = .TRUE.
         IF (NUMPOS_3(3).EQ.1) FILE1 = .TRUE.
         IF (NUMPOS_3(4).EQ.1) GRAPH = .TRUE.
         IF (NUMPOS_3(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_3(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_3(7).EQ.1) XFROMY = .TRUE.
         IF (NUMPOS_3(8).EQ.1) YFROMX = .TRUE.
         DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_3(I)
         ENDDO   
      ENDIF 
      
      IF (PARS) THEN
         NUMPOS(1) = 1
      ELSE
         NUMPOS(1) = 0
      ENDIF      
      IF (TAB2) THEN
         NUMPOS(2) = 1
      ELSE
         NUMPOS(2) = 0
      ENDIF
      IF (FILE1) THEN
         NUMPOS(3) = 1
      ELSE
         NUMPOS(3) = 0
      ENDIF
      IF (GRAPH) THEN
         NUMPOS(4) = 1
      ELSE
         NUMPOS(4) = 0
      ENDIF
      IF (PLOT) THEN
         NUMPOS(5) = 1
      ELSE
         NUMPOS(5) = 0
      ENDIF
      IF (CONLIM) THEN
         NUMPOS(6) = 1
      ELSE
         NUMPOS(6) = 0
      ENDIF
      IF (XFROMY) THEN
         NUMPOS(7) = 1
      ELSE
         NUMPOS(7) = 0
      ENDIF
      IF (YFROMX) THEN
         NUMPOS(8) = 1
      ELSE
         NUMPOS(8) = 0
      ENDIF
      IF (NGANG.LE.0) THEN
         NGANG = 0
         NUMPOS(9) = 1
         NUMPOS(10) = 0
         NUMPOS(11) = 0
      ELSEIF (NGANG.EQ.1) THEN
         NUMPOS(9) = 0
         NUMPOS(10) = 1
         NUMPOS(11) = 0
      ELSE
         NGANG = 2   
         NUMPOS(9) = 0
         NUMPOS(10) = 0
         NUMPOS(11) = 1
      ENDIF   
      NUMPOS(12) = 0
      
C
C All of NUMPOS has been defined so create the full menu
C
      WRITE (TEXT,900)
      
      IF (NTYPE.EQ.1) THEN
C
C do_1: suppress options 2, 3, 4, and 8
C
         DO I = 8, L12 - 1 
            NUMPOS(I) = NUMPOS(I + 1)
            TEXT(I + 2) = TEXT(I + 3)
         ENDDO 
         DO I = 2, NUMOPT_1
            NUMPOS(I) = NUMPOS(I + 3)
            TEXT(I + 2) = TEXT(I + 5)
         ENDDO
      ELSEIF (NTYPE.EQ.2) THEN
c
c do_2: just suppress option 8 (input x calculate y(x))
c        
         DO I = 8, L12 - 1
            NUMPOS(I) = NUMPOS(I + 1)
            TEXT(I + 2) = TEXT(I + 3)
         ENDDO
      ENDIF      
C
C Display main menu
C      
      REPEET = .TRUE.
      DO WHILE (REPEET) 
         NUMPOS(NUMOPT) = 0
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMPOS(NUMOPT).EQ.1) THEN
            CALL POLADV (NTYPE)
         ELSE
            REPEET = .FALSE.
         ENDIF  
      ENDDO

      IF (NTYPE.EQ.1) THEN
C
C undo_1
C        
          DO I = 12, 9, -1
             NUMPOS(I) = NUMPOS(I - 4)
          ENDDO  
          DO I = 8, 5, -1
             NUMPOS(I) = NUMPOS(I - 3)
          ENDDO   
          NUMPOS(2) = 0      
          NUMPOS(3) = 0      
          NUMPOS(4) = 0      
          NUMPOS(8) = 0 
      ELSEIF (NTYPE.EQ.2) THEN
c
c undo_2
c      
          DO I = 12, 9, -1
             NUMPOS(I) = NUMPOS(I - 1)
          ENDDO
          NUMPOS(8) = 0       
      ENDIF   
            
      IF (NUMPOS(1).EQ.1) THEN
         PARS = .TRUE.
      ELSE
         PARS = .FALSE.
      ENDIF       
      IF (NUMPOS(2).EQ.1) THEN
         TAB2 = .TRUE.
      ELSE
         TAB2 = .FALSE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         FILE1 = .TRUE.
         TAB1 = .TRUE.
      ELSE
         FILE1 = .FALSE.
         TAB1 = .FALSE.
      ENDIF
      IF (NUMPOS(4).EQ.1) THEN
         GRAPH = .TRUE.
      ELSE
         GRAPH = .FALSE.
      ENDIF
      IF (NUMPOS(5).EQ.1) THEN
         PLOT = .TRUE.
      ELSE
         PLOT = .FALSE.
      ENDIF
      IF (NUMPOS(6).EQ.1) THEN
         CONLIM = .TRUE.
      ELSE
         CONLIM = .FALSE.
      ENDIF
      IF (NUMPOS(7).EQ.1) THEN
         XFROMY = .TRUE.
      ELSE
         XFROMY = .FALSE.
      ENDIF
      IF (NUMPOS(8).EQ.1) THEN
         YFROMX = .TRUE.
      ELSE
         YFROMX = .FALSE.
      ENDIF
      IF (NUMPOS(9).EQ.1) THEN
         NGANG = 0
      ELSEIF (NUMPOS(10).EQ.1) THEN
         NGANG = 1
      ELSEIF (NUMPOS(11).EQ.1) THEN
         NGANG = 2
      ENDIF         

      IF (NTYPE.EQ.1) THEN
         DO I = 1, L12
            NUMPOS_1(I) = NUMPOS(I)
         ENDDO
      ELSEIF (NTYPE.EQ.2) THEN 
         DO I = 1, L12
            NUMPOS_2(I) = NUMPOS(I)
         ENDDO  
      ELSE 
         DO I = 1, L12
            NUMPOS_3(I) = NUMPOS(I)
         ENDDO   
      ENDIF
C
C End of code to be used if USE_POLOPT = .FALSE.
C------------------------------------------------
C       
      ENDIF   
C
C Proceed to output
C    
      COLOUR = 15    
      CALL TABLE1 (COLOUR, 'OPEN')
      COLOUR = 0
      IF (XFROMY .AND. NTPNT.GT.0) THEN
         DO I = 1, ICOUNT
            CALL TABLE1 (COLOUR, TEXT_X(I))
         ENDDO   
      ENDIF   
      IF (PARS) THEN
         DO I = 1, N_LINES
            CALL TABLE1 (N_COLOR(I), TEXT_N(I))
         ENDDO   
         CALL TABLE1 (COLOUR, BLANK)
      ENDIF
      IF (NTYPE.GT.1) CALL GKSR01 (NOUT, NADD1, NPTS,
     +                             W2, E, W1, W3, X, Y,
     +                             FILE1, FILE2, GRAPH, TAB1, TAB2)
      CALL TABLE1 (COLOUR, 'CLOSE')
      IF (.NOT.PLOT) RETURN
C
C Set up XGRAF, YGRAF for call to graphics if NOPLOT = .FALSE.
C
      CALL DIVIDE (NGRAF,
     +             XTEMP1, XMIN, XMAX)
      DO I = 1, NGRAF
         XTEMP2(I) = XTEMP1(I)
         XTEMP3(I) = XTEMP1(I)
         YTEMP1(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                      B, P, XTEMP1(I), XMAX, XMIN)
         YTEMP2(I) = YTEMP1(I)
         YTEMP3(I) = YTEMP1(I)
      ENDDO
      XTITLE = 'x'
      YTITLE = 'y'
      IF (NBEST.EQ.1) THEN
         IF (P(2).GE.ZERO .AND. P(1).GE.ZERO) THEN
            D10(1) = FORMGR(P(1))
            D10(2) = FORMGR(P(2))
C            WRITE (PTITLE,1001) P(2), P(1)
            WRITE (PTITLE,1001) TRIM(D10(2)), TRIM(D10(1))
         ELSEIF (P(2).GE.ZERO .AND.P(1).LT.ZERO) THEN
            D10(1) = FORMGR(ABS(P(1)))
            D10(2) = FORMGR(P(2))
C            WRITE (PTITLE,1002) P(2), ABS(P(1))
            WRITE (PTITLE,1002) TRIM(D10(2)), TRIM(D10(1))
         ELSEIF (P(2).LT.ZERO .AND.P(1).GE.ZERO) THEN
            D10(1) = FORMGR(P(1))
            D10(2) = FORMGR(ABS(P(2)))
C            WRITE (PTITLE,1003) ABS(P(2)), P(1)
            WRITE (PTITLE,1003) TRIM(D10(2)), TRIM(D10(1))
         ELSE
           D10(1) = FORMGR(ABS(P(1)))
           D10(2) = FORMGR(ABS(P(2)))
C           WRITE (PTITLE,1004) ABS(P(2)), ABS(P(1))
           WRITE (PTITLE,1004) TRIM(D10(2)), TRIM(D10(1))
         ENDIF
      ELSE
         WRITE (PTITLE,1005) NBEST
      ENDIF
      IF (CONLIM) THEN
         DO I = 1, NGRAF
            DUMMY = SQRT(POLF07(NB2, NB2P1, N13, QF, XTEMP1(I)))*TSTAT
            YTEMP2(I) = YTEMP1(I) + DUMMY
            YTEMP3(I) = YTEMP1(I) - DUMMY
         ENDDO
         CALL GKS004 (L0, L1, L3, L3,
     +                L5, L0, L0, L0,
     +                NPTS, NGRAF, NGRAF, NGRAF,
     +                X, XTEMP1, XTEMP2, XTEMP3,
     +                Y, YTEMP1, YTEMP2, YTEMP3,
     +                PTITLE, XTITLE, YTITLE, 
     +                SAVEIT, SAVEIT)
      ELSE
         CALL GKS004 (L0, L1, L0, L0,
     +                L5, L0, L0, L0,
     +                NPTS, NGRAF, NGRAF, NGRAF,
     +                X, XTEMP1, XTEMP2, XTEMP3,
     +                Y, YTEMP1, YTEMP2, YTEMP3,
     +                PTITLE, XTITLE, YTITLE,
     +                SAVEIT, SAVEIT)
      ENDIF
      IF (NTYPE.NE.1 .AND. NTYPE.NE.2) THEN
         IF (DERIVS) THEN
            NC = NBEST + 1
            CALL  POLPLT (NC, NPTS,
     +                    P, X)   
         ENDIF                    
      ENDIF  
C
C Format statements
C      
  100 FORMAT (11X,'Parameters p(i) cannot be determined accurately'
     +/1X,'*REMEDY : Choose more sensible X-units say - 10 < X < 10'
     +/11X,'Choose a  lower degree for best-fit polynomial'
     +/11X,'Obtain more (better ?) experimental data.')
  200 FORMAT (A/3X,'Parameter',5X,'Value ',7X,
     +'Std.Error    Lower95%cl    Upper95%cl',4X,'p')
C  300 FORMAT (4X,'p(',I1,')',3X,1P,
C     +1X,E13.5,1X,E13.5,1X,E13.5,1X,E13.5,0P,F8.4,A2)
  300 FORMAT (4X,'p(',I1,')',3X,
     +1X,A13,1X,A13,1X,A13,1X,A13,F8.4,A2)
C  350 FORMAT (A11,1P,1X,E13.5,1X,E13.5,1X,E13.5,1X,E13.5,0P,F8.4,A2)    
  350 FORMAT (A11,1X,A13,1X,A13,1X,A13,1X,A13,F8.4,A2)   
  375 FORMAT (' (R-squared =',F7.4,', R =',F8.4,', p =',F7.4,')')
  400 FORMAT (/1X,'Correlation matrix')
  500 FORMAT (7F8.4)
  600 FORMAT (
     +/1X,'You must  be very careful if you wish to use this best-fit'
     +/1X,'curve as a calibration curve for predicting x given y since'
     +/1X,'there are turning points for Xmin <= x <= Xmax as follows:-'
     +/15X,'x-value',7X,'y-value')
C 700 FORMAT (9X,1P,2E14.4)
  700 FORMAT (10X,A13,1X,A13)
  800 FORMAT (
     +/1X,'The best-fit curve has no turning points for Xmin < x < Xmax'
     +/1X,'and is suitable as a calibration curve for predicting x with'
     +/1X,'95% confidence limits from y supplied.')
  900 FORMAT (
     + 'Select the type of output required for the results'
     +/
     +/'Display table of best-fit parameters'
     +/'Display table of goodness-of-fit'
     +/'Display table of residuals (and save to results file)'
     +/'Plot residuals'
     +/'Plot best-fit curve'
     +/'Plot 95% confidence limits'
     +/'Input y-values then predict x (calibration)'
     +/'Input x-values then estimate y (evaluation)'
     +/'Input calibration/evaluation data from terminal then discard'
     +/'Input calibration/evaluation data from terminal then save'
     +/'Input calibration/evaluation data from file or clipboard'
     +/'Help')
C 1001 FORMAT ('y = ',1P,E9.3,'x + ',E9.3)
C 1002 FORMAT ('y = ',1P,E9.3,'x - ',E9.3)
C 1003 FORMAT ('y = -',1P,E9.3,'x + ',E9.3)
C 1004 FORMAT ('y = -',1P,E9.3,'x - ',E9.3)
 1001 FORMAT ('y = ',A,'x + ',A)
 1002 FORMAT ('y = ',A,'x - ',A)
 1003 FORMAT ('y = -',A,'x + ',A)
 1004 FORMAT ('y = -',A,'x - ',A)
 1005 FORMAT ('Best fit degree',I2,' polynomial')
      END
C
C*************************************************************************
C SUBROUTINE OPTPOL for use when fitting polynomials
C*************************************************************************
C
      SUBROUTINE OPTPOL (NGANG, NTYPE,
     +                   AGAIN, CONLIM, DERIVS, FILE1, GRAPH, PARS,
     +                   PLOT, TAB1,
     +                   TAB2, XFROMY, YFROMX)   
C
C 24/12/2019 Developed from POL006 and added new variable AGAIN
C            The code was extracted from POL006 in order to develop the check-box
C            interface for controlling run-time options in program POLNOM
C 22/04/2020 Developed from POLOPT to be used when NTYPE > 2  	
C
C Decide type of output required 
C Advanced polynomial then calibrate
C
C
C Arguments
C
      INTEGER, INTENT (IN)    :: NTYPE
      INTEGER, INTENT (INOUT) :: NGANG
      LOGICAL, INTENT (INOUT) :: AGAIN, CONLIM, FILE1, GRAPH, 
     +                           PARS, PLOT, TAB1, TAB2, XFROMY, YFROMX 
      LOGICAL, INTENT (INOUT) :: DERIVS 
C
C Locals
C    
      INTEGER    L15, L30
      PARAMETER (L15 = 15, L30 = 30)
      INTEGER    I, L 
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMDEC = 1,
     +           NSTART = 3)
      INTEGER    NUMBLD(L30), NUMPOS(L15)
      INTEGER    NUMBLD_3(L30), NUMPOS_3(L15)
      INTEGER    NUMOPT_3
      PARAMETER (NUMOPT_3 = L15)
      CHARACTER (LEN = 100) TEXT(L30)
      CHARACTER (LEN = 30 ) CIPHER 
      LOGICAL    FIRST, SWITCH_OFF 
      LOGICAL    REPEET    
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      DATA       FIRST, SWITCH_OFF / .TRUE., .FALSE. /
      DATA       NUMBLD, NUMPOS / L30*0, L15*0 /
      DATA       NUMBLD_3 / L30*0 /
      DATA       NUMPOS_3 / L15*0 /
      EXTERNAL   POLADV, RBOX01, PUTADV
C
C Set DERIVS and check SWITCH_OFF
C      
      IF (NTYPE.EQ.1 .OR. NTYPE.EQ.2) THEN
         CALL PUTADV (
     +'NTYPE = 1 or NTYPE = 2 in call to OPTPOL not allowed')
         RETURN
      ENDIF    
      IF (SWITCH_OFF) RETURN
      IF (FIRST) THEN
C
C First time initialise parameters for interface depending on NTYPE
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 4: advanced polynomial then calibrate
C        
         FIRST = .FALSE.
         NGANG = 0
         DO L = 10, 12
            NUMBLD_3(L + 2) = 100
            NUMPOS_3(L) = 0
         ENDDO
         NUMPOS_3(1) = 1
         NUMPOS_3(2) = 1
         NUMPOS_3(5) = 1
         NUMPOS_3(7) = 0
         NUMPOS_3(10) = 1
      ENDIF         
      IF (NTYPE.NE.1 .AND. NTYPE.NE.2) THEN    
         NUMOPT = NUMOPT_3
         NTEXT = NUMOPT + 2
         IF (NUMPOS_3(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_3(2).EQ.1) TAB2 = .TRUE.
         IF (NUMPOS_3(3).EQ.1) FILE1 = .TRUE.
         IF (NUMPOS_3(4).EQ.1) GRAPH = .TRUE.
         IF (NUMPOS_3(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_3(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_3(7).EQ.1) DERIVS = .TRUE.  
         IF (NUMPOS_3(8).EQ.1) XFROMY = .TRUE.
         IF (NUMPOS_3(9).EQ.1) YFROMX = .TRUE.
         DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_3(I)
         ENDDO  
      ENDIF 
C
C Set up parameters to call RBOX01
C     
      IF (PARS) THEN
         NUMPOS(1) = 1
      ELSE
         NUMPOS(1) = 0
      ENDIF      
      IF (TAB2) THEN
         NUMPOS(2) = 1
      ELSE
         NUMPOS(2) = 0
      ENDIF
      IF (FILE1) THEN
         NUMPOS(3) = 1
      ELSE
         NUMPOS(3) = 0
      ENDIF
      IF (GRAPH) THEN
         NUMPOS(4) = 1
      ELSE
         NUMPOS(4) = 0
      ENDIF
      IF (PLOT) THEN
         NUMPOS(5) = 1
      ELSE
         NUMPOS(5) = 0
      ENDIF
      IF (CONLIM) THEN
         NUMPOS(6) = 1
      ELSE
         NUMPOS(6) = 0
      ENDIF
      IF (DERIVS) THEN
         NUMPOS(7) = 1
      ELSE
         NUMPOS(7) = 0
      ENDIF      
      IF (XFROMY) THEN
         NUMPOS(8) = 1
      ELSE
         NUMPOS(8) = 0
      ENDIF
      IF (YFROMX) THEN
         NUMPOS(9) = 1
      ELSE
         NUMPOS(9) = 0
      ENDIF
      IF (NGANG.LE.0 .OR. NGANG.GT.2) THEN
         NGANG = 0
         NUMPOS(10) = 1
         NUMPOS(11) = 0
         NUMPOS(12) = 0
      ELSEIF (NGANG.EQ.1) THEN
         NUMPOS(10) = 0
         NUMPOS(11) = 1
         NUMPOS(12) = 0
      ELSE
         NGANG = 2   
         NUMPOS(10) = 0
         NUMPOS(11) = 0
         NUMPOS(12) = 1
      ENDIF   
C
C All of NUMPOS has been defined so create the full menu
C
      IF (DERIVS) THEN
         CIPHER = ' and best-fit-derivatives'
      ELSE
         CIPHER = '  '  
      ENDIF   
      WRITE (TEXT,100) CIPHER
C
C Display main menu
C      
      NUMPOS(L15 - 1) = 0
      REPEET = .TRUE.
      DO WHILE (REPEET) 
         NUMPOS(NUMOPT) = 0
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMPOS(NUMOPT).EQ.1) THEN
            CALL POLADV (NTYPE)
         ELSE
            REPEET = .FALSE.
         ENDIF  
      ENDDO
      IF (NUMPOS(1).EQ.1) THEN
         PARS = .TRUE.
      ELSE
         PARS = .FALSE.
      ENDIF       
      IF (NUMPOS(2).EQ.1) THEN
         TAB2 = .TRUE.
      ELSE
         TAB2 = .FALSE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         FILE1 = .TRUE.
         TAB1 = .TRUE.
      ELSE
         FILE1 = .FALSE.
         TAB1 = .FALSE.
      ENDIF
      IF (NUMPOS(4).EQ.1) THEN
         GRAPH = .TRUE.
      ELSE
         GRAPH = .FALSE.
      ENDIF
      IF (NUMPOS(5).EQ.1) THEN
         PLOT = .TRUE.
      ELSE
         PLOT = .FALSE.
      ENDIF
      IF (NUMPOS(6).EQ.1) THEN
         CONLIM = .TRUE.
      ELSE
         CONLIM = .FALSE.
      ENDIF
      IF (NUMPOS(7).EQ.1) THEN
         DERIVS = .TRUE.
      ELSE
         DERIVS = .FALSE.
      ENDIF       
      IF (NUMPOS(8).EQ.1) THEN
         XFROMY = .TRUE.
      ELSE
         XFROMY = .FALSE.
      ENDIF
      IF (NUMPOS(9).EQ.1) THEN
         YFROMX = .TRUE.
      ELSE
         YFROMX = .FALSE.
      ENDIF
      IF (NUMPOS(10).EQ.1) THEN
         NGANG = 0   
         NUMPOS(11) = 0
         NUMPOS(12) = 0
      ELSEIF (NUMPOS(11).EQ.1) THEN
         NGANG = 1
         NUMPOS(10) = 0
         NUMPOS(12) = 0
      ELSEIF (NUMPOS(12).EQ.1) THEN
         NGANG = 2
         NUMPOS(10) = 0
         NUMPOS(11) = 0
      ENDIF         
      IF (NTYPE.NE.1 .AND. NTYPE.NE.2) THEN 
         DO I = 1, L15
            NUMPOS_3(I) = NUMPOS(I)
         ENDDO   
      ENDIF
      IF (NUMPOS(L15 - 2).EQ.1) THEN
         AGAIN = .TRUE.
      ELSE
         AGAIN = .FALSE.
      ENDIF       
      IF (NUMPOS(L15 - 1).EQ.1) THEN
         SWITCH_OFF = .TRUE.
      ELSE
         SWITCH_OFF = .FALSE.
      ENDIF       
      IF (.NOT.PLOT) THEN
         DERIVS = .FALSE.
         CONLIM = .FALSE.
      ENDIF        
C
C Format statement 
C      
  100 FORMAT (
     + 'Options when using POLNOM to fit polynomials'
     +/
     +/'Display table of best-fit parameters'
     +/'Display table of goodness-of-fit'
     +/'Display table of residuals (and save to results file)'
     +/'Plot residuals'
     +/'Plot best-fit curve',1x,a
     +/'Add 95% confidence limits'
     +/'Add an option to plot best-fit derivatives' 
     +/'Input y-values then predict x (calibration)'
     +/'Input x-values then estimate y (evaluation)'
     +/'Input calibration/evaluation data from terminal then discard'
     +/'Input calibration/evaluation data from terminal then save'
     +/'Input calibration/evaluation data from file or clipboard'
     +/'Provide an option to choose a new degree after fitting'     
     +/'Do not ask again this session'
     +/'Help')
      END
C
C*************************************************************************
C SUBROUTINE POLOPT for use when fitting lines
C*************************************************************************
C          
      SUBROUTINE POLOPT (NGANG, NTYPE,
     +                   AGAIN, CONLIM, FILE1, GRAPH, PARS, PLOT, TAB1,
     +                   TAB2, XFROMY, YFROMX)   
C
C 24/12/2019 Developed from POL006 and added new variable AGAIN
C            The code was extracted from POL006 in order to develop the check-box
C            interface for controlling run-time options in program POLNOM
C
C Decide type of output required depending on NTYPE as follows
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C
C
C Arguments
C
      INTEGER, INTENT (IN)    :: NTYPE
      INTEGER, INTENT (INOUT) :: NGANG
      LOGICAL, INTENT (INOUT) :: AGAIN, CONLIM, FILE1, GRAPH, PARS,
     +                           PLOT, TAB1, TAB2, XFROMY, YFROMX 
C
C Locals
C    
      INTEGER     L14, L30
      PARAMETER (L14 = 14, L30 = 30)
      INTEGER    I, J, K, L 
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMDEC = 1,
     +           NSTART = 3)
      INTEGER    NUMBLD(L30), NUMPOS(L14)
      INTEGER    NUMBLD_1(L30), NUMPOS_1(L14)
      INTEGER    NUMBLD_2(L30), NUMPOS_2(L14)
      INTEGER    NUMBLD_3(L30), NUMPOS_3(L14)
      INTEGER    NUMOPT_1, NUMOPT_2, NUMOPT_3
      PARAMETER (NUMOPT_1 = L14 - 4, NUMOPT_2 = L14 - 1, NUMOPT_3 = L14)
      CHARACTER (LEN = 100) TEXT(L30)
      LOGICAL    FIRST, SWITCH_OFF 
      LOGICAL    REPEET    
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      DATA       FIRST, SWITCH_OFF / .TRUE., .FALSE. /
      DATA       NUMBLD, NUMPOS / L30*0, L14*0 /
      DATA       NUMBLD_1, NUMBLD_2, NUMBLD_3 / L30*0, L30*0, L30*0 /
      DATA       NUMPOS_1, NUMPOS_2, NUMPOS_3 / L14*0, L14*0, L14*0 /
      EXTERNAL   POLADV, RBOX01

      IF (SWITCH_OFF) RETURN
      IF (FIRST) THEN
C
C First time initialise parameters for interface depending on NTYPE
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C        
         FIRST = .FALSE.
         NGANG = 0
         NUMBLD_1(1) = 1
         NUMBLD_2(1) = 1
         NUMBLD_3(1) = 1
         I = NUMOPT_1 - 4
         J = NUMOPT_2 - 4
         K = NUMOPT_3 - 4
         DO L = 1, 3
            I = I + 1
            J = J + 1
            K = K + 1
            NUMBLD_1(I) = 100
            NUMBLD_2(J) = 100
            NUMBLD_3(K) = 100
         ENDDO
         
         NUMPOS_1(5) = 1
         NUMPOS_1(7) = 0

         NUMPOS_2(1) = 1
         NUMPOS_2(2) = 1
         NUMPOS_2(5) = 1
         NUMPOS_2(7) = 0

         NUMPOS_3(1) = 1
         NUMPOS_3(2) = 1
         NUMPOS_3(5) = 1
         NUMPOS_3(7) = 0
      ENDIF         
      
      IF (NTYPE.EQ.1) THEN
         NUMOPT = NUMOPT_1
         NTEXT = NUMOPT + 2
         IF (NUMPOS_1(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_1(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_1(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_1(7).EQ.1) XFROMY = .TRUE. 
         DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_1(I)
         ENDDO     
      ELSEIF (NTYPE.EQ.2) THEN
         NUMOPT = NUMOPT_2
         NTEXT = NUMOPT + 2
         IF (NUMPOS_2(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_2(2).EQ.1) TAB2 = .TRUE.
         IF (NUMPOS_2(3).EQ.1) FILE1 = .TRUE.
         IF (NUMPOS_2(4).EQ.1) GRAPH = .TRUE.
         IF (NUMPOS_2(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_2(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_2(7).EQ.1) XFROMY = .TRUE.
          DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_2(I)
         ENDDO   
      ELSE    
         NUMOPT = NUMOPT_3
         NTEXT = NUMOPT + 2
         IF (NUMPOS_3(1).EQ.1) PARS = .TRUE.
         IF (NUMPOS_3(2).EQ.1) TAB2 = .TRUE.
         IF (NUMPOS_3(3).EQ.1) FILE1 = .TRUE.
         IF (NUMPOS_3(4).EQ.1) GRAPH = .TRUE.
         IF (NUMPOS_3(5).EQ.1) PLOT = .TRUE.
         IF (NUMPOS_3(6).EQ.1) CONLIM = .TRUE.
         IF (NUMPOS_3(7).EQ.1) XFROMY = .TRUE.
         IF (NUMPOS_3(8).EQ.1) YFROMX = .TRUE.
         DO I = 1, NTEXT
            NUMBLD(I) = NUMBLD_3(I)
         ENDDO   
      ENDIF 
C
C Set up parameters to call RBOX01
C     
      IF (PARS) THEN
         NUMPOS(1) = 1
      ELSE
         NUMPOS(1) = 0
      ENDIF      
      IF (TAB2) THEN
         NUMPOS(2) = 1
      ELSE
         NUMPOS(2) = 0
      ENDIF
      IF (FILE1) THEN
         NUMPOS(3) = 1
      ELSE
         NUMPOS(3) = 0
      ENDIF
      IF (GRAPH) THEN
         NUMPOS(4) = 1
      ELSE
         NUMPOS(4) = 0
      ENDIF
      IF (PLOT) THEN
         NUMPOS(5) = 1
      ELSE
         NUMPOS(5) = 0
      ENDIF
      IF (CONLIM) THEN
         NUMPOS(6) = 1
      ELSE
         NUMPOS(6) = 0
      ENDIF
      IF (XFROMY) THEN
         NUMPOS(7) = 1
      ELSE
         NUMPOS(7) = 0
      ENDIF
      IF (YFROMX) THEN
         NUMPOS(8) = 1
      ELSE
         NUMPOS(8) = 0
      ENDIF
      IF (NGANG.LE.0) THEN
         NGANG = 0
         NUMPOS(9) = 1
         NUMPOS(10) = 0
         NUMPOS(11) = 0
      ELSEIF (NGANG.EQ.1) THEN
         NUMPOS(9) = 0
         NUMPOS(10) = 1
         NUMPOS(11) = 0
      ELSE
         NGANG = 2   
         NUMPOS(9) = 0
         NUMPOS(10) = 0
         NUMPOS(11) = 1
      ENDIF   
      
C
C All of NUMPOS has been defined so create the full menu
C
      WRITE (TEXT,100)
      
      IF (NTYPE.EQ.1) THEN
C
C do_1: suppress options 2, 3, 4, and 8
C
         DO I = 8, L14 - 1 
            NUMPOS(I) = NUMPOS(I + 1)
            TEXT(I + 2) = TEXT(I + 3)
         ENDDO 
         DO I = 2, NUMOPT_1
            NUMPOS(I) = NUMPOS(I + 3)
            TEXT(I + 2) = TEXT(I + 5)
         ENDDO
      ELSEIF (NTYPE.EQ.2) THEN
c
c do_2: just suppress option 8 (input x calculate y(x))
c        
         DO I = 8, L14 - 1
            NUMPOS(I) = NUMPOS(I + 1)
            TEXT(I + 2) = TEXT(I + 3)
         ENDDO
      ENDIF      
C
C Display main menu
C      
      NUMPOS(L14 - 1) = 0
      REPEET = .TRUE.
      DO WHILE (REPEET) 
         NUMPOS(NUMOPT) = 0
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMPOS(NUMOPT).EQ.1) THEN
            CALL POLADV (NTYPE)
         ELSE
            REPEET = .FALSE.
         ENDIF  
      ENDDO

      IF (NTYPE.EQ.1) THEN
C
C undo_1
C        
          DO I = 12, 9, -1
             NUMPOS(I) = NUMPOS(I - 4)
          ENDDO  
          DO I = 8, 5, -1
             NUMPOS(I) = NUMPOS(I - 3)
          ENDDO   
          NUMPOS(2) = 0      
          NUMPOS(3) = 0      
          NUMPOS(4) = 0      
          NUMPOS(8) = 0 
      ELSEIF (NTYPE.EQ.2) THEN
c
c undo_2
c      
          DO I = 12, 9, -1
             NUMPOS(I) = NUMPOS(I - 1)
          ENDDO
          NUMPOS(8) = 0       
      ENDIF   
            
      IF (NUMPOS(1).EQ.1) THEN
         PARS = .TRUE.
      ELSE
         PARS = .FALSE.
      ENDIF       
      IF (NUMPOS(2).EQ.1) THEN
         TAB2 = .TRUE.
      ELSE
         TAB2 = .FALSE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         FILE1 = .TRUE.
         TAB1 = .TRUE.
      ELSE
         FILE1 = .FALSE.
         TAB1 = .FALSE.
      ENDIF
      IF (NUMPOS(4).EQ.1) THEN
         GRAPH = .TRUE.
      ELSE
         GRAPH = .FALSE.
      ENDIF
      IF (NUMPOS(5).EQ.1) THEN
         PLOT = .TRUE.
      ELSE
         PLOT = .FALSE.
      ENDIF
      IF (NUMPOS(6).EQ.1) THEN
         CONLIM = .TRUE.
      ELSE
         CONLIM = .FALSE.
      ENDIF
      IF (NUMPOS(7).EQ.1) THEN
         XFROMY = .TRUE.
      ELSE
         XFROMY = .FALSE.
      ENDIF
      IF (NUMPOS(8).EQ.1) THEN
         YFROMX = .TRUE.
      ELSE
         YFROMX = .FALSE.
      ENDIF
      IF (NUMPOS(9).EQ.1) THEN
         NGANG = 0
      ELSEIF (NUMPOS(10).EQ.1) THEN
         NGANG = 1
      ELSEIF (NUMPOS(11).EQ.1) THEN
         NGANG = 2
      ENDIF         
      
      IF (NTYPE.EQ.1) THEN
         DO I = 1, L14
            NUMPOS_1(I) = NUMPOS(I)
         ENDDO
      ELSEIF (NTYPE.EQ.2) THEN 
         DO I = 1, L14
            NUMPOS_2(I) = NUMPOS(I)
         ENDDO  
      ELSE 
         DO I = 1, L14
            NUMPOS_3(I) = NUMPOS(I)
         ENDDO   
      ENDIF

      IF (NUMPOS(L14 - 2).EQ.1) THEN
         AGAIN = .TRUE.
      ELSE
         AGAIN = .FALSE.
      ENDIF       

      IF (NUMPOS(L14 - 1).EQ.1) THEN
         SWITCH_OFF = .TRUE.
      ELSE
         SWITCH_OFF = .FALSE.
      ENDIF       
C
C Format statement 
C      
  100 FORMAT (
     + 'Options when using POLNOM to fit polynomials'
     +/
     +/'Display table of best-fit parameters'
     +/'Display table of goodness-of-fit'
     +/'Display table of residuals (and save to results file)'
     +/'Plot residuals'
     +/'Plot best-fit curve'
     +/'Plot 95% confidence limits'
     +/'Input y-values then predict x (calibration)'
     +/'Input x-values then estimate y (evaluation)'
     +/'Input calibration/evaluation data from terminal then discard'
     +/'Input calibration/evaluation data from terminal then save'
     +/'Input calibration/evaluation data from file or clipboard'
     +/'Provide an option to choose a new degree after fitting'     
     +/'Do not ask again this session'
     +/'Help')
      END
C
C                
    
C
C*************************************************************************
C SUBROUTINE POLOPT_1 for use when fitting lines in simple mode in SIMSTAT
C*************************************************************************
C          
      SUBROUTINE POLOPT_1 (NGANG, NTYPE,
     +                     AGAIN, CONLIM, FILE1, GRAPH, PARS, PLOT,
     +                     TAB1, TAB2, XFROMY, YFROMX)   
C
C 24/12/2019 Developed from POL006 and added new variable AGAIN
C            The code was extracted from POL006 in order to develop the check-box
C            interface for controlling run-time options in program POLNOM
C 23/10/2020 Developed for the cases NTYPE = 1 and NTYPE = 2
C
C Decide type of output required depending on NTYPE as follows
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C
C
C Arguments
C
      INTEGER, INTENT (IN)    :: NTYPE
      INTEGER, INTENT (INOUT) :: NGANG
      LOGICAL, INTENT (INOUT) :: CONLIM, PARS, PLOT, XFROMY 
      LOGICAL, INTENT (OUT)   :: AGAIN, FILE1, GRAPH, TAB1, TAB2, YFROMX
C
C Locals
C    
      INTEGER    L20, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (L20 = 20, NUMDEC = 1, NUMOPT = 9, NSTART = 3, 
     +           NTEXT = 11)
      INTEGER    I 
      INTEGER    ICOLOR, IXL, IYL, LSHADE
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(L20), NUMPOS(L20)
      CHARACTER (LEN = 100) TEXT(L20)
      LOGICAL    SWITCH_OFF 
      LOGICAL    REPEET    
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      DATA       SWITCH_OFF / .FALSE. /
      DATA       NUMBLD, NUMPOS / L20*0, L20*0 /
      EXTERNAL   POLADV, RBOX01

      AGAIN = .FALSE.
      
      IF (SWITCH_OFF) RETURN

      IF (NTYPE.NE.1) RETURN
          
      AGAIN = .FALSE.
      FILE1 = .FALSE.
      GRAPH = .FALSE.
      TAB1 = .FALSE.
      TAB2 = .FALSE.
      YFROMX = .FALSE.
      DO I = 7, 9
         NUMBLD(I) = 100
      ENDDO
      
C
C Set up parameters to call RBOX01
C     
      IF (PARS) THEN
         NUMPOS(1) = 1
      ELSE
         NUMPOS(1) = 0
      ENDIF      
      IF (PLOT) THEN
         NUMPOS(2) = 1
      ELSE
         NUMPOS(2) = 0
      ENDIF
      IF (CONLIM) THEN
         NUMPOS(3) = 1
      ELSE
         NUMPOS(3) = 0
      ENDIF
      IF (XFROMY) THEN
         NUMPOS(4) = 1
      ELSE
         NUMPOS(4) = 0
      ENDIF
      IF (NGANG.LE.0 .OR. NGANG.GT.2) THEN
         NGANG = 0
         NUMPOS(5) = 1
         NUMPOS(6) = 0
         NUMPOS(7) = 0
      ELSEIF (NGANG.EQ.1) THEN   
         NGANG = 1
         NUMPOS(5) = 0
         NUMPOS(6) = 1
         NUMPOS(7) = 0
      ELSEIF (NGANG.EQ.2) THEN  
         NGANG = 2 
         NUMPOS(5) = 0
         NUMPOS(6) = 0
         NUMPOS(7) = 1
      ENDIF  
      IF (SWITCH_OFF) THEN
         NUMPOS(8) = 1
      ELSE       
         NUMPOS(8) = 0
      ENDIF   
C
C All of NUMPOS has been defined so create the full menu
C
      WRITE (TEXT,100)
      
C
C Display main menu
C      
      REPEET = .TRUE.
      DO WHILE (REPEET) 
         NUMPOS(NUMOPT) = 0
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMPOS(NUMOPT).EQ.1) THEN
            CALL POLADV (NTYPE)
         ELSE
            REPEET = .FALSE.
         ENDIF  
      ENDDO

      IF (NUMPOS(1).EQ.1) THEN
         PARS = .TRUE.
      ELSE
         PARS = .FALSE.
      ENDIF       
      IF (NUMPOS(2).EQ.1) THEN
         PLOT = .TRUE.
      ELSE
         PLOT = .FALSE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         CONLIM = .TRUE.
      ELSE
         CONLIM = .FALSE.
      ENDIF
      IF (NUMPOS(4).EQ.1) THEN
         XFROMY = .TRUE.
      ELSE 
         XFROMY = .FALSE.
      ENDIF      
      IF (NUMPOS(5).EQ.1) THEN
         NGANG = 0
      ELSEIF (NUMPOS(6).EQ.1) THEN
         NGANG = 1
      ELSEIF (NUMPOS(7).EQ.1) THEN
         NGANG = 2
      ENDIF         
      IF (NUMPOS(8).EQ.1) THEN
         SWITCH_OFF = .TRUE.
      ELSE
         SWITCH_OFF = .FALSE.
      ENDIF       
C
C Format statement 
C      
  100 FORMAT (
     + 'Options when using POLNOM to fit a line in simple mode'
     +/
     +/'Display table of best-fit parameters'
c...2  +/'Display table of goodness-of-fit'
c...3   +/'Display table of residuals (and save to results file)'
c...4   +/'Plot residuals'
     +/'Plot best-fit curve'
     +/'Plot 95% confidence limits'
     +/'Input y-values then predict x (calibration)'
c...8    +/'Input x-values then estimate y (evaluation)'
     +/'Input calibration/evaluation data from terminal then discard'
     +/'Input calibration/evaluation data from terminal then save'
     +/'Input calibration/evaluation data from file or clipboard'
c...12    +/'Provide an option to choose a new degree after fitting'     
     +/'Do not ask again this session'
     +/'Help')
      END
C
C                




C***************************************************************************
C SUBROUTINE POLOPT_2 for use when fitting lines in advanced mode in SIMSTAT
C***************************************************************************
C          
      SUBROUTINE POLOPT_2 (NGANG, NTYPE,
     +                     AGAIN, CONLIM, FILE1, GRAPH, PARS, PLOT,
     +                     TAB1, TAB2, XFROMY, YFROMX)   
C
C 24/12/2019 Developed from POL006 and added new variable AGAIN
C            The code was extracted from POL006 in order to develop the check-box
C            interface for controlling run-time options in program POLNOM
C 23/10/2020 Developed for the case NTYPE = 2
C
C Decide type of output required depending on NTYPE as follows
C NTYPE = 1: simple line then calibrate
C NTYPE = 2: advanced line then calibrate
C NTYPE = 3: advanced polynomial then calibrate
C
C
C Arguments
C
      INTEGER, INTENT (IN)    :: NTYPE
      INTEGER, INTENT (INOUT) :: NGANG
      LOGICAL, INTENT (INOUT) :: CONLIM, FILE1, GRAPH, PARS, PLOT, TAB1,
     +                           TAB2, XFROMY 
      LOGICAL, INTENT (OUT)   :: AGAIN, YFROMX
C
C Locals
C    
      INTEGER    L20, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (L20 = 20, NUMDEC = 1, NUMOPT = 12, NSTART = 3, 
     +           NTEXT = 14)
      INTEGER    I 
      INTEGER    ICOLOR, IXL, IYL, LSHADE
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1)
      INTEGER    NUMBLD(L20), NUMPOS(L20)
      CHARACTER (LEN = 100) TEXT(L20)
      LOGICAL    SWITCH_OFF 
      LOGICAL    REPEET    
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      DATA       SWITCH_OFF / .FALSE. /
      DATA       NUMBLD, NUMPOS / L20*0, L20*0 /
      EXTERNAL   POLADV, RBOX01

      AGAIN = .FALSE.
      
      IF (SWITCH_OFF) RETURN

      IF (NTYPE.NE.2) RETURN
          
      AGAIN = .FALSE.
      YFROMX = .FALSE.
      DO I = 10, 12
         NUMBLD(I) = 100
      ENDDO
      
C
C Set up parameters to call RBOX01
C     
      IF (PARS) THEN
         NUMPOS(1) = 1
      ELSE
         NUMPOS(1) = 0
      ENDIF      
      IF (TAB2) THEN
         NUMPOS(2) = 1
      ELSE
         NUMPOS(2) = 0
      ENDIF
      IF (TAB1 .OR. FILE1) THEN
         NUMPOS(3) = 1
      ELSE
         NUMPOS(3) = 0
      ENDIF
      IF (GRAPH) THEN
         NUMPOS(4) = 1
      ELSE
         NUMPOS(4) = 0
      ENDIF
      IF (PLOT) THEN
         NUMPOS(5) = 1
      ELSE
         NUMPOS(5) = 0
      ENDIF
      IF (CONLIM) THEN
         NUMPOS(6) = 1
      ELSE
         NUMPOS(6) = 0
      ENDIF
      IF (XFROMY) THEN
         NUMPOS(7) = 1
      ELSE
         NUMPOS(7) = 0
      ENDIF
      IF (NGANG.LE.0 .OR. NGANG.GT.2) THEN
         NGANG = 0
         NUMPOS(8) = 1
         NUMPOS(9) = 0
         NUMPOS(10) = 0
      ELSEIF (NGANG.EQ.1) THEN   
         NGANG = 1
         NUMPOS(8) = 0
         NUMPOS(9) = 1
         NUMPOS(10) = 0
      ELSEIF (NGANG.EQ.2) THEN  
         NGANG = 2 
         NUMPOS(8) = 0
         NUMPOS(9) = 0
         NUMPOS(10) = 1
      ENDIF  
      IF (SWITCH_OFF) THEN
         NUMPOS(11) = 1
      ELSE       
         NUMPOS(11) = 0
      ENDIF   
C
C All of NUMPOS has been defined so create the full menu
C
      WRITE (TEXT,100)
      
C
C Display main menu
C      
      REPEET = .TRUE.
      DO WHILE (REPEET) 
         NUMPOS(NUMOPT) = 0
         CALL RBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMPOS(NUMOPT).EQ.1) THEN
            CALL POLADV (NTYPE)
         ELSE
            REPEET = .FALSE.
         ENDIF  
      ENDDO

      IF (NUMPOS(1).EQ.1) THEN
         PARS = .TRUE.
      ELSE
         PARS = .FALSE.
      ENDIF       
      IF (NUMPOS(2).EQ.1) THEN
         TAB2 = .TRUE.
      ELSE
         TAB2 = .FALSE.
      ENDIF
      IF (NUMPOS(3).EQ.1) THEN
         TAB1 = .TRUE.
         FILE1 = .TRUE.
      ELSE
         TAB1 = .FALSE.
         FILE1 = .FALSE.
      ENDIF
      IF (NUMPOS(4).EQ.1) THEN
         GRAPH = .TRUE.
      ELSE 
         GRAPH = .FALSE.
      ENDIF  
      IF (NUMPOS(5).EQ.1) THEN
         PLOT = .TRUE.
      ELSE 
         PLOT = .FALSE.
      ENDIF
      IF (NUMPOS(6).EQ.1) THEN
         CONLIM = .TRUE.
      ELSE 
         CONLIM = .FALSE.
      ENDIF     
      IF (NUMPOS(7).EQ.1) THEN
         XFROMY = .TRUE.
      ELSE 
         XFROMY = .FALSE.
      ENDIF      
      IF (NUMPOS(8).EQ.1) THEN
         NGANG = 0
      ELSEIF (NUMPOS(9).EQ.1) THEN
         NGANG = 1
      ELSEIF (NUMPOS(10).EQ.1) THEN
         NGANG = 2
      ENDIF         
      IF (NUMPOS(11).EQ.1) THEN
         SWITCH_OFF = .TRUE.
      ELSE
         SWITCH_OFF = .FALSE.
      ENDIF       
C
C Format statement 
C      
  100 FORMAT (
     + 'Options when using POLNOM to fit a line in advanced mode'
     +/
     +/'Display table of best-fit parameters'
     +/'Display table of goodness-of-fit'
     +/'Display table of residuals (and save to results file)'
     +/'Plot residuals'
     +/'Plot best-fit curve'
     +/'Plot 95% confidence limits'
     +/'Input y-values then predict x (calibration)'
c...8    +/'Input x-values then estimate y (evaluation)'
     +/'Input calibration/evaluation data from terminal then discard'
     +/'Input calibration/evaluation data from terminal then save'
     +/'Input calibration/evaluation data from file or clipboard'
c...12    +/'Provide an option to choose a new degree after fitting'     
     +/'Do not ask again this session'
     +/'Help')
      END
C
C                
















      