C
C
      SUBROUTINE POL007 (IA1, NADD1, NBEST, NB2, NB2P1, NGANG, NIN,
     +                   NOUT, NP, N7, N13,
     +                   B, P, QF, TSTAT, W1, W2, W3, XMAX, XMIN,
     +                   HAZARD,
     +                   ISTOP, YFROMX)
C
C ACTION : new version of what was originally SUB07 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          01/08/2005 deleeted MODE, NTYPE and ADVISE from argument list
C          06/04/2015 added INTENTS and introduced NGANG
C
C          Evaluate Y = F(X) and 95% confidence limits given exact X-values
C          W1 = ENEW, W2 = XNEW, W3 = YNEW
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IA1, NADD1, NBEST, NB2,
     +                                       NB2P1, NGANG, NIN, NOUT,
     +                                       NP, N7, N13
      DOUBLE PRECISION,    INTENT (IN)    :: B(N7), P(N7), QF(N13), 
     +                                       TSTAT, XMAX, XMIN
      DOUBLE PRECISION,    INTENT (INOUT) :: W1(NP), W2(NP), W3(NP)
      CHARACTER (LEN = *), INTENT (INOUT) :: HAZARD(NP)
      LOGICAL,             INTENT (IN)    :: ISTOP, YFROMX      
C
C Locals
C     
      INTEGER    I, ISEND, J, NX
      INTEGER    ICOLOR, JX, JY
      PARAMETER (ICOLOR = 3, JX = 4, JY = 4)
      INTEGER    KCOLOR
      DOUBLE PRECISION POLF07, POLFCN
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE, TEXT(30)
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 13  ) D13(4), SHOWRJ
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, YES
      EXTERNAL   SHOWRJ
      EXTERNAL   TABLE1, VEC1IN, YESNO2, GETJM1, GETVEC
      EXTERNAL   POLF07, POLFCN
      INTRINSIC  SQRT, MIN
      IF (ISTOP) RETURN
      IF (.NOT.YFROMX) RETURN
        
      IF (NGANG.LE.0) THEN
         ISEND = 0
      ELSEIF(NGANG.GE.2) THEN
         ISEND = 2
      ELSE
         ISEND = 1
      ENDIF
      
   40 CONTINUE
      IF (ISEND.EQ.0) THEN
         TITLE = 'Values input from terminal'  
         I = 0
         NX = 1
         J = MIN (NP,50)
         CALL GETJM1 (I, NX, J,
     +'Number of x-values required to calculate y (evaluation)')
         CALL GETVEC (NX,
     +                W2,
     +               'Input x-values')
         IF (NX.LT.1) THEN
            ABORT = .TRUE.
         ELSE
            ABORT = .FALSE.
         ENDIF      
      ELSE                 
         I = ISEND
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NP, NX,
     +                W2,
     +                FNAME, TITLE, ABORT, FIXNPT,
     +                LABEL)
         CLOSE (UNIT = NIN)
      ENDIF   
      IF (ABORT) GOTO 60
      KCOLOR = 15
      CALL TABLE1 (KCOLOR, 'OPEN')
      KCOLOR = 0
      DO I = 1, NX
         HAZARD(I) = ' '
         IF (W2(I).LT.XMIN .OR. W2(I).GT.XMAX) THEN
            WRITE (LINE,100) I
            CALL TABLE1 (KCOLOR, LINE)
            WRITE (NOUT,100) I
            HAZARD(I) = 'x out of range'
         ENDIF
      ENDDO
      DO I = 1, NX
         W1(I) = SQRT(POLF07(NB2, NB2P1, N13, QF, W2(I)))*TSTAT
         W3(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                  B, P, W2(I), XMAX, XMIN)
      ENDDO
      WRITE (TEXT,200)
      LINE = TEXT(2)
      KCOLOR = 4
      CALL TABLE1 (KCOLOR, LINE)
      KCOLOR = 0
      DO I = 1, NX
         D13(1) = SHOWRJ(W2(I))
         D13(2) = SHOWRJ(W3(I))
         D13(3) = SHOWRJ(W3(I) - W1(I))
         D13(4) = SHOWRJ(W3(I) + W1(I))
C         WRITE (LINE,300) W2(I), W3(I), W3(I) - W1(I),
C     +                    W3(I) + W1(I), HAZARD(I)
         WRITE (LINE,300) D13(1), D13(2), D13(3), D13(4), HAZARD(I)
         CALL TABLE1 (KCOLOR, LINE)
      ENDDO
      CALL TABLE1 (KCOLOR, 'CLOSE')
      WRITE (NOUT,400)  TITLE
      WRITE (NOUT,200)
      DO I = 1, NX
         D13(1) = SHOWRJ(W2(I))
         D13(2) = SHOWRJ(W3(I))
         D13(3) = SHOWRJ(W3(I) - W1(I))
         D13(4) = SHOWRJ(W3(I) + W1(I))
C      WRITE (NOUT,300) (W2(I), W3(I), W3(I) - W1(I),
C     +                  W3(I) + W1(I), HAZARD(I), I = 1, NX)
         WRITE (NOUT,300) D13(1), D13(2), D13(3), D13(4), HAZARD(I)
      ENDDO   

C
C LABEL 60: Here from a crash reading in data or normal termination
C =========
C
   60 CONTINUE
      WRITE (LINE,500)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, JX, JY, 
     +             LINE,
     +             YES)
      IF (YES) GOTO 40
C
C Format statements
C        
  100 FORMAT (
     +1X,'CAUTION : x-value(',I4,') outside range Xmin to Xmax')
  200 FORMAT (/8X,
     +'x-input',2X,'y-calculated    Lower95%cl    Upper95%cl')
C  300 FORMAT (1X,1P,4E14.5,2X,A18)
  300 FORMAT (1X,4(1X,A13),2X,A18)
  400 FORMAT (/1X,'Title of data'/1X,A)
  500 FORMAT ('Do you want to input another set of x-data points ?')
      END
C
C