C
C
      SUBROUTINE POL008 (IA1, NADD1, NBEST, NB2, NB2P1, NGANG, NIN,
     +                   NOUT, NP, NTPNT, N7, N13,
     +                   B, P, QF, TSQD, W1, W2, W3, W4, XDIFF, XMAX,
     +                   XMIN, YMAX, YMIN,
     +                   HAZARD,
     +                   ISTOP, XFROMY)
C
C ACTION : new version of what was originally SUB08 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          01/08/2005 deleted MODE, NTYPE and ADVISE from argument list
C          05/04/2015 improved interface for input of y and added INTENTS and NGANG
C
C          Predict X and 95% confidence limits given mean values for Y = F(X)
C          W1 = FX, W2 = XLOW, W3 = XNEW, W4 = XHIGH
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) ::    IA1, NADD1, NBEST, NB2,
     +                                       NB2P1, NGANG, NIN, NOUT,
     +                                       N7, N13, NP, NTPNT
      DOUBLE PRECISION,    INTENT (IN)    :: B(N7), P(N7), QF(N13),
     +                                       TSQD, XDIFF, XMAX, XMIN,
     +                                       YMAX, YMIN
      DOUBLE PRECISION,    INTENT (INOUT) :: W1(NP), W2(NP), W3(NP),
     +                                       W4(NP)
      CHARACTER (LEN = *), INTENT (INOUT) :: HAZARD(NP)
      LOGICAL,             INTENT (IN)    :: ISTOP, XFROMY
C
C Locals
C    
      INTEGER    NN, N4
      PARAMETER (NN = 10, N4 = 4)
      INTEGER    I, ISEND, IWARN, J, K, L, NF
      INTEGER    JCOLOR, JX, JY
      PARAMETER (JCOLOR = 7, JX = 4, JY = 4)
      INTEGER    NUMBLD(N4)
      INTEGER    KCOLOR
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION XX(NN), YY(NN)
      DOUBLE PRECISION DELTA, EPSI, X1, X2, X3, Y1, Y2
      DOUBLE PRECISION POLFCN
      DOUBLE PRECISION X02AJF$
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE1, TEXT(30)
      CHARACTER (LEN = 80  ) TITLE
      CHARACTER (LEN = 13  ) D13(4), SHOWRJ
      LOGICAL    FIXNPT, LABEL
      PARAMETER (FIXNPT = .FALSE., LABEL = .TRUE.)
      LOGICAL    ABORT, UPWARD, YES
      DATA       NUMBLD / N4*0 /
      EXTERNAL   SHOWRJ
      EXTERNAL   YESNO2, ANSWER, VEC1IN, TABLE1, GETVEC, GETJM1
      EXTERNAL   POLFCN, POL009, POL010
      EXTERNAL   X02AJF$
      INTRINSIC  ABS, MIN, MAX, DBLE
      IF (ISTOP) RETURN
      EPSI = X02AJF$()
      IF (.NOT.XFROMY) RETURN

      IF (NGANG.LE.0) THEN
         ISEND = 0
      ELSEIF (NGANG.GE.2) THEN
         ISEND = 2
      ELSE
         ISEND = 1
      ENDIF           

      DELTA = XDIFF/(DBLE(NN) - ONE)
      DO I = 1, NN
         IF (I.EQ.1) THEN
            XX(I) = XMIN
         ELSEIF (I.EQ.NN) THEN
            XX(I) = XMAX
         ELSE
            XX(I) = XX(I - 1) + DELTA
         ENDIF
         YY(I) = POLFCN(IA1, NADD1, NBEST, NOUT, N7,
     +                  B, P, XX(I), XMAX, XMIN)
      ENDDO
C
C LABEL 20: Main branch point
C =========
C
   20 CONTINUE
      UPWARD = .TRUE.
      IF (NTPNT.GT.0) THEN
         WRITE (TEXT,100) NTPNT
         YES = .TRUE.
         CALL ANSWER (JCOLOR, NUMBLD, N4,
     +                TEXT,
     +'Search upwards for smallest x-value solution ?',
     +                YES)
         IF (YES) THEN
            UPWARD = .TRUE.
         ELSE
            UPWARD = .FALSE.
         ENDIF
      ENDIF
      IF (ISEND.EQ.0) THEN
         I = 0
         NF = 1 
         J = MIN(NP,50)
         CALL GETJM1 (I, NF, J,
     +'Number of observed y-values to predict x (calibration)') 
         IF (NF.GT.0) THEN 
            ABORT = .FALSE.   
            TITLE = 'Values input from terminal'     
            CALL GETVEC (NF,
     +                   W1,
     +                   'Input y-values required')
         ELSE
            ABORT = .TRUE.
            RETURN
         ENDIF
      ELSE               
         I = ISEND
         CLOSE (UNIT = NIN)
         CALL VEC1IN (I, NIN, NP, NF, 
     +                W1,
     +                FNAME, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = NIN)
      ENDIF   
      IF (ABORT) GOTO 80
C
C Open TABLE1
C
      KCOLOR = 15
      CALL TABLE1 (KCOLOR, 'OPEN')
      KCOLOR = 0
C
C Preliminary check to see if in range
C
      DO I = 1, NF
         HAZARD(I) = ' '
         IF (W1(I).LT.YMIN .OR. W1(I).GT.YMAX) THEN
            HAZARD(I) = 'Ignore all values'
            W2(I) = ZERO
            W3(I) = ZERO
            W4(I) = ZERO
            WRITE (LINE1,200) I
            CALL TABLE1 (KCOLOR, LINE1)
            WRITE (NOUT,200) I
         ENDIF
      ENDDO
C
C Loop to calculate predicted values
C
      X3 = 0.02D+00*XDIFF
      DO I = 1, NF
         IF (W1(I).LT.YMIN .OR. W1(I).GT.YMAX) GOTO 60
         X1 = XMIN
         X2 = XMAX
         DO J = 2, NN
            IF (UPWARD) THEN
               K = J - 1
               L = K + 1
            ELSE
               K = NN - J + 1
               L = K + 1
            ENDIF
            Y1 = MIN(YY(K), YY(L))
            Y2 = MAX(YY(K), YY(L))
            IF (W1(I).GE.Y1 .AND. W1(I).LE.Y2) THEN
               X1 = MIN(XX(K), XX(L))
               X2 = MAX(XX(K), XX(L))
               GOTO 40
            ENDIF
         ENDDO
C
C LABEL 40: out of range so calculation abandoned
C =========
C
   40    CONTINUE
         CALL POL009 (IA1, IWARN, NADD1, NBEST, NOUT, N7,
     +                B, W1(I), P, XMAX, XMIN, X1, X2, X3)
         W3(I) = X1
         IF (IWARN.EQ.0) THEN
            WRITE (LINE1,300) I
            CALL TABLE1 (KCOLOR, LINE1)
            WRITE (NOUT,300) I
            HAZARD(I) = 'Ignore all values'
            W2(I) = ZERO
            W3(I) = ZERO
            W4(I) = ZERO
         ELSE
            CALL POL010 (IA1, I, NADD1, NBEST, NB2, NB2P1, NOUT, N7,
     +                   N13,
     +                   B, P, QF, TSQD, W3(I), X3, W4(I), W2(I), XMAX,
     +                   XMIN, W1(I))
            IF (W2(I).LT.XMIN .OR. W4(I).GT.XMAX) THEN
               WRITE (LINE1,400) I
               CALL TABLE1 (KCOLOR, LINE1)
               WRITE (NOUT,400) I
               HAZARD(I) = 'Limit out of range'
            ENDIF
            IF (ABS(W2(I) - W3(I)).LE.EPSI .OR.
     +          ABS(W4(I) - W3(I)).LE.EPSI) THEN
               WRITE (LINE1,500) I
               CALL TABLE1 (KCOLOR, LINE1)
               WRITE (NOUT,500) I
               HAZARD(I) = 'Ignore 95% limit'
            ENDIF
         ENDIF
C
C LABEL 60: out of range so calculation abandoned
C =========
C
   60    CONTINUE
      ENDDO
C
C Output results
C
      WRITE (TEXT,600)
      LINE1 = TEXT(2)
      KCOLOR = 4
      CALL TABLE1 (KCOLOR, LINE1)
      KCOLOR = 0
      DO I = 1, NF
         D13(1) = SHOWRJ(W1(I))
         D13(2) = SHOWRJ(W3(I))
         D13(3) = SHOWRJ(W2(I))
         D13(4) = SHOWRJ(W4(I))
C         WRITE (LINE1,700) W1(I), W3(I), W2(I), W4(I), HAZARD(I)
         WRITE (LINE1,700) D13(1), D13(2), D13(3), D13(4), HAZARD(I) 
         CALL TABLE1 (KCOLOR, LINE1)
      ENDDO
      CALL TABLE1 (KCOLOR, 'CLOSE')
      WRITE (NOUT,800)  TITLE
      WRITE (NOUT,600)
C      WRITE (NOUT,700) (W1(I), W3(I), W2(I), W4(I), HAZARD(I),
C     +                   I = 1, NF)
      DO I = 1, NF
         D13(1) = SHOWRJ(W1(I))
         D13(2) = SHOWRJ(W3(I))
         D13(3) = SHOWRJ(W2(I))
         D13(4) = SHOWRJ(W4(I))
         WRITE (NOUT,700) D13(1), D13(2), D13(3), D13(4), HAZARD(I) 
      ENDDO  
C
C LABEL 80: Another go ?
C =========
C
   80 CONTINUE
      YES = .FALSE.
      WRITE (LINE1,900)
      CALL YESNO2 (JCOLOR, JX, JY, LINE1, YES)
      IF (YES) GOTO 20
  100 FORMAT (
     +'The best-fit calibration curve has',I4,1X,'turning point(s) so'
     +/'you must decide whether to search upwards for the solution'
     +/'at the smallest x-value, or  downwards for the solution at'
     +/'the largest x-value.')
  200 FORMAT (
     +1X,'*FATAL* : y-value(',I4,') outside range Ymin to Ymax')
  300 FORMAT (
     +1X,'WARNING : Impossible to predict x at point number',I6)
  400 FORMAT (
     +1X,'WARNING : x or 95% limit(',I4,') outside range Xmin to Xmax')
  500 FORMAT (
     +1X,'WARNING : x = 95% limit at point number',I6)
  600 FORMAT (/5X,
     +'y-measured   x-predicted    Lower95%cl    Upper95%cl')
C  700 FORMAT (1X,1P,4E14.5,2X,A18)
  700 FORMAT (1X,4(1X,A13),2X,A18)
  800 FORMAT (/1X,'Title of data'/1X,A)
  900 FORMAT ('Do you want to input another set of y-data points ?')
      END
C
C