C
C
      SUBROUTINE POL009 (IA1, IWARN, NADD1, NBEST, NOUT, N7,
     +                   B, CONST, P, XMAX, XMIN, X1, X2, X3)
C
C ACTION : new version of what was originally SUB09 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          Solve  F(X) - CONST = 0.0
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (INOUT) :: IWARN
      INTEGER,          INTENT (IN)    :: IA1, NADD1, NBEST, NOUT, N7
      DOUBLE PRECISION, INTENT (IN)    :: B(N7), CONST, P(N7), XMAX,
     +                                    XMIN      
      DOUBLE PRECISION, INTENT (INOUT) :: X1, X2, X3      
C
C Locals
C      
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    IFAIL, IND, IR
      DOUBLE PRECISION C(17)
      DOUBLE PRECISION FX, F1, F2, TOLX, TSAVE
      DOUBLE PRECISION POLF09
      DOUBLE PRECISION ZERO, ONE, XTOL, X9
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, XTOL = 1.0D-04,
     +           X9 = 9.0D+00)
      EXTERNAL   POLF09
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA
      IWARN = N1
      TSAVE = ZERO
C
C LABEL 20: Branch point for finding end points to estimate zeros
C =========
C
   20 CONTINUE
      F1 = POLF09(IA1, NADD1, NBEST, NOUT, N7,
     +            B, P, X1, XMAX, XMIN, CONST)
      F2 = POLF09(IA1, NADD1, NBEST, NOUT, N7,
     +            B, P, X2, XMAX, XMIN, CONST)
      IF (F1*F2.GT.ZERO) THEN
         TSAVE = TSAVE + ONE
         X1 = X1 - (TSAVE**2)*X3
         X2 = X2 + (TSAVE**2)*X3
         IF (TSAVE.LT.X9) GOTO 20
         IWARN = N0
         RETURN
      ENDIF
      TOLX = XTOL
      IR = N2
      IND = N1
      IFAIL = N1
C
C LABEL 40: Reverse communication entry for C05AZF
C =========
C
   40 CONTINUE
      CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
      IF (IND.EQ.N0) GOTO 60
      FX = POLF09(IA1, NADD1, NBEST, NOUT, N7,
     +            B, P, X1, XMAX, XMIN, CONST)
      GOTO 40
C
C LABEL 60: Exit point for reverse communication
C =========
C
   60 CONTINUE
      IF (IFAIL.NE.N0) THEN
         CALL PUTIFA (IFAIL, NOUT, 'C05AZF/POL009')
         IWARN = N0
      ENDIF
      END
C
C