C
C
      SUBROUTINE POL010 (IA1, N, NADD1, NBEST, NB2, NB2P1, NOUT, N7,
     +                   N13,
     +                   B, P, QF, TSQD, X, XD, XH, XL, XMAX, XMIN, Y)
C
C ACTION : new version of what was originally SUB10 in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          06/04/2015 added INTENTS
C
C          95% confidence limits for predicted X given mean Y
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,           INTENT (IN) :: IA1, N, NADD1, NBEST, NB2,
     +                                  NB2P1, NOUT, N7, N13
      DOUBLE PRECISION, INTENT (IN)  :: B(N7), P(N7), QF(N13), TSQD, X,
     +                                  XD, XMAX, XMIN, Y
      DOUBLE PRECISION, INTENT (OUT) :: XH, XL
C
C Locals
C      
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, IFAIL, IND, IR
      DOUBLE PRECISION FX, F1, F2, X1, X2, TOLX, TSAVE
      DOUBLE PRECISION C(17), RESUL(2)
      DOUBLE PRECISION POLF10
      DOUBLE PRECISION ZERO, ONE, XTOL, X9
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, XTOL = 1.0D-04,
     +           X9 = 9.0D+00)
      CHARACTER (LEN = 100) LINE
      EXTERNAL   POLF10
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA, PUTWAR
      INTRINSIC  MIN, MAX
      DO I = N1, N2
         TSAVE = ONE
         X1 = X
         X2 = X
C
C LABEL 20: Adjust end points for root finding algorithm
C =========
C
   20    CONTINUE
         IF (I.EQ.N1) THEN
            X1 = X - (TSAVE**2)*XD
         ELSE
            X2 = X + (TSAVE**2)*XD
         ENDIF
         F1 = POLF10(IA1, NADD1, NBEST, NB2, NB2P1, NOUT, N7, N13,
     +               B, P, QF, TSQD, X1, XMAX, XMIN, Y)
         F2 = POLF10(IA1, NADD1, NBEST, NB2, NB2P1, NOUT, N7, N13,
     +               B, P, QF, TSQD, X2, XMAX, XMIN, Y)
         IF (F1*F2.GT.ZERO) THEN
            TSAVE = TSAVE + ONE
            IF (TSAVE.LT.X9) GOTO 20
            IF (I.EQ.N1) THEN
               WRITE (LINE,100) N
               WRITE (NOUT,100) N
            ELSE
               WRITE (LINE,200) N
               WRITE (NOUT,200) N
            ENDIF
            CALL PUTWAR (LINE)
            RESUL(I) = X
            GOTO 80
         ENDIF
         TOLX = XTOL
         IR = N2
         IND = N1
         IFAIL = N1
C
C LABEL 40: Entry point for reverse communication
C =========
C
   40    CONTINUE
         CALL C05AZF$(X1, X2, FX, TOLX, IR, C, IND, IFAIL)
         IF (IND.EQ.N0) GOTO 60
         FX = POLF10(IA1, NADD1, NBEST, NB2, NB2P1, NOUT, N7, N13,
     +               B, P, QF, TSQD, X1, XMAX, XMIN, Y)
         GOTO 40
C
C LABEL 60: Exit point for reverse communication
C =========
C
   60    CONTINUE
         RESUL(I) = X1
         IF (IFAIL.NE.N0) THEN
            CALL PUTIFA (IFAIL, NOUT, 'C05AZF/POL010')
            RESUL(I) = X
            IF (I.EQ.N1) THEN
               WRITE (LINE,100) N
               WRITE (NOUT,100) N
            ELSE
               WRITE (LINE,200) N
               WRITE (NOUT,200) N
            ENDIF
            CALL PUTWAR (LINE)
         ENDIF
C
C LABEL 80: Abnormal calculation for this value
C ========
C
   80    CONTINUE
      ENDDO
      XL = MIN(RESUL(1), RESUL(2))
      XH = MAX(RESUL(1), RESUL(2))
C
C Format statements
C      
  100 FORMAT ('No low-X  con. lim. for x(',I2,')')
  200 FORMAT ('No high-X con. lim. for x(',I2,')')
      END
C
C