C
C POLBIN
C POLBIN_SPECIES
C POLBIN_HILL_PLOT
C
      SUBROUTINE POLBIN (IFAIL, NF, NGRAF, NMAX, NPAR, NZXY,
     +                   A, PAR, W, XGRAF, XMAX, XMIN, YGRAF, 
     +                   Z, ZX, ZY)
C
C ACTION : analyse a binding polynomial of degree NPAR
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 30/9/97
C          05/02/2015 upgraded, introduced hill plot and all species fractional populations,
C                     and added ZX(NZXY) and ZY(NZXY) to supply data for a Hill plot.
C                     Also added POLBIN_SPECIES and POLBIN_HILL_PLOT AND increased size
C                     of NMAX
C          19/12/2021 added E_NUMBERS and E_FORMATS, etc.
C
C          IFAIL = 0 if OK
C          NF = output unit
C          NGRAF = plot dimension
C          NMAX = dimension >= 2*NPAR - 1
C          NPAR = no. of binding constants = degree
C          NZXY = dimesnions for ZX and ZY
C          A = workspace to hold binding polynomial
C          PAR = overall (association) binding constants
C          XGRAF = plot space
C          XMAX = upper limit for plotting on entry
C          XMIN = lower limit for plotting on entry
C          YGRAF = plot space
C          W = workspace (at least 8*NMAX)
C          Z = array of zeros  (2 by NMAX)
C          ZX(NZXY) and ZY(NZXY) data to use in Hill plot if NZXY > 2
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NF, NGRAF, NMAX, NPAR, NZXY 
      INTEGER,          INTENT (OUT)   :: IFAIL
      DOUBLE PRECISION, INTENT (IN)    :: PAR(NPAR), XMAX, XMIN
      DOUBLE PRECISION, INTENT (IN)    :: ZX(NZXY), ZY(NZXY)
      DOUBLE PRECISION, INTENT (INOUT) :: A(NMAX), XGRAF(NGRAF),
     +                                    YGRAF(NGRAF), W(8*NMAX),
     +                                    Z(2,NMAX)
     
C
C Locals
C     
      INTEGER    COLOUR, I, J, K, M, N, NBEST, NDEN, NHESS, NIN, NSPEC, 
     +           NWORST
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NUMTXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 13,
     +           NSTART = 11)
      INTEGER    NFINE
      PARAMETER (NFINE = 100)
      INTEGER    ICOUNT, L1, L2, L3, L4, M1, M2, M3, M4, N1, N2, N3, N4
      INTEGER    NUMBLD(30), NUMPOS(30)
      DOUBLE PRECISION AVHILL, BOT, HMAX, HMIN, H50, TOP, XHMAX, XHMIN,
     +                 XH50, XI, XMAX1, XMIN1, XVAL(5), X2(2), X3(2),
     +                 X4(2), YVAL(5), Y2(2), Y3(2), Y4(2)
      DOUBLE PRECISION DELTA, DN, POLVAL, X_HALF, XTEMP, YTEMP
      DOUBLE PRECISION ZERO, ONE, EPSI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPSI = 1.0D-50)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 40 ) PTITLE, XTITLE, YTITLE
      CHARACTER (LEN = 13 ) D13(4), SHOWLJ
      CHARACTER (LEN = 8  ) WORD8
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, DSPLAY, FILE, SUPPLY
      PARAMETER (DSPLAY = .TRUE., FILE = .TRUE., SUPPLY = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .TRUE.)
      LOGICAL    OK(5), REPEET
      EXTERNAL   E_FORMATS, REVPRO, SHOWLJ
      EXTERNAL   POLCAL, POLDEN, POLEQY, POLHES, LBOX01, GKS004, TABLE1,
     +           ZEROS1, POLVAL, DIVIDE, GKST04, GETIM1, POLSWP, PUTADV,
     +           GETDGT, PATCH2
      EXTERNAL   POLBIN_SPECIES, POLBIN_HILL_PLOT, RUN_TUTORIAL
      INTRINSIC  DBLE, MAX, NINT
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / 30*1 /
      DATA       ICOUNT / 0 /
C
C Check the input data then define XMAX1, XMIN1
C
      IFAIL = 0
      IF (NMAX.LT.2*NPAR - 1) THEN
         IFAIL = 1
         CALL PUTADV ('NMAX  < 2*NPAR - 1 in call to POLBIN')
         RETURN
      ENDIF
      IF (NPAR.LT.1) THEN
         IFAIL = 2
         CALL PUTADV ('NPAR < 1 in call to POLBIN')
         RETURN
      ENDIF
      DO I = 1, NPAR
         IF (PAR(I).LT.ZERO) THEN
            IFAIL = 3
            CALL PUTADV ('Negative K-values are not allowed')
            RETURN
         ENDIF
      ENDDO
      XMIN1 = MAX(EPSI,XMIN)
      XMAX1 = MAX(XMIN1 + EPSI,XMAX)
C
C Calculate the critical values
C
      E_NUMBERS = E_FORMATS()
      ICOUNT = ICOUNT + 1
      WRITE (NF,50) ICOUNT

      DO I = 1, 5
         OK(I) = .TRUE.
      ENDDO
      YVAL(1) = 0.05D+00
      YVAL(2) = 0.10D+00
      YVAL(3) = 0.50D+00
      YVAL(4) = 0.90D+00
      YVAL(5) = 0.95D+00
      WRITE (NF,100)
      DO I = 1, NPAR
         IF (E_NUMBERS) THEN
            WRITE (NF,200) I, PAR(I)
         ELSE
            D13(1) = SHOWLJ(PAR(I))
            WRITE (NF,250) I, D13(1)
         ENDIF      
      ENDDO
      DO I = 1, 5
C
C Find the zeros numerically then define X_HALF, XMAX1, and XMIN1
C        
         CALL POLEQY (IFAIL, NPAR, NF,
     +                PAR, XVAL(I), YVAL(I))
         IF (IFAIL.NE.0 .OR. XVAL(I).LT.ZERO) THEN
            OK(I) = .FALSE.
         ELSE
            IF (E_NUMBERS) THEN 
               WRITE (NF,300) YVAL(I), XVAL(I), NINT(100.0D+00*YVAL(I))  
            ELSE
               D13(1) = SHOWLJ(XVAL(I))
               WRITE (NF,350) YVAL(I), D13(1), NINT(100.0D+00*YVAL(I))                 
            ENDIF  
         ENDIF
      ENDDO
      X_HALF = XVAL(3)
      IF (OK(1)) THEN
        IF (XMIN1.GT.XVAL(1)) XMIN1 = XVAL(1)
      ENDIF
      IF (OK(5)) THEN
        IF (XMAX1.LT.XVAL(5)) XMAX1 = XVAL(5)
      ENDIF
C
C Main loop
C      
      NUMDEC = NUMOPT - 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (NZXY.GT.2) THEN
            WORD8 = 'and Data'
         ELSE
            WORD8 = '        '
         ENDIF   
         IF (E_NUMBERS) THEN   
            WRITE (TEXT,400) XMIN, XMAX, XMIN1, XMAX1, WORD8
         ELSE
            D13(1) = SHOWLJ(XMIN)
            D13(2) = SHOWLJ(XMAX)
            D13(3) = SHOWLJ(XMIN1)
            D13(4) = SHOWLJ(XMAX1)  
            WRITE (TEXT,450) TRIM(D13(1)), TRIM(D13(2)), TRIM(D13(3)), 
     +                       TRIM(D13(4)), WORD8  
         ENDIF  
         DO I = 1, 5
            IF (OK(I)) THEN
               IF (E_NUMBERS) THEN
                  WRITE (TEXT(I + 4),300) YVAL(I), XVAL(I),
     +                                    NINT(100.0D+00*YVAL(I))
               ELSE
                  D13(1) = SHOWLJ(XVAL(I))
                  WRITE (TEXT(I + 4),350) YVAL(I), TRIM(D13(1)), 
     +                                    NINT(100.0D+00*YVAL(I))
               ENDIF
            ENDIF  
         ENDDO
         NUMBLD(1) = 4
         NUMTXT = NSTART + NUMOPT + 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NUMTXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: List the binding constants
C
            CALL POLSWP (NPAR, NF,
     +                   PAR)
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: The zeros M = no. coefficients, N = degree
C
            M = NPAR + 1
            N = NPAR
            J = M
            DO I = 1, N
               J = J - 1
               A(I) = PAR(J)
            ENDDO
            A(M) = ONE
            WRITE (NF,'(A)') BLANK
            WRITE (NF,500)
            CALL ZEROS1 (M, N, NIN, NF, NMAX,
     +                   A, W, Z,
     +                   ABORT, DSPLAY, FILE, SUPPLY)
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: Zeros of H(p) Degree of Hessian = 2n - 4
C
            IF (NPAR.LE.2) THEN
               CALL PUTADV ('Hessian only has zeros for n > 2')
            ELSE
               M = NPAR + 1
               N = NPAR
               J = 0
               A(1) = ONE
               DO I = 2, M
                  J = J + 1
                  A(I) = PAR(J)
               ENDDO
               CALL POLHES (IFAIL, M,
     +                      A, W)
               M = 2*NPAR - 3
               N = 2*NPAR - 4
               J = M + 1
               DO I = 1, M
                  J = J - 1
                  A(I) = W(J)
               ENDDO
               WRITE (NF,'(A)') BLANK
               WRITE (NF,600)
               CALL ZEROS1 (M, N, NIN, NF, NMAX,
     +                      A, W, Z,
     +                      ABORT, DSPLAY, FILE, SUPPLY)
            ENDIF
         ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: Zeros of D(p) Degree of D(p) = 2n - 2
C
            M = NPAR + 1
            N = NPAR
            J = 0
            A(1) = ONE
            DO I = 2, M
               J = J + 1
               A(I) = PAR(J)
            ENDDO
            CALL POLDEN (IFAIL, M,
     +                   A, W)
            M = 2*NPAR - 1
            N = 2*NPAR - 2
            J = M + 1
            DO I = 1, M
               J = J - 1
               A(I) = W(J)
            ENDDO
            WRITE (NF,'(A)') BLANK
            WRITE (NF,'(A)') ' Zeros of D(x) (Hill slope denominator)'
            CALL ZEROS1 (M, N, NIN, NF, NMAX,
     +                   A, W, Z,
     +                   ABORT, DSPLAY, FILE, SUPPLY)
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: Hill plot slopes
C
            CALL DIVIDE (NGRAF,
     +                   XGRAF, XMIN1, XMAX1)
C
C Make sure X_HALf is present in the X-variables
C            
            XGRAF(NGRAF) = XMAX1
            LOOP_1: DO I = 2, NGRAF - 1
               IF (XGRAF(I - 1).LT.X_HALF .AND. 
     +             XGRAF(I).GT.X_HALF) THEN
                  XGRAF(I) = X_HALF 
                  EXIT LOOP_1
               ENDIF
            ENDDO LOOP_1     
C
C The binding polynomial
C
            M = NPAR + 1
            N = NPAR
            J = 0
            A(1) = ONE
            DO I = 2, M
               J = J + 1
               A(I) = PAR(J)
            ENDDO
C
C The Hessian stored in W(6*NMAX + 1)
C
            CALL POLHES (IFAIL, M,
     +                   A, W)
            NHESS = 6*NMAX + 1
            M = 2*NPAR - 3
            J = NHESS - 1
            DO I = 1, M
               J = J + 1
               W(J) = W(I)
            ENDDO
C
C The denominator stored in W(1)
C
            M = NPAR + 1
            NDEN = 1
            CALL POLDEN (IFAIL, M,
     +                   A, W)
            HMAX = - 1.0D+300
            HMIN = 1.0D+300
            J = 2*NPAR - 3
            K = 2*NPAR - 1
            NBEST = -1
            NWORST = -1
            DO I = 1, NGRAF
               XI = XGRAF(I)
               TOP = POLVAL (J, W(NHESS), XI)
               BOT = POLVAL (K, W(NDEN), XI)
               YGRAF(I) = ONE + XI*TOP/BOT
               IF (YGRAF(I).GT.HMAX) THEN
                  HMAX = YGRAF(I)
                  XHMAX = XGRAF(I)
                  NBEST = I
               ENDIF
               IF (YGRAF(I).LT.HMIN) THEN
                  HMIN = YGRAF(I)
                  XHMIN = XGRAF(I)
                  NWORST = I
               ENDIF
            ENDDO
C
C Fine search for HMAX
C            
            IF (NBEST.GT.1 .AND. NBEST.LT.NGRAF) THEN
               DELTA = (XGRAF(NBEST + 1) - XGRAF(NBEST - 1))
     +                 /DBLE(NFINE - 1)
               XTEMP = XGRAF(NBEST - 1)
               DO I = 2, NFINE - 1
                  XTEMP = XTEMP + DELTA
                  TOP = POLVAL (J, W(NHESS), XTEMP)
                  BOT = POLVAL (K, W(NDEN), XTEMP)
                  YTEMP = ONE + XTEMP*TOP/BOT
                  IF (YTEMP.GT.HMAX) THEN
                     HMAX = YTEMP
                     XHMAX = XTEMP
                  ENDIF
               ENDDO
               XGRAF(NBEST) = XHMAX
               YGRAF(NBEST) = HMAX  
            ENDIF
C
C Fine search for HMIN
C            
            IF (NWORST.GT.1 .AND. NWORST.LT.NGRAF) THEN
               DELTA = (XGRAF(NWORST + 1) - XGRAF(NWORST - 1))
     +                 /DBLE(NFINE - 1)
               XTEMP = XGRAF(NBEST - 1)
               DO I = 2, NFINE - 1
                  XTEMP = XTEMP + DELTA
                  TOP = POLVAL (J, W(NHESS), XTEMP)
                  BOT = POLVAL (K, W(NDEN), XTEMP)
                  YTEMP = ONE + XTEMP*TOP/BOT
                  IF (YTEMP.LT.HMIN) THEN
                     HMIN = YTEMP
                     XHMIN = XTEMP
                  ENDIF
               ENDDO
               XGRAF(NWORST) = XHMIN
               YGRAF(NWORST) = HMIN  
            ENDIF   
C
C Table of results
C                       
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            IF (E_NUMBERS) THEN
               WRITE (LINE,700) HMIN, XHMIN
            ELSE
               D13(1) = SHOWLJ(XHMIN)
               WRITE (LINE,750) HMIN, TRIM(D13(1))
            ENDIF      
            WRITE (NF,'(A)') BLANK
            IF (E_NUMBERS) THEN
               WRITE (NF,700) HMIN, XHMIN
            ELSE
               D13(1) = SHOWLJ(XHMIN)
               WRITE (NF,750) HMIN, TRIM(D13(1))
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
            IF (E_NUMBERS) THEN
               WRITE (LINE,800) HMAX, XHMAX
               WRITE (NF,800) HMAX, XHMAX
            ELSE
               D13(1) = SHOWLJ(XHMAX)
               WRITE (LINE,850) HMAX, TRIM(D13(1))
               WRITE (NF,850) HMAX, TRIM(D13(1)) 
            ENDIF  
            CALL TABLE1 (COLOUR, LINE)
            IF (OK(3)) THEN
               XH50 = XVAL(3)
               TOP = POLVAL (J, W(NHESS), XH50)
               BOT = POLVAL (K, W(NDEN), XH50)
               H50 = ONE + XH50*TOP/BOT
               IF (E_NUMBERS) THEN
                  WRITE (LINE,900) H50, XH50
                  WRITE (NF,900) H50, XH50
               ELSE
                  D13(1) = SHOWLJ(XH50)
                  WRITE (LINE,950) H50, TRIM(D13(1))
                  WRITE (NF,950) H50, TRIM(D13(1))
               ENDIF  
               CALL TABLE1 (COLOUR, LINE)
            ENDIF
            CALL TABLE1 (COLOUR, 'CLOSE')
            X2(1) = XGRAF(1)
            X2(2) = XGRAF(NGRAF)
            Y2(1) = ONE
            Y2(2) = ONE
            X3(1) = XHMAX
            Y3(1) = HMAX
            X4(1) = XHMIN
            Y4(1) = HMIN
            PTITLE = 'Hill plot slope s(x)'
            XTITLE = 'x'
            YTITLE = 's'
            L1 = 1
            L2 = 2
            L3 = 0
            L4 = 0
            M1 = 0
            M2 = 0
            M3 = 5
            M4 = 8
            N1 = NGRAF
            N2 = 2
            N3 = 1
            N4 = 1
            CALL GKS004 (L1, L2, L3, L4,
     +                   M1, M2, M3, M4,
     +                   N1, N2, N3, N4,
     +                   XGRAF, X2, X3, X4,
     +                   YGRAF, Y2, Y3, Y4,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: Saturation function
C
            CALL DIVIDE (NGRAF,
     +                   XGRAF, XMIN1, XMAX1)
C
C The binding polynomial
C
            M = NPAR + 1
            N = NPAR
            J = 0
            A(1) = ONE
            DO I = 2, M
               J = J + 1
               A(I) = PAR(J)
            ENDDO
C
C The Derivative in W(1)
C
            I = NPAR + 1
            J = 2
            CALL POLCAL (IFAIL, I, J, K,
     +                   A, X2, W,
     +                  'derivative')
            IF (IFAIL.EQ.0) THEN
               J = NPAR
               K = NPAR + 1
               DN = ONE/DBLE(J)
               DO I = 1, NGRAF
                  XI = XGRAF(I)
                  TOP = POLVAL (J, W, XI)
                  BOT = POLVAL (K, A, XI)
                  YGRAF(I) = DN*XI*TOP/BOT
               ENDDO
               AVHILL = ONE
               X2(1) = ONE
               X2(2) = ONE
               Y2(1) = ONE
               Y2(2) = ONE
               X3(1) = ONE
               Y3(1) = ONE
               X4(1) = ONE
               Y4(1) = ONE
               PTITLE = '(1/n)dlog(p)/dlog(x)'
               XTITLE = 'x'
               YTITLE = 'y'
               L1 = 1
               L2 = 0
               L3 = 0
               L4 = 0
               M1 = 0
               M2 = 0
               M3 = 0
               M4 = 0
               N1 = NGRAF
               N2 = 1
               N3 = 1
               N4 = 1
               CALL GKST04 (L1, L2, L3, L4,
     +                      M1, M2, M3, M4,
     +                      N1, N2, N3, N4,
     +                      AVHILL,
     +                      XGRAF, X2, X3, X4, YGRAF, Y2, Y3, Y4,
     +                      PTITLE, XTITLE, YTITLE,
     +                      SAVEIT, SAVEIT)
            ENDIF
         ELSEIF (NUMDEC.EQ.7) THEN  
C
C NUMDEC = 7: Hill plot
C         
            CALL POLBIN_HILL_PLOT (NGRAF, NPAR, NZXY,
     +                             A, PAR, W, XGRAF, XMAX1, XMIN1,
     +                             YGRAF, ZX, ZY) 
         ELSEIF (NUMDEC.EQ.8) THEN
C
C NUMDEC = 8: Species population fraction
C
            CALL DIVIDE (NGRAF,
     +                   XGRAF, XMIN1, XMAX1)
C
C The binding polynomial
C
            M = NPAR + 1
            N = NPAR
            J = 0
            A(1) = ONE
            DO I = 2, M
               J = J + 1
               A(I) = PAR(J)
            ENDDO
            I = 0
            J = NPAR
            CALL GETIM1 (I, NSPEC, J,
     +'Number of the species to be plotted')
            K = NPAR + 1
            DO I = 1, NGRAF
               XI = XGRAF(I)
               IF (NSPEC.EQ.0) THEN
                  TOP = ONE
               ELSE
                  TOP = PAR(NSPEC)*XI**NSPEC
               ENDIF
               BOT = POLVAL (K,
     +                       A, XI)
               YGRAF(I) = TOP/BOT
            ENDDO
            X2(1) = ONE
            X2(2) = ONE
            Y2(1) = ONE
            Y2(2) = ONE
            X3(1) = ONE
            Y3(1) = ONE
            X4(1) = ONE
            Y4(1) = ONE
            WRITE (PTITLE,1000) NSPEC
            XTITLE = 'x'
            YTITLE = 'Fraction'
            L1 = 1
            L2 = 0
            L3 = 0
            L4 = 0
            M1 = 0
            M2 = 0
            M3 = 0
            M4 = 0
            N1 = NGRAF
            N2 = 1
            N3 = 1
            N4 = 1
            CALL GKS004 (L1, L2, L3, L4,
     +                   M1, M2, M3, M4,
     +                   N1, N2, N3, N4,
     +                   XGRAF, X2, X3, X4, YGRAF, Y2, Y3, Y4,
     +                   PTITLE, XTITLE, YTITLE,
     +                   SAVEIT, SAVEIT)
         ELSEIF (NUMDEC.EQ.9) THEN
C
C NUMDEC = 9: Population species 
C         
            CALL POLBIN_SPECIES (NGRAF, NPAR,
     +                           A, PAR, XGRAF, XMAX1, XMIN1, YGRAF)
         ELSEIF (NUMDEC.EQ.10) THEN
C
C NUMDEC = 10: Change X_start, X_stop
C         
            IF (E_NUMBERS) THEN
               WRITE (LINE,1100) XMIN1
            ELSE
               D13(1) = SHOWLJ(XMIN1)
               WRITE (LINE,1150) TRIM(D13(1))
            ENDIF  
            CALL GETDGT (XMIN1, ZERO, LINE)
            IF (XMIN1.LT.EPSI) XMIN1 = EPSI
            IF (E_NUMBERS) THEN  
               WRITE (LINE,1200) XMAX1
            ELSE
               D13(1) = SHOWLJ(XMAX1)
               WRITE (LINE,1250) TRIM(D13(1))  
            ENDIF  
            CALL GETDGT (XMAX1, XMIN1, LINE)
         ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
C         
C NUMDEC = NUMOPT - 2: Results  
           CALL REVPRO (NF)   
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C         
            NUMTXT = 24
            NUMBLD(1) = 4
            NUMBLD(8) = 1  
            NUMBLD(14) = 1  
            NUMBLD(18) = 1  
            NUMBLD(22) = 1  
            WRITE (TEXT,1300)
            CALL PATCH2 (NUMBLD, NUMTXT,
     +                   TEXT)  
            NUMBLD(1) = 0
            NUMBLD(8) = 0  
            NUMBLD(14) = 0  
            NUMBLD(18) = 0  
            NUMBLD(22) = 0       
            CALL RUN_TUTORIAL ('cooperative_ligand_binding.pdf')      
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Exit
C         
            REPEET = .FALSE.   
         ENDIF
      ENDDO
C
C Format statements
C 
   50 FORMAT (
     +/
     +/' Cooperativity Analysis:',I3
     +/' ---------------------------'
     +/ )     
  100 FORMAT (/' Binding constants (overall association constants)')
  200 FORMAT (' K(',I2,') =',1P,E13.5)
  250 FORMAT (' K(',I2,') =',1X,A)
  300 FORMAT (' y =',0P,F7.4,' at x =',1P,E13.5,
     +'... The',I3,'% saturation point') 
  350 FORMAT (' y =',F7.4,' at x =',1X,A,
     +'... The',I3,'% saturation point')    
  400 FORMAT (' Cooperativity Analysis for y = (1/n)dlog(p(x))/dlog(x)'/
     +/' X-start (original) =',1P,E13.5,', X_stop (original) =',E13.5,
     +/' X-start (current ) =',1P,E13.5,', X_stop (current) =',E13.5,
     +/
     +/
     +/
     +/
     +/
     +/
     +/'Display binding constants and cooperativity coefficients'
     +/'Display zeros of p(x) = 1 + K(1)x + ...  + K(n)x^n'
     +/'Display zeros of H(x) = npd^2p/dx^2 - (n-1)(dp/dx)^2'
     +/'Display zeros of D(x) = dp/dx(np - xdp/dx)'
     +/'Display/Plot Min/Max Hill plot slope s(x) = 1 + xH(x)/D(x)'
     +/'Plot y = f(x) then various graphical transforms'
     +/'Plot y = f(x) then Hill Plot with asymptotes',1x,a
     +/'Plot an individual species population fraction'
     +/'Plot all possible species population fractions'
     +/'Change the range of x used for plotting'
     +/'Results'
     +/'Help: summary and tutorial'
     +/'Quit ... Exit cooperativity analysis'/
     +/'Min/Max Hill slope means inside the range X_start to X_stop')
  450 FORMAT (' Cooperativity Analysis for y = (1/n)dlog(p(x))/dlog(x)'/
     +/' X-start (original) =',1X,A,', X_stop (original) =',1X,A,
     +/' X-start (current ) =',1X,A,', X_stop (current ) =',1X,A,
     +/
     +/
     +/
     +/
     +/
     +/
     +/'Display binding constants and cooperativity coefficients'
     +/'Display zeros of p(x) = 1 + K(1)x + ...  + K(n)x^n'
     +/'Display zeros of H(x) = npd^2p/dx^2 - (n-1)(dp/dx)^2'
     +/'Display zeros of D(x) = dp/dx(np - xdp/dx)'
     +/'Display/Plot Min/Max Hill plot slope s(x) = 1 + xH(x)/D(x)'
     +/'Plot y = f(x) then various graphical transforms'
     +/'Plot y = f(x) then Hill Plot with asymptotes',1x,a
     +/'Plot an individual species population fraction'
     +/'Plot all possible species population fractions'
     +/'Change the range of x used for plotting'
     +/'Results'
     +/'Help: summary and tutorial'
     +/'Quit ... Exit cooperativity analysis'/
     +/'Min/Max Hill slope means inside the range X_start to X_stop')   
  500 FORMAT (' Zeros of the Binding Polynomial p(x)')
  600 FORMAT (' Zeros of H(x) (the Hessian of p(x))')
  700 FORMAT (
     +' Minimum Hill slope (within range) =',F8.4,' at x =',1P,E13.5)
  750 FORMAT (
     +' Minimum Hill slope (within range) =',F8.4,' at x =',1X,A)   
  800 FORMAT (
     +' Maximum Hill slope (within range) =',F8.4,' at x =',1P,E13.5)
  850 FORMAT (
     +' Maximum Hill slope (within range) =',F8.4,' at x =',1X,A)     
  900 FORMAT (
     +' y = 0.5 Hill slope (at 50% satn.) =',F8.4,' at x =',1P,E13.5)
  950 FORMAT (
     +' y = 0.5 Hill slope (at 50% satn.) =',F8.4,' at x =',1X,A)     
 1000 FORMAT ('Population Fraction for Species',I3)
 1100 FORMAT ('X-start required (Current value =',1P,E13.5,')')
 1150 FORMAT ('X-start required (Current value =',1X,A,')')
 1200 FORMAT ('X-stop required (Current value =',1P,E13.5,')')
 1250 FORMAT ('X-stop required (Current value =',1X,A,')') 
 1300 FORMAT ('Cooperativity Analysis'
     +/
     +/'Given the overall binding constants either interactively or'
     +/'from a best-fit curve to experimental data using program SFFIT,'
     +/'this control presents the options required for a cooperativity'
     +/'analysis. The most useful options are as follows.' 
     +/
     +/'1}`Display binding constants and cooperativity coefficients.'
     +/'  `This show all alternative conventions for binding constants'
     +/'  `and the intrinsic cooperativity coefficients based on the'
     +/'  `differences between adjacent Adair constants corrected for'
     +/'  `statistical factors.' 
     +/
     +/'2)`Display the Min/Max Hill plot slope s(x) = 1 + xH(x)/D(x).' 
     +/'  `This shows any changes in cooperativity along the saturation'
     +/'  `curve at zeros of the Hessian of the binding opolynomial.'
     +/
     +/'3)`Plot y = f(x) then Hill Plot with asymptotes.'
     +/'  `This creates a Hill plot for the given binding constants and'
     +/'  `the asymptotes approached at the extremities of Hill plots.'
     +/
     +/'4)`Plot all possible species population fractions.'
     +/'  `This shows how the fraction of macromolecule or receptor in'
     +/'  `various states of ligation changes as saturation proceeds.' ) 
      END
C
C------------------------------------------------------------------------------
C
      subroutine polbin_species (ngraf, npar,
     +                           a, par, xgraf, xmax, xmin, ygraf)
c
c action: plot all species population fractions
c author: w.g.bardsley, university of mqanchester, u.k., 05/02/2015
c    
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: ngraf, npar
      double precision, intent (in)    :: par(npar), xmax, xmin
      double precision, intent (inout) :: a(npar + 1), xgraf(ngraf),
     +                                    ygraf(ngraf) 
c
c allocatable
c            
      integer,                allocatable :: jfiles(:), lfiles(:),
     +                                       mfiles(:)
      double precision,       allocatable :: denom(:)
      character (len = 1024), allocatable :: files(:)
c
c locals
c       
      integer    i, ifail, ios, j, k, nfiles, nout, nspec  
      integer    n2
      parameter (n2 = 2)
      double precision polval, top, x
      double precision one
      parameter (one = 1.0d+00)
      character (len = 40) titles(4)
      logical    askif, there
      parameter (askif = .false.)
      external   deleet, divide, polval, gettmp, getnou, smplot
      if (npar.lt.1) return
c
c allocate
c        
      k = npar + 1
      ifail = 0
      allocate (jfiles(k), stat = ifail)
      if (ifail.ne.0) return
      allocate (lfiles(k), stat = ifail)
      if (ifail.ne.0) return
      allocate (mfiles(k), stat = ifail)
      if (ifail.ne.0) return
      allocate (denom(ngraf), stat = ifail)
      if (ifail.ne.0) return
      allocate (files(k), stat = ifail)  
c
c initialise and load coefficients into array a
c      
      titles(1) = 'Species Population Fractions'       
      titles(2) = 'x'
      titles(3) = 'Fractions'
      titles(4) = ' '
      do i = 1, k
         jfiles(i) = 0
         lfiles(i) = 1
         mfiles(i) = 0
      enddo 
      call divide (ngraf,
     +             xgraf, xmin,xmax) 
      k = npar + 1
      j = 0
      a(1) = one
      do i = 2, k
         j = j + 1
         a(i) = par(j)
      enddo
c      
c calculate the denominators
c
      do i = 1, ngraf
         x = xgraf(i)
         denom(i) = polval (k,
     +                      a, x)         
      enddo      
c
c now the species fractional populations
c
      nspec = -1
      nfiles = npar + 1
      do k = 1, nfiles
         nspec = nspec + 1
         do i = 1, ngraf
            x = xgraf(i)
            if (nspec.eq.0) then
                top = one
            else
                top = par(nspec)*(x**nspec)
            endif
            ygraf(i) = top/denom(i)
         enddo
         call gettmp (ifail,
     +                files(k)) 
         call getnou (nout)
         open (unit = nout, file = files(k), iostat = ios) 
         write (nout,'(a)',iostat=ios) 'Temporary file'
         write (nout,'(2i6)',iostat=ios) ngraf, n2
         do j = 1, ngraf
            write (nout,'(2e15.7)',iostat=ios) xgraf(j), ygraf(j)
         enddo
         close (unit = nout)              
      enddo  
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      k = npar + 1
      do i = 1, k
         call deleet (files(i),
     +                askif, there)
      enddo
      deallocate (jfiles,stat=ios)              
      deallocate (lfiles,stat=ios)              
      deallocate (mfiles,stat=ios)              
      deallocate (denom,stat=ios)              
      deallocate (files,stat=ios)              
      end
c
c----------------------------------------------------------------------------
c
      subroutine polbin_hill_plot (ngraf, npar, nzxy,
     +                             a, par, w, xgraf, xmax, xmin, ygraf,
     +                             zx, zy)
c
c action: Hill plot with aymptotes and also data if nzxy > 2
c author: w.g.bardsley, university of manchester, u.k., 05/02/2015
c    
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: ngraf, npar, nzxy
      double precision, intent (in)    :: par(npar), xmax, xmin
      double precision, intent (in)    :: zx(nzxy), zy(nzxy)
      double precision, intent (inout) :: a(npar + 1), w(npar + 1), 
     +                                    xgraf(ngraf), ygraf(ngraf) 
c
c locals
c 
      integer    i, icount, ifail, ios, j, jcount, k, nout, npts
      integer    jfiles(4), lfiles(4), mfiles(4), nfiles
      integer    n2
      parameter (n2 = 2)
      double precision bot, delta, dn, p, polval, top, xi, y
      double precision x2(2), y2(2)
      double precision one
      parameter (one = 1.0d+00)
      double precision  epsi, ymax, ymin
      parameter (epsi = 0.001d+00, ymax = one - epsi, ymin = epsi)
      character (len = 1024) files(4)
      character (len = 50  ) titles(4) 
      logical    askif, first, there
      parameter (askif = .false.)
      external   divide, gettmp, polcal, smplot, getnou, deleet, putadv,
     +           polval
      intrinsic  dble
      data      first /.true. /  
c
c Create xgraf 
c      
      call divide (ngraf,
     +             xgraf, xmin, xmax) 
c
c The polynomial in a
c     
      k = npar + 1
      j = 0
      a(1) = one
      do i = 2, k
         j = j + 1
         a(i) = par(j)
      enddo   
C
C The derivative in w
C
      i = npar + 1
      j = 2
      call polcal (ifail, i, j, k,
     +             a, x2, w,
     +            'derivative')
      if (ifail.eq.0) then
c
c The theoretical curve
c        
         j = npar
         k = npar + 1
         dn = one/dble(j)
         npts = 0
         do i = 1, ngraf
            xi = xgraf(i)
            top = polval (j,
     +                    w, xi)
            bot = polval (k,
     +                    a, xi)
            y = dn*xi*top/bot
            if (y.ge.ymin .and. y.le.ymax) then
               npts = npts + 1
               xgraf(npts) = xi 
               ygraf(npts) = y
            endif    
         enddo 
      else
         return    
      endif

      do i = 1, 4
         jfiles(i) = 0
         lfiles(i) = 0
         mfiles(i) = 0
         files(i) = ' '
      enddo

      nfiles = 0

      if (npts.gt.2) then
c
c Theoretical curve
c        
         nfiles = nfiles + 1
         lfiles(nfiles) = 1
         call gettmp (ifail,
     +                files(nfiles)) 
         call getnou (nout)
         open (unit = nout, file = files(nfiles), iostat=ios)
         write (nout,'(a)',iostat=ios) 'Temporary file'
         write (nout,'(2i6)',iostat=ios) npts, n2
         do i = 1, npts     
            write (nout,'(2e17.9)',iostat=ios) xgraf(i), ygraf(i)
         enddo
         close (unit = nout)
      else
         return   
      endif   
c
c Asymptote for p = par(1)/n
c      
      delta = (xmax - xmin)/dble(ngraf - 1) 
      dn = dble(npar)
      p = par(1)/dn
      xi = xmin - delta
      icount = 0
      do i = 1, ngraf
         xi = xi + delta 
         y = p*xi
         y = y/(one + y)
         if (y.ge.ymin .and. y.le.ymax) then
            icount = icount + 1
            x2(icount) = xi
            y2(icount) = y
            exit
         endif
      enddo
      xi = xmax + delta
      do i = 1, ngraf
         xi = xi - delta
         y = p*xi
         y = y/(one + y)
         if (y.ge.ymin .and. y.le.ymax) then
            icount = icount + 1
            x2(icount) = xi
            y2(icount) = y
            exit
         endif
      enddo   
                 
      if (icount.eq.2) then
         nfiles = nfiles + 1
         lfiles(nfiles) = 2
         call gettmp (ifail,
     +                files(nfiles))
         call getnou (nout)   
         open (unit = nout, file = files(nfiles), iostat = ios)
         write (nout,'(a)',iostat=ios) 'Temporary file'
         write (nout,'(2i6)',iostat=ios) n2, n2
         do i = 1, 2
            write (nout,'(2e17.9)',iostat=ios) x2(i), y2(i)
         enddo   
         close (unit = nout)
      endif   
c
c Asymptote for p = n*par(n)/par(npar - 1)
c      
      p = dn*par(npar)/par(npar - 1)
      xi = xmin - delta
      jcount = 0
      do i = 1, ngraf
         xi = xi + delta 
         y = p*xi
         y = y/(one + y)
         if (y.ge.ymin .and. y.le.ymax) then
            jcount = jcount + 1
            x2(jcount) = xi
            y2(jcount) = y
            exit
         endif
      enddo
      xi = xmax + delta
      do i = 1, ngraf
         xi = xi - delta
         y = p*xi
         y = y/(one + y)
         if (y.ge.ymin .and. y.le.ymax) then
            jcount = jcount + 1
            x2(jcount) = xi
            y2(jcount) = y
            exit
         endif
      enddo 
       
      if (jcount.eq.2) then
         nfiles = nfiles + 1
         lfiles(nfiles) = 2
         call gettmp (ifail,
     +                files(nfiles))
         call getnou (nout)   
         open (unit = nout, file = files(nfiles), iostat = ios)
         write (nout,'(a)',iostat=ios) 'Temporary file'
         write (nout,'(2i6)',iostat=ios) n2, n2
         do i = 1, n2
            write (nout,'(2e17.9)',iostat=ios) x2(i), y2(i)
         enddo   
         close (unit = nout)
      endif   
      
      titles(1) = 'Saturation Function y with Hill Asymptotes'
      titles(2) = 'x'
      titles(3) = 'y'
      titles(4) = ' '
      
      if (nzxy.gt.2) then
c
c plot data as well
c        

         npts = 0
         do i = 1, nzxy
            y = zy(i)
            if (y.ge.ymin .and. y.le.ymax) npts = npts + 1
         enddo
         if (npts.gt.2) then 
            nfiles = nfiles + 1  
            lfiles(nfiles) = 0
            mfiles(nfiles) = 5  
            call gettmp (ifail,
     +                   files(nfiles)) 
            call getnou (nout)
            open (unit = nout, file = files(nfiles), iostat = ios)
            write (nout,'(a)',iostat=ios) 'Temporary file'
            write (nout,'(2i6)',iostat=ios) npts, n2
            do i = 1, nzxy     
               y = zy(i)
               if (y.ge.ymin .and. y.le.ymax) then
                  write (nout,'(2e17.9)',iostat=ios) zx(i), zy(i)
               endif    
            enddo
            close (unit = nout)        
         endif   
      endif   

      if (first) then
         first = .false.
         call putadv (
     +'Choose Hill plot with A = 1 from the next [Transform] option')
      endif 
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             files, titles)
      do i = 1, nfiles
        call deleet (files(i),
     +               askif, there) 
      enddo
      end            
C
C
