C
C Leave the header for testing in case more functions are to be added
C
C     PROGRAM TEST
C     IMPLICIT NONE
C     INTEGER  I, IFAIL, NP, NQ, NR
C     DOUBLE PRECISION P(100), Q(100), R(100)
C     INTRINSIC DBLE
C     NP = 3
C     NQ = 3
C     DO I = 1, NP
C        P(I) = DBLE(I)
C     ENDDO
C     DO I = 1, NQ
C        Q(I) = 10.0*DBLE(I)
C     ENDDO
C*    CALL POLCAL (IFAIL, NP, NQ, NR, P, Q, R, 'add')
C*    CALL POLCAL (IFAIL, NP, NQ, NR, P, Q, R, 'differentiate')
C*    CALL POLCAL (IFAIL, NP, NQ, NR, P, Q, R, 'reverse')
C*    CALL POLCAL (IFAIL, NP, NQ, NR, P, Q, R, 'subtract')
C*    CALL POLCAL (IFAIL, NP, NQ, NR, P, Q, R, 'multiply')
C     PRINT*,'IFAIL =', IFAIL
C     DO I = 1, NR
C        PRINT*,R(I)
C     ENDDO
C     END
C
C
      SUBROUTINE POLCAL (IFAIL, NP, NQ, NR,
     +                   P, Q, R,
     +                   ACTION)
C
C ACTION : Polynomial calculations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/9/97
C          05/04/2015 added INTENTS
C
C          IFAIL = 0: OK
C          NP: Dimension of P ... input (always unchanged)
C          NQ: Dimension of Q ... input (always unchanged)
C          NR: Dimension of R ... output (not always defined)
C          P: polynomial degree NP - 1 ... input (unchanged unless overwrite)
C          Q: polynomial degree NQ - 1 ... input (always unchanged)
C          R: polynomial degree NR - 1... output (not always defined)
C          ACTION = add, differentiate, multiply, overwrite, reverse, subtract
C          P and Q are not usually changed and R almost always holds the output
C          result. For differentiation and reversal Q(NQ) are not accessed.
C          The one exception is scalar multiplication (overwrite) which replaces
C          P by Q(1) times P and does not access W. To replace R by a scalar
C          multiple of P just use multiply.
C          So the scheme is as follows:
C
C                    add: R = P + Q, NR = max(NP,NQ)
C          differentiate: R = dP/dx, NR = NP - 1 (Q is not used)
C               multiply: R = P*Q, NR = NP + NQ - 1
C              overwrite: P = Q(1)*P scalar multiplication (R is not used)
C                reverse: R = P in reverse order  (Q is not used)
C               subtract: R = P - Q, NR = max(NP,NQ)
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NP, NQ
      INTEGER,             INTENT (OUT)   :: IFAIL, NR
      DOUBLE PRECISION,    INTENT (IN)    :: Q(NQ)
      DOUBLE PRECISION,    INTENT (INOUT) :: P(NP), R(*)
      CHARACTER (LEN = *), INTENT (IN)    :: ACTION
C
C Locals
C
      
      INTEGER    I, J, K
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER (LEN = 1) WORD1
      INTRINSIC  DBLE, MAX
      WORD1 = ACTION(1:1)
      IFAIL = 0
      NR = 0
      IF (NP.LT.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (NQ.LT.1) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (WORD1.EQ.'A' .OR. WORD1.EQ.'a') THEN
         WORD1 = 'A'
      ELSEIF (WORD1.EQ.'D' .OR. WORD1.EQ.'d') THEN
         WORD1 = 'D'
      ELSEIF (WORD1.EQ.'M' .OR. WORD1.EQ.'m') THEN
         WORD1 = 'M'
      ELSEIF (WORD1.EQ.'O' .OR. WORD1.EQ.'o') THEN
         WORD1 = 'O'
      ELSEIF (WORD1.EQ.'R' .OR. WORD1.EQ.'r') THEN
         WORD1 = 'R'
      ELSEIF (WORD1.EQ.'S' .OR. WORD1.EQ.'s') THEN
         WORD1 = 'S'
      ELSE
         IFAIL = 3
         RETURN
      ENDIF
      IF (WORD1.EQ.'A') THEN
C
C Add
C
         NR = MAX(NP, NQ)
         DO I = 1, NR
            IF (I.LE.NP .AND. I.LE.NQ) THEN
               R(I) = P(I) + Q(I)
            ELSEIF (I.LE.NP) THEN
               R(I) = P(I)
            ELSE
               R(I) = Q(I)
            ENDIF
         ENDDO
      ELSEIF (WORD1.EQ.'D') THEN
C
C Differentiate
C
         NR = NP - 1
         DO I = 1, NR
            R(I) = DBLE(I)*P(I + 1)
         ENDDO
      ELSEIF (WORD1.EQ.'M') THEN
C
C Multiply
C
         NR = NP + NQ - 1
         DO I = 1, NR
            R(I) = ZERO
         ENDDO
         DO I = 1, NP
            K = I - 1
            DO J = 1, NQ
               K = K + 1
               R(K) = R(K) + P(I)*Q(J)
            ENDDO
         ENDDO
      ELSEIF (WORD1.EQ.'O') THEN
C
C Overwrite
C
         DO I = 1, NP
            P(I) = Q(1)*P(I)
         ENDDO
      ELSEIF (WORD1.EQ.'R') THEN
C
C Reverse
C
         NR = NP
         J = NP + 1
         DO I = 1, NR
            J = J - 1
            R(I) = P(J)
         ENDDO
      ELSEIF (WORD1.EQ.'S') THEN
C
C Subtract
C
         NR = MAX(NP, NQ)
         DO I = 1, NR
            IF (I.LE.NP .AND. I.LE.NQ) THEN
               R(I) = P(I) - Q(I)
            ELSEIF (I.LE.NP) THEN
               R(I) = P(I)
            ELSE
               R(I) = - Q(I)
            ENDIF
         ENDDO
      ENDIF
      END
C
C
