C
C
      SUBROUTINE POLDEN (IFAIL, N,
     +                   P, W)
C
C ACTION : Input polynomial P of degree N - 1 and return Denominator in W
C          where denominator = dp/dx(np - xdp/dx)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 29/9/97
C          N and P are unchanged
C          05/04/2015 added INTENTS  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      INTEGER,          INTENT (OUT) :: IFAIL
      DOUBLE PRECISION, INTENT (IN)  :: P(N)
      DOUBLE PRECISION, INTENT (OUT) :: W(6*N)
C
C Locals
C
      INTEGER    I, J, NP, NQ, NR, N1, N2, N3, N4, N5
      DOUBLE PRECISION TEMP(1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   POLCAL
      INTRINSIC  DBLE
C
C Blank out the workspace
C
      DO I = 1, 6*N
         W(I) = ZERO
      ENDDO      
C
C Check N
C
      IF (N.LT.2) THEN
         IFAIL = 1
         RETURN
      ELSE
         IFAIL = 0
      ENDIF
C
C Generate dP/dx in W(N1) onwards
C
      NP = N
      NQ = 1
      N1 = 1
      CALL POLCAL (IFAIL, NP, NQ, NR, P, TEMP, W(N1),
     +            'differentiate')
      IF (IFAIL.NE.0) RETURN
C
C Generate xdp/dx in W(N2) onwards
C
      N2 = N
      W(N2) = ZERO
      J = 0
      DO I = N2 + 1, N2 + N
         J = J + 1
         W(I) = W(J)
      ENDDO
      IF (IFAIL.NE.0) RETURN
C
C Put np in W(N3)
C
      N3 = 2*N
      N4 = 3*N
      J = 0
      DO I = N3, N3 + N - 1
         J = J + 1
         W(I) = P(J)
      ENDDO
      NP = N
      NQ = 1
      TEMP(1) = DBLE(N - 1)
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N3), TEMP, W(N4),
     +             'overwrite')
      IF (IFAIL.NE.0) RETURN
C
C Put np - xdp/dx in W(N4)
C
      NP = N
      NQ = N
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N3), W(N2), W(N4),
     +             'subtract')
      IF (IFAIL.NE.0) RETURN
C
C Put dp/dx(np - dp/dx) in W(N5)
C
      N5 = 4*N
      NP = N - 1
      NQ = N
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N1), W(N4), W(N5),
     +             'multiply')
      IF (IFAIL.NE.0) RETURN
C
C Shuffle the Denominator up front
C
      DO I = 1, NR
         W(I) = W(N5 + I - 1)
      ENDDO
      END
C
C
