C
C
      SUBROUTINE POLEQY (IFAIL, N, NF,
     +                   P, XVAL, YVAL)
C
C ACTION : Predict XVAL where Y = YVAL and P(N) are binding constants
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/9/97
C          05/04/2015 added INTENTS
c
C          Solves YVAL = (1/N)(XdP/dX)/P
C          XVAL set = - 1 if root cannot be located
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N, NF
      INTEGER,          INTENT (OUT) :: IFAIL
      DOUBLE PRECISION, INTENT (IN)  :: P(N), YVAL
      DOUBLE PRECISION, INTENT (OUT) :: XVAL
C
C Locals
C      
      INTEGER    I, IR, IND, J
      DOUBLE PRECISION EPSI, ZERO, ONE, VBIG
      PARAMETER (EPSI = 1.0D-04, ZERO = 0.0D+00, ONE = 1.0D+00,
     +           VBIG = 1.0D+200)
      DOUBLE PRECISION C(20)
      DOUBLE PRECISION BOT, DN, FX, FY, TOLX, TOP, XX, YY
      EXTERNAL   C05AZF$
      EXTERNAL   PUTIFA
      INTRINSIC  DBLE
C
C Check the input data
C
      IFAIL = 0
      XVAL = - ONE
      IF (N.LT.1 .OR. YVAL.LT.0.05D+00 .OR. YVAL.GT. 0.95D+00) THEN
         IFAIL = - 1
         RETURN
      ENDIF
      IF (N.EQ.1) THEN
C
C The special case n = 1
C
         TOP = YVAL
         BOT = P(1)*(ONE - YVAL)
         XVAL = TOP/BOT
      ELSE
C
C The case n > 1 ... first calculate FX
C
         DN = DBLE(N)
         XX = ZERO
         BOT = P(N)
         TOP = DN*P(N)
         J = N
         DO I = 1, N - 1
            J = J - 1
            BOT = BOT*XX + P(J)
            TOP = TOP*XX + DBLE(J)*P(J)
         ENDDO
         BOT = DN*(BOT*XX + ONE)
         TOP = TOP*XX
         FX = YVAL - TOP/BOT
         YY = ONE
C
C Now calculate FY and cycle until FX*FY < 0 or YY becomes too large
C
   20    CONTINUE
         BOT = P(N)
         TOP = DN*P(N)
         J = N
         DO I = 1, N - 1
            J = J - 1
            BOT = BOT*YY + P(J)
            TOP = TOP*YY + DBLE(J)*P(J)
         ENDDO
         BOT = DN*(BOT*YY + ONE)
         TOP = TOP*YY
         FY = YVAL - TOP/BOT
         IF (FX*FY.GT.ZERO) THEN
            YY = 1.0D+02*YY
            IF (YY.LT.VBIG) THEN
               GOTO 20
            ELSE
               IFAIL = - 2
               RETURN
            ENDIF
         ENDIF
C
C FX*FY is < 0 so find the zero
C
         TOLX = EPSI
         IR = 0
         IND = 1
         IFAIL = 1
   40    CONTINUE
         CALL C05AZF$(XX, YY, FX, TOLX, IR, C, IND, IFAIL)
         IF (IND.EQ.0) GOTO 60
         IF (IND.LT.2 .OR. IND.GT.4) THEN
            IFAIL = - 3
            RETURN
         ENDIF
         BOT = P(N)
         TOP = DN*P(N)
         J = N
         DO I = 1, N - 1
            J = J - 1
            BOT = BOT*XX + P(J)
            TOP = TOP*XX + DBLE(J)*P(J)
         ENDDO
         BOT = DN*(BOT*XX + ONE)
         TOP = TOP*XX
         FX = YVAL - TOP/BOT
         GOTO 40
   60    CONTINUE
C
C Success the root has been found
C
         XVAL = XX
         CALL PUTIFA (IFAIL, NF, 'C05AZF/POLEQY')
      ENDIF
      END
C
C
