C
C
      DOUBLE PRECISION FUNCTION POLFCN (IA1, NADD1, NBEST, NOUT, N7,
     +                                  B, P, X, XMAX, XMIN)
C
C ACTION : new version of what was originally FPOLY in POLNOM
C AUTHOR : W.G.Bardsley, University of Manchester, UK, 18/4/99
C          05/04/2015 added INTENTS
C
C          Evaluate best-fit polynomial for x in original coordinates
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: IA1, NADD1, NBEST, NOUT, N7
      DOUBLE PRECISION, INTENT (IN) :: B(N7), P(N7), X, XMAX, XMIN
C
C Locals
C      
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I, IFAIL
      DOUBLE PRECISION R
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   PUTIFA
      EXTERNAL   E02AKF$
      IF (X.GE.XMIN .AND. X.LE.XMAX) THEN
         IFAIL = N1
         CALL E02AKF$(NADD1, XMIN, XMAX, B, IA1, N7, X, R, IFAIL)
         IF (IFAIL.NE.N0) THEN
            CALL PUTIFA (IFAIL, NOUT, 'E02AKF/POLFCN')
            POLFCN = ZERO
         ELSE
            POLFCN = R
        ENDIF
      ELSE
         POLFCN = P(NADD1)
         DO I = NBEST, N1, - N1
            POLFCN = POLFCN*X + P(I)
         ENDDO
      ENDIF
      END
C
C