C
C
      SUBROUTINE POLHES (IFAIL, N,
     +                   P, W)
C
C ACTION : Input polynomial P of degree N - 1 and return Hessian in W
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 29/9/97
C          05/04/2015 added INTENTS
C
C          N and P are unchanged
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: N
      INTEGER,          INTENT (OUT) :: IFAIL
      DOUBLE PRECISION, INTENT (IN)  :: P(N)
      DOUBLE PRECISION, INTENT (OUT) :: W(8*N)
C
C Locals
C      
      INTEGER    I, NP, NQ, NR, N1, N2, N3, N5, N7
      DOUBLE PRECISION TEMP(1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   POLCAL
      INTRINSIC  DBLE
C
C Blank out the workspace
C
      DO I = 1, 8*N
         W(I) = ZERO
      ENDDO      
C
C Check N
C
      IF (N.LT.2) THEN
         IFAIL = 1
         RETURN
      ELSE
         IFAIL = 0
      ENDIF
C
C Generate dP/dx in W(N1) onwards
C
      NP = N
      NQ = 1
      N1 = 1
      CALL POLCAL (IFAIL, NP, NQ, NR, P, TEMP, W(N1),
     +            'differentiate')
      IF (IFAIL.NE.0) RETURN
C
C Generate d^2p/dx^2 in W(N2) onwards
C
      NP = NR
      NQ = 1
      N2 = N
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N1), TEMP, W(N2),
     +             'differentiate')
      IF (IFAIL.NE.0) RETURN
C
C Put pd^2p/dx^2 in W(N3)
C
      NP = N
      NQ = NR
      N3 = 2*N
      CALL POLCAL (IFAIL, NP, NQ, NR, P, W(N2), W(N3),
     +             'multiply')
      IF (IFAIL.NE.0) RETURN
C
C Multiply up by the degree N - 1
C
      NP = NR
      NQ = 1
      TEMP(1) = DBLE(N - 1)
      N7 = 6*N
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N3), TEMP, W(N7),
     +             'overwrite')
      IF (IFAIL.NE.0) RETURN
C
C Square dp/dx
C
      NP = N - 1
      NQ = N - 1
      N5 = 4*N
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N1), W(N1), W(N5),
     +             'multiply')
      IF (IFAIL.NE.0) RETURN
C
C Multiply up by the degree - 1 i.e. N - 2
C
      NP = NR
      NQ = 1
      TEMP(1) = DBLE(N - 2)
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N5), TEMP, W(N1),
     +             'overwrite')
      IF (IFAIL.NE.0) RETURN
C
C Subtract (n - 1)(dp/dx)^2 from npd^2p/dx^2
C
      NP = NR
      NQ = NR
      CALL POLCAL (IFAIL, NP, NQ, NR, W(N3), W(N5), W(N7),
     +             'subtract')
      IF (IFAIL.NE.0) RETURN
C
C Shuffle the Hessian up front
C
      DO I = 1, NR
         W(I) = W(N7 + I - 1)
      ENDDO
      END
C
C
