C
C
      SUBROUTINE POLINV (IA, N,
     +                   A, AINV)
C
C     08/10/2001 call to POLINV from POL003 replaced by call to
C                QNINV1 since F04ASF$ proved to be over accurate
C     O5/04/2015 added INTENTS
C
C************SPECIAL VERSION FOR PROGRAM POLNOM****************
C
C NOTE: It is essential to copy A into ATEMP in order to use the
C        BLAS/LAPACK version of F04ASF$ which alters A on return
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IA, N
      DOUBLE PRECISION, INTENT (INOUT) :: A(IA,N), AINV(IA,N)
C
C Locals
C      
      INTEGER    I, J, IFAIL, IF0, IF1, IF2, K, NMAX
      PARAMETER (NMAX = 20)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION B(NMAX), C(NMAX), WK1(NMAX), WK2(NMAX)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION ATEMP(NMAX,NMAX)
      CHARACTER (LEN = 100) LINE
      EXTERNAL   PUTFAT, PUTWAR
      EXTERNAL   F04ASF$
      IF0 = N0
      IF1 = N0
      IF2 = N0
      DO I = N1, N
         DO J = N1, N
            B(J) = ZERO
            C(J) = ONE
            DO K = N1, N
               ATEMP(K,J) = A(K,J)
            ENDDO
         ENDDO
         B(I) = ONE
         IFAIL = N1
         CALL F04ASF$(ATEMP, NMAX, B, N, C, WK1, WK2, IFAIL)
         IF (IFAIL.EQ.N0) THEN
            IF0 = IF0 + N1
         ELSE
            IF (IFAIL.EQ.N1) IF1 = IF1 + N1
            IF (IFAIL.EQ.N2) IF2 = IF2 + N1
         ENDIF
         DO J = N1, N
            AINV(I,J) = C(J)
         ENDDO
      ENDDO
      IF (IF1.GT.N0) THEN
         WRITE (LINE,100) IF1
         CALL PUTWAR (LINE)
      ENDIF
      IF (IF2.GT.N0) THEN
         WRITE (LINE,200) IF2
         CALL PUTWAR (LINE)
      ENDIF
      IF (IF0.LT.N) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         DO I = N1, N
            DO J = N1, N
               AINV(I,J) = ONE
            ENDDO
         ENDDO
      ENDIF
  100 FORMAT ('IFAIL = 1,',I3,1X,'times in F04ASF/POLINV')
  200 FORMAT ('IFAIL = 2,',I3,1X,'times in F04ASF/POLINV')
  300 FORMAT (
     +'Covariance matrix is rank-deficient ... Ignore standard errors')
      END
C
C