c
c
      subroutine polplt (nc, n,
     +                   c, x)   
c
c action: plot a polynomial and first three derivatives
c author: w.g.bardsley, university of manchester, u.k. 22/04/2020
c
c nc = number of coefficients 
c  c = coefficients as in f(x) = c(1) + c2(x) +...+c(n)x^(cn - 1)  
c  n = array containing the range to be plotted (minumum 2)
c  x = array containing the range to be plotted        
c
c arguments
c        
      integer,          intent (in) :: nc, n
      double precision, intent (in) :: c(nc), x(n)   
c
c locals
c      
      integer    i, j, numdec, numopt
      parameter (numopt = 5)
      integer    nd, npts 
      parameter (nd = 4, npts = 160)
      double precision pd(nd)
      double precision delta, xmax, xmin 
      double precision x1(npts)
      double precision y1(npts), y2(npts), y3(npts), y4(npts)
      character (len = 80) text(numopt)
      logical  repeet
      external pderiv, gks001, listbx, putadv
c
c check
c      
      if (nc.lt.1) then
         call putadv ('NC < 1 in call to POLPLT') 
         return
      endif 
      if (n.lt.2) then
         call putadv ('N < 2 in call to POLPLT')
         return
      endif     
c
c calculate xmax, xmin, and x1
c     
      xmin = 1.0d+300
      xmax = - xmin
      do i = 1, n
         if (x(i).lt.xmin) xmin = x(i)
         if (x(i).gt.xmax) xmax = x(i)
      enddo         
      x1(1) = xmin
      x1(npts) = xmax
      delta = (xmax - xmin)/dble(npts - 1)
      do i = 2, npts - 1
         x1(i) = x1(i - 1) + delta
      enddo
c
c calculate pd
c
      do j = 1, 4
         do i = 1, npts 
            if (j.eq.1) then 
               call pderiv (nc, nd,
     +                      c, pd, x1(i))
               y1(i) = pd(j)
            elseif (j.eq.2) then 
               call pderiv (nc, nd,
     +                      c, pd, x1(i))
               y2(i) = pd(j)  
            elseif (j.eq.3) then 
               call pderiv (nc, nd,
     +                      c, pd, x1(i))
               y3(i) = pd(j) 
            elseif (j.eq.4) then 
               call pderiv (nc, nd,
     +                      c, pd, x1(i))
               y4(i) = pd(j)    
            endif      
         enddo
      enddo   
c
c proceed to plotting
c     
      write (text,100) 
      repeet = .true.
      do while (repeet)
         numdec = numopt
         call listbx (numdec, numopt,
     +                text)         
         if (numdec.eq.1) then
            call gks001 (1, 0, npts,  
     +                   x1, y1,
     +                  'Polynomial', 'x', 'y')
         elseif (numdec.eq.2) then
            call gks001 (1, 0, npts,  
     +                   x1, y2,
     +                  'First Derivative', 'x', 'y')
         elseif (numdec.eq.3) then
            call gks001 (1, 0, npts,  
     +                   x1, y3,
     +                  'Second Derivative', 'x', 'y')
         elseif (numdec.eq.4) then
            call gks001 (1, 0, npts,  
     +                   x1, y4,
     +                  'Third Derivative', 'x', 'y')
         else
            repeet = .false. 
         endif
         
      enddo
c
c format statement
c      
  100 format (
     + 'Plot the polynomial'
     +/'Plot the first derivative'
     +/'Plot the second derivative'
     +/'Plot the third derivative'
     +/'Quit ... Exit these plotting options')
      end  
c
c                