C
C
      SUBROUTINE POLSWP (N, NF,
     +                   C)
C
C ACTION : Supply overall binding constants K(I) in C then
C          swap K into A and B and form inverses if possible
C AUTHOR : W.G.Bardsley, University of Manchester, U.K. 2/10/97
C          Derived from SWAPKS of SFFIT
C          05/04/2015 added INTENTS 
C          20/12/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N, NF
      DOUBLE PRECISION, INTENT (IN) :: C(N)
C
C Locals
C      
      INTEGER    I, COLOUR
      DOUBLE PRECISION A(100), AINV(100), B(100), BDIFF(100),
     +                 BINV(100), CINV(100)
      DOUBLE PRECISION BIGLOG, RATIO, REELI, REELN
      DOUBLE PRECISION XBIG, XMINUS, XPLUS, XSMALL
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ONE, TWO
      PARAMETER (XPLUS = 0.005D+00, XMINUS = - XPLUS, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      CHARACTER  SYMBOL(20)*1, TEXT(100)*100
      CHARACTER (LEN = 13) D13(6), SHOWLJ, SHOWRJ
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS, SHOWLJ, SHOWRJ
      EXTERNAL   TABLE1
      EXTERNAL   X02AMF$
      INTRINSIC  LOG, MAX, ABS, DBLE
      E_NUMBERS = E_FORMATS()
      COLOUR = 15
      CALL TABLE1 (COLOUR, 'OPEN')
      XSMALL = 1.0D+09*X02AMF$()
      XBIG = ONE/XSMALL
      BIGLOG = LOG(XBIG)
      REELN = DBLE(N)
      IF (C(1).GT.XBIG .OR. C(1).LT.XSMALL) GOTO 10
      CINV(1) = ONE/C(1)
      A(1) = C(1)
      AINV(1) = ONE/A(1)
      B(1) = C(1)/REELN
      IF (B(1).LT.XSMALL) GOTO 10
      BINV(1) = ONE/B(1)
      DO I = 2, N
         IF (C(I).GT.XBIG .OR. C(I).LT.XSMALL) GOTO 10
         CINV(I) = ONE/C(I)
         IF ((LOG(C(I)) - LOG(C(I - 1))).GT.BIGLOG) GOTO 10
         A(I) = C(I)*CINV(I - 1)
         IF (A(I).LT.XSMALL) GOTO 10
         AINV(I) = ONE/A(I)
         REELI = I
         B(I) = A(I)*(REELI/(REELN - REELI + ONE))
         IF (B(I).LT.XSMALL) GOTO 10
         BINV(I) = ONE/B(I)
         BDIFF(I) = B(I) - B(I - 1)
         RATIO = TWO*BDIFF(I)/MAX((ABS(B(I)) + ABS(B(I - 1))), XSMALL)
         IF (RATIO.GT.XPLUS) THEN
            SYMBOL(I) = '+'
         ELSEIF (RATIO.LT.XMINUS) THEN
            SYMBOL(I) = '-'
         ELSE
            SYMBOL(I) = '?'
         ENDIF
      ENDDO
C
C Write to the resuWWlts file formats 100, 200, 250
C      
      WRITE (NF,100)
      DO I = 1, N
         IF (E_NUMBERS) THEN
            WRITE (NF,200) I, C(I), CINV(I), A(I), AINV(I), B(I), 
     +                     BINV(I)
           ELSE
             D13(1) = SHOWRJ(C(I))
             D13(2) = SHOWRJ(CINV(I))
             D13(3) = SHOWRJ(A(I))
             D13(4) = SHOWRJ(AINV(I))
             D13(5) = SHOWRJ(B(I))
             D13(6) = SHOWRJ(BINV(I))
             WRITE (NF,250) I, D13(1), D13(2), D13(3), D13(4), 
     +                      D13(5), D13(6) 
         ENDIF  
      ENDDO
C
C Write to the display formats 100, 200, 250
C       
      WRITE (TEXT,100)
      COLOUR = 4
      DO I = 1, 5
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      COLOUR = 0
      DO I = 1, N
         IF (E_NUMBERS) THEN
            WRITE (TEXT(I),200) I, C(I), CINV(I), A(I), AINV(I), B(I),
     +                          BINV(I)
         ELSE
            D13(1) = SHOWRJ(C(I))
            D13(2) = SHOWRJ(CINV(I))
            D13(3) = SHOWRJ(A(I))
            D13(4) = SHOWRJ(AINV(I))
            D13(5) = SHOWRJ(B(I))
            D13(6) = SHOWRJ(BINV(I))
            WRITE (TEXT(I),250) I, D13(1), D13(2), D13(3), D13(4), 
     +                          D13(5), D13(6) 
         ENDIF  
      ENDDO   
      DO I = 1, N
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
C
C Return at this point if N = 1
C
      IF (N.EQ.1) THEN
         CALL TABLE1 (COLOUR, 'CLOSE')
         RETURN
      ENDIF
C
C Write to the results file formats 300, 400, 450
C      
      WRITE (NF,300)
      IF (E_NUMBERS) THEN
         DO I = 2, N
            WRITE (NF,400) I, I - 1, BDIFF(I), SYMBOL(I)
         ENDDO   
      ELSE
         DO I = 2, N
            D13(1) = SHOWLJ(BDIFF(I))
            WRITE (NF,450) I, I - 1, D13(1), SYMBOL(I)
         ENDDO 
      ENDIF  
C
C Write to the display formats 300, 400, 450
C       
      WRITE (TEXT,300)
      COLOUR = 4
      DO I = 1, 2
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      COLOUR = 0
      IF (E_NUMBERS) THEN
         DO I = 2, N
            WRITE (TEXT(I),400) I, I - 1, BDIFF(I), SYMBOL(I)
         ENDDO
      ELSE 
         DO I = 2, N
            D13(1) = SHOWlJ(BDIFF(I))
            WRITE (TEXT(I),450) I, I - 1, D13(1), SYMBOL(I)
         ENDDO
      ENDIF          
      DO I = 2, N 
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
      RETURN
   10 CONTINUE
      WRITE (NF,500)
      WRITE (TEXT,500)
      DO I = 1, 3
         CALL TABLE1 (COLOUR, TEXT(I))
      ENDDO
      CALL TABLE1 (COLOUR, 'CLOSE')
C
C Format statements
C      
  100 FORMAT (
     +/
     +/1X,'Ligand binding constants as follows:',
     +/1X,'Overall (K), Adair (A), Adair statistically corrected (B)',
     +/1X,'Number',8X,'K',11X,'1/K',13X,'A',11X,'1/A',13X,'B',11X,'1/B')
  200 FORMAT (2X,I2,1P,6(1X,E13.5))
  250 FORMAT (2X,I2,6(1X,A13))
  300 FORMAT (/1X,'Intrinsic cooperativity coefficients',3X,'Sign')
  400 FORMAT (5X,'B(',I2,') - B(',I2,') =',1P,E13.5,9X,A1)    
  450 FORMAT (5X,'B(',I2,') - B(',I2,') =',1X,A13,9X,A1)      
  500 FORMAT (
     +/1X,'WARNING : Extreme values estimated for binding constants'
     +/11X,'1/K, A, 1/A, B and/or 1/B cannot be calculated')
      END
C
C
