C
C
      DOUBLE PRECISION FUNCTION POLVAL (N,
     +                                  P, X)
C
C ACTION : Evaluate a polynomial of degree N - 1
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/9/97
C          05/04/2015 added INTENTS  
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: N
      DOUBLE PRECISION, INTENT (IN) :: P(N), X
C
C Locals
C      
      INTEGER  I
      IF (N.LE.0) THEN
C
C Set to zero if degree < 0
C
         POLVAL = 0.0D+00
      ELSEIF (N.EQ.1) THEN
C
C Polynomial is a constant
C
        POLVAL = P(N)
      ELSE
C
C Degree is > 0
C
        POLVAL = P(N)
        DO I = N - 1, 1, - 1
           POLVAL = X*POLVAL + P(I)
        ENDDO
      ENDIF
      END
C
C
