
C
C
      SUBROUTINE PROBRS (ISEND, NF, NNEG, NPOS, NRES, NRUN, NR1, NR5,
     +                   PROBR, PROBS, PROBT, RESID)
C
C ACTION   : Calculate RUN and SIGN test statistics
C NAG      : G01BDF (or else G01EEF or G01BJF if available), S15ABF
C
C If ISEND = 1 this subroutine must be called with:-
C the no. of residuals (NRES) and either the residuals (RESID) or
C any corresponding sequence of correctly signed values e.g. +/- 1
C
C If ISEND = 2 this subroutine must be called with:-
C the no. of negatives (NNEG), positives (NPOS) and runs (NRUN)
C
C In all cases this subroutine returns:-
C PROBR   = Probability of runs less than or equal to NRUN given
C           the values of NPOS and NNEG
C NR1,NR5 = 1%, 5% reference values. That is the no. of runs for
C           significance levels of .01 and .05
C PROBT   = Probability of runs less than or equal to NRUN given
C           the fixed sum of NPOS + NNEG
C PROBS   = Probability of signs less than the minimum number observed
C           in a two tailed test (either NNEG > NPOS or NNEG <= NPOS)
C
C AUTHOR    : W. G. Bardsley, University of Manchester, U.K., 18/4/89
C             24/7/89 PROBS, PROBT calculated and new series for PROBR
C             20/12/89 Option for G01BDE if G01BJE not available
C             11/12/90 Dealt with singularity in PROBT when NRUN = NTOP,
C             Removed RESNZ from argument list and other small changes
C             27/12/92 Extensive revision introducing calls to PUT???
C             5/1/93 Eliminated ZVAR, ZBOT, ZTOP, ZSTAT, ZPROD, ZSUM, ZSIG,
C             ZMU
C             10/1/93 Added NF to argument list
C             19/10/95 Replaced G01BDF by G01EEF or G01BJF for NAG mark 16
C             26/4/97 win32 version
C             Date of this version 26/4/97
C
      IMPLICIT  NONE
      INTEGER   ISEND, NF, NNEG, NPOS, NRES, NRUN, NR1, NR5
      INTEGER   I, IFAIL, K, M, N, NBOT, NTOP
      DOUBLE PRECISION PROBR, PROBS, PROBT
      DOUBLE PRECISION RESID(NRES)
      DOUBLE PRECISION FACTOR, FEVEN, FODD, PCENT1, PCENT5
      DOUBLE PRECISION A, B, P, RI, RK, RM, RN, SUM1
      DOUBLE PRECISION S15ABF$, PEQK, PGTK, PLEK
      DOUBLE PRECISION HALF, ONE, TWO, ZERO
      PARAMETER (HALF = 0.5D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ZERO = 0.0D+00)
      LOGICAL    EVEN, STOPS, STOP1, STOP5
      EXTERNAL   PUTCAU, PUTIFA, PUTFAT
      EXTERNAL   G01BJF$, S15ABF$
      INTRINSIC  MAX, MIN, NINT, SQRT, DBLE
C
C Initialise NR1, NR5, PROBR, PROBS, PROBT
C
      NR1 = - 1
      NR5 = - 1
      PROBR = - ONE
      PROBS = - ONE
      PROBT = - ONE
C
C Here if ISEND = 1 : First initialise counters then locate the first
C nonzero residual and calculate NNEG, NPOS, NRUN from the signs of RESID
C
      IF (ISEND.EQ.1) THEN
         NNEG = 0
         NPOS = 0
         NRUN = 0
         K = 0
   20    CONTINUE
         K = K + 1
         A = RESID(K)
         IF (A.LT.ZERO) THEN
            NNEG = NNEG + 1
         ELSEIF (A.GT.ZERO) THEN
            NPOS = NPOS + 1
         ELSE
            IF (K.EQ.NRES) THEN
               CALL PUTFAT ('All zeros in run/sign-test')
               RETURN
            ENDIF
            GOTO 20
         ENDIF
         NRUN = 1
         DO I = K + 1, NRES
            B = RESID(I)
            IF (B.LT.ZERO) THEN
               NNEG = NNEG + 1
            ELSEIF (B.GT.ZERO) THEN
               NPOS = NPOS + 1
            ELSE
               GOTO 40
            ENDIF
            IF (A*B.LT.ZERO) THEN
               NRUN = NRUN + 1
               A = B
            ENDIF
   40       CONTINUE
         ENDDO
      ENDIF
C
C Here if ISEND = 2 : NNEG, NPOS, NRUN must be known in advance
C
      M = MAX(NNEG, NPOS)
      N = MIN(NNEG, NPOS)
C
C First check that NRUN is not less than NBOT or GREATER than NTOP
C
      IF (N.EQ.0) THEN
         IF (M.EQ.0) THEN
            CALL PUTFAT ('All zeros in run/sign-test')
            RETURN
         ENDIF
         NBOT = 1
      ELSE
         NBOT = 2
      ENDIF
      IF (M.EQ.N) THEN
         NTOP = 2*N
      ELSE
         NTOP = 2*N + 1
      ENDIF
      IF (NRUN.LT.NBOT .OR. NRUN.GT.NTOP) THEN
         CALL PUTFAT ('Impossible runs in run/sign-test')
         RETURN
      ENDIF
C
C Check for the singular case N = 0
C
      IF (N.EQ.0) THEN
         IF (NRUN.NE.1) THEN
            CALL PUTFAT ('Impossible runs in run/sign-test')
            RETURN
         ELSE
            PROBR = ONE
            PROBS = HALF**(M - 1)
            PROBT = PROBS
            NR1 = 1
            NR5 = 1
            CALL PUTCAU ('No sign change in run/sign-test')
         ENDIF
         RETURN
      ENDIF
C
C Check for the singular case M = N = 1
C
      IF (M.EQ.1 .AND. N.EQ.1) THEN
         IF (NRUN.NE.2) THEN
            CALL PUTFAT ('Impossible runs in run/sign-test')
         ELSE
            PROBR = ONE
            PROBS = ONE
            PROBT = ONE
            NR1 = 2
            NR5 = 2
         ENDIF
         RETURN
      ENDIF

C
C Now calculate PROBT and PROBS using incomplete beta function or binomial
C
      IF (NRUN.EQ.(M + N)) THEN
         PROBT = ONE
      ELSE
         P = HALF
         I = M + N - 1
         K = NRUN - 1
         IFAIL = 1
         CALL G01BJF$(I, P, K, PLEK, PGTK, PEQK, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01BJF/PROBRS')
         PROBT = PLEK
         IF (PROBT.GT.ONE) THEN
            PROBT = ONE
         ELSEIF (PROBT.LT.ZERO) THEN
           PROBT = ZERO
         ENDIF
      ENDIF
      IF (M.EQ.N) THEN
         PROBS = ONE
      ELSE
         P = HALF
         I = M + N
         K = N
         IFAIL = 1
         CALL G01BJF$(I, P, K, PLEK, PGTK, PEQK, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'G01BJF/PROBRS')
         PROBS = PLEK
         PROBS = TWO*PROBS
         IF (PROBS.GT.ONE) THEN
            PROBS = ONE
         ELSEIF (PROBS.LT.ZERO) THEN
            PROBS = ZERO
         ENDIF
      ENDIF
C
C Method to be used depends on M and N, if both > 20 use NORMAL Approximation
C
      IF (M.LT.20 .OR. N.LT.20) THEN
C
C First work out the multiplicative factor
C
         RM = DBLE(M)
         RN = DBLE(N)
         FACTOR = ONE
         DO I = 1, N
            RI = DBLE(I)
            FACTOR = FACTOR*RI/(RI + RM)
         ENDDO
         PCENT1 = 0.01D+00/FACTOR
         PCENT5 = 0.05D+00/FACTOR
C
C Now sum the series until STOPS, STOP1 AND STOP5 are .TRUE.
C
         EVEN = .TRUE.
         STOPS = .FALSE.
         STOP1 = .FALSE.
         STOP5 = .FALSE.
         DO I = 2, NTOP
            IF (I.EQ.2) THEN
               FEVEN = TWO
               SUM1 = FEVEN
            ELSEIF (EVEN) THEN
               RI = DBLE(I)
               RK = (RI - TWO)/TWO
               FEVEN = (RM - RK)*(RN - RK)*FEVEN/(RK*RK)
               SUM1 = SUM1 + FEVEN
            ELSE
               RI = DBLE(I)
               FODD = (RM + RN - RI + ONE)*FEVEN/(RI - ONE)
               SUM1 = SUM1 + FODD
            ENDIF
            IF (I.EQ.NRUN) THEN
               PROBR = FACTOR*SUM1
               STOPS = .TRUE.
            ENDIF
            IF (.NOT.STOP1 .AND. SUM1.GE.PCENT1) THEN
               NR1 = I - 1
               STOP1 = .TRUE.
            ENDIF
            IF (.NOT.STOP5 .AND. SUM1.GE.PCENT5) THEN
               NR5 = I - 1
               STOP5 = .TRUE.
            ENDIF
            IF (STOPS .AND. STOP1 .AND. STOP5) GOTO 60
            EVEN = .NOT. EVEN
         ENDDO
   60    CONTINUE
      ELSE
C
C Enter here only if NNEG and NPOS both exceed 20 and
C calculate PROBR using the NORMAL APPROXIMATION (NAG routine S15ABF)
C Note the continuity correction factor of - 0.5 applied to ZMU
C
         P = TWO*DBLE(NNEG*NPOS)
         SUM1 = DBLE(NNEG + NPOS)
         A = HALF + P/SUM1
         B = SQRT((P*(P - SUM1))/(SUM1*SUM1*(SUM1 - ONE)))
         IFAIL = 1
         PROBR = S15ABF$((DBLE(NRUN) - A)/B, IFAIL)
         CALL PUTIFA (IFAIL, NF, 'S15ABF/PROBRS')
         NR1 = NINT(A - 2.326D+00*B)
         NR5 = NINT(A - 1.645D+00*B)
      ENDIF
      IF (PROBR.GT.ONE) THEN
         PROBR = ONE
      ELSEIF (PROBR.LT.ZERO) THEN
         PROBR = ZERO
      ENDIF
      END
C
C
