c
c
      subroutine protat (isend, ncmax, nin, nout, nrmax,
     +                   r, res, w, x, y, yhat,
     +                   fnamex, fnamey,
     +                   abort, newdat)
c
c action: procrustes rotation
c author: w.g.bardsley, university of manchester, u.k., 26/05/2005
c         02/08/2006 use newdat request new data when isend = 2
c         20/09/2006 replaced mtplot by matplt
c         07/11/2006 added intents
c         31/07/2012 removed check for NAG library and added form12
c         04/11/2014 corrected confusion over nomenclature which should be as follows
c                    A is rotated to give B-hat as best-fit to unchanged target B 
c         10/11/2021 added E_NUMBERS and E_FORMATS, etc.
c
c         isend: (input/unchanged) procedure indicator as follows:
c                 isend = 1: free standing
c                 isend = 2: data supplied as two files
c         ncmax: (input/unchanged) dimension
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) dimension
c         r, res, w, x, y, yhat: workspaces except that on
c         successful exit they contain the data
c         and current results
c         fnamey, fnamey: if isend = 1 these are workspaces
c                         if isend = 2 these must be files containing
c                                      the matrices
c         abort: (output) error indicator
c        newdat: (output) .true. only if new data requested when isend = 2
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: isend, ncmax, nin, nout,
     +                                       nrmax
      double precision,    intent (inout) :: r(nrmax,ncmax), res(nrmax),
     +                                       w(ncmax*ncmax + 7*ncmax), 
     +                                       x(nrmax,ncmax),
     +                                       y(nrmax,ncmax), 
     +                                       yhat(nrmax,ncmax)
      character (len = *), intent (inout) :: fnamex, fnamey
      logical,             intent (out)   :: abort, newdat(2)
c
c locals
c
      integer    i, ifail, icount, ios, j, ksend, m, n, ncolx, ncoly,
     +           nrowx, nrowy
      integer    lcx, lcy, lrx, lry 
      integer    iscale, itype
      integer    jsend, ntype, n1, n2, n6
      parameter (jsend = 2, ntype = 3, n1 = 1, n2 = 2, n6 = 6)
      integer    icolor, ix, iy, lshade, numdec, numopt, nstart, ntext,
     +           numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 14,
     +           nstart = 13, ntext = numopt + nstart - 1, numtxt = 21)
      integer    numbld(30), numpos(30)
      double precision alpha, rss
      double precision one
      parameter (one = 1.0d+00)
      character  line*100, text(30)*100, titlex*80, titley*80
      character  ptitle*80
      character  scale1(n2)*40, type1(n6)*40
      character  pscale*1, pscal1(n2)*1, stand*1, stand1(n6)*1
      character (len = 12) form12, colx, coly, rowx, rowy
      character (len = 13) d13(2), showlj
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    done1, done2, done3, ok, fileit, ready, repeet
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      external   e_formats, showlj
      external   putfat, mattin, revpro, lbox01, table1, putifa, dsplay,
     +           matplt, listbx, patch1, form12
      external   g03bcf$
      intrinsic  len_trim
      save       ncolx, ncoly, nrowx, nrowy
      save       titlex, titley
      save       icount, iscale, itype
      data       ncolx, ncoly, nrowx, nrowy / 0, 0, 0, 0 /
      data       titlex, titley / 'No data', 'No data' /
      data       icount, iscale, itype / 0, 1, 3 /
      data       scale1 / 'Scaling applied',
     +                    'No scaling used' /
      data       type1 / 'No translation or normalisation',
     +                   'Translation to origin (zero)',
     +                   'To origin then Y-centroid',
     +                   'Unit normalisation',
     +                   'Standardisation',
     +                   'Matching' /
      data        pscal1 / 'S', 'U' /
      data        stand1 / 'N', 'Z', 'C', 'U', 'S', 'M' /
      data        numbld / 30*0 /
      data        numpos / 30*1 /
c
c inititialise abort and newdat
c
      abort = .true.
      newdat(1) = .false.
      newdat(2) = .false.
c
c check isend
c
      if (isend.lt.1 .or. isend.gt.2) then
         abort = .true.
         write (line,100)
         call putfat (line)
         return
      else
         abort = .false.
      endif
      if (isend.eq.2) then
c
c isend = 2: attempt to open the X and Y files
c
         close (unit = nin)
         open (unit = nin, file = fnamex, iostat = ios)
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,'(a)',iostat=ios) titlex
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,*,iostat=ios) nrowx, ncolx
         if (ios.ne.0) abort = .true.
         do i = 1, nrowx
            if (.not.abort) read (nin,*,iostat=ios) (x(i,j),
     +                                               j = 1, ncolx)
            if (ios.ne.0) abort = .true.
         enddo
         close (unit = nin)
         if (abort .or. ncolx.lt.1 .or. nrowx.lt.1) then
            write (line,200) 'A'
            call putfat (line)
            return
         endif
         close (unit = nin)
         open (unit = nin, file = fnamey, iostat = ios)
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,'(a)',iostat=ios) titley
         if (ios.ne.0) abort = .true.
         if (.not.abort) read (nin,*,iostat=ios) nrowy, ncoly
         if (ios.ne.0) abort = .true.
         do i = 1, nrowy
            if (.not.abort) read (nin,*,iostat=ios) (y(i,j),
     +                                               j = 1, ncoly)
            if (ios.ne.0) abort = .true.
         enddo
         close (unit = nin)
         if (abort .or. ncoly.lt.1 .or. nrowy.lt.1) then
            write (line,200) 'B'
            call putfat (line)
            return
         endif
         if (ncolx.ne.ncoly .or. nrowx.ne.nrowy) then
            abort = .true.
            write (line,300)
            call putfat (line)
            return
         endif
      endif
c
c main loop
c
      e_numbers = e_formats()
      colx = form12(ncolx)
      coly = form12(ncoly)
      rowx = form12(nrowx)
      rowy = form12(nrowy)
      lcx = len_trim(colx)
      lcy = len_trim(coly)
      lrx = len_trim(rowx)
      lry = len_trim(rowy)
      numdec = numopt - 1
      done1 = .true.
      done2 = .true.
      done3 = .true.
      ok = .false.
      repeet = .true.
      do while (repeet)  
         write (text,400) titlex, rowx(1:lrx), colx(1:lcx),
     +                    titley, rowy(1:lry), coly(1:lcy),
     +                    type1(itype), scale1(iscale) 
         if (numdec.lt.1 .or. numdec.gt.numopt) numdec = numopt - 1
         numbld(1) = 1
         numbld(4) = 1
         numbld(8) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         numbld(8) = 0
         if (isend.eq.2) then
c
c isend = 2: prevent re-definition of fnamex and fnamey
c
            if (numdec.eq.1) then
               newdat(1) = .true.
               newdat(2) = .false.
               return
            elseif (numdec.eq.2) then
               newdat(1) = .false.
               newdat(2) = .true.
               return
            endif
         endif
c
c check if nrowx = nrowy and ncolx = ncoly and ncolx > 1 nrowx > 1
c
         if (ncolx.eq.ncoly .and. nrowx.eq.nrowy .and.
     +       ncolx.gt.1 .and. ncoly.gt.1) then
            abort = .false.
            ready = .true.
         else
            abort = .true.
            ready = .false.
         endif
         if (.not.ready) then
c
c warn user to read in data
c
            if (numdec.ge.3 .and.numdec.le.9) then
               numdec = 0
               write (line,600)
               call putfat (line)
            endif
         endif
         if (.not.ok) then
c
c warn user if not analysed
c
            if (numdec.ge.4 .and.numdec.le.9) then
               numdec = 0
               write (line,700)
               call putfat (line)
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: read in X-data
c
            j = jsend
            close (unit = nin)
            call mattin (j, ncmax, ncolx, nin, nrmax, nrowx,
     +                   x, res,
     +                   fnamex, titlex,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncolx = 0
               nrowx = 0
               ready = .false.
            endif
            colx = form12(ncolx)
            rowx = form12(nrowx)
            lcx = len_trim(colx)
            lrx = len_trim(rowx)
            ok = .false.
         elseif (numdec.eq.2) then
c
c numdec = 2: read in Y-data
c
            j = jsend
            close (unit = nin)
            call mattin (j, ncmax, ncoly, nin, nrmax, nrowy,
     +                   y, res,
     +                   fnamey, titley,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (abort) then
               ncoly = 0
               nrowy = 0
               ready = .false.
            endif
            coly = form12(ncoly)
            rowy = form12(nrowy)
            lcy = len_trim(coly)
            lry = len_trim(rowy)
            ok = .false.
         elseif (numdec.eq.3) then
c
c numdec = 3: call g03bcf after initialising X and Y
c
            close (unit = nin)
            open (unit = nin, file = fnamex)
            read (nin,'(a)') titlex
            read (nin,*) nrowx, ncolx
            do i = 1, nrowx
               read (nin,*) (x(i,j), j = 1, ncolx)
            enddo
            close (unit = nin)
            open (unit = nin, file = fnamey)
            read (nin,'(a)') titley
            read (nin,*) nrowy, ncoly
            do i = 1, nrowy
               read (nin,*) (y(i,j), j = 1, ncoly)
            enddo
            close (unit = nin)
            stand = stand1(itype)
            pscale = pscal1(iscale)
            n = nrowx
            m = ncolx
            ifail = 1
            call g03bcf$(stand, pscale, n, m, x, nrmax, y, nrmax, yhat,
     +                   r, nrmax, alpha, rss, res, w, ifail)
            if (ifail.eq.0) then
               icount = icount + 1
               abort = .false.
               if (pscale.ne.'S') alpha = one
               done1 = .false.
               done2 = .false.
               done3 = .false.
               ok = .true.
c
c write a full description for the results table
c
               if (e_numbers) then 
                  write (text,800) icount, titlex, titley,
     +                             rowx(1:lrx), colx(1:lcx),
     +                             type1(itype), scale1(iscale),
     +                             alpha, rss
               else
                  d13(1) = showlj(alpha)
                  d13(2) = showlj(rss)
                  write (text,850) icount, titlex, titley,
     +                             rowx(1:lrx), colx(1:lcx),
     +                             type1(itype), scale1(iscale),
     +                             d13(1), d13(2)
               endif  
               write (nout,'(a)') blank
               j = 15
               call table1 (j, 'OPEN')
               do i = 1, 11
                  if (i.eq.1) then
                     j = 4
                  elseif (i.eq. 3 .or. i.eq.5) then
                     j = 1
                  else
                     j = 0
                  endif
                  if (i.eq.2) then
                     call table1 (j, blank)
                  else
                     call table1 (j, text(i))
                  endif
c
c output description to results file
c
                  write (nout,'(a)') text(i)
                  if (i.eq.1) write (nout,'(a)')
     +                              ' ----------------------'
               enddo
               call table1 (j, 'CLOSE')
            else
               abort = .true.
               call putifa (ifail, nout, 'G03BCF/PROTAT')
            endif
         elseif (numdec.eq.4) then
c
c view residuals
c
             write (ptitle,900)
             i = 1
             j = 1
             if (n.le.100) then
                fileit = .true.
             else
                fileit = .false.
             endif
             if (done1) fileit = .false.
             call dsplay (i, j, nout, nrmax, n, ntype,
     +                    res,
     +                    ptitle,
     +                    fileit)
            done1 = .true.
         elseif (numdec.eq.5) then
c
c view rotation matrix
c
            write (ptitle,1000)
            if (m.le.20) then
               fileit = .true.
            else
               fileit = .false.
            endif
            if (done2) fileit = .false.
            call dsplay (ncmax, m, nout, nrmax, m, ntype,
     +                   r,
     +                   ptitle,
     +                   fileit)
            done2 = .true.
         elseif (numdec.eq.6) then
c
c view y-hat matrix
c
            write (ptitle,1100)
            if (n.le.200 .and. m.le.20) then
               fileit = .true.
            else
               fileit = .false.
            endif
            if (done3) fileit = .false.
            call dsplay (ncmax, m, nout, nrmax, n, ntype,
     +                   yhat,
     +                   ptitle,
     +                   fileit)
            done3 = .true.
         elseif (numdec.eq.7) then
c
c plot residuals
c
            ksend = 1
            call matplt (ksend, n1, n1, nout, n, n,
     +                   res)
         elseif (numdec.eq.8) then
c
c plot rotation matrix
c
            ksend = 4
            call matplt (ksend, ncmax, m, nout, nrmax, m,
     +                   r)
         elseif (numdec.eq.9) then
c
c plot yhat matrix
c
            ksend = 4
            call matplt (ksend, ncmax, m, nout, nrmax, n,
     +                   yhat)
         elseif (numdec.eq.10) then
c
c change transformation
c
            call listbx (itype, n6,
     +                   type1)
            ok = .false.
            numdec = 3
         elseif (numdec.eq.11) then
c
c change scaling
c
            call listbx (iscale, n2,
     +                   scale1)
            ok = .false.
            numdec = 3 
          elseif (numdec.eq.numopt - 2) then
c
c results
c          
            call revpro (nout)
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,1200)
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
        
         elseif (numdec.eq.numopt) then
            if (isend.eq.2) then
               newdat(1) = .false.
               newdat(2) = .false.
            endif
            repeet = .false.
         endif
      enddo      
c
c format statements
c      
  100 format ('ISEND out of range in call to PROTAT')
  200 format ('Error opening',1x,a,1x,'matrix file in PROTAT')
  300 format ('X and Y dimensions unequal in call to PROTAT')
  400 format (
     + ' Procrustes analysis options'
     +/
     +/' Title for A-data to be rotated:'
     +/1x,a
     +/' Number of A-Rows:',1x,a,', Number of A-Columns:',1x,a
     +/
     +/' Title for B-data to act as target:'
     +/1x,a
     +/' Number of B-Rows:',1x,a,', Number of B-Columns:',1x,a
     +/' Transformation:',1x,a
     +/' Scaling:',1x,a
     +/
     +/'Input: new A-matrix (for rotation)'
     +/'Input: new B-matrix (for target)'
     +/'Calculate: B-hat matrix, i.e. A transformed'
     +/'View/File/Save/Print: residuals'
     +/'View/File/Save/Print: rotation matrix'
     +/'View/File/Save/Print: B-hat matrix'
     +/'Plot: residuals'
     +/'Plot: rotation matrix'
     +/'Plot: B-hat matrix'
     +/'Change: transformation'
     +/'Change: scaling'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit Procrustes analysis')
  600 format ('A and B must have the same shape')
  700 format ('First do the calculation')
  800 format (
     + ' Procrustes results:',i3
     +/
     +/' A-data for rotation:'
     +/1x,a
     +/' B-data for target:'
     +/1x,a
     +/' Number of rows:',1x,a,', Number of columns:',1x,a
     +/' Type:',1x,a
     +/' Scaling:',1x,a
     +/' alpha =',1p,e13.5
     +/' Residual sum of squares =',e13.5)
  850 format (
     + ' Procrustes results:',i3
     +/
     +/' A-data for rotation:'
     +/1x,a
     +/' B-data for target:'
     +/1x,a
     +/' Number of rows:',1x,a,', Number of columns:',1x,a
     +/' Type:',1x,a
     +/' Scaling:',1x,a
     +/' alpha =',1x,a
     +/' Residual sum of squares =',1x,a)   
  900 format ('Residuals from Procrustes rotation')
 1000 format ('Rotation matrix from Procrustes rotation')
 1100 format ('B-hat matrix from Procrustes rotation')
 1200 format (
     + 'Procrustes analysis'
     +/
     +/'Given two matrices A and B of dimensions n by m, it is often'
     +/'useful to see how closely A can be made to fit B, using only'
     +/'distance preserving transformations, such as translation and'
     +/'rotation. For instance, A could be a matrix of loadings, and'
     +/'it might be valuable to see how close the loading matrix is'
     +/'to one from another sample. Transformations available are:'
     +/'1.`None'
     +/'2.`Translation to the origin'
     +/'3.`Translation to the origin then the B-centroid after rotation'
     +/'4.`Unit normalisation'
     +/'5.`Translation and normalisation (i.e. Standardisation)'
     +/'6.`Translation, normalisation to B-scale, then translation to'
     +/'  `the B-centroid after rotation (i.e. Matching)'
     +/
     +/'After rotation a scaling factor alpha can be estimated by least'
     +/'squares, and this can be used to dilate the coordinates of the'
     +/'transformed and rotated matrix to obtain an optimum fit. The'
     +/'resulting matrix B-hat is computed and the residuals are then'
     +/'provided to estimate goodness of fit of B-hat to B.')
      end
c
c
