c
c
      subroutine pseudi (ncol, nout, nrmax, nrow,
     +                   a,
     +                   newdat)
c
c action: pseudo inverse of a matrix
c author: w.g.bardsley, university of manchester, u.k., 09/08/2011
c         30/08/2011 increased ai(n,n) to ai(n,n + 2) to avoid troubles in BLAS 
c
      implicit none
c
c arguments
c       
      integer,          intent (in)  :: ncol, nout, nrmax, nrow
      double precision, intent (in)  :: a(nrmax,ncol)       
      logical,          intent (out) :: newdat
c
c allocatable
c       
      double precision, allocatable :: ai(:,:)
c
c locals
c      
      integer    i, ierr, j, n, nrank, numdec, numopt
      integer    icount
      integer    ntype, numtxt
      parameter (ntype = 3, numtxt = 17)
      integer    numbld(numtxt)
      double precision tol
      double precision zero
      parameter (zero = 0.0d+00)
      character  text(30)*100, title*80
      character (len = 12) form12, word12
      logical    done1, done2, fileit, repeet
      save       icount
      save       tol
      data       icount / 0 /
      data       tol / 1.0d-07 /
      data       numbld / numtxt*0 / 
      external   putfat, getdgt, listbx, dsplay, form12, pseudo, putadv,
     +           patch2, revpro
c
c intialise then check
c      
      done1 = .false.
      done2 = .false.
      newdat = .false.
      nrank = -1
      if (nrmax.lt.1    .or.
     +    ncol.lt.1     .or. 
     +    nrow.gt.nrmax) then 
         call putfat ('Dimension error in call to PSEUDI')
         return
      endif 
      if (ncol.gt.nrow) then
         call putfat ('Must have number of rows >= number of columns')
         return
      endif   
c
c allocate
c      
      ierr = 0
      if (allocated(ai)) deallocate(ai, stat = ierr)
      if (ierr.ne.0) return
      n = nrow  
      allocate (ai(n,n + 2), stat = ierr)
      if (ierr.ne.0) return
      repeet = .true.
      numdec = 3
      do while (repeet)
         write (text,100)
         numopt = 7
         call listbx (numdec, numopt,
     +                text)
         if (nrank.lt.0 .and. numdec.le.2) then
c
c calculate only if rank < 0 and options 1 or 2 are required
c
            done1 = .false.           
            do j = 1, ncol
               do i = 1, nrow
                  ai(i,j) = a(i,j)
               enddo  
            enddo   
            call pseudo (ncol, nrank, n, nrow, 
     +                   ai, tol)           
            word12 = form12(nrank)
            write (title,200) tol, word12
         endif   
         if (numdec.le.2) then 
c
c display/save
c            
            if (numdec.eq.2 .and. done1) then
               call putadv ('Already saved to results file')
               numdec = 1
            endif     
            if (numdec.eq.1) then
               fileit = .false.
            else 
               done1 = .true.    
               fileit = .true.
               if (.not.done2) then
                  icount = icount + 1
                  write (nout,300) icount
                  done2 = .true.
               endif   
            endif   
            call dsplay (n, nrow, nout, n, ncol, ntype,
     +                   ai,
     +                   title,     
     +                   fileit)
         elseif (numdec.eq.3) then 
c
c change tolerance
c         
            call getdgt (tol, zero, 'Tolerance required') 
            nrank = -1
         elseif (numdec.eq.4) then  
c
c help
c         
            write (text,400) 
            numbld(1) = 1
            call patch2 (numbld, numtxt,
     +                   text)
         elseif (numdec.eq.5) then
c
c results
c         
            call revpro (nout) 
         elseif (numdec.eq.6) then  
c
c new data
c         
            repeet = .false.
            newdat = .true.
         else
c
c cancel
c           
            repeet = .false.
         endif    
      enddo
c
c deallocate
c      
      deallocate (ai, stat = ierr)
c
c format statements
c      
  100 format (
     + 'Pseudo inverse: display only'
     +/'Pseudo inverse: display and save to results file'
     +/'Change TOL'
     +/'Help'
     +/'Results'
     +/'Data: New/Edit/Transform/View'
     +/'Quit ... Exit pseudo inverse options') 
  200 format ('Pseudo inverse with TOL =',1p,e11.3,', rank =',1x,a) 
  300 format (
     +/
     +/'Pseudo inverse and rank calculations with matrix',i4
     +/) 
  400 format ( 
     + 'The pseudo inverse and singular value decomposition'
     +/
     +/'For a matrix A with m rows and n columns the SVD is'
     +/
     +/'         A = U*Sigma*V^T'
     +/
     +/'and from this the psedo inverse P can be calculated as'
     +/
     +/'         P = V*Sigma^{-1}*U^T.'
     +/
     +/'Note that P is a n by m matrix, and this calculation'
     +/'requires that m >= n.'
     +/
     +/'The rank of A is the number of non-zero singular values, and'
     +/'this can only be calculated if a tolerance factor TOL is'
     +/'defined. This is so that, if X is the maximum singular value,'
     +/'sigma(i) values are assumed to be zero for sigma(i) < TOL*X.')
     
      end
c
c        