C
C Note: This subroutine changes NPTS to calculate the Jacobian. So the
C       maximum dimensions must be used for declaring the array sizes,
C       not NPTS. NPAR is not changed so it can be used to dimension
C       the parameters.
C
C
      SUBROUTINE QNCOV1 (FUNCT,
     +                   INDEX, ISTATE, NF, NFREE, NHESS, NMAX, NPAR,
     +                   NPTS, NX,
     +                   CORR, CV, DIAGV, ERRY, FACT, FJACC, G, HESSEX,
     +                   SIGMA, W, X, XVAL, YVAL, ZVAL,
     +                   EQUAL, FREE)
C
C NAG     : X02AMF
C ESTIMATE JACOBIAN FJACC AT THE SOLUTION POINT USING QNGRAD. THEN
C HESSIAN FROM JTRANSPOSE*J AND INVERT TO GET THE COVARIANCE MATRIX.
C THE COMPLICATED CODE INVOLVING K, ESAV1, XSAV1, YSAV1, ZSAV1
C IS REQUIRED TO FOOL FUNCT1 AND THE MODEL SO THAT EITHER
C THE GRADIENT VECTOR OR THE JACOBIAN CAN BE ESTIMATED BY QNGRAD
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 6/2/90
C ADVICE  : FUNCT   function to evaluate objective function
C           INDEX   required for permutation of free/fixed variables
C           ISTATE  state of variable free/fixed, etc.
C           NF      output unit
C           NFREE   output the no. of free variables
C           NHESS   dimension of enlarged Hessian (dimension for F01ABF)
C                   this should be at least = NX + 1
C           NMAX    maximum sample size (i.e. maximum value for NPTS)
C           NPAR    no. of current parameters
C           NPTS    no. of current data points (but set to 1 pointwise)
C           NX      maximum no. of parameters
C           CORR    correlation matrix
C           CV      covariance matrix
C           DIAGV   diagonal elements
C           ERRY    error in y
C           FACT    parameter scaling factors
C           FJACC   Jacobian for covariance matrix
C           G       gradient vector
C           HESSEX  external Hessian
C           SIGMA   WSSQ/NDOF
C           W       workspace (at least 3*NX) required by QNGRD1
C           X       parameters
C           XVAL    scaled x-data
C           YVAL    scaled y-data
C           ZVAL    scaled theory
C           EQUAL   identifies replicates in data set
C           FREE    identifies parameters as free or fixed
C
C           19/09/1997 Extensive revision for win32 version
C           18/09/1999 Added call to WAITER
C           04/02/2001 Replaced assumed size by dimensioned arrays
C           20/05/2001 Reconstituted CV on exit for PCVTST
C           16/10/2007 added INTENTS
C           13/02/2020 added NOISY to control call to TABLE1  
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NHESS, NMAX, NPAR
      INTEGER,          INTENT (IN)    :: NF, NX
      INTEGER,          INTENT (IN)    :: ISTATE(NPAR)
      INTEGER,          INTENT (INOUT) :: INDEX(NPAR), NFREE
      INTEGER,          INTENT (INOUT) :: NPTS
      DOUBLE PRECISION, INTENT (IN)    :: FACT(NPAR), SIGMA
      DOUBLE PRECISION, INTENT (INOUT) :: ERRY(NMAX), X(NPAR), 
     +                                    XVAL(NMAX), YVAL(NMAX),
     +                                    ZVAL(NMAX)
      DOUBLE PRECISION, INTENT (INOUT) :: CORR(NX,NX), CV(NHESS,NHESS),
     +                                    DIAGV(NPAR), FJACC(NMAX,NX),
     +                                    G(NPAR), HESSEX(NHESS,NHESS),
     +                                    W(3*NPAR)
      LOGICAL,          INTENT (INOUT) :: EQUAL(NMAX)
      LOGICAL,          INTENT (INOUT) :: FREE(NPAR)
C
C Locals
C      
      INTEGER    I, ICOL, IROW, J, K
      INTEGER    COLOUR
      DOUBLE PRECISION DUMMY, ESAV1, RTOL, SCALE1, SUM1, XSAV1, YSAV1,
     +                 ZSAV1
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  LINE*100, TYPE1*20
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ACTION, IWARNU, TPOINT
      LOGICAL    NOISY, NOISY1
      PARAMETER (NOISY1 = .FALSE.) 
      EXTERNAL   X02AMF$
      EXTERNAL   FUNCT
      EXTERNAL   QNGRD1, QNINV1, TABLE1, PUTFAT, WAITER
      INTRINSIC  ABS, MAX, SQRT
C
C Check NHESS
C
      IF (NHESS.LE.NX) THEN
         CALL PUTFAT ('NHESS =< NX in call to QNCOV1')
         RETURN
      ENDIF
C
C Call WAITER with ACTION = .TRUE.
C
      ACTION = .TRUE.
      CALL WAITER (ACTION)
C
C Save NPTS and first data point
C
      K = NPTS
      ESAV1 = ERRY(1)
      XSAV1 = XVAL(1)
      YSAV1 = YVAL(1)
      ZSAV1 = ZVAL(1)
C
C Pretend NPTS = 1 to work out the Jacobian
C
      NPTS = 1
      TPOINT = .FALSE.
      DO I = 1, K
         IF (EQUAL(I)) THEN
            DO J = 1, NPAR
               FJACC(I,J) = FJACC(I - 1,J)
            ENDDO
         ELSE
            ERRY(1) = ERRY(I)
            XVAL(1) = XVAL(I)
            YVAL(1) = YVAL(I)
            CALL QNGRD1 (FUNCT,
     +                   J, NPAR,
     +                   G, W, X,
     +                   TPOINT)
            DO J = 1, NPAR
               FJACC(I,J) = G(J)
            ENDDO
         ENDIF
      ENDDO
C
C Restore the first data point and NPTS
C
      NPTS = K
      ERRY(1) = ESAV1
      XVAL(1) = XSAV1
      YVAL(1) = YSAV1
      ZVAL(1) = ZSAV1
C
C Create J transpose J
C
      DO I = 1, NPAR
         DO J = 1, I
            SUM1 = ZERO
            DO K = 1, NPTS
               SUM1 = SUM1 + FJACC(K,I)*FJACC(K,J)
            ENDDO
            CORR(I,J) = TWO*SUM1
            CORR(J,I) = CORR(I,J)
         ENDDO
      ENDDO
C
C Identify free or fixed variables
C
      NFREE = 0
      DO I = 1, NPAR
         FREE(I) = .FALSE.
         IF (ISTATE(I).GT.0) THEN
             FREE(I) = .TRUE.
             NFREE = NFREE + 1
             INDEX(NFREE) = I
         ENDIF
      ENDDO
C
C Scale up to make the external projected Hessian
C
      DO I = 1, NFREE
         DO J = 1, I
            DUMMY = CORR(INDEX(I),INDEX(J))
            HESSEX(I,J) = DUMMY/(FACT(INDEX(I))*FACT(INDEX(J)))
            IF (I.NE.J) HESSEX(J,I) = HESSEX(I,J)
         ENDDO
      ENDDO
C
C Invert then scale up to get the covariance matrix
C
      CALL QNINV1 (NHESS, NFREE, NF,
     +             HESSEX, CV)
      SCALE1 = TWO*SIGMA
      DO I = 1, NFREE
         DO J = 1, I
            CV(I,J) = SCALE1*CV(I, J)
            IF (I.NE.J) CV(J,I) = CV(I,J)
         ENDDO
      ENDDO
C
C Parameter standard errors
C
      NFREE = 0
      IWARNU = .FALSE.
      NOISY = NOISY1
      DO I = 1, NPAR
         IF (FREE(I)) THEN
            NFREE = NFREE + 1
            DIAGV(I) = CV(NFREE,NFREE)
         ELSE
            DIAGV(I) = ZERO
            IF (.NOT.IWARNU) THEN
               IWARNU = .TRUE.
               IF (NOISY) THEN
                  COLOUR = 15
                  CALL TABLE1 (COLOUR, 'OPEN')
                  COLOUR = 0
               ENDIF   
            ENDIF
            IF (ISTATE(I).EQ.0) THEN
               TYPE1 = '[Fixed]'
            ELSEIF (ISTATE(I).EQ.-1) THEN
               TYPE1 = '[Upper Limit]'    
            ELSEIF (ISTATE(I).EQ.-2) THEN   
               TYPE1 = '[Lower Limit]'
            ELSE
               TYPE1 = BLANK   
            ENDIF 
            IF (NOISY) THEN  
               WRITE (LINE,100) I, TYPE1
               CALL TABLE1 (COLOUR, LINE)
            ENDIF   
            WRITE (NF,100) I, TYPE1
         ENDIF
      ENDDO
      IF (IWARNU .AND. NOISY) CALL TABLE1 (COLOUR, 'CLOSE')
C
C Return if NFREE =< 1
C
      IF (NFREE.LE.1) THEN
         ACTION = .FALSE.
         CALL WAITER (ACTION)
         RETURN
      ENDIF
C
C Create the correlation matrix
C
      RTOL = 1.0D+09*X02AMF$()
      IROW = 0
      DO I = 1, NPAR
         IF (FREE(I)) IROW = IROW + 1
         ICOL = 0
         DO J = 1, I
            IF (FREE(J)) ICOL = ICOL + 1
            IF (FREE(I) .AND. FREE(J)) THEN
               DUMMY = SQRT(ABS(CV(ICOL,ICOL)*CV(IROW,IROW)))
               CORR(I,J) = CV(IROW,ICOL)/MAX(DUMMY,RTOL)
               IF (CORR(I,J).LT.- ONE) CORR(I,J) = - ONE
               IF (CORR(I,J).GT.  ONE) CORR(I,J) =   ONE
            ELSE
               CORR(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
C
C Restore CV
C
       DO I = 1, NPAR
          DO J = 1, I
             IF (I.EQ.J) THEN
                CV(J,J) = DIAGV(J)
             ELSE
                IF (FREE(I) .AND. FREE(J)) THEN
                   CV(I,J) = CORR(I,J)*SQRT(DIAGV(I)*DIAGV(J))
                ELSE
                   CV(I,J) = ZERO
                ENDIF
                CV(J,I) = CV(I,J)
             ENDIF
          ENDDO
       ENDDO
C
C Call WAITER with ACTION = .FALSE.
C
      ACTION = .FALSE.
      CALL WAITER (ACTION)
C
C Format statement
C      
  100 FORMAT (
     +'Ignore Std. Err. for Parameter(internal index =',I4,')',1X,A)
      END
C
C
