c
c-----------------------------------------------------------------
c The SIMFIT Interfaces to lbfgs-B
c
c In addition to several independent calls, e.g. for maximum likelihood
c minimisation (Fitting Weibull for censored data), or orthogonal
c regression, the main interfaces to setulb (= lbfgsb) are as follows:
c
c QNFIT0: completely silent version
c QNFIT1: output only if bad fitting results
c QNFIT2: includes a winio control to monitor progress
c QNFIT3: inludes an interface to list01 to control random fitting
c-----------------------------------------------------------------
c
c
      subroutine qnfit0 (deriv, funct, ifail, iw, liw, lw1, lw2, n, nbd,
     +                   nf, npts,
     +                   bl, bu, f, g, w1, w2, x,
     +                   type1, type2)
c
c action : call setulb for minimisation
c author : w.g.bardsley, university of manchester, u.k., 09/09/1997
c          13/10/1997 Added wssq1, wssq2, pcent, time, numfev to w1 output
c          14/01/1998 Revised but this version does not provide the user
c                     the chance to interrupt
c          09/11/1998 reduced dimension required for lw1 and value of m
c          18/09/1999 added call to waiter
c          05/12/1999 increased dimension required for lw1
c          29/12/1999 removed all analysis of results and call to waiter
c          10/01/2000 introduced link to list01 via common block so that
c                     fitting can be interrupted with ifail = 2.
c          25/01/2000 introduced call to qnfree
c          05/02/2001 restored to original purpose as a silent front end
c          19/1//2009 added intents
c
c advice : this is a replacement for e04jaf in the simfit quasi newton
c          programs
c dimensions :
c          note: liw >= 3*n
c                lw1 >= 2*(2*m*n + 4*n + 11*m*m + 8*m)
c                lw2 >= 3*n
c arguments : deriv = subroutine to calculate function g (may need w2)
c             funct = subroutine to calculate gradient f
c             iw    = integer workspace
c             liw   = size of iw
c             lw1   = size of w1
c             lw2   = size of w2
c             n     = size of bl, bu, g, x
c             nbd   = type of bounds (0 = unbounded, 1 = only lower,
c                     2 = both, 3 = only upper)
c             nf    = output unit
c             npts  = no. of data points
c             bl    = lower bounds
c             bu    = upper bounds
c             g     = gradient
c             w1    = double precision workspace for optimiser
c             w2    = double precision workspace for gradient
c             x     = variables
c             type1 = 'exact' or 'approximate' derivatives
c             type2 = 'low', 'medium', 'high' precision
c
c extra parameters : m = no. corrections in limited memory matrix 3=< m =< 20
c                    iprint = frequency and type of output < 0 => no output
c                    factr = tolerance 1.d+7 for moderate accuracy
c                    pgtol = tolerance on projected gradient
c
      implicit         none
c
c arguments
c      
      integer,             intent (in)    :: liw, lw1, lw2, n, nf, npts
      integer,             intent (inout) :: ifail
      integer,             intent (in)    :: nbd(n)
      integer,             intent (inout) :: iw(liw)
      double precision,    intent (in)    :: bl(n), bu(n) 
      double precision,    intent (inout) :: f, g(n), w1(lw1), w2(lw2),
     +                                       x(n)
      character (len = *), intent (in)    :: type1, type2
c
c locals
c      
      integer          i, m, mtry, iprint, isave(44)
      parameter       (m = 10, iprint = - 1)
      integer          maxfev, numfev
      integer          kfree
      parameter       (kfree = 500)
      integer          isend, jfree(kfree), nfree
      double precision factr, pgtol, dsave(29)
      double precision clock2, time, t1, t2, wssq1, wssq2
      double precision zero, one, ftol
      parameter       (zero = 0.0d+00, one = 1.0d+00, ftol = 1.0d-10)
      double precision blfree(kfree), bufree(kfree), gfree(kfree),
     +                 xfree(kfree)
      character        csave*60, task*60
      logical          align1
      logical          lsave(4)
      logical          fixed, free(kfree)
      external         clock2, putfat
      external         deriv, funct, setulb, qnfree
      intrinsic        abs, dble
c
c Set the default output parameters in case of premature return
c
      do i = 1, 5
         w1(i) = zero
      enddo
c
c Check the input parameters before fitting
c
      ifail = 0
      if (n.lt.1) then
         ifail = - 1
         return
      endif
      i = 3*n
      if (liw.lt.i) then
         ifail = - 2
         return
      endif
      i = 2*(2*m*n + 4*n + 11*m*m + 8*m)
      if (lw1.lt.i) then
         call putfat ('Dimension lw1 to small in call to qnfit')
         ifail = - 3
         return
      endif
      i = 3*n
      if (lw2.lt.i) then
         ifail = - 4
         return
      endif
      do i = 1, n
         if (bl(i).gt.bu(i)) then
            ifail = - 5
            return
         endif
      enddo
      do i = 1, n
         if (x(i).lt.bl(i) .or. x(i).gt.bu(i)) then
            ifail = - 6
            return
         endif
      enddo
      do i = 1, n
         if (nbd(i).lt.0 .or. nbd(i).gt.3) then
            ifail = - 7
            return
         endif
      enddo
c
c Use arguments to stop ftn95 complaining ... they may be needed in future
c
      if (type1.eq.'exact') then
         i = nf
         i = npts
      endif
c
c Calculate wssq1
c
      call funct (n, x, wssq1)
c
c We start the iteration by initializing task.
c
      task = 'START'
c
c Now we decide on the precision ... low, medium or high
c
      if (type2(1:1).eq.'l' .or. type2(1:1).eq.'L') then
         mtry = m - 4
         factr = 1.0d+10
         pgtol = 1.0d-5
      elseif (type2(1:1).eq.'h' .or. type2(1:1).eq.'H') then
         mtry = m
         factr = 1.0d+1
         pgtol = 1.0d-7
      else
         mtry = m - 2
         factr = 1.0d+5
         pgtol = 1.0d-6
      endif
c
c ------- the beginning of the loop ----------
c

      ifail = 0
      maxfev = 200*(n + 1)
      numfev = 0
      time = zero
      align1 = .true.
      t1 = clock2 (align1)
      align1 = .false.
c
c call qnfree with isend = 0 then re-set isend to isend = 1
c
      isend = 0
      call qnfree (isend, jfree, nfree, n,
     +             bl, blfree, bu, bufree, x, xfree,
     +             fixed, free)
      isend = 1
  20  continue
c
c This is the call to the L-BFGS-B code.
c
      if (fixed) then
         call setulb (nfree, mtry, xfree, blfree, bufree, nbd, f, gfree,
     +                factr, pgtol, w1, iw, task, iprint, csave, lsave,
     +                isave, dsave)
         call qnfree (isend, jfree, nfree, n, bl, blfree, bu, bufree,
     +                x, xfree, fixed, free)
      else
         call setulb (n, mtry, x, bl, bu, nbd, f, g, factr, pgtol, w1,
     +                iw, task, iprint, csave, lsave, isave, dsave)
      endif
c
c Increment the number of iterations
c
      numfev = numfev + 1
c
c Check numfev and see if fitting has been interupted, i.e. nopen = 0
c
      if (numfev.eq.maxfev) then
         t2 = clock2 (align1)
         time = time + t2 - t1
         ifail = 2
         goto 40
      endif
      if (task(1:2) .eq. 'FG') then
c
c the minimization routine has returned to request the
c function f and gradient g values at the current x.
c
         call funct (n,
     +               x, f)
         call deriv (funct,
     +               n,
     +               g, w2, x,
     +               free)
c
c re-assign the derivatives if not all parameters are free
c
         if (fixed) then
            do i = 1, nfree
               gfree(i) = g(jfree(i))
            enddo
         endif
c
c go back to the minimization routine.
c
         goto 20
      endif
c
c
      if (task(1:5) .eq. 'NEW_X')  then
c
c the minimization routine has returned with a new iterate,
c

         if (numfev.lt.2 .or. dsave(13).gt.ftol*(one + abs(f))) then
            goto 20
         else
            task =
     +     'CONVERGENCE: projected gradient < 1.d-10*(1 + abs(f))'
         endif
      endif
c           ---------- the end of the loop -------------
c
c If task is neither FG nor NEW_X we terminate execution.
c
   40 continue
      if (ifail.ne.2) then
         t2 = clock2 (align1)
         time = time + t2 - t1
      endif
      if (ifail.eq.2) then
         ifail = 2!to silence ftn95
      elseif (task(1:4) .eq. 'CONV' .or.
     +        task .eq. 'ABNORMAL_TERMINATION_IN_LNSRCH') then
         ifail = 0
      else
         ifail = 1
      endif
      call funct (n, x, wssq2)
c
c Store results in workspace w1
c
      w1(1) = wssq1
      w1(2) = wssq2
      w1(3) = 100.0d+00*(wssq1 - wssq2)/(wssq1 + ftol)
      w1(4) = time
      w1(5) = dble(numfev)
      end
c
c
