c
c-----------------------------------------------------------------
c The SIMFIT Interfaces to lbfgs-B
c
c In addition to several independent calls, e.g. for maximum likelihood
c minimisation (Fitting Weibull for censored data), or orthogonal
c regression, the main interfaces to setulb (= lbfgsb) are as follows:
c
c QNFIT0: completely silent version
c QNFIT1: output only if bad fitting results
c QNFIT2: includes a winio@ control to monitor progress
c QNFIT3: inludes an interface to list01 to control random fitting
c-----------------------------------------------------------------
c
c FILE: QNFIT2 
c ============
c
c       This is the front end to LBFGSB which is called by QNFIT and nDEQSOL
c
c Note: This code uses clearwin+ to wrap a window round the call to
c       LBFGSB (setulb) in order to display the results of optimisation
c       in real time. To get a completely silent version up and running,
c       then the call to QNFIT2 can be replaced by a call to QNFIT0.
c       To get a silent version running but which also includes diagnostics,
c       you can replace the call to QNFIT2 by a call to QNFIT1.
c
c =========================================================================
c This version complains if errors are encountered or a bad fit results.
c It also gives intermediate output during the optimisation using a window
c created by salford-software ftn95/clearwin+ so it is NOT PORTABLE to any
c other compilers as it stands. It is only called by QNFIT and DEQSOL.
c =========================================================================
c
      subroutine qnfit2 (deriv, funct, ifail, iw, liw, lw1, lw2, n, nbd,
     +                   nf, npts,
     +                   bl, bu, f, g, w1, w2, x,
     +                   type1, type2)
c
c action : call setulb for minimisation
c author : w.g.bardsley, university of manchester, u.k., 9/9/97
c          13/10/1997 Added wssq1, wssq2, pcent, time, numfev to w1 output
c          12/02/1998 Reorganised and added window and temporary_yield@ to
c                     provide intermediate output during optimisation
c                     For some reason this change prevents mmfit/hlfit/
c                     sffit/csafit/eoqsol, etc. from using cauchy in lbfgs
c                     The problem can be resolved by three steps
c                     (i) compiling qnfit2 using /fullcheck
c                    (ii) compiling cauchy with /fullcheck
c                   (iii) not outputting dsave if it is too small. The first
c                         exit gives dsave(13) = 1.620e-198 and this causes
c                         an invalid floating point operation.
c                         conclusion: at present this is an unresolved problem
c                         but it is probably a compiler error, .e.g. failing
c                         to write dsave(13) when it is valid number????????
c.......................  special comment added 18/06/2000
c.......................  NO. dsave(13) is only defined when task = 'NEW_X'
c.......................  and setulb/formk has been edited to prevent these
c.......................  problems from recurring
c          26/10/1998 changed iprint to 10 and changed output unit in
c                     mainlb to 6 not 8 so all output directed to w_simfit.err. I still
c                     do not understand the errors but all variables are now initialised
c                     in mainlb whatever the value of iprint
c          09/11/1998 reduced dimension of lw1 for new version of setulb
c          05/12/1999 increased dimension of w1
c                     and re-set value for m
c                     It seems that all the trouble may have been caused by the
c                     salford compiler not handling array dimensions properly
c          10/01/2000 moved from w_simfit.dll to w_menus.dll and
c                     renamed call back, etc. to qnfit2 not qnfit1
c          25/01/2000 introduced call to qnfree and %cc
c          18/06/2000 altered use of dsave(13) and defined all locals
c                     before use. Also extensive SAVE used.
c          07/03/2002 set iprint = 0 to avoid error 410 A function called
c                     from within I/O has itself performed I/O. It appears that the
c                     salflibc.dll including file_find@ faults when lbfgsb wites the
c                     iteration details to file while the winio@ window is open.
c          19/07/2007 moved the output control to lbfgsb in w_menus.dll which 
c                     calls w_lbfgsb in w_clearwin.dll
c          19/11/2009 added intents
c
c advice : this is a replacement for e04jaf in the simfit quasi newton
c          programs
c dimensions :
c          note: liw >= 3*n
c                lw1 >= 2*(2*m*n + 4*n + 11*m*m + 8*m)
c                lw2 >= 3*n
c arguments : deriv = subroutine to calculate function g (may need w2)
c             funct = subroutine to calculate gradient f
c             iw    = integer workspace
c             liw   = size of iw
c             lw1   = size of w1
c             lw2   = size of w2
c             n     = size of bl, bu, g, x
c             nbd   = type of bounds (0 = unbounded, 1 = only lower,
c                     2 = both, 3 = only upper)
c             nf    = output unit
c             npts  = no. of data points
c             bl    = lower bounds
c             bu    = upper bounds
c             g     = gradient
c             w1    = double precision workspace for optimiser
c             w2    = double precision workspace for gradient
c             x     = variables
c             type1 = 'exact' or 'approximate' derivatives
c             type2 = 'low', 'medium', 'high' precision
c
c extra parameters : m = no. corrections in limited memory matrix 3=< m =< 20
c                    iprint = frequency and type of output < 0 => no output
c                    factr = tolerance 1.d+7 for moderate accuracy
c                    pgtol = tolerance on projected gradient
c

      implicit         none
c
c Variables in the argument list.......................................
c

      integer,          intent (in)    :: liw, lw1, lw2, n, nf, npts
      integer,          intent (inout) :: ifail
      integer,          intent (in)    :: nbd(n)
      integer,          intent (inout) :: iw(liw)
      double precision, intent (in)    :: bl(n), bu(n)
      double precision, intent (inout) :: f, g(n), w1(lw1), w2(lw2),
     +                                    x(n)
      character (len = *), intent (in) :: type1, type2

c
c Local parameters.....................................................
c

      integer          icolor, ix, iy, lshade, numtxt
      parameter       (icolor = 9, ix = 4, iy = 4, lshade = 1,
     +                 numtxt = 20)
      integer          iprint, m, mtry
      parameter       (iprint = 10, m = 10)
      integer          kfree
      parameter       (kfree = 500)
      double precision zero, one, f2, f10, f100, ftol, tvalue
      parameter       (zero = 0.0d+00, one = 1.0d+00, f2 = 2.0d+00,
     +                 f10 = 10.0d+00, f100 = 100.0d+00, ftol = 1.0d-10,
     +                 tvalue = 0.05d+00)
      character        blank*1, minfit*32, nofit*32
      parameter       (blank = ' ',
     +                 minfit = 'Only a small reduction in WSSQ',
     +                 nofit = 'No appreciable reduction in WSSQ')
      logical          border
      parameter       (border = .false.)


c
c Local scalars and arrays..............................................
c

      integer          numbld(numtxt)
      integer          i, isave(44)
      integer          maxfev, numfev, numgrd
      integer          isend, jfree(kfree), nfree
      double precision factr, dsave(29), pgtol
      double precision clock2, pcent, time, t1, t2, wssq1, wssq2
      double precision blfree(kfree), bufree(kfree), gfree(kfree),
     +                 xfree(kfree)
      character        info(7)*12
      character        csave*60, word8*8, resul*32, task*60,
     +                 text(numtxt)*80
      logical          align1
      logical          lsave(4), yes
      logical          stop_qnfit2
      logical          fixed, free(kfree)

c
c externals and intrinsics.............................................
c

      external         yesno2, patch1, lcase1, triml1, clock2, 
     +                 putfat, tyield
      external         deriv, funct, setulb, qnfree, lbfgsb
      external         sleep1
      intrinsic        abs, dble

c
c save.......................................................
c

      
      save             isave, csave, dsave, lsave, task
      
c
c Initialise workspaces
c
      do i = 1, n
         g(i) = zero
      enddo
      do i = 1, lw1
         w1(i) = zero
      enddo
      do i = 1, lw2
         w2(i) = zero
      enddo
      do i = 1, liw
         iw(i) = 0
      enddo
c
c Check the input parameters to make sure they are consistent with m = 15
c
      ifail = 0
      if (n.lt.1) then
         ifail = - 1
         return
      endif
      i = 3*n
      if (liw.lt.i) then
         ifail = - 2
         return
      endif
      i = 2*(2*m*n + 4*n + 11*m*m + 8*m)
      if (lw1.lt.i) then
         call putfat ('Dimension lw1 too small in call to qnfit2')
         ifail = - 3
         return
      endif
      i = 3*n
      if (lw2.lt.i) then
         ifail = - 4
         return
      endif
      do i = 1, n
         if (bl(i).gt.bu(i)) then
            ifail = - 5
            return
         endif
      enddo
      do i = 1, n
         if (x(i).lt.bl(i) .or. x(i).gt.bu(i)) then
            ifail = - 6
            return
         endif
      enddo
      do i = 1, n
         if (nbd(i).lt.0 .or. nbd(i).gt.3) then
            ifail = - 7
            return
         endif
      enddo
c
c Initialise local workspaces
c
       do i = 1, 44
          isave(i) = 0
       enddo
       do i = 1, 29
          dsave(i) = zero
       enddo
       do i = 1, 4
          lsave(i) = .true.
       enddo
       csave = blank
       task = blank
c
c Calculate wssq1
c
      call funct (n, x, wssq1)
      f = wssq1
c
c Now we decide on the precision ... low, medium or high
c
      if (type2(1:1).eq.'l' .or. type2(1:1).eq.'L') then
         mtry = m - 4
         factr = 1.0d+10
         pgtol = 1.0d-5
      elseif (type2(1:1).eq.'h' .or. type2(1:1).eq.'H') then
         mtry = m
         factr = 1.0d+1
         pgtol = 1.0d-7
      else
         mtry = m - 2
         factr = 1.0d+5
         pgtol = 1.0d-6
      endif
c
c---------------------------------------------
c ------- the beginning of the loop ----------
c---------------------------------------------
c

c
c We start the iteration by initializing task, maxfev, time, etc.
c
      task = 'START'
      maxfev = 200*(n + 1)
      time = zero
      align1 = .true.
      stop_qnfit2 = .false.
c
c see if all variables are free then re-set isend to isend = 1
c
      isend = 0
      call qnfree (isend, jfree, nfree, n, 
     +             bl, blfree, bu, bufree, x, xfree,
     +             fixed, free)
      isend = 1
c
c***********************************************************************
c label 20 ... winio@ code to open the waiting window
c***********************************************************************
c
   20 continue
      ifail = 0
      numfev = 0
      numgrd = 0
      write (info(1),'(2x,1p,e10.3)') wssq1
      write (info(2),'(2x,1p,e10.3)') wssq1
      write (info(3),'(2x,1p,e10.3)') time
      info(4) = '  unassigned'
      write (info(5),'(i12)') numfev
      write (info(6),'(i12)') numgrd
      info(7) = '  unfinished'
      isend = 0
      stop_qnfit2 = .false.
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2)

c
c**********************************************************************
c label 40: The main loop repeats from here
c**********************************************************************
c
      t1 = clock2 (align1)
  40  continue
c
c This is the call to the L-BFGS-B code.
c
      call tyield
      if (fixed) then
         call setulb (nfree, mtry, xfree, blfree, bufree, nbd, f, gfree,
     +                factr, pgtol, w1, iw, task, iprint, csave, lsave,
     +                isave, dsave)
         isend = 1
         call qnfree (isend, jfree, nfree, n, bl, blfree, bu, bufree,
     +                x, xfree, fixed, free)
      else
         call setulb (n, mtry, x, bl, bu, nbd, f, g, factr, pgtol,
     +                w1, iw, task, iprint, csave, lsave, isave, dsave)
      endif
      call tyield
c
c Upgrade the function value displayed
c
      write (info(2),'(2x,1p,e10.3)') f
      isend = 2
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2)
c
c Check and upgrade the time used
c
      t2 = clock2 (align1)
      time = time + t2 - t1
      t1 = clock2 (align1)
      write (info(3),'(2x,1p,e10.3)') time
      isend = 3
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2)      
c
c Check the number of function evaluations
c
      numfev = numfev + 1
      write (info(5),'(i12)') numfev
      isend = 5
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2) 
      if (numfev.eq.maxfev) then
         isend = 8
         call lbfgsb (isend,
     +                info,
     +                stop_qnfit2)
         yes = .false.
         call yesno2 (icolor, ix, iy,
     +'Maximum iterations used ... re-enter with current parameters ?',
     + yes)
         if (yes) then
            time = zero
            stop_qnfit2 = .false.
            goto 20
         else
            ifail = 2
            task = 'optimisation terminated by user intervention'
            stop_qnfit2 = .true.
            goto 60
         endif
      endif

c
c Has the user requested to stop ?
c 
      isend = 10
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2)
      if (stop_qnfit2) then
         if (task(1:4) .eq. 'CONV') then
            ifail = 0
            continue
         else
            ifail = 3
            task = 'optimisation terminated by user intervention'
         endif
         goto 60
      endif

      if (task(1:2) .eq. 'FG') then
c
c the minimization routine has returned to request the
c function f and gradient g values at the current x.
c
         call funct (n, x, f)
         call deriv (funct, n, g, w2, x, free)
c
c re-assign derivatives if some variables are fixed
c
         if (fixed) then
            do i = 1, nfree
               gfree(i) = g(jfree(i))
            enddo
         endif
         numgrd = numgrd + 1
         write (info(6),'(i12)') numgrd
         isend = 6
         call lbfgsb (isend,
     +                info,
     +                stop_qnfit2)
c
c go back to the minimization routine.
c
         goto 40
      endif

      if (task(1:5) .eq. 'NEW_X') then
c
c the minimization routine has returned for a new iterate,
c check and upgrade the proj. grad. and make decision about next action
c
         write (info(4),'(2x,1p,e10.3)') dsave(13)
         isend = 4
         call lbfgsb (isend,
     +                info,
     +                stop_qnfit2)
         if (numfev.lt.2 .or. dsave(13).gt.ftol*(one + abs(f))) then
            goto 40
         else
            ifail = 0
            task =
     +     'CONVERGENCE: projected gradient < 1.d-10*(1 + abs(f))'
            
            info(7) = '  completed '
            isend = 7
            call lbfgsb (isend,
     +                   info,
     +                   stop_qnfit2)
            isend = 9
            call lbfgsb (isend,
     +                   info,
     +                   stop_qnfit2)
            stop_qnfit2 = .false.
            isend = 11 
            call lbfgsb (isend,
     +                   info,
     +                   stop_qnfit2)
            goto 60
         endif
      endif
c
c
c           ---------- the end of the loop -------------

c
c If task is neither FG nor NEW_X we terminate execution.
c
      info(7) = '  completed '
      isend = 7
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2) 
      isend = 9
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2) 
   60 continue
      isend = 10
      call lbfgsb (isend,
     +             info,
     +             stop_qnfit2) 
      if (stop_qnfit2) then
         isend = 8
         call lbfgsb (isend,
     +                info,
     +                stop_qnfit2)         
      else
         call tyield
         call sleep1 (tvalue)
         goto 60
      endif
c
c Assign ifail
c
      if (ifail.eq.2 .or. ifail.eq.3) then
         i = ifail!to silence ftn95
      elseif (task(1:4) .eq. 'CONV' .or.
     +        task .eq. 'ABNORMAL_TERMINATION_IN_LNSRCH') then
         ifail = 0
      else
         ifail = 1
      endif
c
c calculate the % reduction in wssq
c
      call funct (n, x, wssq2)
      pcent = f100*(wssq1 - wssq2)/(wssq1 + ftol)
c
c put out a warning if there seems to be some trouble
c
      if (pcent.lt.f10 .or. ifail.ne.0) then
         do i = 1, numtxt
            numbld(i) = 0
         enddo
         if (pcent.lt.f2) then
            resul = nofit
         elseif (pcent.lt.f10) then
            resul = minfit
         else
            resul = blank
         endif
         if (pcent.lt.f10) numbld(15) = 1
         numbld(20) = 1
         write (word8,'(I8)') numfev
         call triml1 (word8)
         call lcase1 (task)
         write (text,100) type1, factr, type2, pgtol, wssq1, wssq2,
     +                    ifail, pcent, resul, time, word8, npts, n,
     +                    task
         numbld(1) = 1
         call patch1 (icolor, ix, iy, lshade, numbld, numtxt, text,
     +                border)
         write (nf,'(A)') blank
         write (nf,200) type1, factr, type2, pgtol, wssq1, wssq2,
     +                  ifail, pcent, resul, time, word8, npts, n,
     +                  task
         write (nf,'(A)') blank
      endif
c
c Store results in workspace w1
c
      w1(1) = wssq1
      w1(2) = wssq2
      w1(3) = pcent
      w1(4) = time
      w1(5) = dble(numfev)
c
c format statements
c      
  100 FORMAT (
     + 'Optimisation Method: Quasi-Newton with ',A,' gradient'
     +/
     +/'QNFIT2: limited progress could be due to:'
     +/'a) the wrong mathematical-model/gradient for this data'
     +/'b) inappropriate starting estimates for this model'
     +/'c) noisy/ill-conditioned/sparse/numerically-exact data'
     +/'d) badly scaled data (i.e. units too large/small)'
     +/'e) badly chosen data weighting factors (i.e. s-values)'
     +/'f) insufficient number of iterations (re-enter ?), or'
     +/'g) incorrect tolerance parameters factr and pgtol.'
     +/'factr               `=',1P,E11.3,',  Precision: ',A
     +/'pgtol               `=',1P,E11.3
     +/'wssq/ndof before    `=',1P,E11.3
     +/'wssq/ndof after     `=',1P,E11.3,',  IFAIL =',I3
     +/'Percent reduction   `=',0P,F11.2,'% ',A
     +/'cpu time (sec)      `=',1P,E11.3,',  no. of iterations = ',A
     +/'No. of data points  `=',I6
     +/'No. of parameters   `=',I6
     +/'Convergence message (TASK on exit from SETULB) is:'
     +/A)
  200 FORMAT (
     + ' Optimisation Method: Quasi-Newton with ',A,' gradient'
     +/
     +/' QNFIT2: limited progress could be due to:'
     +/' a) the wrong mathematical-model/gradient for this data'
     +/' b) inappropriate starting estimates for this model'
     +/' c) noisy/ill-conditioned/sparse/numerically-exact data'
     +/' d) badly scaled data (i.e. units too large/small)'
     +/' e) badly chosen data weighting factors (i.e. s-values)'
     +/' f) insufficient number of iterations (re-enter ?), or'
     +/' g) incorrect tolerance parameters factr and pgtol.'
     +/' factr              =',1P,E11.3,',  Precision: ',A
     +/' pgtol              =',1P,E11.3
     +/' wssq/ndof before   =',1P,E11.3
     +/' wssq/ndof after    =',1P,E11.3,',  IFAIL =',I3
     +/' Percent reduction  =',0P,F11.2,'% ',A
     +/' cpu time (sec)     =',1P,E11.3,',  no. of iterations = ',A
     +/' No. of data points =',I6
     +/' No. of parameters  =',I6
     +/' Convergence message (TASK on exit from SETULB) is:'
     +/' ', A)
      end
c
c
