c
c
      subroutine qnfree (isend, jfree, nfree, npar,
     +                   bl, blfree, bu, bufree, x, xfree,
     +                   fixed, free)
c
c action: separate free from fixed parameters for lbfgsB, etc.
c author: w.g.bardsley, university of manchester, u.k., 25/01/2000
c         19/11/2009 aded intents
c
c         isend = 0: initialise xfree from x, etc.
c         isend = 1: restore x from xfree
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)    :: isend, npar
      integer,          intent (inout) :: jfree(npar), nfree
      double precision, intent (in)    :: bl(npar), bu(npar)
      double precision, intent (inout) :: blfree(npar), bufree(npar),
     +                                    x(npar), xfree(npar)
      logical,          intent (inout) :: fixed, free(npar)
c
c locals
c      
      integer    i
      double precision epsi
      parameter (epsi = 1.0d-10)
      external   putfat
      intrinsic  abs
      if (isend.eq.0) then
c
c see if there are any fixed parameters and if so miss them out
c
         nfree = 0
         do i = 1, npar
            if (abs(bu(i) - bl(i)).gt.epsi) then
               nfree = nfree + 1
               jfree(nfree) = i
               xfree(nfree) = x(i)
               blfree(nfree) = bl(i)
               bufree(nfree) = bu(i)
               free(i) = .true.
            else
               free(i) = .false.
            endif
         enddo
         if (nfree.eq.npar) then
            fixed = .false.
         else
            fixed = .true.
         endif
      elseif (isend.eq.1) then
         do i = 1, nfree
            x(jfree(i)) = xfree(i)
         enddo
      else
         call putfat ('ISEND out of range in call to QNFREE')
      endif
      end
c
c
