C
C
      SUBROUTINE QNGRD2 (FUNCT,
     +                   INFORM, N,
     +                   G, W, X_IN,
     +                   FREE, TPOINT)
C
C ACTION    : Evaluate gradient vector G for function defined by FUNCT
C NAG       : X02AJF, X02AMF
C ARGUMENTS : TPOINT = .TRUE.  expect G to be the zero vector
C             TPOINT = .FALSE. then use central differences etc.
C             INFORM = 0 if O.K.
C             INFORM = 1 if N too small
C             INFORM = 2 if failure to calculate G
C             INFORM = 3 if too much cancellation error
C AUTHOR    : W. G. Bardsley, University of Manchester, U.K.
C             09/09/1997 derived from QNGRAD
C             24/10/1998 Added TOL1, TOL2 and TOL3
C             25/01/2000 derived from QNGRD1 by introducing FREE
C             19/11/2009 added INTENTS
C             17/01/2016 added FMAX and FMIN
C             03/03/2017 made X_IN INTENT (IN) then copied to X on entry         
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (OUT)   :: INFORM
      DOUBLE PRECISION, INTENT (IN)    :: X_IN(N) 
      DOUBLE PRECISION, INTENT (INOUT) :: G(N), W(3*N)
      LOGICAL,          INTENT (IN)    :: FREE(N), TPOINT
C
C Locals
C      
      INTEGER    I, NX1, NX2
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, SIX, THIRTY, PNT1,
     +                 DIMIN, TWOTHD
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, SIX = 6.0D+00,
     +           THIRTY = 30.0D+00, PNT1 = 0.1D+00,
     +           DIMIN = 0.01D+00, TWOTHD = 2.0D+00/3.0D+00)
      DOUBLE PRECISION
     +           ABFMID, ABGI, CNCERR, DI, EPSMCH, ERRMAX,
     +           ERRSUM, FBACK, FDIFF, FFORW, FMID, GI, GMAX,
     +           GSUM, H, HTRY, HTRY2, HTRYSQ, RCNERR, RPGERR,
     +           RTOL, XI, X02AJF$, X02AMF$
      DOUBLE PRECISION X(200)     
      DOUBLE PRECISION TOL1, TOL2, TOL3
      DOUBLE PRECISION FMAX, FMIN
      PARAMETER (FMAX = 1.0D+07, FMIN = 1.0D-07)
      EXTERNAL   FUNCT
      EXTERNAL   PUTFAT
      EXTERNAL   X02AJF$, X02AMF$
      INTRINSIC  ABS, SQRT
      IF (N.LT.1) THEN
         CALL PUTFAT ('QNGRD2 must have N >= 1')
         INFORM = 1
         RETURN
      ENDIF
C
C copy X_IN to X to make sure X_IN is not altered
C      
      DO I = 1, N
         X(I) = X_IN(I)
      ENDDO       
      EPSMCH = X02AJF$()
      RTOL = 1.0D+09*X02AMF$()
      CALL FUNCT (N, X, FMID)
      ABFMID = ABS(FMID)
      IF (ABFMID.GT.FMAX) THEN
         ABFMID = FMAX
      ELSEIF (ABFMID.LT.FMIN) THEN
         ABFMID = FMIN
      ENDIF      
      INFORM = 2
      TOL1 = EPSMCH*(FOUR*ABFMID + ONE)
      TOL2 = SIX*TOL1
      TOL3 = THREE*(TWO*ABFMID + ONE)
      HTRY = THIRTY*SQRT(TOL1)
      HTRY2 = HTRY + HTRY
      HTRYSQ = HTRY*HTRY
      IF (HTRY2.LT.RTOL) HTRY2 = RTOL
      IF (HTRYSQ.LT.RTOL) HTRYSQ = RTOL
      ERRSUM = ZERO
      GSUM = ZERO
      GMAX = ZERO
      ERRMAX = ZERO
C
C function values: f(x + h) = g, f(x - h) = w
C
      DO I = 1, N
         IF (FREE(I)) THEN
            XI = X(I)
            X(I) = XI + HTRY
            CALL FUNCT (N, X, G(I))
            X(I) = XI - HTRY
            CALL FUNCT (N, X, W(I))
            X(I) = XI
         ELSE
            G(I) = ZERO
         ENDIF
      ENDDO
C
C central differences
C
      NX1 = N
      NX2 = 2*N
      DO I = 1, N
         IF (FREE(I)) THEN
            FFORW = G(I)
            FBACK = W(I)
            DI = ABS(FFORW + FBACK - TWO*FMID)/HTRYSQ
            IF (DI.LT.DIMIN) DI = DIMIN
            W(NX1 + I) = DI
            GI = (FFORW - FBACK)/HTRY2
            G(I) = GI
            H = SQRT(TOL2/DI)
            W(NX2 + I) = H
            CNCERR = EPSMCH*(TOL3/H + ONE)
            W(I) = CNCERR
            ABGI = ABS(GI)
            ERRSUM = ERRSUM + ABGI*CNCERR/DI
            GSUM = GSUM + GI*GI/DI
            IF (ABGI.GT.GMAX) GMAX = ABGI
            IF (CNCERR.GT.ERRMAX) ERRMAX = CNCERR
         ENDIF
      ENDDO
      IF (ERRMAX.LT.EPSMCH) ERRMAX = EPSMCH
      IF (ERRSUM.LT.EPSMCH) ERRSUM = EPSMCH
      GMAX = TWO*GMAX
      RCNERR = ONE
      IF (ERRMAX.LE.GMAX) RCNERR = ERRMAX/GMAX
      RPGERR = ONE
      IF (ERRSUM.LE.GSUM) RPGERR = ERRSUM/GSUM
      INFORM = 0
C
C stop now if the approximation seems good
C
      IF (RCNERR.LE.PNT1 .AND. RPGERR.LE.PNT1 .AND. .NOT.TPOINT) RETURN
C
C o/w refine
C
      INFORM = 2
      ERRSUM = ZERO
      GSUM = ZERO
      GMAX = ZERO
      ERRMAX = ZERO
      DO I = 1, N
         IF (FREE(I)) THEN
            GI = G(I)
            ABGI = ABS(GI)
            IF (ABGI.LT.RTOL) ABGI = RTOL
            DI = W(NX1 + I)
            CNCERR = W(I)
            RCNERR = ONE
            IF (CNCERR.LE.ABGI) RCNERR = CNCERR/ABGI
            IF (RCNERR.LE.PNT1 .AND. .NOT.TPOINT) THEN
               INFORM = 2!to silence ftn95
            ELSE
               H = W(NX2 + I)
               H = H**TWOTHD
               IF (H.LT.RTOL) H = RTOL
               XI = X(I)
               X(I) = XI + H
               CALL FUNCT (N, X, FFORW)
               X(I) = XI - H
               CALL FUNCT (N, X, FBACK)
               FDIFF = FFORW - FBACK
               GI = FDIFF/(H + H)
               X(I) = XI
               G(I) = GI
               ABGI = ABS(GI)
               CNCERR = EPSMCH*(TOL3/H + ONE)
            ENDIF
            ERRSUM = ERRSUM + ABGI*CNCERR/DI
            GSUM = GSUM + GI*GI/DI
            IF (ABGI.GT.GMAX) GMAX = ABGI
            IF (CNCERR.GT.ERRMAX) ERRMAX = CNCERR
         ENDIF
      ENDDO
      IF (ERRMAX.LT.EPSMCH) ERRMAX = EPSMCH
      IF (ERRSUM.LT.EPSMCH) ERRSUM = EPSMCH
      GMAX = TWO*GMAX
      RCNERR = ONE
      IF (ERRMAX.LE.GMAX) RCNERR = ERRMAX/GMAX
      RPGERR = ONE
      IF (ERRSUM.LE.GSUM) RPGERR = ERRSUM/GSUM
      IF (RCNERR.LE.PNT1 .AND. RPGERR.LE.PNT1) THEN
         INFORM = 0
      ELSE
         INFORM = 3
      ENDIF
      END
C
C
