C
C
      SUBROUTINE QNINV1 (IA, N, NF,
     +                   A, AINV)
C
C ACTION : Invert a real symmetric positive definite matrix using F01ADF
C          The upper triangle of A must contain the elements of matrix A
C          The upper triangle is unchanged but the lower is overwritten
C          but offset by 1
C          The matrix AINV contains the full inverse of matrix A on exit
C ADVICE : This version has IA as first dimension of both A and AINV
C          where IA > N
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          ../../.. DBOS version
C          11/09/1997 win32 version ... NMAX = 1 since not needed by F01ABF$
C          22/10/1998 Corrected since F01ABF$ is dimensioned Z(N)
C          12/04/2007 replaced F01ABF by F01ADF
C
      IMPLICIT   NONE    
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: IA, N, NF  
      DOUBLE PRECISION, INTENT (INOUT) :: A(IA,*)
      DOUBLE PRECISION, INTENT (INOUT) :: AINV(IA,*)
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 17)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      INTEGER    I, J, IFAIL
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  TEXT(NUMTXT)*100
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   PUTIFA, PATCH1
      EXTERNAL   F01ADF$
      DATA NUMBLD / 14*0, 3*1 /
C
C Call F01ADF then check IFAIL
C
      IFAIL = N1
      CALL F01ADF$(N, A, IA, IFAIL)
      IF (IFAIL.NE.N0) THEN
C
C Warn user and set inverse = 1
C        
         CALL PUTIFA (IFAIL, NF, 'F01ADF/QNINV1')
         WRITE (TEXT,100)
         WRITE (NF,200)
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
         DO I = N1, N
            DO J = N1, N
               AINV(J,I) = ONE
            ENDDO
         ENDDO
         RETURN
      ENDIF
C
C Set lower triangle of AINV
C
      DO I = N1, N
        DO J = I, N
            AINV(J,I) = A(J + 1,I)
         ENDDO
      ENDDO
C
C Set upper triangle of AINV
C
      DO I = N2, N
        DO J = N1, I - N1
          AINV(J,I) = AINV(I,J)
        ENDDO
      ENDDO
C
C Format statements
C      
  100 FORMAT (
     + 'The Hessian matrix is rank-deficient so the parameter standard'
     +/'errors are not uniquely defined and the covariance matrix can'
     +/'not be calculated. The correlation matrix has been set to 1.'
     +/
     +/'Possible reasons for the ill-conditioning could be as follows.'
     +/
     +/'1) `The data may be too sparse or noisy for the chosen model or'
     +/'   `there could be a bad experimental design (e.g. spacing).'
     +/'2) `The model fitted may not be the correct model or it could'
     +/'   `be over-parameterised.'
     +/'3) `The data scaling or weighting factors could be incorrect.'
     +/'4) `The data may be exact preventing accumulation of sufficient'
     +/'   `curvature information to estimate a quasi-Newton Hessian.'
     +/
     +/'Note that the parameter estimates are probably not meaningful,'
     +/'so ignore the parameter standard errors and correlation matrix,'
     +/'then get more data or else choose a more appropriate model.')
  200 FORMAT (
     +/' The Hessian matrix is rank-deficient so the parameter standard'
     +/' errors are not uniquely defined and the covariance matrix can'
     +/' not be calculated. The correlation matrix has been set to 1.'
     +/
     +/' Possible reasons for the ill-conditioning could be as follows.'
     +/
     +/' 1) The data may be too sparse or noisy for the chosen model or'
     +/'    there could be a bad experimental design (e.g. spacing).'
     +/' 2) The model fitted may not be the correct model or it could'
     +/'    be over-parameterised.'
     +/' 3) The data scaling or weighting factors could be incorrect.'
     +/' 4) The data may be exact preventing accumulation of sufficient'
     +/'    curvature information to estimate a quasi-Newton Hessian.'
     +/
     +/' Note that the parameter estimates are probably not meaningful,'
     +/' so ignore the parameter standard errors and correlation matrix'
     +/' then get more data or else choose a more appropriate model.')
      END
C
C
