C
C
      SUBROUTINE QRFACT (NCMAX, NCOL, NIN, NF, NRMAX, NROW, NWORK,
     +                   A, W,
     +                   TITLE,
     +                   ABORT, DISPLY, FILE, SUPPLY)
C
C ACTION : QR factorisation of a matrix
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/10/2003
C          Derived from MATRIX 22/10/2003
C          Edited 05/12/2003
C          01/03/2005 replaced DGEQRF, DORGQR by F08AEF$, F08AFF$
C          16/01/2006 moved Q and R to allocatables
C          16/10/2006 moved T to allocatables and further editing 
C          27/11/2006 introduced NCADD and NRADD to allow /check_mate  
C          11/05/2010 introduced NKLCFG to switch on/off the test file advice 
C          30/04/2011 introduced call to TFILEQ 
C
C ADVICE : If successful then on exit ABORT = .FALSE.,
C          A is then returned as the matrix
C          The routine is silent if SUPPLY is .TRUE. and both DISPLY
C          and FILE are .FALSE.
C               
C          NCMAX: (input/unchanged) max. column dimension 
C           NCOL: (input/output) actual no. columns (depending on SUPPLY)
C            NIN: (input/unchanged) unconnected input unit 
C             NF: (input/unchanged) preconnected output unit
C          NRMAX: (input/unchanged) max. row dimension 
C           NROW: (input/output) actual no. rows (depending on SUPPLY)
C          NWORK: (input/unchanged) workspace dimension > NCOL*BLOCKSIZE, say 64*NCOL 
C              A: (input/output) matrix returned/supplied (depending on SUPPLY)
C              W: workspace
C          ABORT: (output) failure ?
C         DISPLY: (input/unchanged) table to screen ?
C           FILE: (input/unchanged) output to file ?
C         SUPPLY: (input/unchanged) provide data ?
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)    :: NCMAX, NIN, NF, NRMAX, NWORK 
      INTEGER,          INTENT (INOUT) :: NCOL, NROW
      DOUBLE PRECISION, INTENT (INOUT) :: A(NRMAX,NCMAX), W(NWORK)
      LOGICAL,          INTENT (IN)    :: DISPLY, FILE, SUPPLY 
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: Q(:,:), R(:,:), T(:)
C
C Locals
C
                 
      INTEGER    NCQMAX, NCRMAX, NRQMAX, NRRMAX 
      INTEGER    NCOL1, NROW1
      INTEGER    I, ICOUNT, IERR, INFO, ISEND, J, NTMAX
      INTEGER    KVAL9, NKLCFG
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT, NTEXT1
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NUMOPT = 11, NTEXT1 = 1)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N21
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N21 = 21)
      INTEGER    NTYPE
      PARAMETER (NTYPE = 3) 
      INTEGER    NCADD, NRADD
      PARAMETER (NCADD = 5, NRADD = 5)
      DOUBLE PRECISION B(1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  TITLE*(*)
      CHARACTER  CHOP80*80, FNAME*1024, FNAME1*1024, LINE*100,
     +           WORD80*80, TEXT(NUMOPT)*100, TEXT1(NTEXT1)*100,
     +           TITLE1*80 
      CHARACTER  Q8*8, R8*8
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT1, FILE1, FILE2, FILE3, REPEET
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    HEADER, QTEXT, QTITLE
      PARAMETER (HEADER = .TRUE., QTEXT = .TRUE., QTITLE = .TRUE.)
      EXTERNAL   F08AEF$, F08AFF$
      EXTERNAL   MATTIN, PUTFAT, DSPLAY, CHOP80, LBOX02, MATOUT, REVPRO
      EXTERNAL   NKLCFG, TFILEQ
      INTRINSIC  MIN, MAX
      SAVE       ICOUNT
      DATA       ICOUNT / 0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Read in the matrix if .NOT.SUPPLY
C
      IF (.NOT.SUPPLY) THEN
         KVAL9 = NKLCFG(N21)
         IF (KVAL9.EQ.N1) THEN
            WRITE (LINE,100)
            CALL TFILEQ (LINE)
         ENDIF   
         I = N0
         CLOSE (UNIT = NIN)
         CALL MATTIN (I, NCMAX, NCOL, NIN, NRMAX, NROW,
     +                A, B,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ENDIF
C
C Initialise ABORT = .TRUE.
C
      ABORT = .TRUE.
C
C Check the dimensions
C
      IF (NCOL.LT.N2 .OR. NROW.LT.N2) THEN
          IF (DISPLY) THEN
             WRITE (LINE,200)
             CALL PUTFAT (LINE)
          ENDIF
          ABORT = .TRUE.
          RETURN
      ENDIF
      IF (NCOL.GT.NCMAX .OR. NROW.GT.NRMAX) THEN
         IF (DISPLY) THEN
            WRITE (LINE,300) 
            CALL PUTFAT (LINE)
         ENDIF
         ABORT = .TRUE.   
         RETURN
      ENDIF
C
C Allocate workspace
C                 
      IF (NROW.GE.NCOL) THEN
         NCQMAX = NROW + NRADD
         NRQMAX = NROW + NRADD
         NCRMAX = NCOL + NCADD
         NRRMAX = NCOL + NCADD
      ELSE
         NCQMAX = NCOL + NCADD
         NRQMAX = NROW + NRADD
         NCRMAX = NCOL + NCADD
         NRRMAX = NROW + NRADD 
      ENDIF   
      IERR = 0
      IF (ALLOCATED(Q)) DEALLOCATE(Q, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(R)) DEALLOCATE(R, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(T)) DEALLOCATE(T, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Q(NRQMAX,NCQMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(R(NRRMAX,NCRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN    
      NTMAX = MAX(NCOL,NROW)
      ALLOCATE(T(NTMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C First copy A into Q since matrices are overwritten
C
      DO I = N1, NCOL
         DO J = N1, NROW
            Q(J,I) = A(J,I)
         ENDDO
      ENDDO
C
C Factorise
C
      CALL F08AEF$(NROW, NCOL, Q, NRQMAX, T, W, NWORK, INFO)
      IF (INFO.NE.N0) THEN
         IF (DISPLY) THEN
            WRITE (LINE,400) INFO
            CALL PUTFAT (LINE)
         ENDIF
         ABORT = .TRUE.
         DEALLOCATE(Q, STAT = IERR)
         DEALLOCATE(R, STAT = IERR)
         DEALLOCATE(T, STAT = IERR)
         RETURN
      ENDIF
C
C Copy result into R
C
      DO I = N1, MIN(NCOL,NROW)
         DO J = N1, NCOL
            IF (J.LT.I) THEN
               R(I,J) = ZERO
            ELSE
               R(I,J) = Q(I,J)
            ENDIF
         ENDDO
      ENDDO
C
C Reconsitute all of Q
C
      CALL F08AFF$(NROW, NROW, MIN(NCOL,NROW), Q, NRQMAX, T, W, NWORK,
     +             INFO)
      IF (INFO.NE.N0) THEN
         IF (DISPLY) THEN
            WRITE (LINE,500) INFO
            CALL PUTFAT (LINE)
         ENDIF
         ABORT = .TRUE.
         DEALLOCATE(Q, STAT = IERR)
         DEALLOCATE(R, STAT = IERR)
         RETURN
      ELSEIF (DISPLY) THEN
         FILE1 = FILE
         FILE2 = FILE
         FILE3 = FILE
         IF (MAX(NCOL,NROW).GT.20) THEN
            FILE1 = .FALSE.
            FILE2 = .FALSE.
            FILE3 = .FALSE.
         ENDIF
         WORD80 = CHOP80(TITLE)
         ICOUNT = ICOUNT + N1
         IF (FILE) THEN
            WRITE (NF,600) ICOUNT, WORD80
         ENDIF 
         IF (NROW.GE.NCOL) THEN
            R8 = '(R = R1)'
         ELSE
            R8 = BLANK
         ENDIF
         IF (NROW.LE.NCOL) THEN
            Q8 = '(Q = Q1)'
         ELSE
            Q8 = BLANK
         ENDIF            
         REPEET = .TRUE.
         DO WHILE (REPEET)
            WRITE (TEXT,700) Q8, R8, Q8, R8
            NUMDEC = NUMOPT
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IF (NUMDEC.EQ.1) THEN
C
C Display A
C
               NCOL1 = NCOL
               NROW1 = NROW
               CALL DSPLAY (NCMAX, NCOL1, NF, NRMAX, NROW1, NTYPE,
     +                      A,
     +                      WORD80,
     +                      FILE1)
               FILE1 = .FALSE.
            ELSEIF (NUMDEC.LE.3) THEN
C
C Display Q/Q1
C
               IF (NUMDEC.EQ.2) THEN
                  NCOL1 = NROW
                  NROW1 = NROW
                  WRITE (LINE,1000) 'Q'
               ELSE
                  IF (NROW.GT.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NROW
                  ELSE
                     NCOL1 = NROW
                     NROW1 = NROW
                  ENDIF
                  WRITE (LINE,1000) 'Q1'
               ENDIF
               CALL DSPLAY (NCQMAX, NCOL1, NF, NRQMAX, NROW1, NTYPE,
     +                      Q,
     +                      LINE,
     +                      FILE2)
               FILE2 = .FALSE.
            ELSEIF (NUMDEC.LE.5) THEN
C
C Display R/R1
C
               IF (NUMDEC.EQ.4) THEN
                  IF (NROW.GE.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NCOL
                  ELSE   
                     NCOL1 = NCOL
                     NROW1 = NROW
                  ENDIF 
                  WRITE (LINE,1100) 'R'  
               ELSE
                  IF (NROW.GE.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NCOL
                  ELSE
                     NCOL1 = NROW
                     NROW1 = NROW
                  ENDIF
                  WRITE (LINE,1100) 'R1'
               ENDIF
               CALL DSPLAY (NCRMAX, NCOL1, NF, NRRMAX, NROW1, NTYPE,
     +                      R,
     +                      LINE,
     +                      FILE3)
               FILE3 = .FALSE.
            ELSEIF (NUMDEC.LE.7) THEN
C
C File Q/Q1
C
               TEXT1(1) = BLANK
               IF (NUMDEC.EQ.6) THEN
                  NCOL1 = NROW
                  NROW1 = NROW
                  TITLE1 = 'Matrix-Q'
               ELSE
                  IF (NROW.GT.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NROW
                  ELSE
                     NCOL1 = NROW
                     NROW1 = NROW
                  ENDIF
                  TITLE1 = 'Matrix-Q1'
               ENDIF
               CLOSE (UNIT = NIN)
               ISEND = N1
               CALL MATOUT (ISEND, NCOL1, NIN, NRQMAX, NROW1,
     +                      NTEXT1,
     +                      Q,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.LE.9) THEN
C
C File R/R1
C
               
               TEXT1(1) = BLANK
               IF (NUMDEC.EQ.8) THEN
                  IF (NROW.GE.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NCOL
                  ELSE   
                     NCOL1 = NCOL
                     NROW1 = NROW
                  ENDIF 
                  TITLE1 = 'Matrix-R'
               ELSE
                  IF (NROW.GE.NCOL) THEN
                     NCOL1 = NCOL
                     NROW1 = NCOL
                  ELSE
                     NCOL1 = NROW
                     NROW1 = NROW
                  ENDIF
                  TITLE1 = 'Matrix-R1'
               ENDIF
               CLOSE (UNIT = NIN)
               ISEND = N1
               CALL MATOUT (ISEND, NCOL1, NIN, NRRMAX, NROW1,
     +                      NTEXT1,
     +                      R,
     +                      FNAME1, TEXT1, TITLE1,
     +                      ABORT1, HEADER, QTEXT, QTITLE)
               CLOSE (UNIT = NIN)
            ELSEIF (NUMDEC.EQ.10) THEN
C
C Review progress
C            
               CALL REVPRO (NF)   
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               REPEET = .FALSE.
            ENDIF
         ENDDO
      ENDIF
C
C OK so set ABORT = .FALSE.
C
      ABORT = .FALSE.
C
C Deallocate workspace
C
      DEALLOCATE(Q, STAT = IERR)
      DEALLOCATE(R, STAT = IERR)
      DEALLOCATE(T, STAT = IERR)
C
C Format statements
C
  100 FORMAT ('Now input a matrix formatted like matrix.tf2')
  200 FORMAT ('Not a matrix ... Must have m, n > 1')
  300 FORMAT ('Dimension error in call to QRFACT')
  400 FORMAT ('On exit from DGEQRF, INFO =',I4)
  500 FORMAT ('On exit from DORGQR, INFO =',I4)
  600 FORMAT (
     +/'The QR factorisation of matrix',I3
     +/'================================='
     +/
     +/'Title of data:'
     +/A)
  700 FORMAT (
     + 'Display current matrix'
     +/'Display Q'
     +/'Display Q1',1X,A
     +/'Display R'
     +/'Display R1',1X,A
     +/'file: Save Q As ...' 
     +/'File: Save Q1 As ...',1X,A
     +/'File: Save R As ...'
     +/'File: Save R1 As ...',1X,A
     +/'Results'
     +/'Quit ... Exit QR analysis')
 1000 FORMAT ('The orthogonal matrix',1X,A)
 1100 FORMAT ('The upper triangular/trapezoidal matrix',1X,A)
      END
C
C
