c
c
      subroutine randat (iseq, ivec, nivec, nxvec,
     +                   uvec, xvec)
c
c action: random numbers, permutations and latin squares
c author: w.g.bardsley, university of manchester, u.k., 17/05/2003
c         28/06/2004 improved menu format 2000
c         28/02/2006 made latin allocatable
c         01/10/2007 added intents and call to fname
c         27/09/2012 replaced call to g05ccf$ by call to rseeds
c
c         nivec and nxvec are input/unchanged
c         iseq(nivec), ivec(nivec), uvec(nxvec), and xvec(nxvec) are workspaces
c
c         iseq = permuted sequence of length nseq
c         ivec = numi random integers from U(ilow,ihigh)
c         uvec = numu random numbers from U(xlow,xhigh)
c         xvec = numx random numbers from N(a,b)
c         latin = numlat dimensional random latin square
c
c         nmax = max. dimension of latin square
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: nivec, nxvec
      integer,          intent (inout) :: iseq(nivec), ivec(nivec)
      double precision, intent (inout) :: uvec(nxvec), xvec(nxvec)
c
c local allocatable workspace
c
      integer, allocatable :: latin(:,:)
c
c locals
c
      integer    i, ierr, ihigh, ilow, j, jcolor, jseed, ktype, nlatin,
     +           nout, nsav, nseq, numi, numn, numu
      integer    isend, jsend, nmax, ntypes
      parameter (isend = 1, jsend = 0, nmax = 100, ntypes = 5)
      integer    ncol(ntypes), nrow(ntypes)
      integer    icolor, ix, iy, lshade, numdec, numopt, numsta, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numsta = 11)
      integer    numbld(30), numpos(20)
      integer    len200, l1, l2
      integer    g05dyf$
      double precision a, b, xhigh, xlow
      double precision xtemp, ytemp
      double precision zero, one, epsi, xbig
      parameter (zero = 0.0d+00, one = 1.0d+00, epsi = 1.0d-10,
     +           xbig = 1.0d+300)
      double precision g05daf$, g05ddf$
      character  fname*1024
      character  line*100, text(30)*100, title(ntypes)*80, type1*100
      character (len = 12 ) form12, word12(7) 
      character (len = 13 ) d13(4), showlj, showrj
      character (len = 100) header
      logical    e_numbers, e_formats
      logical    abort, again, ready(ntypes), repeet
      logical    border, titles
      parameter (border = .false., titles = .true.)
      external   e_formats, showlj, showrj
      external   lbox02, patch1, lview2, putfat, table1, putadv, ranseq,
     +           ranlat, len200, ofiles, getnou, getjl1, getdl1, getjm1,
     +           getd01, getdge, fnames, lstbox, form12
      external   g05dyf$, g05daf$, g05ddf$, rseeds
      intrinsic  char, trim
      save       ilow, ihigh, nlatin, nseq, numi, numn, numu
      save       a, b, xlow, xhigh
      data       ilow, ihigh / 1, 10 /
      data       nlatin / 5 /
      data       nseq, numi, numn, numu / 10, 10, 10, 10 /
      data       a, b / zero, one /
      data       xlow, xhigh / zero, one /
      data       numbld / 30*0 /
      data       numpos / 20*1 /

c
c----------------------------------------------------------------------
c allocate workspace then initialise
c----------------------------------------------------------------------
c
      ierr = 0
      if (allocated(latin)) deallocate(latin, stat = ierr)
      if (ierr.ne.0) return
      allocate(latin(nmax,nmax), stat = ierr)
      if (ierr.ne.0) return
      call rseeds (jsend, jseed, ktype)
      if (ktype.eq.0) then
         header = 'Seed type: System clock'
      else
         word12(1) = form12(jseed)
         header = 'Seed type: User-selected seed = '//word12(1)
      endif      
      do i = 1, ntypes
         ncol(i) = 0
         nrow(i) = 0
         ready(i) = .false.
      enddo
      numdec = 7
      repeet = .true.
c
c----------------------------------------------------------------------
c the main loop
c----------------------------------------------------------------------
c
      e_numbers = e_formats()
      do while (repeet)
         word12(1) = form12(ilow)
         word12(2) = form12(ihigh)
         word12(3) = form12(numi)
         word12(4) = form12(numu)
         word12(5) = form12(numn)
         word12(6) = form12(nseq)
         word12(7) = form12(nlatin)
         l1 = len200(word12(1))
         l2 = len200(word12(2))
         if (e_numbers) then
            write (text,100) word12(1)(1:l1), word12(2)(1:l2),
     +                       word12(3), xlow, xhigh, word12(4),         
     +                       a, b, word12(5),         
     +                       word12(6),    
     +                       word12(7)  
         else
            d13(1) = showlj(xlow)
            d13(2) = showlj(xhigh)
            d13(3) = showlj(a)
            d13(4) = showlj(b)
            write (text,150) word12(1)(1:l1), word12(2)(1:l2),
     +                       word12(3), trim(d13(1)), trim(d13(2)), 
     +                       word12(4),         
     +                       trim(d13(3)), trim(d13(4)), word12(5),         
     +                       word12(6),    
     +                       word12(7)  



         endif  
         text(4) = header 
         numopt = 8
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         numbld(3) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0 
         numbld(3) = 0        
         type1 = text(numdec + numsta - 1)
         if (numdec.lt.numopt - 2) then
c
c----------------------------------------------------------------------
c generate, view , Save As ...
c----------------------------------------------------------------------
c
            again = .true.
            nsav = numdec
            numdec = 1
            do while (again)
               write (text,200)
               if (numdec.eq.0) numdec = 1
               numopt = 4
               call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                      text)
               if (numdec.eq.2 .or. numdec.eq.3) then
                  if (.not.ready(nsav)) then
                     write (line,300)
                     call putfat (line)
                     numdec = 0
                  endif
               endif
               if (numdec.eq.1) then
c
c generate
c
                  abort = .false.
                  j = len200(type1)
                  ncol(nsav) = 1
                  if (nsav.eq.1) then
                     write (title(1),400) type1(1:j), word12(1)(1:l1),
     +                                                word12(2)(1:l2)
                     nrow(1) = numi
                     do i = 1, numi
                        ivec(i) = g05dyf$(ilow, ihigh)
                     enddo
                  elseif (nsav.eq.2) then
                     if (e_numbers) then
                        write (title(2),500) type1(1:j), xlow, xhigh
                     else
                        d13(1) = showlj(xlow)
                        d13(2) = showlj(xhigh)  
                        write (title(2),550) type1(1:j), trim(d13(1)),
     +                                       trim(d13(2))
                     endif  
                     nrow(2) = numu
                     do i = 1, numu
                        uvec(i) = g05daf$(xlow, xhigh)
                     enddo
                  elseif (nsav.eq.3) then
                     if (e_numbers) then
                        write (title(3),600) type1(1:j), a, b
                     else
                        d13(1) = showlj(a)
                        d13(2) = showlj(b) 
                        write (title(3),650) type1(1:j), trim(d13(1)),
     +                                       trim(d13(2))
                     endif                       
                     nrow(3) = numn
                     do i = 1, numn
                        xvec(i) = g05ddf$(a, b)
                     enddo
                  elseif (nsav.eq.4) then
                     write (title(4),700) type1(1:j), word12(6)
                     nrow(4) = nseq
                     call ranseq (nseq, iseq, abort)
                  elseif (nsav.eq.5) then
                     ncol(5) = nlatin
                     nrow(5) = nlatin
                     call ranlat (latin, nmax, nlatin,
     +                            abort)
c
c niter is only defined after the latin square has been generated
c
                     write (title(5),800) type1(1:j), word12(7)
                  endif
                  if (abort) then
                     if (nsav.ne.5) then
                        write (line,900)
                     else
                        write (line,1000)
                     endif
                     call putfat (line)
                     ready(nsav) = .false.
                     numdec = 7
                   else
                     write (line,1100)
                     call putadv (line)
                     ready(nsav) = .true.
                     numdec = 2
                  endif
               elseif (numdec.eq.2) then
c
c view
c
                  jcolor = 15
                  call table1 (jcolor, 'OPEN')
                  jcolor = 4
                  call table1 (jcolor, title(nsav))
                  jcolor = 0
                  if (nsav.eq.1) then
                     do i = 1, numi
                        write (line,1200) ivec(i)
                        call table1 (jcolor, line)
                     enddo
                  elseif (nsav.eq.2) then
                     do i = 1, numu
                        if (e_numbers) then
                           write (line,1300) uvec(i)
                        else
                           d13(1) = showrj(uvec(i))
                           write (line,1350) d13(1)
                        endif      
                        call table1 (jcolor, line)
                     enddo
                  elseif (nsav.eq.3) then
                     do i = 1, numn
                        if (e_numbers) then
                           write (line,1300) xvec(i)
                        else
                           d13(1) = showrj(xvec(i))
                           write (line,1350) d13(1)
                        endif      
                        call table1 (jcolor, line)
                     enddo
                  elseif (nsav.eq.4) then
                     if (nseq.le.26) then
                        write (line,'(26i3)') (iseq(i), i = 1, nseq)
                        call table1 (jcolor, line)
                        write (line,1400)
                        jcolor = 4
                        call table1 (jcolor, line)
                        jcolor = 0
                        write (line,'(26a3)') (char(iseq(i) + 64),
     +                                         i = 1, nseq)
                        call table1 (jcolor, line)
                     else   
                        do i = 1, nseq
                           write (line,1200) iseq(i)
                           call table1 (jcolor, line)
                        enddo   
                     endif
                  elseif (nsav.eq.5) then
                     do i = 1, nlatin
                        write (line,1500) (latin(i,j), j = 1, nlatin)
                        call table1 (jcolor, line)
                     enddo
                     if (nlatin.le.26) then
                        write (line,1400)
                        jcolor = 4
                        call table1 (jcolor, line)
                        jcolor = 0
                        do i = 1, nlatin
                           write (line,1600) (char(latin(i,j) + 64),
     +                                        j = 1, nlatin)
                           call table1 (jcolor, line)
                        enddo
                     endif
                  endif
                  call table1 (jcolor, 'CLOSE')
                  numdec = 1
               elseif (numdec.eq.3) then
c
c Save As ...
c
                  call getnou (nout)
                  close (unit = nout)
                  call ofiles (isend, nout,
     +                         fname,
     +                         abort)
                  if (abort) then
                     close (unit = nout)
                  else
                     write (nout,'(a)') title(nsav)
                     write (nout,1700) nrow(nsav), ncol(nsav)
                     if (nsav.eq.1) then
                        do i = 1, numi
                           write (nout,1200) ivec(i)
                        enddo
                     elseif (nsav.eq.2) then
                        do i = 1, numu
                           if (e_numbers) then 
                              write (nout,1300) uvec(i)
                           else
                              d13(1) = showrj(uvec(i))
                              write (nout,1350) d13(1)
                           endif
                        enddo
                     elseif (nsav.eq.3) then
                        do i = 1, numn
                           if (e_numbers) then
                              write (nout,1300) xvec(i)
                           else
                              d13(1) = showrj(xvec(i))
                              write (nout,1350) d13(1)
                           endif
                        enddo
                     elseif (nsav.eq.4) then
                        do i = 1, nseq
                           write (nout,1200) iseq(i)
                        enddo
                     elseif (nsav.eq.5) then
                        do i = 1, nlatin
                           write (nout,1500) (latin(i,j), j = 1, nlatin)
                        enddo
                     endif
                     if (nsav.eq.4 .and. nseq.le.26) then
                        write (nout,'(i6)') nseq + 2
                        write (nout,1400)
                        do i = 1, nseq
                           write (nout,'(a10)') char(iseq(i) + 64)
                        enddo
                     elseif (nsav.eq.5 .and. nlatin.le.26) then
                        write (nout,'(i6)') nlatin + 2
                        write (nout,1400)
                        do i = 1, nlatin
                           write (nout,1600) (char(latin(i,j) + 64),
     +                                        j = 1, nlatin)
                        enddo
                     else
                        write (nout,'(i6)') 1
                     endif
                     write (nout,1800)
                     close (unit = nout)
                     i = 2
                     call fnames (i, 
     +                            fname)                      
                  endif
                  numdec = 1
               elseif (numdec.eq.numopt) then
                  again = .false.
               endif
            enddo
            numdec = nsav
         elseif (numdec.eq.numopt - 2) then
c
c----------------------------------------------------------------------
c configure
c----------------------------------------------------------------------
c
            again = .true.
            do while (again)
               if (e_numbers) then
                  write (text,2000) ilow, ihigh, numi, xlow, xhigh,
     +                              numu, a, b, numn, nseq, nlatin
               else
                  word12(1) = form12(ilow)
                  word12(2) = form12(ihigh)
                  word12(3) = form12(numi)
                  d13(1) = showlj(xlow)
                  d13(2) = showlj(xhigh)
                  word12(4) = form12(numu)
                  d13(3) = showlj(a)
                  d13(4) = showlj(b)
                  word12(5) = form12(numn)
                  word12(6) = form12(nseq)
                  word12(7) = form12(nlatin)   
                  write (text,2050) word12(1), word12(2), word12(3), 
     +                              d13(1), d13(2), word12(4), d13(3), 
     +                              d13(4), word12(5), word12(6),
     +                              word12(7)
               endif  
               numopt = 12
               numdec = numopt
               call lview2 (ix, iy, numdec, numopt,
     +                      text,
     +                      titles)

               if (numdec.eq.1) then
                  write (line,2100) ihigh
                  i = -10000000
                  j = ihigh - 1
                  call getjl1 (i, ilow, j, line)
                  ready(1) = .false.
               elseif (numdec.eq.2) then
                  write (line,2200) ilow
                  i = ilow + 1
                  j = 10000000
                  call getjl1 (i, ihigh, j, line)
                  ready(1) = .false.
               elseif (numdec.eq.3) then
                  i = 1
                  j = 1000000
                  write (line,2300)
                  call getjl1 (i, numi, j, line)
                  ready(1) = .false.
               elseif (numdec.eq.4) then
                  xtemp = - xbig
                  ytemp = xhigh - epsi
                  write (line,2400) xhigh
                  call getdl1 (xtemp, xlow, ytemp, line)
                  ready(2) = .false.
               elseif (numdec.eq.5) then
                  xtemp = xlow + epsi
                  ytemp = xbig
                  write (line,2500) xlow
                  call getdl1 (xtemp, xhigh, ytemp, line)
                  ready(2) = .false.
               elseif (numdec.eq.6) then
                  i = 1
                  j = 1000000
                  write (line,2600)
                  call getjl1 (i, numu, j, line)
                  ready(2) = .false.
               elseif (numdec.eq.7) then
                  write (line,2700)
                  call getd01 (a, line)
                  ready(3) = .false.
               elseif (numdec.eq.8) then
                  write (line,2800)
                  call getdge (b, epsi, line)
                  ready(3) = .false.
               elseif (numdec.eq.9) then
                  i = 1
                  j = 1000000
                  write (line,2900)
                  call getjl1 (i, numn, j, line)
                  ready(3) = .false.
               elseif (numdec.eq.10) then
                  i = 2
                  j = 1000
                  write (line,3000) j
                  call getjl1 (i, nseq, j, line)
                  ready(4) = .false.
               elseif (numdec.eq.11) then
                  i = 2
                  j = 100
                  write (line,3100)
                  call getjm1 (i, nlatin, j, line)
                  ready(5) = .false.
               elseif (numdec.eq.numopt) then
                  again = .false.
               endif
            enddo
            numdec = 7
         elseif (numdec.eq.numopt - 1) then
c
c----------------------------------------------------------------------
c help
c----------------------------------------------------------------------
c
            write (text,3200)
            numtxt = 22
            numbld(1) = 1
            numbld(3) = 1
            numbld(7) = 1
            numbld(11) = 1
            numbld(15) = 1
            numbld(19) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numbld(3) = 0
            numbld(7) = 0
            numbld(11) = 0
            numbld(15) = 0
            numbld(19) = 0
         elseif (numdec.eq.numopt) then
c
c----------------------------------------------------------------------
c cancel
c----------------------------------------------------------------------
c
            repeet = .false.
         endif
      enddo
c
c deallocate workspace
c
      deallocate(latin, stat = ierr)
c
c format statements
c
  100 format (
     + 'Generating random numbers or permutations'
     +/
     +/'Current configuration:'
     +/
     +/'U(i,j): i =',1x,a,', j =',1x,a,', n =',1x,a
     +/'U(x,y): x =',1p,e11.3,', y =',e11.3,', n =',1x,a 
     +/'N(mu,sigma^2): mu =',1p,e11.3,', sigma^2 =',e10.3,', n =',1x,a
     +/'Random permutation: n =',1x,a
     +/'Random Latin square: k =',1x,a 
     +/ 
     +/'Random integers from U(i,j)'
     +/'Random numbers from U(x,y)'
     +/'Random numbers from N(mu,sigma^2)'
     +/'Random permutations of 1,2,3,...,n'
     +/'Random k by k Latin Square'
     +/'Configure the options'
     +/'Help'
     +/'Quit ... Exit random/permutation options')
  150 format (
     + 'Generating random numbers or permutations'
     +/
     +/'Current configuration:'
     +/
     +/'U(i,j): i =',1x,a,', j =',1x,a,', n =',1x,a
     +/'U(x,y): x =',1x,a,', y =',1x,a,', n =',1x,a 
     +/'N(mu,sigma^2): mu =',1x,a,', sigma^2 =',1x,a,', n =',1x,a
     +/'Random permutation: n =',1x,a
     +/'Random Latin square: k =',1x,a 
     +/ 
     +/'Random integers from U(i,j)'
     +/'Random numbers from U(x,y)'
     +/'Random numbers from N(mu,sigma^2)'
     +/'Random permutations of 1,2,3,...,n'
     +/'Random k by k Latin Square'
     +/'Configure the options'
     +/'Help'
     +/'Quit ... Exit random/permutation options')   
  200 format (
     + 'Generate random data'
     +/'View'
     +/'Save As ...'
     +/'Quit ... Exit these random number options')
  300 format ('First generate the random data')
  400 format (a,': i =',1x,a,', j =',1x,a)
  500 format (a,': x =',1p,e11.3,', y =',e11.3)
  550 format (a,': x =',1x,a,' y =',1x,a) 
  600 format (a,': mu =',1p,e11.3,', sigma^2 =',e10.3)
  650 format (a,': mu =',1x,a,', sigma^2 =',1x,a)
  700 format (a,': n =',1x,a)
  800 format (a,': k =',1x,a)
  900 format ('Failure to generate a permutation ... try again')
 1000 format ('Failure to generate a Latin Square ... try again')
 1100 format ('Random data have been generated')
 1200 format (i10)
 1300 format (1p,e17.9)
 1350 format (1x,a)
 1400 format ('Equivalent alphabetical representation')
 1500 format (100i4)
 1600 format (100a2)
 1700 format (2i6)
 1800 format ('Random data generated by Simfit subroutine RANDAT')
c1900 format ('Random data have been written to the file')
 2000 format (
     + 'Random number configuration options `Current value'
     +/'U(i,j): input i (where i < j)       `', i4
     +/'U(i,j): input j (where j > i)       `', i4
     +/'U(i,j): input size                  `', i4
     +/'U(x,y): input x (where x < y)       `', 1p,e11.3
     +/'U(x,y): input y (where y > x)       `',    e11.3
     +/'U(x,y): input size                  `', i4
     +/'N(mu,sigma^2): input mu             `',    e11.3
     +/'N(mu,sigma^2): input sigma^2        `',    e11.3
     +/'N(mu,sigma^2): input size           `', i4
     +/'Permutation vector: input size      `', i4
     +/'Latin Square: input dimension       `', i4
     +/'Apply                               `...')
 2050 format (
     + 'Random number configuration options `Current value'
     +/'U(i,j): input i (where i < j)       `', 1x,a
     +/'U(i,j): input j (where j > i)       `', 1x,a
     +/'U(i,j): input size                  `', 1x,a
     +/'U(x,y): input x (where x < y)       `', 1x,a
     +/'U(x,y): input y (where y > x)       `', 1x,a
     +/'U(x,y): input size                  `', 1x,a
     +/'N(mu,sigma^2): input mu             `', 1x,a
     +/'N(mu,sigma^2): input sigma^2        `', 1x,a
     +/'N(mu,sigma^2): input size           `', 1x,a
     +/'Permutation vector: input size      `', 1x,a
     +/'Latin Square: input dimension       `', 1x,a
     +/'Apply                               `...')                           
 2100 format ('An integer less than',i8)
 2200 format ('An integer greater than',i8)
 2300 format ('The number of U(i,j) random integers required')
 2400 format ('A number less than',1p,e11.3)
 2500 format ('A number greater than',1p,e11.3)
 2600 format ('The number of U(x,y) random numbers required')
 2700 format ('The mean of the distribution, mu')
 2800 format ('The variance of the distribution, sigma^2 > 0')
 2900 format ('The number of N(mu,sigma^2) random numbers required')
 3000 format ('Length of the permutation sequence required, max.',i6)
 3100 format ('Dimension k for the random k by k Latin Squares')
 3200 format (
     + 'Generating pseudo random numbers for experimental design'
     +/
     +/'Random integers from U(i,j)'
     +/'Specify integers i and j with i < j and this option generates'
     +/'random integers from a uniform distribution on (i,j).'
     +/
     +/'Random numbers from U(x,y)'
     +/'Specify numbers x and y with x < y and this option generates'
     +/'random numbers from a uniform distribution on (x,y).'
     +/
     +/'Random numbers from N(mu,sigma^2)'
     +/'Specify numbers mu and sigma^2 and this option generates random'
     +/'numbers from a normal distribution on (mu,sigma^2).'
     +/
     +/'Random permutations of (1,n)'
     +/'Specify n > 1 and this option generates random permutations on'
     +/'the integer vector 1, 2, ..., n'
     +/
     +/'Random k by k Latin Squares'
     +/'Specify k > 1 and this option generates random Latin Squares'
     +/
     +/'Note: Simfit program RANNUM has many additional functions')
      end
c
c
