c
c

      subroutine ranlat (latin, ncmax, nlatin,
     +                   abort)
c
c action: generate a random latin square
c author: w.g.bardsley, university of manchester, u.k., 16/05/2003
c         01/10/2007 added intents
c
c         Note: there must be a previous call to g05ccf$ to set the seed
c         ncmax = array dimension for latin (INPUT: unchanged)
c         nlatin = size of latin square required (INPUT: unchanged)
c         latin = the latin square (OUTPUT)
c         abort = .true. on failure o/w returned as .false. (OUTPUT)
c
c         This version creates a stepwise shifted starting matrix then
c         permutes the rows and columns twice in succession following
c         D.R.Cox in Planning of Experiments Wiley, 1958, p205
c         ranseq generates a random permutation of nseq of length n
c
      implicit   none
c
c arguments
c      
      integer, intent (in)  :: ncmax, nlatin 
      integer, intent (out) :: latin(ncmax,ncmax)
      logical, intent (out) :: abort
c
c locals
c      
      integer    i, j, k, n
      integer    nmax
      parameter (nmax = 1000)
      integer    nseq(nmax), ntemp(nmax,nmax)
      external   ranseq
      
c
c check input parameters
c
      abort = .true.
      if (ncmax.gt.nmax .or. nlatin.lt.3) return
c
c define n
c
      n = nlatin
      if (n.eq.4) then
c
c special action if nlatin = 4
c
         do j = 1, n
            latin(1,j) = j
         enddo
         do i = 2, n
            latin(i,1) = i
         enddo
         call ranseq (n, nseq, abort)
         if (abort) return
         if (nseq(1).eq.1) then
            latin(2,2) = 1
            latin(2,3) = 4
            latin(2,4) = 3
            latin(3,2) = 4
            latin(3,3) = 2
            latin(3,4) = 1
            latin(4,2) = 3
            latin(4,3) = 1
            latin(4,4) = 2
         elseif (nseq(1).eq.2) then
            latin(2,2) = 3
            latin(2,3) = 4
            latin(2,4) = 1
            latin(3,2) = 4
            latin(3,3) = 1
            latin(3,4) = 2
            latin(4,2) = 1
            latin(4,3) = 2
            latin(4,4) = 3
         elseif (nseq(1).eq.3) then
            latin(2,2) = 4
            latin(2,3) = 1
            latin(2,4) = 3
            latin(3,2) = 1
            latin(3,3) = 4
            latin(3,4) = 2
            latin(4,2) = 3
            latin(4,3) = 2
            latin(4,4) = 1
         else
            latin(2,2) = 1
            latin(2,3) = 4
            latin(2,4) = 3
            latin(3,2) = 4
            latin(3,3) = 1
            latin(3,4) = 2
            latin(4,2) = 3
            latin(4,3) = 2
            latin(4,4) = 1
         endif
      else
c
c initialise latin by sliding rows along one cell at a time
c
         do i = 1, n
            k = i - 1
            do j = 1, n
               k = k + 1
               if (k.gt.n) k = 1
               latin(i,j) = k
            enddo
         enddo
      endif
c
c generate a permutation vector
c
      call ranseq (n, nseq, abort)
      if (abort) return
c
c write permuted columns to ntemp
c
      do j = 1, n
         k = nseq(j)
         do i = 1, n
            ntemp(i,j) = latin(i,k)
         enddo
      enddo
c
c generate another permutation vector
c
      call ranseq (n, nseq, abort)
      if (abort) return
c
c write permuted rows to latin
c
      do i = 1, n
         k = nseq(i)
         do j = 1, n
            latin(i,j) = ntemp(k,j)
         enddo
      enddo
c
c generate another permutation vector
c
      call ranseq (n, nseq, abort)
      if (abort) return
c
c write permuted columns to ntemp
c
      do j = 1, n
         k = nseq(j)
         do i = 1, n
            ntemp(i,j) = latin(i,k)
         enddo
      enddo
c
c generate yet another permutation vector
c
      call ranseq (n, nseq, abort)
      if (abort) return
c
c write permuted rows to latin
c
      do i = 1, n
         k = nseq(i)
         do j = 1, n
            latin(i,j) = ntemp(k,j)
         enddo
      enddo
      abort = .false.
      end
c
c
