c
c     
       subroutine ranmat 
c
c action: generate random matrices
c author: w.g.bardsley, university of manchester, u.k., 26/05/2006
c         02/08/2006 added facility for MANOVA Poisson and binomial matrices
c         17/10/2006 added ymdhms to be called with argument info(1)
c         01/10/2007 added begin{values} ...end{values} to MANOVA files
c         05/12/2011 corrected error with binomial reference vector
c         27/09/2012 replaced call to g05ccf$ by call to rseeds
c
       implicit   none
c
c local allocatable arrays
c
      double precision, allocatable :: r(:), x(:,:), xmu(:), xsig(:)
c
c locals
c
      integer    i, ierr, j, jseed, k, ktype, l, ncmax, ncols, nrmax,
     +           nrows, nout
      integer    isend, jsend, numdec, numopt, nsmall, ntext, ntype
      parameter (isend = 0, jsend = 1, numopt = 14, nsmall = 1,
     +           ntext = 23, ntype = 3)
      integer    iadd1, ifail, ng, numbld(ntext) 
      integer    nbinom, ngmin, ngmax, ngtop, nr, ntemp
      parameter (ngmin = 2, ngmax = 100) 
      integer    g05eyf$
      double precision a, amu, asig, b, bmu, bsig
      double precision pbinom, pmu, qmu, t 
      double precision atemp, btemp, dn
      double precision zero, one, two, ten, epsi, half
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00, 
     +           ten = 10.0d+00, epsi = 0.001d+00, half = 0.5d+00)
      double precision g05ddf$, g05daf$
      character  text(30)*100, line*100, title*80, word20*20
      character (len = 12) colnum, form12, word12, rownum
      character (len = 7) word7
      character  fname*1024, info(nsmall)*32
      logical    manova, ok, repeet
      logical    abort, header, qtext, qtitle
      parameter (header = .true., qtext = .false., qtitle = .false.) 
      external   getnou, getjge, getdg2, listbx, putfat, putadv, viewit,
     +           matout, patch2, getjm1, getdm1, i1file, triml1, ymdhms,
     +           fnames, form12     
      external   g05ddf$, g05daf$, g05ecf$, g05eyf$, g05edf$, rseeds
      intrinsic  min, dble, sqrt
      save       amu, asig, bmu, bsig
      save       pbinom, pmu, qmu
      save       ncols, nrows 
      save       nbinom
      data       amu, asig, bmu, bsig / zero, one, one, two /
      data       pbinom, pmu, qmu / half, one, ten /
      data       ncols, nrows / 5, 20 / 
      data       nbinom / 10 /
      data       numbld / ntext*0 /
c
c random seed
c        
      call rseeds (isend, jseed, ktype)
c
c main loop
c     
      word12 = form12(nbinom)
      k = len_trim(word12) 
      write (word7,'(f7.4)') pbinom
      word20 = word12(1:k)//','//word7                
      call triml1 (word20)
      manova = .false.
      ok = .false.
      repeet = .true.
      do while (repeet)     
         colnum = form12(ncols)
         rownum = form12(nrows)
         write (text,100) rownum, colnum, amu, bmu, asig, bsig, pmu,
     +                    qmu, word20     
         numdec = numopt - 1
         call listbx (numdec, numopt,
     +                text)       
         if (numdec.eq.8) then    
c
c check if MANOVA data generation is possible
c         
            ng = nrows/ncols
            if (ng.lt.2) then   
               write (line,200)
               call putfat (line)
               numdec = 1  
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: choose number of rows
c           
            ok = .false.
            write (line,300) 'rows'
            i = 2
            call getjge (nrows, i,
     +                   line)
         elseif (numdec.eq.2) then
c
c numdec = 2: choose number of columns
c         
            ok = .false.
            write (line,300) 'columns'
            i = 2
            call getjge (ncols, i,
     +                   line)
         elseif (numdec.eq.3) then
c
c numdec = 3: choose B >= A
c         
            ok = .false.
            write (line,400)
            call getdg2 (amu, bmu,
     +                   line)
         elseif (numdec.eq.4) then
c
c numdec = 4: choose D >= C > 0
c         
            ok = .false.
            write (line,500)
            atemp = asig
            btemp = bsig
            call getdg2 (atemp, btemp,
     +                   line)
            if (atemp.le.epsi) then
               write (line,600)
               call putfat (line)
            else
               asig = atemp
               bsig = btemp
            endif  
         elseif (numdec.eq.5) then
c
c numdec = 5: choose P >= Q >= 0
c         
            ok = .false. 
            atemp = pmu
            btemp = qmu
            write (line,700)
            call getdg2 (atemp, btemp,
     +                   line)
            if (atemp.ge.zero) then
               pmu = atemp
               qmu = btemp
            else
               write (line,800)
               call putfat (line)
            endif       
         elseif (numdec.eq.6) then   
c
c numdec = 6: choose N, p
c             
            ntemp = 3    
            call getjge (nbinom, ntemp,
     +                   'binomial N')
            atemp = epsi
            btemp = one - epsi
            call getdm1 (atemp, pbinom, btemp,
     +                   'binomial p')
            write (word20,'(i10,'','',f7.4)') nbinom, pbinom 
            call triml1 (word20)   
         elseif (numdec.ge.7 .and. numdec.le.10) then
c
c numdec = 7, 8, 9 or 10: allocate then generate
c                         
            ok = .false.            
            manova = .false.
            if (numdec.eq.7 .or. numdec.eq.9) then
               ncmax = ncols
            elseif (numdec.eq.8) then 
               manova = .true.  
               ncmax = ncols + 1
             elseif (numdec.eq.10) then
               ncmax = 2    
            endif      
            nrmax = nrows
            ierr = 0               
            if (allocated(x)) deallocate(x, stat = ierr)
            if (ierr.ne.0) return
            allocate(x(nrmax,ncmax), stat = ierr)
            if (ierr.ne.0) return
            if (numdec.ge.7 .and. numdec.le.8) then 
c
c ANOVA and MANOVA
c           
               if (allocated(xmu)) deallocate(xmu, stat = ierr)
               if (ierr.ne.0) return
               if (allocated(xsig)) deallocate(xsig, stat = ierr)
               if (ierr.ne.0) return
               allocate(xmu(ncols), stat = ierr)
               if (ierr.ne.0) return
               allocate(xsig(ncols), stat = ierr)
               if (ierr.ne.0) return  
               do i = 1, ncols
                  xmu(i) = g05daf$(amu,bmu)
                  xsig(i) = g05daf$(asig,bsig)
               enddo
               do j = 1, ncols
                  a = xmu(j)
                  b = xsig(j)
                  do i = 1, nrows
                     x(i,j) = g05ddf$(a, b)
                  enddo
               enddo    
               ok = .true.
            elseif (numdec.eq.9) then
c
c contingency table
c                        
               if (allocated(xmu)) deallocate(xmu, stat = ierr)
               if (ierr.ne.0) return
               allocate(xmu(ncols), stat = ierr)
               if (ierr.ne.0) return
               do i = 1, ncols
                  xmu(i) = g05daf$(pmu,qmu)
               enddo    
               do j = 1, ncols 
                  t = xmu(j)
                  nr = 30 + 20*nint(sqrt(t))
                  if (allocated(r)) deallocate(r, stat = ierr)
                  if (ierr.ne.0) return
                  allocate(r(nr), stat = ierr)
                  if (ierr.ne.0) return 
                  ifail = 0
                  call g05ecf$(t, r, nr, ifail)
                  if (ifail.eq.0) then
                     do i = 1, nrows                         
                        x(i,j) = dble(g05eyf$(r, nr))
                     enddo
                     ok = .true.
                  endif   
               enddo
            elseif (numdec.eq.10) then
c
c analysis of proportions
c            
               dn = dble(nbinom)
               t = dn*pbinom*(one - pbinom)
               nr = 30 + 20*nint(sqrt(t))
               if (allocated(r)) deallocate(r, stat = ierr)
               if (ierr.ne.0) return
               allocate(r(nr), stat = ierr) 
               if (ierr.ne.0) return
               ifail = 1
               call g05edf$(nbinom, pbinom, r, nr, ifail)
               if (ifail.eq.0) then
                  do i = 1, nrows                         
                     x(i,1) = dble(g05eyf$(r, nr))
                     x(i,2) = dn
                  enddo
                  ok = .true.
               endif   
            endif 
            if (manova) then
c
c add a first column for MANOVA data
c            
               ngtop = nrows/ncols 
               ng = min(ngtop,ngmax)
               if (ng.gt.ngmin) then 
                  write (line,300) 'groups'
                  call getjm1 (ngmin, ng, ngtop,
     +                         line)
               endif
               do j = ncols, 1, -1 
                  k = j + 1
                  do i = 1, nrows
                     x(i,k) = x(i,j)
                  enddo
               enddo 
               ntemp = nrows/ng
               k = 0   
               l = 0
               do j = 1, ng 
                  k = k + 1
                  do i = 1, ntemp
                     l = l + 1
                     x(l,1) = k
                  enddo 
               enddo  
               if (l.lt.nrows) then
                  do i = l + 1, nrows
                     x(i,1) = k
                  enddo
               endif            
            endif
            if (ok) then
               write (line,900)
               call putadv (line)
               if (numdec.ge.7 .and.numdec.le.8) then
                  write (title,1000) amu, bmu, asig, bsig
               elseif (numdec.eq.9) then
                  write (title,1100) pmu, qmu
               elseif (numdec.eq.10) then
                  write (title,1200) word20   
               endif   
            else
               write (line,1300)
               call putfat (line)   
            endif         
         elseif (numdec.eq.11) then
c
c numdec = 11: view
c         
            if (ok) then  
               call viewit (ncmax, nrmax, nrmax, ntype,
     +                      x,
     +                      title)
            else
               write (line,1400)
               call putfat (line)
            endif                  
         elseif (numdec.eq.12) then
c
c numdec = 12: save to file using curent title for header and ymdhms for trailer
c         
            if (ok) then
               call ymdhms (info(1))
               call getnou (nout)
               close (unit = nout)
               call matout (jsend, ncmax, nout, nrmax, nrmax, nsmall,
     +                      x, 
     +                      fname, info, title,
     +                      abort, header, qtext, qtitle)                  
               close (unit = nout)
               if (manova .and. .not.abort) then  
c
c add group means to the file
c               
                  if (allocated(r)) deallocate(r, stat = ierr)
                  if (ierr.ne.0) return
                  allocate(r(ncols), stat = ierr)
                  if (ierr.ne.0) return
                  open (unit = nout, file = fname)
                  read (nout,'(a)') line
                  read (nout,*) i, j
                  do i = 1, nrows
                     read (nout,*) (dn, j = 1, ncmax)
                  enddo                
                  ntemp = ng + 3
                  call i1file (nout, ntemp) 
                  iadd1 = 0
                  ntemp = nrows/ng
                  write (nout,'(a)') 'begin{values}'
                  do i = 1, ng 
                     if (i.lt.ng) then  
                        l = ntemp
                     else
                        l = nrows - (ng - 1)*ntemp   
                     endif 
                     do j = 1, ncmax - 1 
                        r(j) = zero
                     enddo 
                     do k = 1, l
                        iadd1 = iadd1 + 1
                        do j = 1, ncmax - 1
                           r(j) = r(j) + x(iadd1,j + 1) 
                        enddo 
                     enddo
                     dn = dble(l)    
                     do j = 1, ncmax - 1
                        r(j) = r(j)/dn
                     enddo   
                     write (nout,'(1p,50e13.5)')(r(j), j = 1, ncmax - 1)
                  enddo  
                  write (nout,'(a)') 'end{values}'          
                  write (nout,1500) ng
                  close (unit = nout)  
               endif
               i = 2
               call fnames(i,
     +                     fname)  
            else
               write (line,1400)
               call putfat (line)
            endif   
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c         
            write (text,1600)   
            numbld(1) = 1 
            numbld(8) = 1
            numbld(14) = 1
            numbld(19) = 1
            call patch2 (numbld, ntext,
     +                   text)
            numbld(1) = 0 
            numbld(8) = 0
            numbld(14) = 0
            numbld(19) = 0            
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: done
c         
            repeet = .false.
         endif
      enddo
c
c deallocate workspaces
c                       
      deallocate(r, stat = ierr)
      deallocate(x, stat = ierr)
      deallocate(xmu, stat = ierr)
      deallocate(xsig, stat = ierr)
c
c format statements
c
  100 format (
     + 'Change: number of rows      `Current value:',1x,a
     +/'Change: number of columns   `Current value:',1x,a
     +/'Change: range for mu        `Current A,B:',1p,e10.2,',',e10.2
     +/'Change: range for sigma     `Current C,D:',1p,e9.2,',',e9.2   
     +/'Change: range for lambda    `Current P,Q:',1p,e9.2,',',e9.2
     +/'Change: binomial parameters `Current N,p:',1x,a
     +/'Generate: ANOVA-type matrix `Normally distributed'
     +/'Generate: MANOVA-type matrix`Classified into groups' 
     +/'Generate: contingency table `Poisson distribution'   
     +/'Generate: proportions       `Binomial distribution'
     +/'View                        `Inspect data '
     +/'Save As ...                 `Create data file'
     +/'Help                        `Details'
     +/'Quit                        `Exit random matrix options')
  200 format ('MANOVA matrix must have no. rows >= twice no. columns')
  300 format ('No. of',1x,a,1x,'required (>= 2)')
  400 format ('Range [A,B] required for mu (B >= A)')
  500 format ('Range [C,D] required for sigma (D >= C > 0)')
  600 format ('Must have sigma > 0') 
  700 format ('Range [P,Q] required for lambda (Q >= P >= 0)')
  800 format ('Must have lambda >= 0')
  900 format ('A pseudo-random matrix has been generated')
 1000 format (
     +'Random matrix:',1p,e10.2,' =< mu =<',1p,e10.2,
     +',',1p,e9.2,' =< sigma =<',1p,e9.2)    
 1100 format (
     +'Random matrix:',1p,e10.2,' =< Poisson lambda =<',1p,e10.2)  
 1200 format ('Successes and no. of trials for binomial N,p =',1x,a)    
 1300 format ('Cannot generate the requested matrix')
 1400 format ('First generate a random matrix')
 1500 format (
     +'Column 1 defines groups, trailing',i4,1x,'lines are group means')
 1600 format (
     + 'Pseudo-random uncorrelated ANOVA-type matrices'
     +/'Each column j is normally distributed N(mu(j),sigma(j)^2),'
     +/'where the mu(j) are from a uniform distribution U(A,B) and'
     +/'the sigma(j) are from a uniform distribution U(C,D), C > 0.'
     +/'1-way ANOVA H0: corresponds to A = B and C = D, but these can'
     +/'also be used to demonstrate some multivariate techniques.'
     +/
     +/'Pseudo-random uncorrelated MANOVA-type matrices'
     +/'These are as ANOVA types, except that an additional column 1'
     +/'is added to indicate the group, and a matrix of group means is'
     +/'appended to any data file created, in case you want to use it'
     +/'to demonstrate the assignment of extra observations to groups.'
     +/
     +/'Pseudo-random uncorrelated contigency tables'
     +/'Each column j is Poisson distributed with mean lambda(j)) where'
     +/'the lambda(j) are from a uniform distribution U(P,Q), P >= 0.'
     +/'These can be used for chi-square tests or log-linear analysis.'
     +/
     +/'Pseudo-random binomial samples' 
     +/'Each row is a simulated binomial experiment with x successes in'
     +/'N trials, i.e. x is distributed b(N,p), N > 0, 0 =< p =< 1'
     +/'These can be used to demonstrate analysis of proportions and'
     +/'also meta analysis if the number of rows is even.')
      end
c
c
