c
c
      subroutine ranseq (n, nseq, abort)
c
c action: generate a random permutation of integers 1 to n
c author: w.g.bardsley, university of manchester, u.k., 16/05/2003
c         01/10/2007 now calls G05EHF$
c         27/09/2012 added call to rseeds
c
c         G05CBF or G05CCF must be called before this routine is called
c         n = length of permutation sequence required (unchanged)
c         nseq = returned with the permuted sequence
c         abort = .false. if successful
c
      implicit   none
c
c arguments
c      
      integer, intent (in)  :: n
      integer, intent (out) :: nseq(n)
      logical, intent (out) :: abort
c
c locals
c      
      integer    i, ifail, jseed, ktype
      integer    isend
      parameter (isend = 0)
      external   g05ehf$, rseeds
c
c check
c
      abort = .false.
      if (n.lt.1) then
         abort = .true.
         return
      elseif (n.eq.1) then
         nseq(1) = 1
         return
      else
         call rseeds (isend, jseed, ktype)
         do i = 1, n
            nseq(i) = i
         enddo    
         ifail = 1
         call g05ehf$(nseq, n, ifail)   
         if (ifail.ne.0) abort = .true.
      endif
      end
c
c
