c
c
      subroutine regran (icen, irank, isz, iwa, lwork, ncmax, ncol, nin,
     +                   nout, nv, nrmax, nrow, nwmax,
     +                   a, eta, parest, parvar, vapvec, x, y, work,
     +                   zin,
     +                   fnamea, titlea,
     +                   newdat, supply)
c
c action: regression on ranks using G08RAF and G08RBF
c author: w.g.bardsley, university of manchester, u.k., 16/11/2005
c         31/11/2005 allowed for isx editing and special case of nvar = 1
c         24/07/2006 introduced fnamea, titlea, newdat, and supply
c
c ncmax: (input/unchanged) dimension
c  ncol: supply = .true. (input/unchanged) o/w (output)
c   nin: (input/unchanged) unconnected unit for data input
c  nout: (input/unchanged) preconnected unit for results
c nrmax: (input/unchanged) dimension
c  nrow: supply = .true. (input/unchanged) o/w (output)
c nwmax: (input/unchanged) dimension
c        Note: nwmax must be >= nrmax*(nrmax + 1)/2 and
c              lwork >= nrmax*(ncmax + 1) for the largest
c              possible data set
c fnamea: supply = .true. (input/unchanged) o/w (output)
c newdat: (output)
c supply: (input/unchanged)
c
c All other arguments are workspaces if supply = .false., but
c if supply = .true. then the data file and dimensions are supplied
c
c
c
      implicit none
c
c arguments
c
      integer lwork, ncmax, ncol, nin, nout, nrmax, nrow, nwmax
      integer icen(nrmax), irank(nrmax), isz(ncmax), iwa(4*nrmax),
     +        nv(nrmax)
      double precision a(nrmax,ncmax), eta(nrmax), parest(4*ncmax + 1),
     +                 parvar(nrmax,ncmax), vapvec(nwmax),
     +                 x(nrmax,ncmax), y(nrmax), work(lwork),
     +                 zin(nrmax)
      character fnamea*(*), titlea*(*)
      logical   newdat, supply
c
c locals
c
      integer    mark20, nvmax, nxmin
      parameter (mark20 = 20, nvmax = 100, nxmin = 1)
      integer    iszsav(nvmax)
      integer    ntype, numdist, numopt, numsta, numtxt
      parameter (ntype = 3, numdist = 4, numopt = 7, numsta = 9,
     +           numtxt = numopt + numsta - 1)
      integer    numbld(30)
      integer    icount, idist, isend, m, n, nmax, nsum, numdec, nvar
      integer    i, ifail, j, k, l, ns
      double precision tol, x02ajf$, g01eaf$, g01ecf$
      double precision chisq, df, gamma, prob, zval
      double precision zero, one, pnt05, pnt1, pnt2
      parameter (zero = 0.0d+00, one = 1.0d+00, pnt05 = 0.05d+00,
     +           pnt1 = 0.1d+00, pnt2 = 0.2d+00)
      double precision gamhi, gamlow
      parameter (gamhi = 100.0d+00, gamlow = 0.00001d+00)
      character  fname*1024, header*100, line*100, text(30)*100,
     +           title*80
      character  fname1*80, stars*3, title1*80
      character  chop80*80, trim80*80
      character  nodata*20, nofile*20, novars*20
      parameter (nodata = 'No data',
     +           nofile = 'No file',
     +           novars = 'No variables')
      character  dist(numdist)*30
      character  blank*1
      parameter (blank = ' ')
      logical    abort, again, fileit, fitted, ready, repeet, showit
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      logical    censor, done1, done2, tpos
      parameter (tpos = .false.)
      external   coxdat, lstbox, mattin, putadv, putfat, chknag, isitmf,
     +           chop80, trim80, putifa, isxvec, isxtyp, table1, revpro,
     +           isxedi, patch2, isxdat, listbx, getdge, dsplay, getl01
      external   g08raf$, g08rbf$, x02ajf$, g01ecf$, g01eaf$
      intrinsic  dble, sqrt, min
      save       icount, iszsav
      save       idist, gamma
      data       icount, iszsav / 0, nvmax*1 /
      data       idist, gamma / 1, one /
      data       numbld / 30*0 /
      data       dist / 'Error: Normal',
     +                  'Error: Logistic',
     +                  'Error: Extreme value',
     +                  'Error: Double-exponential' /
c
c check
c
      call chknag (mark20,
     +             abort)
      if (abort) return
c
c initialise
c
      newdat = .false.
      tol = sqrt(x02ajf$())
      fitted = .false.
      ready = .false.
      done1 = .true.
      done2 = .true.
      if (supply) then
c
c Check the data file supplied if supply = .true.
c
         call isitmf (m, n,
     +                fnamea)
         if (m.ne.ncol .or. n.ne.nrow) then
            call putfat (
     +'File not formatted correctly ... see g08raf.tf1')
            return
         elseif (m.lt.4 .or. n.lt.2) then
            call putfat (
     +'Must have columns >= 4, rows >= 2 ... see g08raf.tf1')
            return
         elseif (n*(n + 1)/2.gt.nwmax .or.
     +           n*(m + 1).gt.lwork) then
            call putfat (
     +'Insufficient workspace in call to REGRAN')
            return
         else
            fname = fnamea
            title = titlea
            open (unit = nin, file = fnamea)
            read (nin,'(a)') title
            read (nin,*) n, m
            do i = 1, n
               read(nin,*) (a(i,j), j = 1, m)
            enddo
         endif
         close (unit = nin)
c
c transform data into Cox regression format but where t can be negative
c
         call coxdat (icen, irank, nrmax, m, nrmax, n, ncmax, nin,
     +                nrmax, ns,
     +                a, y, x,
     +                fname, title,
     +                abort, tpos)
         if (abort) then
            call putfat (title)
            return
         else
c
c data ok
c
            done1 = .true.
            done2 = .true.
            ready = .true.
            fname1 = trim80(fname)
            title1 = chop80(title)
            icount = icount + 1
            write (nout,700) icount, fname1, title1
            if (ns.gt.1) then
c
c more than 1 stratum so rearrange data and store in array a in correct order
c
               do i = 1, n
                  work(i) = y(i)
               enddo
               i = 0
               do l = 1, ns
                  nv(l) = 0
                  do k = 1, n
                     if (irank(k).eq.l) then
                        nv(l) = nv(l) + 1
                        i = i + 1
                        do j = 1, m
                           a(i,j) = x(k,j)
                        enddo
                        y(i) = work(k)
                     endif
                  enddo
               enddo
               nmax = nv(1)
               do i = 2, ns
                  if (nv(i).gt.nmax) nmax = nv(i)
               enddo
            else
c
c only 1 stratum
c
               ns = 1
               nv(1) = n
               nmax = nv(1)
            endif
c
c check to see if censoring required
c
            censor = .false.
            i = 0
            do while (i.lt.n .and. .not.censor)
               i = i + 1
               if (icen(i).eq.1) censor = .true.
            enddo
c
c work out nsum
c
            nsum = 0
            do i = 1, ns
               nsum = nsum + nv(i)
            enddo
            if (nsum.ne.n) then
               write (line,400)
               call putfat (line)
               ready = .false.
            endif
            numdec = 2
         endif
         nvar = m - 3
      else
         m = 0
         n = 0
         nvar = 0
         fname1 = nofile
         title1 = nodata
      endif
      numdec = numopt - 1
      header = novars
      repeet = .true.
c
c initialise isz
c
      do i = 1, ncmax
         if (i.le.nvmax) then
            isz(i) = iszsav(i)
         else
            isz(i) = 1
         endif
      enddo
c
c main menu
c
      do while (repeet)
         if (numdec.eq.0) numdec = 1
         if (m.gt.0) then
c
c set up header and showit if data are present
c
            call isxvec (isz, m, nvar, nxmin)
            call isxtyp (isz, m, nvar, nxmin,
     +                   header,
     +                   showit)
         else
c
c otherwise display novars
c
            header = novars
            showit = .false.
         endif
         write (text,100) fname1, title1, header
         numbld(1) = 1
         numbld(4) = 1
         numbld(6) = 1
         numbld(8) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(4) = 0
         numbld(6) = 0
         numbld(8) = 0
c
c check numdec
c
         if (.not.ready) then
            if (numdec.ge.2 .and. numdec.le.4) then
               write (line,200)
               call putfat (line)
               numdec = 0
            endif
         endif
         if (.not.fitted) then
            if (numdec.eq.3) then
               write (line,300)
               call putfat (line)
               numdec = 0
            endif
         endif
         if (numdec.eq.1) then
c
c numdec = 1: input new data file
c ===========
c
            if (supply) then
               newdat = .true.
               do i = 1, min(ncmax,nvmax)
                  iszsav(i) = isz(i)
               enddo
               return
            endif
            done1 = .true.
            done2 = .true.
            ready = .false.
            fitted = .false.
            write (line,400)
            call putadv (line)
            close (unit = nin)
            isend = 2
            call mattin (isend, ncmax, m, nin, nrmax, n,
     +                   a, work,
     +                   fname, title,
     +                   abort, fixcol, fixrow, label)
            close (unit = nin)
            if (.not.abort) then
               if (m.lt.4 .or. n.lt.2) then
                  write (line,500)
                  call putfat (line)
                  abort = .true.
               elseif (n*(n + 1)/2.gt.nwmax .or.
     +                 n*(m + 1).gt.lwork) then
                  write (line,600)
                  call putfat (line)
                  abort = .true.
               endif
            endif
            if (.not.abort) then
c
c transform data into Cox regression format but where t can be negative
c
               call coxdat (icen, irank, nrmax, m, nrmax, n, ncmax, nin,
     +                      nrmax, ns,
     +                      a, y, x,
     +                      fname, title,
     +                      abort, tpos)
               if (abort) call putfat (title)
            endif
            if (abort) then
c
c data unacceptable
c
               ready = .false.
               m = 0
               n = 0
               fname1 = nofile
               title1 = nodata
               line = novars
               numdec = 1
            else
c
c data ok
c
               done1 = .true.
               done2 = .true.
               ready = .true.
               fname1 = trim80(fname)
               title1 = chop80(title)
               icount = icount + 1
               write (nout,700) icount, fname1, title1
               if (ns.gt.1) then
c
c more than 1 stratum so rearrange data and store in array a in correct order
c
                  do i = 1, n
                     work(i) = y(i)
                  enddo
                  i = 0
                  do l = 1, ns
                     nv(l) = 0
                     do k = 1, n
                        if (irank(k).eq.l) then
                           nv(l) = nv(l) + 1
                           i = i + 1
                           do j = 1, m
                              a(i,j) = x(k,j)
                           enddo
                           y(i) = work(k)
                        endif
                     enddo
                  enddo
                  nmax = nv(1)
                  do i = 2, ns
                     if (nv(i).gt.nmax) nmax = nv(i)
                  enddo
               else
c
c only 1 stratum
c
                  ns = 1
                  nv(1) = n
                  nmax = nv(1)
               endif
c
c check to see if censoring required
c
               censor = .false.
               i = 0
               do while (i.lt.n .and. .not.censor)
                  i = i + 1
                  if (icen(i).eq.1) censor = .true.
               enddo
c
c work out nsum
c
               nsum = 0
               do i = 1, ns
                  nsum = nsum + nv(i)
               enddo
               if (nsum.ne.n) then
                  write (line,400)
                  call putfat (line)
                  ready = .false.
               endif
               numdec = 2
            endif
         elseif (numdec.eq.2) then
c
c numdec = 2: fit
c ===========
c
            numdec = 1
            done1 = .true.
            done2 = .true.
            fitted = .false.
c
c copy data from a into x
c
            do j = 1, m
               do i = 1, n
                  x(i,j) = a(i,j)
               enddo
            enddo
            if (nvar.lt.m) then
c
c roll columns if any variables suppressed
c
               call isxdat (isz, m, nrmax, n,
     +                      x,
     +                      abort)
            else
               abort = .false.
            endif
            if (.not.abort) then
               ifail = 1
               if (.not.censor) then
c
c no censoring so call g08raf
c
                  call listbx (idist, numdist,
     +                         dist)
                  call g08raf$(ns, nv, nsum, y, nvar, x, nrmax, idist,
     +                         nmax, tol, parvar, nrmax, irank, zin,
     +                         eta, vapvec, parest, work, lwork, iwa,
     +                         ifail)
                  if (ifail.eq.0) then
c
c success so output results from g08raf
c
                     write (nout,'(a)') blank
                     if (showit) write (nout,'(a)') header
                     numdec = 3
                     done1 = .false.
                     done2 = .false.
                     fitted = .true.
                     chisq = parest(2*nvar + 1)
                     df = dble(nvar)
                     ifail = 1
                     prob = g01ecf$('U', chisq, df, ifail)
                     call putifa (ifail, nout, 'G01ECF/REGRAN')
                     write (text,800) ns, n, nvar, dist(idist),
     +                                chisq, nvar, prob
                     j = 15
                     call table1 (j, 'OPEN')
                     do i = 1, 7
                        if (i.eq.1 .or.i.eq.7) then
                           j = 4
                        else
                           j = 0
                        endif
                        call table1 (j, text(i))
                        write (nout,'(a)') text(i)
                     enddo
                     j = 0
                     k = 0
                     do i = 1, m
c
c loop over all variables
c
                        if (isz(i).ne.0) then
c
c but only output if isz(i) .ne.0
c
                           k = k + 1
                           zval = parest(3*nvar + 1 + k)
                           ifail = 1
                           prob = g01eaf$('S', zval, ifail)
                           call putifa (ifail, nout, 'G01EAF/REGRAN')
                           if (prob.gt.pnt2) then
                              stars = '***'
                           elseif (prob.gt.pnt1) then
                              stars = '**'
                           elseif (prob.gt.pnt05) then
                              stars = '*'
                           else
                              stars = blank
                           endif
                           write (line,900) i,
     +                                      parest(k),
     +                                      parest(nvar + k),
     +                                      parest(2*nvar + 1 + k),
     +                                      zval, prob, stars
                        call table1 (j,line)
                        write (nout,'(a)') line
                        endif
                     enddo
                     call table1 (j, 'CLOSE')
                  else
                     call putifa (ifail, nout, 'G08RAF/REGRAN')
                  endif
               else
c
c censoring so call g08rbf
c
                  write (line,1000)
                  call getdge (gamma, zero,
     +                         line)
                  if (gamma.lt.gamlow) then
                     gamma = gamlow
                  elseif (gamma.gt.gamhi) then
                     gamma = gamhi
                  endif
                  call g08rbf$(ns, nv, nsum, y, nvar, x, nrmax, icen,
     +                         gamma, nmax, tol, parvar, nrmax, irank,
     +                         zin, eta, vapvec, parest, work, lwork,
     +                         iwa, ifail)
                  if (ifail.eq.0) then
c
c success so output results from g08rbf
c
                     write (nout,'(a)') blank
                     if (showit) write (nout,'(a)') header
                     numdec = 3
                     done1 = .false.
                     done2 = .false.
                     fitted = .true.
                     chisq = parest(2*nvar + 1)
                     df = dble(nvar)
                     ifail = 1
                     prob = g01ecf$('U', chisq, df, ifail)
                     call putifa (ifail, nout, 'G01ECF/REGRAN')
                     write (text,1100) ns, n, nvar, gamma,
     +                                 chisq, nvar, prob
                     j = 15
                     call table1 (j, 'OPEN')
                     do i = 1, 7
                        if (i.eq.1 .or.i.eq.7) then
                           j = 4
                        else
                           j = 0
                        endif
                        call table1 (j, text(i))
                        write (nout,'(a)') text(i)
                     enddo
                     j = 0
                     k = 0
c
c loop over all variables
c
                     do i = 1, m
                        if (isz(i).ne.0) then
c
c but only output if isz(i).ne.0
c
                           k = k + 1
                           zval = parest(3*nvar + 1 + k)
                           ifail = 1
                           prob = g01eaf$('S', zval, ifail)
                           call putifa (ifail, nout, 'G01EAF/REGRAN')
                           if (prob.gt.pnt2) then
                              stars = '***'
                           elseif (prob.gt.pnt1) then
                              stars = '**'
                           elseif (prob.gt.pnt05) then
                              stars = '*'
                           else
                              stars = blank
                           endif
                           write (line,900) i,
     +                                      parest(k),
     +                                      parest(nvar + k),
     +                                      parest(2*nvar + 1 + k),
     +                                      zval, prob, stars
                           call table1 (j,line)
                           write (nout,'(a)') line
                        endif
                     enddo
                     call table1 (j, 'CLOSE')
                  else
                     call putifa (ifail, nout, 'G08RBF/REGRAN')
                  endif
               endif
            endif
          elseif (numdec.eq.3) then
c
c numdec = 3: covariance matrices, etc.
c ===========
c
            again = .true.
            write (text,1200)
            do while (again)
               k = 3
               call listbx (numdec, k,
     +                      text)
               if (numdec.eq.1) then
c
c covariance matrices
c
                  if (.not.done1) then
                     if (nvar.le.20) then
                        fileit = .true.
                     else
                        write (line,1300)
                        fileit = .false.
                        call getl01 (line, fileit)
                     endif
                  else
                     fileit = .false.
                  endif
                  if (fileit) write (nout,'(a)') blank
                  write (line,1400)
                  i = nvar + 1
                  call dsplay (ncmax, nvar, nout, nrmax, i, ntype,
     +                         parvar,
     +                         line,
     +                         fileit)
                  done1 = .true.
               elseif (numdec.eq.2) then
c
c ranks, g and g-prime
c
                  if (ns.ne.1) then
                     write (line,1500)
                     call putadv (line)
                  else
                     if (.not.done2) then
                        if (nmax.le.30) then
                           fileit = .true.
                        else
                           write (line,1300)
                           fileit = .false.
                           call getl01 (line, fileit)
                        endif
                     else
                        fileit = .false.
                     endif
                     j = 15
                     call table1 (j, 'OPEN')
                     write (line,1600)
                     j = 4
                     call table1 (j, line)
                     if (fileit) then
                        write (nout,'(a)') blank
                        write (nout,'(a)') line
                     endif
                     j = 0
                     do i = 1, nmax
                        write (line,1700) i, irank(i), zin(i), eta(i)
                        call table1 (j, line)
                        if (fileit) write (nout,'(a)') line
                     enddo
                     call table1 (j, 'CLOSE')
                     done2 = .true.
                  endif
               else
                  again = .false.
               endif
            enddo
            numdec = 1
         elseif (numdec.eq.4) then
c
c numdec = 4: suppress/restore variables
c ===========
c
            if (m.eq.1) then
               call putadv ('Cannot suppress 1 variable')
            else
               fitted = .false.
               call isxedi (isz, m, nvar, nxmin)
            endif
            numdec = 2
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: results
c ====================
c
            call revpro (nout)
            numdec = 1
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c ====================
c
            write (text,1800)
            j = 22
            numbld(1) = 1
            numbld(5) = 1
            numbld(8) = 1
            numbld(15) = 1
            numbld(19) = 1
            call patch 2 (numbld, j,
     +                    text)
            numbld(1) = 0
            numbld(5) = 0
            numbld(8) = 0
            numbld(15) = 0
            numbld(19) = 0
            numdec = 1
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            do i = 1, min(ncmax,nvmax)
               iszsav(i) = isz(i)
            enddo
            newdat = .false.
            repeet = .false.
         endif
      enddo
  100 format (
     + 'Regression on ranks'
     +/
     +/'Current data file:'
     +/a
     +/'Current data title:'
     +/a
     +/'Current variables:'
     +/a
     +/'Input a new data file'
     +/'Fit the current data'
     +/'Further analysis'
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit regression on ranks')
  200 format ('First input your data')
  300 format ('First fit the data')
  400 format ('Input a file formatted like g08raf.tf1: x1,...xm,y,t,s')
  500 format ('Data matrix must have at least 4 columns and 2 rows')
  600 format ('Insufficient workspace in call to REGRAN')
  700 format (
     +/'Regression on ranks data set',i4
     +/'File:',1x,a
     +/'Title:',1x,a)
  800 format (
     + 'Regression on ranks'
     +/'Number of samples =',i4
     +/'Sum of sample sizes =',i4
     +/'Number of parameters =',i4
     +/'Distribution =',1x,a
     +/'CTS =',1p,e11.3,', NDOF =',i4,', p = P(chi-sq >= CTS) =',0p,f7.4
     +/'Parameter      Score   Estimate   Std.Err.    z-value    p')
  900 format (i9,1p,4e11.3,0p,f8.4,2x,a)
 1000 format (
     +'Gamma required: 0 (extreme), 1 (logistic), >= 10 (exponential)')
 1100 format (
     + 'Regression on ranks'
     +/'Number of samples =',i4
     +/'Sum of sample sizes =',i4
     +/'Number of parameters =',i4
     +/'gamma =',1p,e11.3
     +/'CTS =',1p,e11.3,', NDOF =',i4,', p = P(chi-sq >= CTS) =',0p,f7.4
     +/'Parameter      Score   Estimate   Std.Err.    z-value    p')
 1200 format (
     + 'Display covariance matrices'
     +/'Display ranks, g and g-prime'
     +/'Cancel')
 1300 format (
     +'Also save this large results table to the results file')
 1400 format (
     +'CV matrices: upper triangle for scores, lower for parameters')
 1500 format ('Only available for 1 sample, i.e., no strata')
 1600 format (
     +'Observation  Rank        E(g)  E(g-prime)')
 1700 format (i11,i6,1p,2e12.3)
 1800 format (
     + 'Regression on ranks'
     +/
     +/'Data files can have cases arranged in any order but they must'
     +/'be formatted as x1, x2,..., xm, y, t, s, as follows.'
     +/'Columns 1 to m: the variables'
     +/'These must contain the covariates x(1) to x(m), where m >= 1.'
     +/
     +/'Column m + 1: the censorship indicator'
     +/'This must contain the indicator value y, defined as y = 0 if in'
     +/'range, or y = 1 if maximum, i.e. too large to measure. If all y'
     +/'are 0 the distribution can be selected, otherwise you set gamma'
     +/'0 < gamma < 100, where 0 = extreme value, 1 = logistic, and'
     +/'large values tend to the negative exponential distribution.'
     +/
     +/'Column m + 2: the observed value, e.g. time, weight, etc.'
     +/'This must be the value observed, or the upper limit if the true'
     +/'value may be larger, i.e., the observation is right censored.'
     +/
     +/'Column m + 3: the stratum indicator'
     +/'1 for cases in stratum 1, 2 for cases in stratum 2, etc. If'
     +/'there are no strata, set all values in the last column to 1.'
     +/'Test files: g08raf.tf1 (uncensored), g08rbf.tf1 (censored).')
      end
c
c
