c
c
      subroutine rob001 (iwrk, nin, nout, nrmax,
     +                   x, wrk)
c
c action: robust 1-sample calculations
c author: w.g.bardsley, university of manchester, u.k., 16/06/2004
c         13/07/2021 added E_NUMBERS and E_FORMATS, etc.
c
c          nin: (input/unchanged) unconnected unit for data input
c         nout: (input/unchanged) preconnected unit for results
c        nrmax: (input/unchanged) dimension
c         iwrk, x, wrk: workspaces
c
      implicit   none
c
c arguments
c
      integer    nin, nout, nrmax
      integer    iwrk(3*nrmax)
      double precision x(nrmax), wrk(4*nrmax)
c
c locals
c
      integer    i, icount, ifail1, ifail2, ifail3, isend, itemp, j, k,
     +n
      integer    icolor, ix, iy, lshade, numdec, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 6)
      integer    numbld(30), numpos(numopt)
      double precision alpha, pcent, used
      double precision xme, xmd, xsd
      double precision tmean, tvar, wmean, wvar
      double precision clevel, estcl, theta, thetal, thetau, wlower,
     +                 wupper
      double precision fbot, ftop, f100
      parameter (fbot = 0.0d+00, ftop = 49.9D+00, f100 = 100.0d+00)
      character  line*100, text(30)*100
      character  fname*1024, title*80
      character  chop80*80, word80*80
      character (len = 12) form12, word12(3) 
      character (len = 13) d13(8), showlj
      character  blank*1, method*1
      parameter (blank = ' ', method = 'E')
      logical    e_formats, e_numbers
      logical    abort, repeet
      logical    border, fixnpt, label
      parameter (border = .false., fixnpt = .false., label = .true.)
      external   e_formats, form12, showlj
      external   getdm1, chop80, vec1in, table1, lbox02, patch1, revpro,
     +           putfat, putifa
      external   g07daf$, g07ddf$, g07eaf$
      intrinsic  dble
      save       icount, clevel, pcent
      data       icount / 0 /
      data       clevel, pcent / 0.95d+00, 10.0d+00 /
      data       numbld / 30*0 /
      data       numpos / numopt*1 /
c
c initialise
c     
      e_numbers = e_formats()
      n = 0
      fname = blank
      word80 = blank
      numdec = numopt - 1
c
c main loop
c
      repeet = .true.
      do while (repeet)
         write (text,100) pcent
         call lbox02 (icolor, ix, iy, numdec, numopt, numpos, text)
         if (numdec.eq.1) then
c
c change pcent = 100*alpha
c
            write (line,200)
            call getdm1 (fbot, pcent, ftop, line)
            numdec = numopt - 1
         elseif (numdec.eq.2) then
c
c new data
c
            word80 = blank
            isend = 3
            close (unit = nin)
            call vec1in (isend, nin, nrmax, n,
     +                   x,
     +                   fname, title,
     +                   abort, fixnpt, label)
            close (unit = nin)
            if (abort .or. n.lt.2) then
               n = 0
               numdec = 2
            else
               word80 = chop80(title)
               numdec = 3
            endif
         elseif (numdec.eq.3) then
c
c analyse
c
            if (n.le.2) then
               write (line,300)
               call putfat (line)
               numdec = 2
            else
               alpha = pcent/f100
               ifail1 = 1
               ifail2 = 1
               ifail3 = 1
c
c call g07daf$
c
               call g07daf$(n, x, wrk, xme, xmd, xsd, ifail1)
               if (ifail1.eq.0) then
c
c call g07ddf$ only if call to g07daf$ was successful
c
                  call g07ddf$(n, x, alpha, tmean, wmean, tvar, wvar, k,
     +                         wrk, ifail2)
               endif
               if (ifail1.eq.0 .and. ifail2.eq.0) then
c
c call g07eaf$ only if calls to g07daf$ and g07ddf$ were successful
c
                  call g07eaf$(method, n, x, clevel, theta, thetal,
     +                         thetau, estcl, wlower, wupper, wrk, iwrk,
     +                         ifail3)
               endif
               if (ifail1.eq.0 .and. ifail2.eq.0 .and. ifail3.eq.0) then
c
c output the results
c
                  icount = icount + 1
                  used = f100*dble(n - 2*k)/dble(n)
                  if (e_numbers) then
                     write (text,400) icount, word80,
     +                      n, xme, xmd, xsd,
     +                      tmean, tvar,
     +                      wmean, wvar,
     +                      2*k, n - 2*k, used,
     +                      theta
                  else
                     word12(1) = form12(n)
                     itemp = 2*k
                     word12(2) = form12(itemp)
                     itemp = n - 2*k
                     word12(3) = form12(itemp)
                     d13(1) = showlj(xme)
                     d13(2) = showlj(xmd)
                     d13(3) = showlj(xsd)
                     d13(4) = showlj(tmean)
                     d13(5) = showlj(tvar)
                     d13(6) = showlj(wmean)
                     d13(7) = showlj(wvar)
                     d13(8) = showlj(theta)
                     write (text,450) icount, word80,
     +                                word12(1), d13(1), d13(2), d13(3),
     +                                d13(4), d13(5),
     +                                d13(6), d13(7),
     +                                word12(2), word12(3), used,
     +                                d13(8)
                  endif
                  j = 15
                  call table1 (j, 'OPEN')
                  write (nout,'(a)') blank
                  do i = 1, 15
                     if (i.eq.1) then
                        j = 4
                     elseif (i.eq.3) then
                        j = 1
                     else
                        j = 0
                     endif
                     write (nout,'(a)') text(i)
                     if (i.eq.2) text(i) = blank
                     call table1 (j, text(i))
                  enddo
                  call table1 (j, 'CLOSE')
               elseif (ifail1.ne.0) then
                  call putifa (ifail1, nout, 'G07DAF/ROB001')
               elseif (ifail2.ne.0) then
                  call putifa (ifail2, nout, 'G07DDF/ROB001')
               elseif (ifail3.ne.0) then
                  call putifa (ifail3, nout, 'G07EAF/ROB001')
               endif
               numdec = numopt - 2
            endif
         elseif (numdec.eq.numopt - 2) then
c
c results
c
            call revpro(nout)
            numdec = numopt - 1
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,500)
            numtxt = 20
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numdec = 2
         elseif (numdec.eq.numopt) then
c
c cancel
c
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Change percent (current =',f5.2,'%)'
     +/'New data'
     +/'Calculate'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit these robust analysis options')
  200 format ('Percentage of data to suppress at each extreme')
  300 format ('First input your data')
  400 format (
     + 'Robust 1-sample analysis no.',i4
     +/'--------------------------------'
     +/'Data:',1x,a
     +/'Total sample size            =',i8
     +/'Median value                 =',1p,e12.4
     +/'Median absolute deviation    =',   e12.4
     +/'Robust standard deviation    =',   e12.4
     +/'Trimmed mean (TM)            =',   e12.4
     +/'Variance estimate for TM     =',   e12.4
     +/'Winsorized mean (WM)         =',   e12.4
     +/'Variance estimate for WM     =',   e12.4
     +/'Number of discarded values   =',i8
     +/'Number of included values    =',i8
     +/'Percentage of sample used    =',0p,f8.2,'% (for TM and WM)'
     +/'Hodges-Lehmann estimate (HL) =',1p,e12.4)
  450 format (
     + 'Robust 1-sample analysis number',i4
     +/'-----------------------------------'
     +/'Data:',1x,a
     +/'Total sample size            =',1x,a
     +/'Median value                 =',1x,a
     +/'Median absolute deviation    =',1x,a
     +/'Robust standard deviation    =',1x,a
     +/'Trimmed mean (TM)            =',1x,a
     +/'Variance estimate for TM     =',1x,a
     +/'Winsorized mean (WM)         =',1x,a
     +/'Variance estimate for WM     =',1x,a
     +/'Number of discarded values   =',1x,a
     +/'Number of included values    =',1x,a
     +/'Percentage of sample used    =',f7.2,'% (for TM and WM)'
     +/'Hodges-Lehmann estimate (HL) =',1x,a)
     
  500 format (
     + 'Robust 1-sample analysis'
     +/
     +/'These techniques are used when your data set has outliers, i.e'
     +/'extreme values that are not typical of the distribution, and so'
     +/'would lead to biased parameter estimates. You supply a sample'
     +/'vector X, i.e. X = (x(1), x(2), ..., x(n)) where n >= 2.'
     +/
     +/'The median value is calculated along with the median absolute'
     +/'deviation and also a robust estimate for the sample standard'
     +/'deviation. This calculation uses the whole data set.'
     +/
     +/'Then you have to decide what percentage of the extreme values'
     +/'to reject. For instance, ten percent would lead to rejection'
     +/'of the lower ten percent and upper ten percent as potential'
     +/'outliers, i.e. twenty percent of the data would be rejected.'
     +/'From the remaining data the Trimmed and Winsorized means are'
     +/'then calculated, along with robust variance estimates.'
     +/
     +/'The Hodges-Lehmann location estimator and 95% confidence limits'
     +/'(using all n data values) are useful with symmetric densities.')
      end
c
c
