C
C
      SUBROUTINE ROB003 (ISX, NCMAX, NCOLS, NF, NRMAX, NROWS,
     +                   A1, A2, B, RES, S, SE, THEORY,
     +                   WK, WT, Y,
     +                   FNAME, TITLE)
C
C
C ACTION : Robust multilinear regression (M-estimates)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          18/06/2006 derived from LINEAR
C
C    ISX: (workspace) variables out (0) or in (1)
C  NCMAX: (input/unchanged) max. no. of columns
C  NCOLS: (input/unchanged) actual no. of columns
C     NF: (input/unchanged) preconnected unit for results
C  NRMAX: (input/unchanged) max. no. of rows
C  NROWS: (input/unchanged) actual no. of rows
C     A1: (input/unchanged) original data matrix ... this is never altered
C     A2: (workspace) current active copy of A1 made as required
C     A3: local allocated workspace
C     A4: local allocated workspace
C      B: (output) parameters
C    RES: (output) residuals
C      S: (output) singular values from SVD
C     SE: (output) parameter standard errors
C THEORY: (output) theoretical fit
C     WK: workspace, NWMAX >= NROWS + NCOLS*(NROWS + NCOLS)
C     WT: (output) weights from robust regression
C      Y: (output) original (active) Y-values
C  FNAME: (input/unchanged) data file
C  TITLE: (input/unchanged) title
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    NCMAX, NCOLS, NF, NRMAX, NROWS
      INTEGER    ISX(NCMAX)
      DOUBLE PRECISION A1(NRMAX,NCMAX), A2(NRMAX,NCMAX),
     +                 B(NCMAX), RES(NRMAX), S(NCMAX),
     +                 SE(NCMAX), THEORY(NRMAX),
     +                 WK(4*NRMAX + NCMAX*(NRMAX + NCMAX)), WT(NRMAX),
     +                 Y(NRMAX)
      CHARACTER  FNAME*(*), TITLE*(*)
C
C Allocatable local arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: A3(:,:), A4(:,:), CV(:,:), X(:,:)
C
C Locals
C
      INTEGER    I, IDF, IFAIL, IP, IRANK, J, K, M, N, NVAR, NDF0,
     +           NDF1, NDF2
      INTEGER    ICOUNT, IERR, LWORK, NCOL1, NIN, NROW1
      INTEGER    COLOUR
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, NXMIN
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, NXMIN = 1)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 10,
     +           NSTART = 14, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    NPAR1, NPTS1
      INTEGER    ISEND, ITYPE, LDA, MODE, NPAR, NPTS
      PARAMETER (ISEND = 2, ITYPE = 1)
      INTEGER    MARK20, NISX
      PARAMETER (MARK20 = 20, NISX = 100)
      INTEGER    ISXSAV(NISX)
      INTEGER    INDW, IPSI, ISIGMA, INDC, MAXIT, NITMON
      DOUBLE PRECISION XSAV(1,NISX), YPRED
      DOUBLE PRECISION CP, DF, FSTAT, PVAL, REGSSQ, RSQD, SIGMA,
     +                 SIGMA2, TEST, TNU, TOL, TSS, TVAL, UWTSSQ, VALUE,
     +                 WSSQ, YBAR
      DOUBLE PRECISION WSSQ1
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT05, PNT1, PNT2
      PARAMETER (PNT025 = 0.025D+00, PNT05 = 0.05D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION G01EBF$, X02AMF$, G01EDF$, G01FBF$
      DOUBLE PRECISION X2(N2), X3(N2), X4(N2)
      DOUBLE PRECISION Y2(N2), Y3(N2), Y4(N2)
      DOUBLE PRECISION CPSI, H1, H2, H3, CUCV, DCHI, TOL_1
      CHARACTER  CHOP60*60, TITLE1*60, TRIM60*60
      CHARACTER  T60*60, C60*60, TXT*100
      CHARACTER  TEXT(30)*100, LINE*100
      CHARACTER  CIPHER*4, LABELM*5, LABELW*5, MEAN*1
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
      CHARACTER  PTITLE*14, XTITLE*10, YTITLE*12
      PARAMETER (PTITLE = 'Residuals Plot', XTITLE = 'Best-Fit Y')
      LOGICAL    DISPLY, FILE1, SUPPLY
      PARAMETER (DISPLY = .FALSE., FILE1 = .FALSE., SUPPLY = .TRUE.)
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AXES, FILE, PRINT1
      PARAMETER (AXES = .TRUE., FILE = .TRUE., PRINT1 = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WTD
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WTD = .FALSE.)
      LOGICAL    ABORT, FITNOW, READY, showit
      LOGICAL    AGAIN1, AGAIN2, DONE1, DONE2
      EXTERNAL   PUTIFA, LBOX01, PUTFAT, TABLE1, PUTADV, PUTWAR, LBOX02,
     +           GETIM1, LINFIT, AXEQB2, GKS004, REVPRO, FTEST1, GETDGE,
     +           TRIM60, CHOP60, TTEST2, HNPLOT, PCVTST, EDITOR, ISXEDI,
     +           ISXTYP, ISXVEC, ROB004, CHKNAG
      EXTERNAL   G01EBF$, X02AMF$, G01EDF$, G01FBF$, G02HAF$
      INTRINSIC  ABS, DBLE, SQRT, MIN
      SAVE       ICOUNT, ISXSAV
      SAVE       XSAV
      DATA       ICOUNT / 0 /
      DATA       ISXSAV / NISX*1 /
      DATA       XSAV / NISX*ONE /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /

C
C Part 1: Check input data
C ========================
C
      IF (NCOLS.GT.NCMAX) THEN
         CALL PUTFAT ('Column dimension exceeded in call to LINEAR')
         RETURN
      ENDIF
      IF (NCOLS.LT.N3) THEN
         CALL PUTFAT ('Must have at least 3 columns: e.g. x, y, and s')
         RETURN
      ENDIF
      IF (NROWS.GT.NRMAX) THEN
         CALL PUTFAT ('Row dimension exceeded in call to LINEAR')
         RETURN
      ENDIF
      IF (NROWS.LE.NCOLS - 2) THEN
         CALL PUTFAT ('Must have more y-values than variables')
         RETURN
      ENDIF
C
C Check for NAG library
C
      CALL CHKNAG (MARK20, ABORT)
      IF (ABORT) RETURN
C
C Allocate workspace
C
      IERR = 0
      IF (ALLOCATED(A3)) DEALLOCATE(A3, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(A4)) DEALLOCATE(A4, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(CV)) DEALLOCATE(CV, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(A3(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(A4(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      LDA = NCMAX
      ALLOCATE(CV(LDA,LDA), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (X(N1,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Initialise
C
      TOL = 1.0D+09*X02AMF$()
      MODE = N3
      NPAR = N0
      NPAR1 = N0
      NPTS = N0
      NPTS1 = N0
      WSSQ1 = - ONE
      LABELW = ' [No]'
C
C Initialise the G02HAF control parameters
C
      ICOUNT = ICOUNT + N1
      CALL ROB004 (INDW, IPSI, ISIGMA, INDC, MAXIT, NITMON,
     +             ICOUNT, NF,
     +             CPSI, H1, H2, H3, CUCV, DCHI, TOL_1)
C
C Initialise elements of ISX ... M = total number of variables
C
      M = NCOLS - N2
      DO I = N1, M
         IF (I.LE.NISX) THEN
            ISX(I) = ISXSAV(I)
         ELSE
            ISX(I) = N1
         ENDIF
      ENDDO
      ISX(M + N1) = N0
C
C Initialise X
C
      DO I = N1, M
         IF (I.LE.NISX) THEN
            X(1,I) = XSAV(1,I)
         ELSE
            X(1,I) = ONE
         ENDIF
      ENDDO
C
C Define N and assign data to array A2 ... include a first column of 1
C for the constant term X = 1
C
      N = N0
      K = NCOLS - N1
      DO I = N1, NROWS
         VALUE = A1(I,NCOLS)
         IF (VALUE.GT.TOL) THEN
            N = N + N1
            A2(N,N1) = ONE
            DO J = N1, M
               A2(N,J + N1) = A1(I,J)
            ENDDO
            Y(N) = A1(I,K)
         ENDIF
      ENDDO
C
C Calculate YBAR ... Y is always unweighted
C
      YBAR = ZERO
      DO I = N1, N
         YBAR = YBAR + Y(I)
      ENDDO
      YBAR = YBAR/DBLE(N)
C
C Now a full analysis to calculate SIGMA2 for CP evaluation
C
      MEAN = 'M'
      IP = M + N1
      ISX(IP) = N0
C
C Assign Y temporarily to the residual vector RES then call AXEQB2
C In this call A4 is workspace and A3 holds the solution on return
C
      DO I = N1, N
         RES(I) = Y(I)
      ENDDO
      LWORK = NRMAX + 5*NCMAX
      NCOL1 = IP
      NROW1 = N
      CALL AXEQB2 (IRANK, LWORK, NCMAX, NCOL1, NIN, NF, NRMAX, NROW1,
     +             A2, A4, A3, S, RES, WK,
     +             TITLE, TITLE1,
     +             ABORT, DISPLY, FILE1, SUPPLY)
C
C Current degrees of freedom and define solution vector
C
      IDF = N - IRANK
      DO I = 1, IP
         B(I) = A3(I,N1)
      ENDDO
C
C Calculate the unweighted sum of squares and SIGMA2 for Mallows Cp, etc.
C
      UWTSSQ = ZERO
      DO I = N1, N
         VALUE = B(1)
         DO J = N1, M
            VALUE = VALUE + A2(I,J + N1)*B(J + N1)
         ENDDO
         UWTSSQ = UWTSSQ + (Y(I) - VALUE)**2
      ENDDO
      DF = DBLE(N - IRANK)
      SIGMA2 = UWTSSQ/DF
      IF (SIGMA2.LE.TOL) THEN
         CALL PUTFAT ('Insufficient variation in Y-values')
         DEALLOCATE(A3, STAT = IERR)
         DEALLOCATE(A4, STAT = IERR)
         DEALLOCATE(CV, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         RETURN
      ENDIF
C
C Now adjust using the least squares starting estimates
C
      SIGMA = SIGMA2
      IF (ISIGMA.EQ.0) CALL GETDGE (SIGMA, TOL,
     +'Fixed value of sigma required for M-estimates')
      IF (INDW.LT.0) THEN
         TEST = DBLE(IP)
         IF (CUCV.LT.TEST) THEN
            CUCV = TEST
            CALL PUTADV ('CUCV re-set to CUCV = IP')
         ENDIF
      ELSEIF (INDW.GT.0) THEN
         TEST = SQRT(DBLE(IP))
         IF (CUCV.LT.TEST) THEN
            CUCV = TEST
            CALL PUTADV ('CUCV re-set to CUCV = sqrt(IP)')
         ENDIF
      ENDIF
      IFAIL = N1
      CALL G02HAF$(INDW, IPSI, ISIGMA, INDC, N, IP, A2, NRMAX, Y, CPSI,
     +             H1, H2, H3, CUCV, DCHI, B, SIGMA, CV, LDA, RES, WT,
     +             TOL_1, MAXIT, NITMON, WK, IFAIL)
      IF (IFAIL.NE.0) THEN
         CALL PUTIFA (IFAIL, NF, 'G02HAF/ROB003')
         IF (IFAIL.LT.7) THEN
            CALL PUTFAT (
     +'The problem cannot be solved with these control parameters')
            DEALLOCATE(A3, STAT = IERR)
            DEALLOCATE(A4, STAT = IERR)
            DEALLOCATE(CV, STAT = IERR)
            DEALLOCATE(X, STAT = IERR)
            RETURN
         ELSE
            CALL PUTWAR (
     +'The results may be unreliable with these control parameters')
         ENDIF
      ENDIF
C
C Calculate the unweighted sum of squares and SIGMA2 for Mallows Cp, etc.
C
      UWTSSQ = ZERO
      DO I = N1, N
         VALUE = B(1)
         DO J = N1, M
            VALUE = VALUE + A2(I,J + N1)*B(J + N1)
         ENDDO
         UWTSSQ = UWTSSQ + (Y(I) - VALUE)**2
      ENDDO
      DF = DBLE(N - IRANK)
      SIGMA2 = UWTSSQ/DF
C
C Part 2: Main branch point for repeated analysis
C ===============================================
C
      T60 = TRIM60(FNAME)
      C60 = CHOP60(TITLE)
      FITNOW = .TRUE.
      READY = .FALSE.
      AGAIN1 = .TRUE.
      AGAIN2 = .FALSE.    
      DONE1 = .TRUE.    
      DONE2 = .TRUE.
      DO WHILE (AGAIN1)
C
C First of all define IP, NVAR and LABELM then initialise the menu
C
         NUMDEC = N1
         CALL ISXVEC (ISX, M, NVAR, NXMIN)
         IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
            IP = NVAR + N1
            LABELM = '(Yes)'
         ELSE
            IP = NVAR
            LABELM = ' (No)'
         ENDIF
         WRITE (TEXT,100) ICOUNT, T60, C60, LABELW, LABELM, M, NVAR,
     +                    M - NVAR, IP
C
C Now refine details of the menu
C
         CALL ISXTYP (ISX, M, NVAR, NXMIN,
     +                LINE,
     +                SHOWIT)
         TEXT(N4) = LINE
         IF (SHOWIT) TEXT(N5) = '* = suppressed variable'
C
C The main menu
C
         NUMBLD(1) = 1
         NUMBLD(4) = 1
         NUMBLD(6) = 1
         NUMBLD(7) = 1
         IF (.NOT.READY) THEN
            NUMDEC = N1
         ELSE
            NUMDEC = NUMOPT - N1
         ENDIF
         FITNOW = .FALSE.
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NUMDEC.EQ.N1) THEN
C
C Proceed to fitting
C
            AGAIN1 = .TRUE.
            FITNOW = .TRUE.
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Change status of MEAN
C
            IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               MEAN = 'Z'
               CALL PUTADV (
     +'Regression will now pass through the origin')
            ELSE
               MEAN = 'M'
               CALL PUTADV (
     +'A mean term, i.e. intercept or constant, will be in the model')
            ENDIF
            NPAR1 = N0
            NPTS1 = N0
            WSSQ = - ONE
            AGAIN1 = .TRUE.
            READY = .FALSE.
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Suppress/Restore variables
C
            CALL ISXEDI (ISX, M, NVAR, NXMIN)
            NPAR1 = N0
            NPTS1 = N0
            WSSQ1 = - ONE
            AGAIN1 = .TRUE.
            READY = .FALSE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Linear regression/correlation/plot (Note: col 1 is X = 1, so J = J + 1)
C
             IF (M.GT.N1) THEN
                CALL GETIM1 (N1, J, M,
     +'Number of x-column for plotting')
             ELSE
                J = N1
             ENDIF
             IF (ISX(J).EQ.N0) THEN
                CALL PUTFAT (
     +'This is not in the current regression set')
             ELSE
                J = J + N1
                DO I = N1, N
                  WK(I) = A2(I,J)
                ENDDO
                CALL LINFIT (NF, N,
     +                       WK, Y,
     +                       FILE, PRINT1)
             ENDIF
             AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Output the residuals, etc.
C
            IF (READY) THEN
               NUMDEC = N1
               AGAIN2 = .TRUE.
               DO WHILE (AGAIN2)
                  WRITE (TEXT,700)
                  CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, N8, NUMPOS,
     +                         TEXT)
                  IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
                     COLOUR = 15
                     CALL TABLE1 (COLOUR, 'OPEN')
                     WRITE (LINE,800)
                     COLOUR = 4
                     CALL TABLE1 (COLOUR, LINE)
                     COLOUR = 0
                     DO I = N1, N
                        WRITE (LINE,1000) I, Y(I), THEORY(I), RES(I),
     +                                    WT(I)
                        CALL TABLE1 (COLOUR, LINE)
                     ENDDO
                     CALL TABLE1 (COLOUR, 'CLOSE')
                     NUMDEC = N2
                  ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C                  
                     IF (DONE1) THEN
                        CALL PUTADV (
     +'Residuals have already been written to the results file')
                     ELSE
                        WRITE (NF,'(A)') ' '
                        WRITE (NF,800)
                        DO I = N1, N
                           WRITE (NF,1000) I, Y(I), THEORY(I), RES(I),
     +                                     WT(I)
                        ENDDO
                        CALL PUTADV (
     +'Residuals have now been written to the results file')                                      
                        DONE1 = .TRUE.
                     ENDIF   
                     NUMDEC = N3
                  ELSEIF (NUMDEC.EQ.N3) THEN
C
C ANOVA
C
                     IFAIL = N1
                     PVAL = G01EDF$(TAIL, FSTAT, DBLE(NDF1), DBLE(NDF2),
     +                              IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EDF/LINEAR')
                     WRITE (TEXT,1100) NDF0, TSS, NDF1, REGSSQ,
     +                                 REGSSQ/DBLE(NDF1),
     +                                 FSTAT, PVAL, NDF2, UWTSSQ,
     +                                 UWTSSQ/DBLE(NDF2)
                     COLOUR = 15
                     CALL TABLE1 (COLOUR, 'OPEN')
                     DO I = N1, N6
                        IF (I.LE.N3) THEN
                           COLOUR = 4
                        ELSE
                           COLOUR = 0
                        ENDIF
                        IF (.NOT.DONE2) WRITE (NF,'(A)') TEXT(I)
                        CALL TABLE1 (COLOUR,TEXT(I))
                     ENDDO
                     CALL TABLE1 (COLOUR, 'CLOSE')
                     DONE2 = .TRUE.
                     NUMDEC = N4
                  ELSEIF (NUMDEC.EQ.N4) THEN
C
C Plot residuals
C
                     DO I = N1, N2
                        X2(I) = ZERO
                        X3(I) = ZERO
                        X4(I) = ZERO
                        Y2(I) = ZERO
                        Y3(I) = ZERO
                        Y4(I) = ZERO
                     ENDDO
                     YTITLE = 'Residuals'
                     CALL GKS004 (N0, N0, N0, N0, N4, N0, N0, N0,
     +                            N, N2, N2, N2,
     +                            THEORY, X2, X3, X4,
     +                            RES, Y2, Y3, Y4,
     +                            PTITLE, XTITLE, YTITLE,
     +                            AXES, AXES)
                     NUMDEC = N5
                  ELSEIF (NUMDEC.EQ.N5) THEN
C
C Half normal plot
C
                     CALL HNPLOT (N1, N,
     +                            RES)
                     NUMDEC = N6
                  ELSEIF (NUMDEC.EQ.N6) THEN
C
C Normal plot
C
                     CALL HNPLOT (N2, N,
     +                            RES)
                     NUMDEC = N7
                  ELSEIF (NUMDEC.EQ.N7) THEN
C
C F tests
C
                     CALL FTEST1 (NF, NPAR1, NPTS1,
     +                            WSSQ1)
                     NUMDEC = N8
                  ELSE
C
C Go back for further analysis
C
                     AGAIN2 = .FALSE.
                  ENDIF
               ENDDO
            ELSE
               CALL PUTFAT ('First fit the data')
            ENDIF
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N6) THEN
C
C Compare 2 parameters
C
            CALL TTEST2 (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N7) THEN
C
C Compare 2 sets of parameters
C
            IF (MODE.EQ.N2 .AND. NPAR.NE.M + N1) CALL PUTWAR (
     +'Data can only be saved for the parameters actually fitted')
            CALL PCVTST (MODE, NF, NPAR, NPTS, LDA,
     +                   CV, B)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
C
C Evaluate y = f(x)
C
            IF (READY .AND. MODE.EQ.N2) THEN
               WRITE (TXT,1200) M
               CALL EDITOR (ISEND, ITYPE, M, N1, N1,
     +                      X,
     +                      TXT,
     +                      CURVE, FIXCOL, FIXROW, LABEL, ORDER, WTD)
               IF (MEAN.EQ.'M') THEN
                  J = N1
                  YPRED = B(J)
               ELSE
                  J = N0
                  YPRED = ZERO
               ENDIF
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     YPRED = YPRED + B(J)*X(1,I)
                  ENDIF
               ENDDO
               COLOUR = 15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
               IF (MEAN.EQ.'M') THEN
                  J = N1
                  WRITE (TXT,1300) N0, ONE, B(J), ' (the constant term)'
                  WRITE (NF,'(A)') TXT
                  CALL TABLE1 (COLOUR, TXT)
               ELSE
                  J = N0
               ENDIF
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     WRITE (TXT,1300) I, X(1,I), B(J), BLANK
                     WRITE (NF,'(A)') TXT
                     CALL TABLE1 (COLOUR, TXT)
                  ENDIF
               ENDDO
               COLOUR = N4
               WRITE (TXT,1400) YPRED
               WRITE (NF,'(A)') TXT
               CALL TABLE1 (COLOUR, TXT)
               CALL TABLE1 (COLOUR, 'CLOSE')
            ELSE
               CALL PUTFAT ('Model not yet fitted')
            ENDIF
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
C
C Results
C
            CALL REVPRO (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Terminate current data analysis
C
            AGAIN1 = .FALSE.
         ENDIF
C
C Part 3: the main fitting procedure
C ==================================
C Define N and assign data to array A2
C Include a first column of 1 for the constant term X = 1 if MEAN
C
         IF (FITNOW) THEN
            FITNOW = .FALSE.
            READY = .TRUE.
            N = N0
            DO I = N1, NROWS
               VALUE = A1(I,NCOLS)
               IF (VALUE.GT.TOL) THEN
                  N = N + N1
                  K = N0
                  IF (MEAN.EQ.'M') THEN
                     K = K + N1
                     A2(N,K) = ONE
                  ENDIF
                  DO J = N1, M
                     IF (ISX(J).NE.N0) THEN
                        K = K + N1
                        A2(N,K) = A1(I,J)
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
C
C Define RES = Y temporarily then call AXEQB2
C
            DO I = N1, N
               RES(I) = Y(I)
            ENDDO
            NCOL1 = IP
            NROW1 = N
            CALL AXEQB2 (IRANK, LWORK, NCMAX, NCOL1, NIN, NF, NRMAX,
     +                   NROW1,
     +                   A2, A4, A3, S, RES, WK,
     +                   TITLE, TITLE1,
     +                   ABORT, DISPLY, FILE1, SUPPLY)
C
C Is the problem of full rank ?
C
            IF (IRANK.LT.IP) THEN
               CALL PUTWAR (
     +'Less than full rank (SVD used in initial least squares fit)')
               MODE = N3
               NPAR = N0
               NPAR1 = N0
               NPTS = N0
               NPTS1 = N0
               WSSQ1 = - ONE
            ELSE
               MODE = N2
               NPAR = IP
               NPAR1 = IP
               NPTS = N
               NPTS1 = N
            ENDIF
C
C Define degrees of freedom then the parameters
C
            IDF = N - IRANK
            DO I = N1, IP
               B(I) = A3(I,N1)
            ENDDO
C
C Calculate UWTSSQ, RES, THEORY, etc. before M-estimates
C
            UWTSSQ = ZERO
            IF (MEAN.EQ.'M') THEN
               DO I = N1, N
                  VALUE = B(1)
                  K = N1
                  DO J = N1, IP - N1
                     K = K + N1
                     VALUE = VALUE + A2(I,K)*B(K)
                  ENDDO
                  THEORY(I) = VALUE
                  RES(I) = THEORY(I) - Y(I)
                  UWTSSQ = UWTSSQ + RES(I)**2
               ENDDO
            ELSE
               DO I = N1, N
                  VALUE = ZERO
                  DO J = N1, IP
                     VALUE = VALUE + A2(I,J)*B(J)
                  ENDDO
                  THEORY(I) = VALUE
                  RES(I) = THEORY(I) - Y(I)
                  UWTSSQ = UWTSSQ + RES(I)**2
               ENDDO
            ENDIF
            DF = DBLE(N - IRANK)
            SIGMA2 = UWTSSQ/DF
C
C Now adjust for M-estimates using least squares solutions for starting estimates
C
            SIGMA = SIGMA2
            IF (ISIGMA.EQ.0) CALL GETDGE (SIGMA, TOL,
     +'Fixed value of sigma required for M-estimates')
            IFAIL = N1
            CALL G02HAF$(INDW, IPSI, ISIGMA, INDC, N, IP, A2, NRMAX,
     +                   Y, CPSI,  H1, H2, H3, CUCV, DCHI, B, SIGMA,
     +                   CV, LDA, RES, WT, TOL_1, MAXIT, NITMON, WK,
     +                   IFAIL) 
            IF (IFAIL.EQ.0) THEN
               DONE1 = .FALSE.
               DONE2 = .FALSE. 
            ELSE
               CALL PUTIFA (IFAIL, NF, 'G02HAF/ROB003')
               IF (IFAIL.LT.7) THEN 
                  DONE1 = .TRUE.
                  DONE2 = .TRUE.
                  CALL PUTFAT ('Parameters will not be meaningful')
               ELSE
                  DONE1 = .FALSE.
                  DONE2 = .FALSE. 
                  CALL PUTWAR ('Parameters may be be unreliable')
               ENDIF
            ENDIF
C
C Calculate UWTSSQ, RES, RSS, TSS after M-estimates
C
            UWTSSQ = ZERO
            IF (MEAN.EQ.'M') THEN
               DO I = N1, N
                  VALUE = B(1)
                  K = N1
                  DO J = N1, IP - N1
                     K = K + N1
                     VALUE = VALUE + A2(I,K)*B(K)
                  ENDDO
                  THEORY(I) = VALUE
                  UWTSSQ = UWTSSQ + RES(I)**2
               ENDDO
            ELSE
               DO I = N1, N
                  VALUE = ZERO
                  DO J = N1, IP
                     VALUE = VALUE + A2(I,J)*B(J)
                  ENDDO
                  THEORY(I) = VALUE
                  UWTSSQ = UWTSSQ + RES(I)**2
               ENDDO
            ENDIF
            DF = DBLE(N - IRANK)
            SIGMA2 = UWTSSQ/DF
C
C Calculate statistics CP, RSQD and F
C
            TSS = ZERO
            IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               DO I = N1, N
                  TSS = TSS + (Y(I) - YBAR)**2
               ENDDO
            ELSE
               DO I = N1, N
                  TSS = TSS + Y(I)**2
               ENDDO
            ENDIF
            REGSSQ = TSS - UWTSSQ
            RSQD = REGSSQ/TSS
            IF (RSQD.LT.ZERO) RSQD = ZERO
            IF (RSQD.GT.ONE) RSQD = ONE
            CP = UWTSSQ/SIGMA2 - DBLE(N - TWO*IP)
            IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               NDF0 =  N - N1
            ELSE
               NDF0 = N
            ENDIF
            NDF2 = N - IP
            NDF1 = NDF0 - NDF2
            FSTAT = (REGSSQ/DBLE(NDF1))/(UWTSSQ/DBLE(NDF2))
C
C Calculate WSSQ
C
            WSSQ = UWTSSQ
            IF (NPAR1.GT.N0 .AND. NPTS1.GT.N0) THEN
               WSSQ1 = WSSQ
            ELSE
               WSSQ1 = - ONE
            ENDIF
C
C Parameter standard errors
C
            DO I = 1, IP
               SE(I) = CV(I,I)
            ENDDO
C
C Store the covariance matrix if satisfactory fit
C
            IF (IFAIL.NE.N0) MODE = N3
            IF (MODE.EQ.N2) THEN
               NPTS = N
               NPAR = IP
               DO I = N1, NPAR
                  DO J = 1, I
                     IF (I.EQ.J) THEN
                        CV(I,J) = CV(I,J)**2
                     ELSE
                        CV(J,I) = CV(I,J)
                     ENDIF
                  ENDDO
               ENDDO
            ELSE
               NPTS = N0
               NPAR = N0
            ENDIF
C
C Output the best-fit parameters
C
            WRITE (NF,'(A)') BLANK
            DO I = N1, N7
               IF (I.NE.N2) WRITE (NF,'(A)') TEXT(I)
            ENDDO
            WRITE (NF,'(A)') BLANK
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            WRITE (LINE,200) IP, IRANK, N, IDF
            WRITE (NF,200) IP, IRANK, N, IDF
            CALL TABLE1 (COLOUR, LINE)
            WRITE (LINE,300) UWTSSQ, CP, RSQD
            WRITE (NF,300) UWTSSQ, CP, RSQD
            CALL TABLE1 (COLOUR, LINE)
            WRITE (LINE,350) SIGMA
            WRITE (NF,350) SIGMA
            CALL TABLE1 (COLOUR, LINE)
            WRITE (LINE,400)
            WRITE (NF,400)
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
C
C Calculate t values and parameter p-values
C
            IFAIL = N1
            TNU = G01FBF$(TAIL, PNT025, DBLE(NDF2), IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G01FBF/LINEAR')
            DF = DBLE(N - IRANK)
            IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
               J = N1
               IF (SE(J).GT.TOL) THEN
                  TVAL = ABS(B(J)/SE(J))
                  IFAIL = N1
                  PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                  CALL PUTIFA (IFAIL, NF, 'G01EBF/LINEAR')
               ELSE
                  PVAL = ONE
               ENDIF
               IF (PVAL.GT.PNT2) THEN
                  CIPHER = ' ***'
               ELSEIF (PVAL.GT.PNT1) THEN
                  CIPHER = '  **'
               ELSEIF (PVAL.GT.PNT05) THEN
                  CIPHER = '   *'
               ELSE
                  CIPHER = '    '
               ENDIF
               IF (PVAL.LT.ZERO) THEN
                  PVAL = ZERO
               ELSEIF (PVAL.GT.ONE) THEN
                  PVAL = ONE
               ENDIF
               WRITE (LINE,500) B(J), B(J) - TNU*SE(J),
     +                          B(J) + TNU*SE(J),
     +                          SE(J), PVAL, CIPHER
               WRITE (NF,500) B(J), B(J) - TNU*SE(J),
     +                        B(J) + TNU*SE(J),
     +                        SE(J), PVAL, CIPHER
               CALL TABLE1 (COLOUR, LINE)
            ELSE
               J = N0
            ENDIF
            DO I = N1, M
               IF (ISX(I).GT.N0) THEN
                  J = J + N1
                  IF (SE(J).GT.TOL) THEN
                     TVAL = ABS(B(J)/SE(J))
                     IFAIL = N1
                     PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                     CALL PUTIFA (IFAIL, NF, 'G01EBF/LINEAR')
                  ELSE
                     PVAL = ONE
                  ENDIF
                  IF (PVAL.GT.PNT2) THEN
                     CIPHER = ' ***'
                  ELSEIF (PVAL.GT.PNT1) THEN
                     CIPHER = '  **'
                  ELSEIF (PVAL.GT.PNT05) THEN
                     CIPHER = '   *'
                  ELSE
                     CIPHER = '    '
                  ENDIF
                  IF (PVAL.LT.ZERO) PVAL = ZERO
                  IF (PVAL.GT.ONE) PVAL = ONE
                  WRITE (LINE,600) I, B(J), B(J) - TNU*SE(J),
     +                             B(J) + TNU*SE(J), SE(J), PVAL, CIPHER
                  WRITE (NF,600) I, B(J), B(J) - TNU*SE(J),
     +                           B(J) + TNU*SE(J),
     +                           SE(J), PVAL, CIPHER
                  CALL TABLE1 (COLOUR, LINE)
               ENDIF
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
      ENDDO
C
C Store ISX and X
C
      DO I = N1, MIN(M,NISX)
         ISXSAV(I) = ISX(I)
         XSAV(N1,I) = X(N1,I)
      ENDDO
C
C Deallocate workspace
C
      DEALLOCATE(A3, STAT = IERR)
      DEALLOCATE(A4, STAT = IERR)
      DEALLOCATE(CV, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
C
C Format statements
C
  100 FORMAT (
     + 'Robust regression analysis',i4
     +/
     +/'Current status of x-variables:'
     +/
     +/
     +/'File:',1X,A
     +/'Title:',1X,A
     +/'Use weights supplied:',1X,A
     +/'Include a constant term:',1X,A
     +/'No. of variables supplied =',I4
     +/'No. of variables included =',I4
     +/'No. of variables excluded =',I4
     +/'No. of parameter estimates =',I4
     +/'Fit data with current settings'
     +/'Change status of constant term'
     +/'Suppress/Restore variables'
     +/'Correlation/plot of y = f(x_i)'
     +/'ANOVA, residuals, F test'
     +/'Compare 2 parameters'
     +/'Compare 2 sets of parameters'
     +/'Evaluate y = f(x)'
     +/'Results'
     +/'Quit ... Exit robust analysis options')
  200 FORMAT (' No. parameters =',I3,
     +', Rank =',I3,', No. points =',I6,', No. deg. freedom =',I6)
  300 FORMAT (' Residual-SSQ =',1P,E9.2,', Mallows'' Cp =',E11.3,
     +', R-squared =',0P,F7.4)
  350 FORMAT (' Final sigma value =',1P,E10.3)
c  400 FORMAT (' Parameter       Value     95% conf. limits',
c     +'      Std.error        p')
  400 FORMAT (' Parameter       Value  Lower95%cl',
     +'  Upper95%cl   Std.error      p')
  500 FORMAT ('  Constant',   1P,4E12.3,0P,F9.4,A)
  600 FORMAT ('    B(',I3,')',1P,4E12.3,0P,F9.4,A)
  700 FORMAT (
     + 'Display the residuals'
     +/'File the residuals'
     +/'Display/file ANOVA table'
     +/'Plot residuals: against theory'
     +/'Plot residuals: half normal'
     +/'Plot residuals: full normal'
     +/'F tests'
     +/'Quit ... Exit residuals analysis')
  800 FORMAT (
     +'Number    Y-value     Theory   Residual   Weighting')
 1000 FORMAT (I6,1P,4E11.3)
 1100 FORMAT (
     +/' ANOVA'
     +/' Source      NDOF         SSQ    Mean SSQ     F-value         p'
     +/' Total     ', I6,1P,E12.3,
     +/' Regression', I6,3E12.3,0P,F10.4
     +/' Residual  ', I6,1P,2E12.3)
 1200 FORMAT ('Values for x(1) to x(',I3,')')
 1300 FORMAT ('x(',I3,') =',1P,E11.3, ', coefficient =',E11.3,A)
 1400 FORMAT ('y(x) =',1P,E11.3)
      END
C
C
