C
C
      SUBROUTINE ROB004 (INDW, IPSI, ISIGMA, INDC, MAXIT, NITMON,
     +                   ICOUNT, NF,
     +                   CPSI, H1, H2, H3, CUCV, DCHI, TOL)
C
C ACTION: set control parameters for G02HAF
C AUTHOR: w.g.bardsley@manchester.ac.uk, 18/07/2006
C
C Note: G02HAF arguments are all output and as defined in NAG documentation
C       ICOUNT: (input/unchanged) number of the analysis
C           NF: (input/unchanged) pre-connected unit for results
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    INDW, IPSI, ISIGMA, INDC, MAXIT, NITMON
      INTEGER    ICOUNT, NF
      DOUBLE PRECISION CPSI, H1, H2, H3, CUCV, DCHI, TOL
C
C Locals
C
      INTEGER    I, IMAX, IMIN, NUMDEC, NUMOPT
      INTEGER    INDW_1, IPSI_1, ISIGMA_1, INDC_1, MAXIT_1, NITMON_1
      INTEGER    NUMTXT, NUMBLD(30)
      DOUBLE PRECISION CPSI_1, H1_1, H2_1, H3_1, CUCV_1, DCHI_1, TOL_1
      DOUBLE PRECISION DMAX, DMIN, HTEMP1, HTEMP2, HTEMP3
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  CIPHER(6)*40, LINE*100, TEXT(30)*100
      CHARACTER  INDW_2(3)*80, IPSI_2(5)*80, ISIGMA_2(3)*80,
     +           INDC_2(2)*80
      CHARACTER  BLANK*1, NOTUSE*40
      PARAMETER (BLANK = ' ', NOTUSE = '(Not used)')
      LOGICAL    REPEET, USEIT(6)
      EXTERNAL   LISTBX, PATCH2, GETJM1, GETDGE, PUTFAT, GETDM1
      SAVE       INDW_1, IPSI_1, ISIGMA_1, INDC_1, MAXIT_1, NITMON_1
      SAVE       CPSI_1, H1_1, H2_1, H3_1, CUCV_1, DCHI_1, TOL_1
      DATA       INDW_1, IPSI_1, ISIGMA_1, INDC_1, MAXIT_1, NITMON_1
     +              / 1,      2,        1,      0,      50,        0 /
      DATA       CPSI_1,    H1_1,    H2_1,    H3_1,  CUCV_1,  DCHI_1,
     +            TOL_1
     +        / 1.0D+00, 1.5D+00, 3.0D+00, 4.5D+00, 3.0D+00, 1.5D+00,
     +          0.5D-04 /
      DATA       INDW_2 /
     +          'INDW < 0, Mallows with Maronna weights',
     +          'INDW = 0, Huber type regression',
     +          'INDW > 0, Schweppe with Krasker-Welsch weights' /
      DATA       IPSI_2 /
     +          'IPSI = 0, Least squares',
     +          'IPSI = 1, Huber function',
     +          'IPSI = 2, Hampel piecewise linear',
     +          'IPSI = 3, Andrew sine wave',
     +          'IPSI = 4, Tukey bi-weight' /
      DATA      ISIGMA_2 /
     +          'ISIG < 0, sigma = med.abs.dev. of residuals',
     +          'ISIG = 0, sigma = constant initial value',
     +          'ISIG > 0, sigma using the chi function' /
      DATA       INDC_2 /
     +          'INDC = 0, Replacing expected by observed',
     +          'INDC = 1, Averaging over residuals'  /
      DATA      NUMBLD / 30*0 /
C
C Initialise by setting parameters equal to the saved values
C
      INDW = INDW_1
      IPSI = IPSI_1
      ISIGMA = ISIGMA_1
      INDC = INDC_1
      MAXIT = MAXIT_1
      NITMON = NITMON_1
      CPSI = CPSI_1
      H1 = H1_1
      H2 = H2_1
      H3 = H3_1
      CUCV = CUCV_1
      DCHI = DCHI_1
      TOL = TOL_1
C
C Main loop to change the parameters
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         DO I = 1, 6
            USEIT(I) = .TRUE.
         ENDDO
         IF (IPSI.NE.1) USEIT(1) = .FALSE.
         IF (IPSI.NE.2) THEN
            USEIT(2) = .FALSE.
            USEIT(3) = .FALSE.
            USEIT(4) = .FALSE.
         ENDIF
         IF (INDW.EQ.0) USEIT(5) = .FALSE.
         IF (IPSI.EQ.0 .OR. ISIGMA.LE.0) USEIT(6) = .FALSE.
         DO I = 1, 6
            IF (USEIT(I)) THEN
               CIPHER(I) = BLANK
            ELSE
               CIPHER(I) = NOTUSE
            ENDIF
         ENDDO
         NUMOPT = 15
         NUMDEC = NUMOPT - 1
         WRITE (TEXT,100) INDW, IPSI, ISIGMA, INDC, MAXIT, NITMON,
     +                    CPSI, CIPHER(1),
     +                      H1, CIPHER(2),
     +                      H2, CIPHER(3),
     +                      H3, CIPHER(4),
     +                    CUCV, CIPHER(5),
     +                    DCHI, CIPHER(6),
     +                    TOL, ICOUNT
         CALL LISTBX (NUMDEC, NUMOPT,
     +                TEXT)
         IF (NUMDEC.EQ.1) THEN
C
C NUMDEC = 1: INDW
C
            NUMOPT = 3
            NUMDEC = INDW + 2
            CALL LISTBX (NUMDEC, NUMOPT,
     +                   INDW_2)
            INDW = NUMDEC - 2
         ELSEIF (NUMDEC.EQ.2) THEN
C
C NUMDEC = 2: IPSI
C
            NUMOPT = 5
            NUMDEC = IPSI + 1
            CALL LISTBX (NUMDEC, NUMOPT,
     +                   IPSI_2)
            IPSI = NUMDEC - 1
         ELSEIF (NUMDEC.EQ.3) THEN
C
C NUMDEC = 3: ISIGMA
C
            NUMOPT = 3
            NUMDEC = ISIGMA + 2
            CALL LISTBX (NUMDEC, NUMOPT,
     +                   ISIGMA_2)
            ISIGMA = NUMDEC - 2
          ELSEIF (NUMDEC.EQ.4) THEN
C
C NUMDEC = 4: INDC
C
            NUMOPT = 2
            NUMDEC = INDC + 1
            CALL LISTBX (NUMDEC, NUMOPT,
     +                   INDC_2)
            INDC = NUMDEC - 1
         ELSEIF (NUMDEC.EQ.5) THEN
C
C NUMDEC = 5: MAXIT
C
            IMIN = 10
            IMAX = 250
            WRITE (LINE,200)
            CALL GETJM1 (IMIN, MAXIT, IMAX,
     +                   LINE)
         ELSEIF (NUMDEC.EQ.6) THEN
C
C NUMDEC = 6: NITMON
C
            WRITE (LINE,300)
            CALL PUTFAT (LINE)
         ELSEIF (NUMDEC.EQ.7) THEN
C
C NUMDEC = 7: CPSI
C
            DMIN = 1.0D-10
            WRITE (LINE,400)
            CALL GETDGE (CPSI, DMIN,
     +                   LINE)
         ELSEIF (NUMDEC.GE.8 .AND. NUMDEC.LE.10) THEN
C
C NUMDEC = 8, 9, 10: H1, H2, H3
C
            HTEMP1 = H1
            HTEMP2 = H2
            HTEMP3 = H3
            DMIN = 1.0D-10
            IF (NUMDEC.EQ.8) THEN
               WRITE (LINE,500) 'H1'
               CALL GETDGE (HTEMP1, DMIN,
     +                      LINE)
            ELSEIF (NUMDEC.EQ.9) THEN
               WRITE (LINE,500) 'H2'
               CALL GETDGE (HTEMP2, DMIN,
     +                      LINE)
            ELSEIF (NUMDEC.EQ.10) THEN
               WRITE (LINE,500) 'H3'
               CALL GETDGE (HTEMP3, DMIN,
     +                      LINE)
            ENDIF
            IF (HTEMP1.GE.DMIN .AND. HTEMP2.GE.HTEMP1 .AND.
     +          HTEMP3.GE.HTEMP2 .AND. HTEMP3.GT.ZERO) THEN
               H1 = HTEMP1
               H2 = HTEMP2
               H3 = HTEMP3
            ELSE
               WRITE (LINE,500) 'H1,H2,and H3'
               CALL PUTFAT (LINE)
            ENDIF
         ELSEIF (NUMDEC.EQ.11) THEN
C
C NUMDEC = 11: CUCV
C
            WRITE (LINE,600)
            DMIN = 1.0D-10
            CALL GETDGE (CUCV, DMIN,
     +                   LINE)
         ELSEIF (NUMDEC.EQ.12) THEN
C
C NUMDEC = 12: DCHI
C
            WRITE (LINE,700)
            DMIN = 1.0D-10
            CALL GETDGE (DCHI, DMIN,
     +                   LINE)
         ELSEIF (NUMDEC.EQ.13) THEN
C
C NUMDEC = 13: TOL
C
            WRITE (LINE,800)
            DMIN = 1.0D-7
            DMAX = 1.0D-01
            CALL GETDM1 (DMIN, TOL, DMAX,
     +                   LINE)
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
C
C NUMDEC = NUMOPT - 1: Help
C
            WRITE (TEXT,900)
            NUMBLD(1) = 1
            NUMTXT = 20
            CALL PATCH2 (NUMBLD, NUMTXT,
     +                   TEXT)
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C NUMDEC = NUMOPT: Apply
C
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Save the new parameters
C
      INDW_1 = INDW
      IPSI = IPSI_1
      ISIGMA_1 = ISIGMA
      INDC_1 = INDC
      MAXIT_1 = MAXIT
      NITMON_1 = NITMON
      CPSI_1 = CPSI
      H1_1 = H1
      H2_1 = H2
      H3_1 = H3
      CUCV_1 = CUCV
      DCHI_1 = DCHI
      TOL_1 = TOL
      WRITE (TEXT,1000) ICOUNT,
     +                  INDW_2(INDW + 2),
     +                  IPSI_2(IPSI + 1),
     +                  ISIGMA_2(ISIGMA + 2),
     +                  INDC_2(INDC + 1),
     +                  MAXIT,
     +                  NITMON,
     +                  CPSI,
     +                  H1,
     +                  H2,
     +                  H3,
     +                  CUCV,
     +                  DCHI,
     +                  TOL
      DO I = 1, 9
        WRITE(NF,'(A)') TEXT(I)
      ENDDO
      DO I = 1, 6
         IF (USEIT(I)) WRITE (NF,'(A)') TEXT(9 + I)
      ENDDO
      WRITE (NF,'(A)') TEXT(16)
C
C Format statements
C
  100 FORMAT(
     + 'INDW  `',I6
     +/'IPSI  `',I6
     +/'ISIGMA`',I6
     +/'INDC  `',I6
     +/'MAXIT `',I6
     +/'NITMON`',I6
     +/'CPSI  `',1P,E12.4,1X,A
     +/'H1    `',   E12.4,1X,A
     +/'H2    `',   E12.4,1X,A
     +/'H3    `',   E12.4,1X,A
     +/'CUCV  `',   E12.4,1X,A
     +/'DCHI  `',   E12.4,1X,A
     +/'TOL   `',   E12.4
     +/'Help  `Details'
     +/'Apply `Proceed to robust regression',i4)
  200 FORMAT ('Number of iterations required')
  300 FORMAT ('Intermediate output not supported in this version')
  400 FORMAT (
     +'Value required for CPSI: Only for IPSI = 1, and then DCHI > 0')
  500 FORMAT (A,1X,'Note: must have 0 =< H1 =< H2 = < H3, H3 > 0')
  600 FORMAT (
     +'CUCV: either INDW < 0, CUCV >= M, or INDW < 0, CUCV >= sqrt(M)')
  700 FORMAT (
     +'DCHI: where either IPSI > 0 or ISIGMA =< 0, and DCHI > 0')
  800 FORMAT ('Value required for TOL')
  900 FORMAT (
     + 'Robust regression options'
     +/
     +/'The data will now be analysed by bounded influence regression'
     +/'to obtain M-estimates by the NAG procedure G02HAF, and in order'
     +/'to do this several control parameters must be set. By changing'
     +/'these parameters you change the program operation, which will'
     +/'lead to different parameter estimates of course.'
     +/
     +/'You can now edit the parameters required for this regression to'
     +/'select the precise methods to use. The parameters are named as'
     +/'in NAG routine G02HAF, and can be understood by reading the NAG'
     +/'documentation or the Simfit reference manual.'
     +/
     +/'As each item is selected you will see a sub-menu describing the'
     +/'available options, or you will be presented with other suitable'
     +/'options.'
     +/
     +/'Note that these options are only available at the start of each'
     +/'regression, and the options selected will be written to the log'
     +/'file of results.')

 1000 FORMAT (
     + ' '
     +/'G02HAF settings for robust regression',i4
     +/'========================================='
     +/A
     +/A
     +/A
     +/A
     +/'MAXIT ',I6
     +/'NITMON',I6
     +/'CPSI  ',1P,E12.4
     +/'H1    ',   E12.4
     +/'H2    ',   E12.4
     +/'H3    ',   E12.4
     +/'CUCV  ',   E12.4
     +/'DCHI  ',   E12.4
     +/'TOL   ',   E12.4)
      END
C
C
